/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.rezervari;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import ro.atreides.restaurant.modules.rezervari.CameraId;
import ro.atreides.restaurant.modules.rezervari.CamereAsociateBean;
import ro.atreides.restaurant.modules.rezervari.CazariReportBean;
import ro.atreides.restaurant.modules.rezervari.HotelGroup;
import ro.atreides.restaurant.modules.rezervari.RaportDetaliatBean;
import ro.atreides.restaurant.modules.rezervari.RezervareBean;
import ro.atreides.restaurant.modules.rezervari.RezervariMeseView;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.sql.SqlUtils;

public class RezervariDao
implements DaoInterface {
    private PreparedStatement addCalendar;
    private PreparedStatement updateStatus;
    private PreparedStatement updateStart;
    private PreparedStatement updateStop;
    private PreparedStatement getInfo;
    private PreparedStatement deleteCalendar;
    private PreparedStatement updateIdProduct;
    private PreparedStatement updateIdPromotie;
    private PreparedStatement addMesePersoaneEntry;
    private PreparedStatement deleteMesePersoaneForCalendar;
    private PreparedStatement updateIdClient;
    private PreparedStatement getCalendarByStatus;
    private PreparedStatement getStartDateForCalendar;
    private PreparedStatement getStopDateForCalendar;
    private PreparedStatement checkoutAtCamera;
    private PreparedStatement getStatusForCalendar;
    private PreparedStatement updateCamera;
    private PreparedStatement getNrFisa;
    private PreparedStatement setNrFisaForCalendar;
    private PreparedStatement updateSexForCalendar;
    private PreparedStatement getCazariReport;
    private PreparedStatement addGroup;
    private PreparedStatement getAllActiveGroups;
    private PreparedStatement updateGroup;
    private PreparedStatement getHotelGroupById;
    private PreparedStatement updateTarif;
    private PreparedStatement updateIdAgentie;
    private PreparedStatement updateNrPers;
    private PreparedStatement updateIdGrup;
    private PreparedStatement updateIdOrder;
    private PreparedStatement setTarifBlocat;
    private PreparedStatement addCameraAsociata;
    private PreparedStatement deleteCamereAsociate;
    private PreparedStatement getCamereAsociateForHost;
    private PreparedStatement getCalendarInfoById;
    private PreparedStatement getCazariActive;
    private PreparedStatement updateDetalii;
    private PreparedStatement updateAvans;
    private PreparedStatement stroneazaAvans;
    private Connection connection;

    public RezervariDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public void setTarif(double tarif, int id) throws SQLException {
        this.updateTarif.setDouble(1, tarif);
        this.updateTarif.setInt(2, id);
        this.updateTarif.execute();
    }

    public void setNrPers(int nr, int id) throws SQLException {
        this.updateNrPers.setInt(1, nr);
        this.updateNrPers.setInt(2, id);
        this.updateNrPers.execute();
    }

    public void setTarifBlocat(boolean blocat, int id) throws SQLException {
        this.setTarifBlocat.setInt(1, blocat ? 1 : 0);
        this.setTarifBlocat.setInt(2, id);
        this.setTarifBlocat.execute();
    }

    public void setIdAgentie(int idValue, int id) throws SQLException {
        if (idValue > 0) {
            this.updateIdAgentie.setInt(1, idValue);
        } else {
            this.updateIdAgentie.setNull(1, 4);
        }
        this.updateIdAgentie.setInt(2, id);
        this.updateIdAgentie.execute();
    }

    public void setIdGrup(int idValue, int id) throws SQLException {
        if (idValue > 0) {
            this.updateIdGrup.setInt(1, idValue);
        } else {
            this.updateIdGrup.setNull(1, 4);
        }
        this.updateIdGrup.setInt(2, id);
        this.updateIdGrup.execute();
    }

    public void setIdOrder(int idValue, int id) throws SQLException {
        if (idValue > 0) {
            this.updateIdOrder.setInt(1, idValue);
        } else {
            this.updateIdOrder.setNull(1, 4);
        }
        this.updateIdOrder.setInt(2, id);
        this.updateIdOrder.execute();
    }

    public void addCameraAsociata(int idHost, int idGuest) throws SQLException {
        this.addCameraAsociata.setInt(1, idHost);
        this.addCameraAsociata.setInt(2, idGuest);
        this.addCameraAsociata.execute();
    }

    public void deleteCamereAsociate(int idHost) throws SQLException {
        this.deleteCamereAsociate.setInt(1, idHost);
        this.deleteCamereAsociate.execute();
    }

    public Vector<CamereAsociateBean> getCamereAsociate(int idHost) throws SQLException {
        Vector<CamereAsociateBean> result = new Vector<CamereAsociateBean>();
        this.getCamereAsociateForHost.setInt(1, idHost);
        ResultSet rs = this.getCamereAsociateForHost.executeQuery();
        while (rs.next()) {
            CamereAsociateBean cab = new CamereAsociateBean();
            cab.setIdGuest(rs.getInt("id_guest"));
            cab.setIdHost(rs.getInt("id_host"));
            result.add(cab);
        }
        rs.close();
        return result;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.getCamereAsociateForHost = this.connection.prepareStatement("select * from hotel_camere_asociate where id_host = ?");
        this.deleteCamereAsociate = this.connection.prepareStatement("delete from hotel_camere_asociate where id_host = ?");
        this.addCameraAsociata = this.connection.prepareStatement("insert into hotel_camere_asociate ( id_host, id_guest ) values (?,?)");
        this.setTarifBlocat = this.connection.prepareStatement("update calendar set tarif_blocat = ? where id = ?");
        this.updateTarif = this.connection.prepareStatement("update calendar set tarif = ? where id = ?");
        this.updateIdAgentie = this.connection.prepareStatement("update calendar set id_agentie = ? where id = ?");
        this.updateNrPers = this.connection.prepareStatement("update calendar set numar_persoane = ? where id = ?");
        this.updateIdGrup = this.connection.prepareStatement("update calendar set id_grup = ? where id = ?");
        this.updateIdOrder = this.connection.prepareStatement("update calendar set id_order = ? where id = ?");
        this.updateSexForCalendar = this.connection.prepareStatement("update calendar set sex = ? where id = ?");
        this.setNrFisaForCalendar = this.connection.prepareStatement("update calendar set nr_fisa = ? where id = ?");
        this.getNrFisa = this.connection.prepareStatement("select nr_fisa from calendar where id = ?");
        this.getStatusForCalendar = this.connection.prepareStatement("select status from calendar where id = ?");
        this.checkoutAtCamera = this.connection.prepareStatement("update calendar set status = 6 where id_table = ? and (status = 4 or status = 5)");
        this.getStartDateForCalendar = this.connection.prepareStatement("select start from calendar where id = ?");
        this.getStopDateForCalendar = this.connection.prepareStatement("select stop from calendar where id = ?");
        this.getCalendarByStatus = this.connection.prepareStatement("select id, id_table, id_product from calendar where status = ? and (id = ? or ? = -1)");
        this.addMesePersoaneEntry = this.connection.prepareStatement("insert into rezervari_mese ( id_calendar, id_product, persoane ) values ( ?,?,? ) ");
        this.deleteMesePersoaneForCalendar = this.connection.prepareStatement("delete from rezervari_mese where id_calendar = ?");
        this.updateIdClient = this.connection.prepareStatement("update calendar set id_client = ? where id = ?");
        this.updateIdProduct = this.connection.prepareStatement("update calendar set id_product = ? where id = ?");
        this.updateIdPromotie = this.connection.prepareStatement("update calendar set id_promotie = ? where id = ?");
        this.addCalendar = this.connection.prepareStatement("insert into calendar(id_table, detalii, id_client, status, start, stop, id_product, id_promotie, sex, tarif, id_agentie, numar_persoane, id_grup, id_order, avans ) values (?, ?, ?, 2, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.updateStatus = this.connection.prepareStatement("update calendar set status = ? where id = ?");
        this.updateStart = this.connection.prepareStatement("update calendar set start = ? where id = ?");
        this.updateStop = this.connection.prepareStatement("update calendar set stop = ? where id = ?");
        this.updateDetalii = this.connection.prepareStatement("update calendar set detalii = ? where id = ?");
        this.updateAvans = this.connection.prepareStatement("update calendar set avans = ? where id = ?");
        this.stroneazaAvans = this.connection.prepareStatement("update calendar set stornat_avans = ? where id = ?");
        String infoQ = "select calendar.status, id_client, calendar.id, start, stop, id_product, coalesce(id_promotie, -1) as id_promo, sex, tarif, coalesce(id_agentie, -1) as id_agen, numar_persoane, tarif_blocat, coalesce(id_grup, -1) as id_grp, coalesce(id_order, -1) as id_ord, tables.label as nume_camera, tables.id as id_camera, avans, stornat_avans, calendar.detalii as detalii_rezervare from calendar inner join tables on calendar.id_Table = tables.id";
        this.getInfo = this.connection.prepareStatement(infoQ + " where (id_table = ? or ? = " + -1 + ")" + " and start < ?" + " and stop >= ?" + " and (id_order = ? or ? = " + -1 + ")" + " and (id_grup = ? or ? = " + -1 + ")");
        this.getCalendarInfoById = this.connection.prepareStatement(infoQ + " where calendar.id = ?");
        this.getCazariActive = this.connection.prepareStatement(infoQ + " where calendar.status in (" + 4 + ", " + 5 + ")" + " and ( id_client = ? or ? = " + -1 + ") and id_order > 0 ");
        this.deleteCalendar = this.connection.prepareStatement("delete from calendar where id = ?");
        this.updateCamera = this.connection.prepareStatement("update calendar set id_table = ? where id = ?");
        this.getCazariReport = this.connection.prepareStatement("select calendar.sex, tables.label || ' - ' || locations.name as camera, id_client, calendar.id as id_calendar, tables.id as id_table, id_order, start, stop, tarif from calendar inner join tables on calendar.id_table = tables.id inner join locations on tables.id_locatie = locations.id where start <= ? and stop >= ? and calendar.status in ( 6,4,5) order by start, camera");
        this.addGroup = this.connection.prepareStatement("insert into hotel_groups(nume_group, id_agentie, status) values ( ?, ?, 1)");
        this.updateGroup = this.connection.prepareStatement("update hotel_groups set nume_group = ?, id_agentie = ?, status = ? where id = ?");
        this.getAllActiveGroups = this.connection.prepareStatement("select * from hotel_groups where status = 1");
        this.getHotelGroupById = this.connection.prepareStatement("select * from hotel_groups where id = ?");
    }

    public HotelGroup getHotelGroupById(int id) throws SQLException {
        HotelGroup result = null;
        this.getHotelGroupById.setInt(1, id);
        ResultSet rs = this.getHotelGroupById.executeQuery();
        if (rs.next()) {
            result = this.getHotelGroupFromRs(rs);
        }
        rs.close();
        return result;
    }

    public Vector<HotelGroup> getAllActiveGroups() throws SQLException {
        Vector<HotelGroup> result = new Vector<HotelGroup>();
        ResultSet rs = this.getAllActiveGroups.executeQuery();
        while (rs.next()) {
            HotelGroup hg = this.getHotelGroupFromRs(rs);
            result.add(hg);
        }
        rs.close();
        return result;
    }

    private HotelGroup getHotelGroupFromRs(ResultSet rs) throws SQLException {
        HotelGroup hg = new HotelGroup();
        hg.setNume(rs.getString("nume_group"));
        hg.setIdAgentie(rs.getInt("id_agentie"));
        hg.setIdGrup(rs.getInt("id"));
        hg.setStatus(rs.getInt("status"));
        return hg;
    }

    public Vector<CazariReportBean> getCazariReport(Timestamp start, Timestamp stop) throws SQLException {
        Vector<CazariReportBean> result = new Vector<CazariReportBean>();
        this.getCazariReport.setTimestamp(1, stop);
        this.getCazariReport.setTimestamp(2, start);
        ResultSet rs = this.getCazariReport.executeQuery();
        while (rs.next()) {
            String camera = rs.getString("camera");
            CazariReportBean cb = new CazariReportBean();
            Timestamp tS = rs.getTimestamp("start");
            Timestamp tE = rs.getTimestamp("stop");
            cb.settE(tE);
            cb.settS(tS);
            int idClient = rs.getInt("id_client");
            cb.setIdClient(idClient);
            cb.setCamera(camera);
            cb.setIdCalendar(rs.getInt("id_calendar"));
            cb.setIdTable(rs.getInt("id_table"));
            cb.setIdOrder(rs.getInt("id_order"));
            cb.setTarif(rs.getDouble("tarif"));
            result.add(cb);
        }
        rs.close();
        return result;
    }

    public int getNrFisa(int idCalendar) throws SQLException {
        int max = 0;
        this.getNrFisa.setInt(1, idCalendar);
        ResultSet rs = this.getNrFisa.executeQuery();
        if (rs.next()) {
            max = rs.getInt(1);
        }
        rs.close();
        if (max < 0) {
            return 0;
        }
        return max;
    }

    public void setNrFisa(int nrFisa, int id) throws SQLException {
        this.setNrFisaForCalendar.setInt(1, nrFisa);
        this.setNrFisaForCalendar.setInt(2, id);
        this.setNrFisaForCalendar.execute();
    }

    public void updateCamera(int id, int newCamera) throws SQLException {
        this.updateCamera.setInt(1, newCamera);
        this.updateCamera.setInt(2, id);
        this.updateCamera.execute();
    }

    public void checkoutAtCamera(int idTable) throws SQLException {
        this.checkoutAtCamera.setInt(1, idTable);
        this.checkoutAtCamera.execute();
    }

    public void deleteCalendar(int id) throws SQLException {
        this.deleteCalendar.setInt(1, id);
        this.deleteCalendar.execute();
    }

    public void updateStop(int id, Timestamp stop) throws SQLException {
        this.updateStop.setTimestamp(1, stop);
        this.updateStop.setInt(2, id);
        this.updateStop.execute();
    }

    public void updateStart(int id, Timestamp start) throws SQLException {
        this.updateStart.setTimestamp(1, start);
        this.updateStart.setInt(2, id);
        this.updateStart.execute();
    }

    public void updateStatus(int id, int newSstatus) throws SQLException {
        this.updateStatus.setInt(1, newSstatus);
        this.updateStatus.setInt(2, id);
        this.updateStatus.execute();
    }

    public void updateIdProduct(int id, int newId) throws SQLException {
        this.updateIdProduct.setInt(1, newId);
        this.updateIdProduct.setInt(2, id);
        this.updateIdProduct.execute();
    }

    public void updateSex(int id, int newSex) throws SQLException {
        this.updateSexForCalendar.setInt(1, newSex);
        this.updateSexForCalendar.setInt(2, id);
        this.updateSexForCalendar.execute();
    }

    public void updateDetalii(String detalii, int id) throws SQLException {
        this.updateDetalii.setString(1, detalii);
        this.updateDetalii.setInt(2, id);
        this.updateDetalii.execute();
    }

    public void updateAvans(double avans, int id) throws SQLException {
        this.updateAvans.setDouble(1, avans);
        this.updateAvans.setInt(2, id);
        this.updateAvans.execute();
    }

    public void updateIdClient(int id, int newId) throws SQLException {
        this.updateIdClient.setInt(1, newId);
        this.updateIdClient.setInt(2, id);
        this.updateIdClient.execute();
    }

    public void updateIdPromo(int id, int newId) throws SQLException {
        if (newId > 0) {
            this.updateIdPromotie.setInt(1, newId);
        } else {
            this.updateIdPromotie.setNull(1, 4);
        }
        this.updateIdPromotie.setInt(2, id);
        this.updateIdPromotie.execute();
    }

    public Map<Integer, RezervareBean> getInfo(Timestamp start, Timestamp stop, int idTable, int idOrder, int idGrup) throws SQLException {
        Map<Integer, RezervareBean> result = Collections.synchronizedMap(new LinkedHashMap());
        this.getInfo.setInt(1, idTable);
        this.getInfo.setInt(2, idTable);
        this.getInfo.setTimestamp(3, stop);
        this.getInfo.setTimestamp(4, start);
        this.getInfo.setInt(5, idOrder);
        this.getInfo.setInt(6, idOrder);
        this.getInfo.setInt(7, idGrup);
        this.getInfo.setInt(8, idGrup);
        ResultSet rs = this.getInfo.executeQuery();
        RezervareBean bean = null;
        while (rs.next()) {
            bean = this.getRezervareBeanFromRs(rs);
            result.put(bean.getIdCalendar(), bean);
        }
        rs.close();
        return result;
    }

    private RezervareBean getRezervareBeanFromRs(ResultSet rs) throws SQLException {
        RezervareBean bean = new RezervareBean();
        bean.setStatus(rs.getInt("status"));
        bean.setIdClient(rs.getInt("id_client"));
        bean.setIdCalendar(rs.getInt("id"));
        bean.setStart(rs.getTimestamp("start"));
        bean.setStop(rs.getTimestamp("stop"));
        bean.setIdProduct(rs.getInt("id_product"));
        bean.setIdPromo(rs.getInt("id_promo"));
        bean.setIdSex(rs.getInt("sex"));
        bean.setIdAgentie(rs.getInt("id_agen"));
        bean.setIdOrder(rs.getInt("id_ord"));
        bean.setIdGrup(rs.getInt("id_grp"));
        bean.setNumarPersoane(rs.getInt("numar_persoane"));
        bean.setTarif(rs.getDouble("tarif"));
        bean.setTarifBlocat(rs.getInt("tarif_blocat") == 1);
        bean.setNumeCamera(rs.getString("nume_camera"));
        bean.setDetaliiRezervare(rs.getString("detalii_rezervare"));
        bean.setIdTable(rs.getInt("id_camera"));
        bean.setAvans(rs.getDouble("avans"));
        bean.setStornatAvans(rs.getBoolean("stornat_avans"));
        return bean;
    }

    public RezervareBean getRezervareById(int idCalendar) throws SQLException {
        RezervareBean bean = null;
        this.getCalendarInfoById.setInt(1, idCalendar);
        ResultSet rs = this.getCalendarInfoById.executeQuery();
        if (rs.next()) {
            bean = this.getRezervareBeanFromRs(rs);
        }
        rs.close();
        return bean;
    }

    public Vector<RezervareBean> getCazariActive(int idClient) throws SQLException {
        Vector<RezervareBean> result = new Vector<RezervareBean>();
        this.getCazariActive.setInt(1, idClient);
        this.getCazariActive.setInt(2, idClient);
        ResultSet rs = this.getCazariActive.executeQuery();
        while (rs.next()) {
            RezervareBean rb = this.getRezervareBeanFromRs(rs);
            result.add(rb);
        }
        rs.close();
        return result;
    }

    public void addCalendar(int idTable, String detalii, int idClient, Timestamp start, Timestamp stop, int idProduct, int idPromotion, int sex, double tarif, int idAgentie, int numarPersoane, int idGrup, int idOrder, double avans) throws SQLException {
        this.addCalendar.setInt(1, idTable);
        this.addCalendar.setString(2, detalii);
        this.addCalendar.setInt(3, idClient);
        this.addCalendar.setTimestamp(4, start);
        this.addCalendar.setTimestamp(5, stop);
        this.addCalendar.setInt(6, idProduct);
        if (idPromotion > 0) {
            this.addCalendar.setInt(7, idPromotion);
        } else {
            this.addCalendar.setNull(7, 4);
        }
        this.addCalendar.setInt(8, sex);
        this.addCalendar.setDouble(9, tarif);
        if (idAgentie > 0) {
            this.addCalendar.setInt(10, idAgentie);
        } else {
            this.addCalendar.setNull(10, 4);
        }
        this.addCalendar.setInt(11, numarPersoane);
        if (idGrup > 0) {
            this.addCalendar.setInt(12, idGrup);
        } else {
            this.addCalendar.setNull(12, 4);
        }
        if (idOrder > 0) {
            this.addCalendar.setInt(13, idOrder);
        } else {
            this.addCalendar.setNull(13, 4);
        }
        this.addCalendar.setDouble(14, avans);
        this.addCalendar.execute();
    }

    public void addGroup(String nume, int idAgentie) throws SQLException {
        this.addGroup.setString(1, nume);
        this.addGroup.setInt(2, idAgentie);
        this.addGroup.execute();
    }

    public void updateGroup(HotelGroup hg) throws SQLException {
        this.updateGroup.setString(1, hg.getNume());
        this.updateGroup.setInt(2, hg.getIdAgentie());
        this.updateGroup.setInt(3, hg.getStatus());
        this.updateGroup.setInt(4, hg.getIdGrup());
        this.updateGroup.execute();
    }

    public void addMasePersoaneEntry(int idCalendar, int idProduct, int nrPersoane) throws SQLException {
        this.addMesePersoaneEntry.setInt(1, idCalendar);
        this.addMesePersoaneEntry.setInt(2, idProduct);
        this.addMesePersoaneEntry.setInt(3, nrPersoane);
        this.addMesePersoaneEntry.execute();
    }

    public void deleteMesePersoaneEntry(int idCalendar) throws SQLException {
        this.deleteMesePersoaneForCalendar.setInt(1, idCalendar);
        this.deleteMesePersoaneForCalendar.execute();
    }

    public Map<Integer, Vector<RezervariMeseView>> getRezervariMeseForCalendar(Vector<Integer> idCalendar) throws SQLException {
        Map<Integer, Vector<RezervariMeseView>> result = Collections.synchronizedMap(new LinkedHashMap());
        String in = Utils.getSqlInSequence(idCalendar);
        String s = "select * from rezervari_mese inner join products on products.id = rezervari_mese.id_product where id_calendar in " + in;
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        while (rs.next()) {
            RezervariMeseView rmv = new RezervariMeseView();
            rmv.setIdProduct(rs.getInt("id_product"));
            rmv.setNrPersoane(rs.getInt("persoane"));
            rmv.setProduct(rs.getString("label"));
            int id_calendar = rs.getInt("id_calendar");
            rmv.setIdCalendar(id_calendar);
            Vector<RezervariMeseView> resultsForCal = result.get(id_calendar);
            if (resultsForCal == null) {
                resultsForCal = new Vector();
                result.put(id_calendar, resultsForCal);
            }
            resultsForCal.add(rmv);
        }
        rs.close();
        return result;
    }

    public Vector<CameraId> getCalendarByStatus(int idStatus, int toFind) throws SQLException {
        Vector<CameraId> result = new Vector<CameraId>();
        this.getCalendarByStatus.setInt(1, idStatus);
        this.getCalendarByStatus.setInt(2, toFind);
        this.getCalendarByStatus.setInt(3, toFind);
        ResultSet rs = this.getCalendarByStatus.executeQuery();
        while (rs.next()) {
            CameraId id = new CameraId();
            id.setIdCalendar(rs.getInt("id"));
            id.setIdProduct(rs.getInt("id_product"));
            id.setIdTable(rs.getInt("id_table"));
            id.setStatus(idStatus);
            result.add(id);
        }
        rs.close();
        return result;
    }

    public Timestamp getStartDateForCalendar(int id) throws SQLException {
        Timestamp result = null;
        this.getStartDateForCalendar.setInt(1, id);
        ResultSet rs = this.getStartDateForCalendar.executeQuery();
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public Timestamp getStopDateForCalendar(int id) throws SQLException {
        Timestamp result = null;
        this.getStopDateForCalendar.setInt(1, id);
        ResultSet rs = this.getStopDateForCalendar.executeQuery();
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public int getStatusForCalendar(int id) throws SQLException {
        int result = -1;
        this.getStatusForCalendar.setInt(1, id);
        ResultSet rs = this.getStatusForCalendar.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public Vector<RaportDetaliatBean> getRaportDetaliat(Timestamp start, Timestamp stop, Connection connection, boolean incasate) throws SQLException {
        String s = "select " + (incasate ? " rest_incasari.dateadd as dataincasarii," : "") + (incasate ? " tip_plata.name as tipplata_nume, tip_plata.id as tipplata_id, " : "") + " tables.label as camera_nume, tables.id as camera_id, calendar.id_client as id_cazat," + " coalesce(calendar.id_agentie, " + -1 + ") as id_firma, products.label as produs_nume, products.id as produs_id," + " sum(sales.quantity_float * sales.ppu) as suma, tva.cota as cota_tva " + "from sales " + "inner join orders on sales.id_order = orders.id " + "inner join tables on tables.id = orders.id_table " + "inner join calendar on orders.id = calendar.id_order " + "inner join products on sales.id_product = products.id " + "inner join subcategories on products.id_subcategory = subcategories.id " + "inner join tva on subcategories.id_tva = tva.id " + (incasate ? "inner join rest_incasari on sales.id_plata = rest_incasari.id " : "") + (incasate ? "inner join tip_plata on rest_incasari.id_tip_plata = tip_plata.id " : "") + "where 1 = 1 " + (incasate ? " AND rest_incasari.dateadd > '" + start + "' and rest_incasari.dateadd < '" + stop + "' " : " AND orders.status = 1") + (incasate ? "" : " AND sales.id_plata is null") + " group by" + (incasate ? " rest_incasari.dateadd ," : "") + (incasate ? " tip_plata.name, tip_plata.id ," : "") + " tables.label, tables.id, calendar.id_client, calendar.id_agentie, products.label, products.id, tva.cota" + " order by " + (incasate ? "date(dateadd)," : "") + " tables.label, products.label";
        ResultSet rs = SqlUtils.executeQuery(s, connection);
        Vector<RaportDetaliatBean> result = new Vector<RaportDetaliatBean>();
        while (rs.next()) {
            RaportDetaliatBean bean = new RaportDetaliatBean();
            bean.setCamera(rs.getString("camera_nume"));
            bean.setIdTable(rs.getInt("camera_id"));
            if (incasate) {
                bean.setData(rs.getTimestamp("dataincasarii"));
                bean.setTipPlata(rs.getString("tipplata_nume"));
                bean.setIdTipPlata(rs.getInt("tipplata_id"));
            }
            bean.setIdCazat(rs.getInt("id_cazat"));
            bean.setIdFirma(rs.getInt("id_firma"));
            bean.setServiciu(rs.getString("produs_nume"));
            bean.setIdProdus(rs.getInt("produs_id"));
            bean.setCotaTva(rs.getDouble("cota_tva"));
            bean.setSuma(rs.getDouble("suma"));
            result.add(bean);
        }
        rs.close();
        return result;
    }
}

