/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.salepicture;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.logic.OrderEvent;
import ro.atreides.restaurant.logic.OrderEventReceiver;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class Module
implements ro.atreides.utils.Module {
    @Override
    public String getModuleName() {
        return "salepicture";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String rawCommand = null;
        String s0 = Utils.getCmdlineValue("-takePictureCommand", cmdArgs);
        if (Validators.correctString(s0)) {
            rawCommand = s0;
        }
        final String extension = Utils.getCmdlineValue("-pictureExtension", cmdArgs, "jpeg");
        if (rawCommand != null) {
            final String finalRawCommand = rawCommand;
            ExecutorService executor = Executors.newCachedThreadPool();
            RestLogic.getInstance().addOrderEventReceiver(new OrderEventReceiver(){

                @Override
                public void processEvent(OrderEvent event) {
                    MessageFormat command = new MessageFormat(finalRawCommand);
                    OrderEvent.OrderEventTypes type = event.getEventType();
                    switch (type) {
                        case SALE_ADDED: {
                            Sale s = (Sale)event.getValue();
                            Date saleDate = new Date(s.getSaledate());
                            s.getProductName();
                            String dateFormatted = Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(saleDate);
                            String pictureName = dateFormatted + "_" + s.getIdProduct() + "." + extension;
                            String commandToRun = Utils.getTranslation(command, pictureName);
                            try {
                                Process exec = Runtime.getRuntime().exec(commandToRun);
                                int exitValue = exec.waitFor();
                                Logger.logDebug(this, "Command exitValue: " + exitValue);
                                System.out.println("Command exitValue: " + exitValue);
                                if (exitValue != 0) break;
                                s.setImg(pictureName);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            break;
                        }
                    }
                }
            });
        }
    }
}

