/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.salesrandomizer;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import ro.atreides.ecronline.BonFiscal;
import ro.atreides.ecronline.BonFiscalItem;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;

public class Module
implements ro.atreides.utils.Module {
    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public String getModuleName() {
        return "Sales randomizer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String params = Utils.getCmdlineValue("-salesRandomizerValues", cmdArgs, "5=2500,6=10000,7=10000,8=15000,9=5000,10=7500");
        String tablesP = Utils.getCmdlineValue("-salesRandomizerTables", cmdArgs, "21,22,23,24,25,26,27,28,29,30");
        String usersP = Utils.getCmdlineValue("-salesRandomizerUsers", cmdArgs, "19,20");
        Vector months = Utils.splitString(params, ',');
        Vector tables = Utils.splitString(tablesP, ',');
        Vector users = Utils.splitString(usersP, ',');
        int startHour = 11;
        int stopHour = 23;
        int minQuantity = 1;
        int maxQuantity = 3;
        int minProduse = 2;
        int maxProduse = 3;
        Random r = new Random();
        Sectie bar = RestLogic.getInstance().getSectieById(1);
        Vector allProducts = NomeclaturaLogic.getInstance().getProductsForSectie(bar);
        ConnectionPool pool = ConnectionPool.getInstance();
        for (int i = 0; i < months.size(); ++i) {
            String s = (String)months.elementAt(i);
            StringTokenizer t = new StringTokenizer(s, "=");
            String monthS = t.nextToken();
            String valueS = t.nextToken();
            int month = Integer.parseInt(monthS) - 1;
            double value = Utils.parseDouble(valueS);
            Date d = DateUtils.getFirstDay(month, 2008);
            double dayLimit = value / 30.0;
            boolean endMonth = false;
            while (!endMonth) {
                boolean endDay = false;
                double dayTotal = 0.0;
                while (!endDay) {
                    double totalBon = 0.0;
                    Vector<BonFiscalItem> bonItems = new Vector<BonFiscalItem>();
                    int nrProd = r.nextInt(maxProduse - minProduse) + minProduse;
                    int hour = r.nextInt(stopHour - startHour) + startHour;
                    int minute = r.nextInt(60);
                    int secunde = r.nextInt(60);
                    int millis = r.nextInt(1000);
                    Date d1 = DateUtils.setTimeToDate(d, hour, minute, secunde, millis);
                    Timestamp saleTime = new Timestamp(d1.getTime());
                    for (int j = 0; j < nrProd; ++j) {
                        int productPos = r.nextInt(allProducts.size());
                        Product p = (Product)allProducts.get(productPos);
                        int q = r.nextInt(maxQuantity - minQuantity) + minQuantity;
                        BonFiscalItem bfi = new BonFiscalItem();
                        String codBare = NomeclaturaLogic.getInstance().getFirstBarcodeByIdProd(p.getId());
                        bfi.setCodBare(codBare);
                        bfi.setQuantity(q);
                        bonItems.add(bfi);
                        BonFiscal bf = new BonFiscal();
                        bf.setDataBon(saleTime.getTime());
                        bf.setItems(bonItems);
                        bf.setPlati(new Vector());
                        bf.setTotal(totalBon += (double)q * RestLogic.getInstance().getPriceForProductCommit(p.getId()));
                        try {
                            String s1 = (String)users.get(r.nextInt(users.size()));
                            int idUser = Integer.parseInt(s1);
                            String s2 = (String)tables.get(r.nextInt(tables.size()));
                            int idTable = Integer.parseInt(s2);
                            if (RestLogic.getInstance().notaByBonFiscal(bf, idUser, idTable, false, true, false)) {
                                pool.commit();
                                continue;
                            }
                            pool.rollBack();
                            continue;
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                            try {
                                pool.rollBack();
                            }
                            catch (SQLException e1) {
                                Logger.logException(this, (Exception)e1);
                            }
                            continue;
                        }
                        finally {
                            pool.releaseConnection();
                        }
                    }
                    dayTotal += totalBon;
                    System.out.println("nota noua: totalBon = " + totalBon + ", dayTotal=" + ", dayLimit=" + dayLimit);
                    if (!(dayTotal > dayLimit)) continue;
                    endDay = true;
                    System.out.println(">>> New day");
                }
                if ((d = DateUtils.advanceOneDay(d)).getMonth() == month) continue;
                endMonth = true;
                System.out.println(">>>>>>>>>>>>> New month");
            }
        }
    }
}

