/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.scale;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Vector;
import ro.atreides.restaurant.modules.scale.ScalePortInterface;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class ScaleInterfaceTcpPortImpl
implements ScalePortInterface {
    private Socket socket;
    private InputStream inS;
    private OutputStream outS;

    @Override
    public boolean buildPort(String params, boolean showErr) {
        Vector items = Utils.splitString(params, '=');
        if (items.size() < 3 || !Validators.correctString((String)items.get(1)) || !Validators.correctInteger((String)items.get(2))) {
            Logger.logError((Object)this, "Configurare incorecta . Eroare fatala!!");
            Utils.systemExit();
        }
        String ip = (String)items.get(1);
        int port = Integer.parseInt((String)items.get(2));
        try {
            this.socket = new Socket();
            InetSocketAddress sa = new InetSocketAddress(ip, port);
            this.socket.connect(sa);
            this.inS = this.socket.getInputStream();
            this.outS = this.socket.getOutputStream();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        return true;
    }

    @Override
    public void closePort() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public OutputStream getOutS() {
        return this.outS;
    }

    @Override
    public InputStream getInS() {
        return this.inS;
    }
}

