/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.transfer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;

public class TransferuriIndexServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Vector<String> products = new Vector<String>();
        products.add("All");
        products.addAll(StockLogic.getInstance().getDistinctStocksInTransfer());
        String error = request.getParameter("error");
        String errorMessage = "";
        if (error != null) {
            if (error.equals("start")) {
                errorMessage = "Data de start gresita. Introduceti una corecta";
            }
            if (error.equals("finish")) {
                errorMessage = "Data de finish gresita. Introduceti una corecta";
            }
        }
        StringBuffer buf = new StringBuffer();
        for (String product : products) {
            buf.append("\n<option>");
            buf.append(product);
            buf.append("</option>");
        }
        Date today = new Date();
        Date start = DateUtils.addDaysToDate(today, -2);
        String start_date = (String)request.getSession().getAttribute("start_date");
        String finish_date = (String)request.getSession().getAttribute("finish_date");
        String startStr = start_date != null ? start_date : Formatters.DATE_FORMAT_RO.format(start);
        String todayStr = finish_date != null ? finish_date : Formatters.DATE_FORMAT_RO.format(today);
        String content = buf.toString();
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IllegalStateException e) {
            out = response.getWriter();
        }
        response.setContentType("text/html");
        File f = new File("webapps/transfer/index.shtml");
        String fullFile = FileUtils.readFileToString(f.getAbsolutePath());
        fullFile = fullFile.replaceAll("%%OPTIUNE%%", content);
        fullFile = fullFile.replaceAll("%%START%%", startStr);
        fullFile = fullFile.replaceAll("%%FINISH%%", todayStr);
        fullFile = fullFile.replaceAll("%%ERROR%%", errorMessage);
        out.write(fullFile);
        out.flush();
    }
}

