/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.transfer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ro.atreides.restaurant.modules.transfer.StockTransferWebBean;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.Validators;

public class TransferuriPozeServlet
extends HttpServlet {
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Date parse;
        String produs = request.getParameter("produs");
        String start = request.getParameter("start");
        String finish = request.getParameter("finish");
        Timestamp startTime = new Timestamp(new Date().getTime());
        Timestamp finishTime = new Timestamp(DateUtils.addDaysToDate(new Date(), -2).getTime());
        if (Validators.correctDate(start, Formatters.DATE_FORMAT_RO)) {
            try {
                parse = Formatters.DATE_FORMAT_RO.parse(start);
                request.getSession().setAttribute("start_date", (Object)Formatters.DATE_FORMAT_RO.format(parse));
                startTime = new Timestamp(parse.getTime());
            }
            catch (ParseException e) {
                Logger.logException((Object)this, (Exception)e);
            }
        } else {
            response.sendRedirect("home?error=start");
        }
        if (Validators.correctDate(finish, Formatters.DATE_FORMAT_RO)) {
            try {
                parse = Formatters.DATE_FORMAT_RO.parse(finish);
                request.getSession().setAttribute("finish_date", (Object)Formatters.DATE_FORMAT_RO.format(parse));
                parse = DateUtils.getEndOfDay(parse);
                finishTime = new Timestamp(parse.getTime());
            }
            catch (ParseException e) {
                Logger.logException((Object)this, (Exception)e);
            }
        } else {
            response.sendRedirect("home?error=finish");
        }
        Vector<StockTransferWebBean> allData = StockLogic.getInstance().getAllStockTransfersInPeriod(produs, startTime, finishTime);
        File productForm = new File("webapps/transfer/productform.shtml");
        String productFormContentOriginal = FileUtils.readFileToString(productForm.getAbsolutePath());
        String currentDir = FileUtils.getCurrentDir();
        StringBuffer buf = new StringBuffer();
        String pictureFolder = "pictures/";
        for (StockTransferWebBean stwb : allData) {
            String copyContent = productFormContentOriginal;
            copyContent = copyContent.replaceAll("%%USER%%", stwb.getUser() != null ? " - " + stwb.getUser() : "");
            copyContent = copyContent.replaceAll("%%PRODUS%%", stwb.getProduct());
            copyContent = copyContent.replaceAll("%%CANTITATE%%", String.valueOf(stwb.getCantitate()));
            copyContent = copyContent.replaceAll("%%MAGAZIE_SURSA%%", stwb.getSursa());
            copyContent = copyContent.replaceAll("%%MAGAZIE_DESTINATIE%%", stwb.getDestinatie());
            copyContent = copyContent.replaceAll("%%DATA%%", Formatters.transferuriDateFormat.format(stwb.getDate()));
            String replacement = stwb.getImgLocation() != null ? pictureFolder + stwb.getImgLocation() : "";
            copyContent = copyContent.replaceAll("%%IMGLOC%%", replacement);
            buf.append(copyContent);
        }
        String content = buf.toString();
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IllegalStateException e) {
            out = response.getWriter();
        }
        response.setContentType("text/html");
        File f = new File("webapps/transfer/transfer.shtml");
        String fullFile = FileUtils.readFileToString(f.getAbsolutePath());
        fullFile = fullFile.replaceAll("%%CONTENT%%", content);
        out.write(fullFile);
        out.flush();
    }
}

