/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.modules.userlogserial;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import purejavacomm.CommPortIdentifier;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import ro.atreides.ecr.datecs.nativeImpl.PortSettingsPureJava;
import ro.atreides.users.User;
import ro.atreides.users.UserLogListener;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ModuleInstantiationException;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class Module
implements ro.atreides.utils.Module {
    private OutputStream outS;
    private SerialPort serialPort = null;
    private boolean connected = false;
    private Vector<String> outQueue = new Vector();

    @Override
    public String getModuleName() {
        return "UserLogSerial";
    }

    @Override
    public Collection getViews() {
        return null;
    }

    @Override
    public void init(String[] cmdArgs, Hashtable runtimeObjects) throws ModuleInstantiationException {
        String params = Utils.getCmdlineValue("-userlogserialparams", cmdArgs, "/dev/ttyS0=9600=8=1=0");
        params = params.replace("/dev/", "");
        String millisBetweenMessages = Utils.getCmdlineValue("-showtimemillis", cmdArgs, "1000");
        final long millis = Long.parseLong(millisBetweenMessages);
        Logger.logDebug(this, "userlogserialparams : " + params + " millis : " + millis);
        System.out.println("userlogserialparams : " + params + " millis : " + millis);
        Vector p = Utils.splitString(params, '=');
        final String portName = (String)p.get(0);
        if (!Validators.correctString(portName)) {
            Logger.logError((Object)this, "Port serial incorect!!");
            Utils.systemExit();
        }
        String speedS = (String)p.get(1);
        final int speed = Integer.parseInt(speedS);
        String dataBitsS = (String)p.get(2);
        final int dataBits = Integer.parseInt(dataBitsS);
        String stopBitsS = (String)p.get(3);
        final int stopBits = Integer.parseInt(stopBitsS);
        String parityS = (String)p.get(4);
        final int parity = Integer.parseInt(parityS);
        Thread th = new Thread(){

            @Override
            public void run() {
                boolean showErr = true;
                block8: while (true) {
                    try {
                        while (true) {
                            if (!Module.this.connected) {
                                boolean buildOK = Module.this.buildPort(portName, speed, dataBits, stopBits, parity, showErr);
                                if (buildOK) {
                                    Module.this.connected = true;
                                    Logger.logDebug(this, "initializat port: " + portName);
                                    showErr = true;
                                } else {
                                    showErr = false;
                                    try {
                                        Thread.sleep(3000L);
                                        continue block8;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        continue;
                                    }
                                }
                            }
                            while (Module.this.connected) {
                                try {
                                    if (Module.this.outQueue.size() > 0) {
                                        Module.this.outS.write(((String)Module.this.outQueue.remove(0)).getBytes());
                                        Module.this.outS.flush();
                                        try {
                                            Thread.sleep(millis);
                                        }
                                        catch (InterruptedException e) {}
                                        continue;
                                    }
                                    Thread.sleep(100L);
                                }
                                catch (IOException e) {
                                    Logger.logException(this, (Exception)e);
                                    Module.this.connected = false;
                                }
                            }
                            if (Module.this.serialPort == null) continue;
                            Module.this.serialPort.close();
                        }
                    }
                    catch (Throwable th) {
                        Logger.logError((Object)this, th);
                        continue;
                    }
                    break;
                }
            }
        };
        th.setName("UserLogSerial");
        th.start();
        UsersLogic.getInstance().addFrontOfficeListener(new UserLogListener(){

            @Override
            public void log(int idUser, String text) throws SQLException {
                User u = UsersLogic.getInstance().getUserByIdNoCommit(idUser);
                String text1 = u.getLogin() + ": " + text + "\n";
                Module.this.outQueue.add(text1);
            }
        });
    }

    private boolean buildPort(String portName, int speed, int dataBits, int stopBits, int parity, boolean showErr) {
        try {
            boolean portFound = false;
            CommPortIdentifier portId = null;
            Enumeration portList = CommPortIdentifier.getPortIdentifiers();
            while (portList.hasMoreElements()) {
                portId = (CommPortIdentifier)portList.nextElement();
                String shortPortName = portName.replace("/dev/", "");
                String curentElementPortName = portId.getName();
                if (!curentElementPortName.equalsIgnoreCase(portName) && !curentElementPortName.equalsIgnoreCase(shortPortName)) continue;
                Logger.logDebug(this, "Found port: " + portName);
                portFound = true;
                break;
            }
            if (!portFound) {
                if (showErr) {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "UserLogSerial: port incorect : \"" + portName + "\"", LangRoAll.nuPotContinua);
                }
                Logger.logDebug(this, "Port incorect: " + portName);
                return false;
            }
            PortSettingsPureJava settings = new PortSettingsPureJava();
            settings.setName(portName);
            settings.setSpeed(speed);
            settings.setDataBits(dataBits);
            settings.setStopBits(stopBits);
            settings.setPariry(parity);
            Logger.logInfo(Utils.class.getName(), ">>>>> Opening port: " + portName + "");
            this.serialPort = (SerialPort)portId.open("UserLogSerial", 2000);
            this.outS = this.serialPort.getOutputStream();
            this.serialPort.setSerialPortParams(settings.getSpeed(), settings.getDataBits(), settings.getStopBits(), settings.getPariry());
            Logger.logInfo(this, "Setari port serial DUPA setParams : baudRate=" + this.serialPort.getBaudRate() + " dataBits=" + this.serialPort.getDataBits() + " stopBits=" + this.serialPort.getStopBits() + " parity=" + this.serialPort.getParity());
            return true;
        }
        catch (PortInUseException e) {
            Logger.logError((Object)this, "UserLogSerial: port ocupat : \"" + portName + "\"");
        }
        catch (Exception e) {
            Logger.logException(this, e);
        }
        return false;
    }
}

