/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.store.cl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.restaurant.base.ModPreparare;
import ro.atreides.utils.db.DaoInterface;

public class ModPreparareDao
implements DaoInterface {
    private PreparedStatement selectModuriPreparare;
    private PreparedStatement addModPreparare;
    private PreparedStatement deleteModPreparare;
    private Connection connection;

    public ModPreparareDao(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.selectModuriPreparare = this.connection.prepareStatement("select * from preparare where (id = ? or ? = -1) and status = 1 order by mod_preparare");
        this.addModPreparare = this.connection.prepareStatement("insert into preparare ( mod_preparare, status ) values ( ? , 1 )");
        this.deleteModPreparare = this.connection.prepareStatement("update preparare set status = 2 where id = ?");
    }

    public void addModPreparare(String modPreparare) throws SQLException {
        this.addModPreparare.setString(1, modPreparare);
        this.addModPreparare.execute();
    }

    public void deleteModPreparare(int id) throws SQLException {
        this.deleteModPreparare.setInt(1, id);
        this.deleteModPreparare.execute();
    }

    public Vector getModuriPreparare(int id) throws SQLException {
        Vector<ModPreparare> result = new Vector<ModPreparare>();
        this.selectModuriPreparare.setInt(1, id);
        this.selectModuriPreparare.setInt(2, id);
        ResultSet rs = this.selectModuriPreparare.executeQuery();
        while (rs.next()) {
            ModPreparare mp = new ModPreparare(rs.getInt("id"), rs.getString("mod_preparare"));
            result.add(mp);
        }
        rs.close();
        return result;
    }
}

