/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.store.cl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.ecr.datecs.nativeImpl.MP55Impl;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.plati.Plata;

public class PaymentImpl
implements DaoInterface {
    private PreparedStatement deleteAllPlatiNF;
    private PreparedStatement setIdPlataToSale;
    private PreparedStatement addPlata;
    private PreparedStatement deletePlatiForOrder;
    private PreparedStatement deleteAllPlati;
    private PreparedStatement getPlatiForOrder;
    private PreparedStatement addBonFiscalNumber;
    private Connection connection;

    public PaymentImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public Vector<Plata> getPlatiForOrder(int idOrder, int clientIndex) throws SQLException {
        Vector<Plata> result = new Vector<Plata>();
        this.getPlatiForOrder.setInt(1, idOrder);
        this.getPlatiForOrder.setInt(2, clientIndex);
        this.getPlatiForOrder.setInt(3, clientIndex);
        ResultSet rs = this.getPlatiForOrder.executeQuery();
        while (rs.next()) {
            Plata plata = new Plata(rs.getInt("idTipPlata"), rs.getDouble("suma"), rs.getString("map_ecr"), rs.getString("name"), rs.getString("comment"), rs.getInt("client_index"));
            result.add(plata);
        }
        rs.close();
        return result;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.addBonFiscalNumber = this.connection.prepareStatement("insert into bonfiscal_numbers(id_order,nr_casa,nr_z,nr_bon,cod_oper) values ( ?, ?, ?, ?, ?)");
        this.setIdPlataToSale = this.connection.prepareStatement("update sales set id_plata = ? where id = ?");
        this.deleteAllPlatiNF = this.connection.prepareStatement("delete from rest_incasari where id_order in ( select id from orders where (fiscal is null or fiscal = 'false') and (orders.status = 3 or orders.status = 4) ) ");
        this.addPlata = this.connection.prepareStatement("insert into rest_incasari (id_order, id_tip_plata, suma, comment, client_index ) values ( ?, ?, ?, ?, ? )");
        this.deletePlatiForOrder = this.connection.prepareStatement("delete from rest_incasari where id_order = ? and (client_index = ? or ? = -1) and (id_tip_plata = ? or ? = -1)");
        this.deleteAllPlati = this.connection.prepareStatement("delete from rest_incasari");
        this.getPlatiForOrder = this.connection.prepareStatement("select sum(rest_incasari.suma) as suma, rest_incasari.comment as comment, tip_plata.id as idTipPlata, tip_plata.map_ecr, tip_plata.name, rest_incasari.client_index from rest_incasari inner join tip_plata on rest_incasari.id_tip_plata = tip_plata.id where id_order = ? and (client_index = ? or ? = -1) group by rest_incasari.comment, rest_incasari.client_index, tip_plata.id, tip_plata.map_ecr, tip_plata.name, tip_plata.is_default order by tip_plata.is_default");
    }

    public void addBonFiscalNumber(int idOrder, int nrBon, int nrZ, int idCasa, MP55Impl.CASA_EXPLAIN_MESSAGES explain_messages) throws SQLException {
        this.addBonFiscalNumber.setInt(1, idOrder);
        this.addBonFiscalNumber.setInt(2, idCasa);
        this.addBonFiscalNumber.setInt(3, nrZ);
        this.addBonFiscalNumber.setInt(4, nrBon);
        this.addBonFiscalNumber.setInt(5, explain_messages.getCode());
        this.addBonFiscalNumber.execute();
    }

    public void deletePlatiForOrder(int idOrder, int clientIndex, int idTipPlata) throws SQLException {
        this.deletePlatiForOrder.setInt(1, idOrder);
        this.deletePlatiForOrder.setInt(2, clientIndex);
        this.deletePlatiForOrder.setInt(3, clientIndex);
        this.deletePlatiForOrder.setInt(4, idTipPlata);
        this.deletePlatiForOrder.setInt(5, idTipPlata);
        this.deletePlatiForOrder.execute();
    }

    public void addPlata(int idOrder, int idTipPlata, double suma, String comment, int clientIndex) throws SQLException {
        this.addPlata.setInt(1, idOrder);
        this.addPlata.setInt(2, idTipPlata);
        this.addPlata.setDouble(3, suma);
        this.addPlata.setString(4, comment);
        this.addPlata.setInt(5, clientIndex);
        this.addPlata.execute();
    }

    public void deleteAllPlati() throws SQLException {
        this.deleteAllPlati.execute();
    }

    public void deleteAllPlatiNF() throws SQLException {
        this.deleteAllPlatiNF.execute();
    }

    public void addPlataToSale(int idPlata, int idSale) throws SQLException {
        this.setIdPlataToSale.setInt(1, idPlata);
        this.setIdPlataToSale.setInt(2, idSale);
        this.setIdPlataToSale.execute();
    }
}

