/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.store.cl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.restaurant.base.NewRecipeEntry;
import ro.atreides.restaurant.base.RecipeItem;
import ro.atreides.restaurant.gui.admin.recipe.RecipeEntry;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.DaoInterface;

public class RestProductsImpl
implements DaoInterface {
    protected Connection connection;
    private PreparedStatement addRecipeItem;
    private PreparedStatement selectProductsByUsedStock;
    private PreparedStatement selectRecipesByProdusRetetaId;
    private PreparedStatement deleteRecipeItem;
    private PreparedStatement addProduseReteta;
    private PreparedStatement getPriceForRetetaProduct;
    private PreparedStatement setPriceForRetetaProduct;
    private PreparedStatement selectIngredientsForProduct;
    private PreparedStatement selectRecipesForCategory;
    private PreparedStatement deleteAllRecipes;
    private PreparedStatement deleteAllProduseReteta;
    private PreparedStatement deleteAllProductie;
    private PreparedStatement getIdRetetaForProduct;
    private PreparedStatement getProductByIdReteta;
    private PreparedStatement getProductieForProduct;
    private PreparedStatement setProductieForReteta;
    private PreparedStatement getProduseReteta;
    private PreparedStatement deleteProductById;
    private PreparedStatement updateTipContClientForProductId;
    private PreparedStatement getModPreparare;
    private PreparedStatement setModPreparare;
    private PreparedStatement getIdStockForProduct;
    private PreparedStatement deleteProdusReteta;

    public RestProductsImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.deleteProdusReteta = this.connection.prepareStatement("delete from produse_reteta where id = ?");
        this.deleteAllProductie = this.connection.prepareStatement("delete from productie");
        this.deleteAllRecipes = this.connection.prepareStatement("delete from recipes");
        this.getProduseReteta = this.connection.prepareStatement("select id_product from produse_reteta");
        this.deleteAllProduseReteta = this.connection.prepareStatement("delete from produse_reteta");
        this.deleteProductById = this.connection.prepareStatement("delete from products where id = ?");
        this.updateTipContClientForProductId = this.connection.prepareStatement("update tip_cont_client set produs_fictiv = ? where produs_fictiv =? ");
        this.addProduseReteta = this.connection.prepareStatement("insert into produse_reteta( id_product, sell_price, status, mod_preparare, productie) values (?, ?, 1, ?, ? )");
        this.addRecipeItem = this.connection.prepareStatement("insert into recipes ( id_parent, id_stock, id_product, quantity ) values ( ?, ?, ?, ? ) ");
        this.deleteRecipeItem = this.connection.prepareStatement("delete from recipes where id = ?");
        this.selectRecipesByProdusRetetaId = this.connection.prepareStatement("select * from recipes where id_parent = ?");
        this.selectProductsByUsedStock = this.connection.prepareStatement("select products.label as produs from products inner join produse_reteta on products.id = produse_reteta.id_product inner join recipes on recipes.id_parent = produse_reteta.id where recipes.id_stock = ? and products.status = 1");
        this.getPriceForRetetaProduct = this.connection.prepareStatement("select sell_price from produse_reteta where id = ?");
        this.setPriceForRetetaProduct = this.connection.prepareStatement("update produse_reteta set sell_price = ? where id = ?");
        this.selectIngredientsForProduct = this.connection.prepareStatement("select stocks.label as stock_label, products.label as produs_label, coalesce(messages.label, 'Buc') as um_label, recipes.id_product as id_product, recipes.id_stock as id_stock, recipes.id_parent as id_parent, recipes.quantity as quantity, recipes.id as id from recipes  left outer join products on recipes.id_product = products.id left outer join produse_finite on products.id = produse_finite.id_product left outer join produse_reteta on products.id = produse_reteta.id_product left outer join stocks on (recipes.id_stock = stocks.id OR produse_finite.id_stock = stocks.id) left outer join units on stocks.id_unit = units.id left outer join keys on units.id_key = keys.id left outer join messages on keys.id = messages.id_key where recipes.id_parent = ? and (messages.id_lang = ? OR messages.id_lang IS NULL)");
        this.selectRecipesForCategory = this.connection.prepareStatement("select products.label as produs, subcategories.label as subcategory, produse_reteta.sell_price as pret, produse_reteta.id as id_reteta, products.id as id_produs, products.cod as cod, products.cod_bare as cod_bare, products.uz_intern as uz_intern from produse_reteta inner join products on produse_reteta.id_product = products.id inner join subcategories on products.id_subcategory = subcategories.id inner join categories on subcategories.id_category = categories.id where ( categories.id = ? or ? = -1 ) and ( subcategories.id = ? or ? = -1 ) and ( products.id = ? or ? = -1 ) and products.status = 1 order by subcategory, products.label");
        this.getIdRetetaForProduct = this.connection.prepareStatement("select produse_reteta.id from products inner join produse_reteta on products.id = produse_reteta.id_product where products.id = ?");
        this.getProductByIdReteta = this.connection.prepareStatement("select id_product from produse_reteta where id = ?");
        this.getProductieForProduct = this.connection.prepareStatement("select produse_reteta.productie from products inner join produse_reteta on products.id = produse_reteta.id_product where products.id = ?");
        this.setProductieForReteta = this.connection.prepareStatement("update produse_reteta set productie = ? where id = ?");
        this.getModPreparare = this.connection.prepareStatement("select mod_preparare from produse_reteta where id = ?");
        this.setModPreparare = this.connection.prepareStatement("update produse_reteta set mod_preparare = ? where id = ?");
        this.getIdStockForProduct = this.connection.prepareStatement("select id_stock from produse_finite where id_product = ?");
    }

    public int getidProductByIdReteta(int idProdusReteta) throws SQLException {
        int result = -1;
        this.getProductByIdReteta.setInt(1, idProdusReteta);
        ResultSet rs = this.getProductByIdReteta.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void deleteProdusReteta(int idProdusReteta) throws SQLException {
        this.deleteProdusReteta.setInt(1, idProdusReteta);
        this.deleteProdusReteta.execute();
    }

    public int getIdStockForProduct(int idProduct) throws SQLException {
        int result = -1;
        this.getIdStockForProduct.setInt(1, idProduct);
        ResultSet rs = this.getIdStockForProduct.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void setModPreparare(int idReteta, String mp) throws SQLException {
        this.setModPreparare.setString(1, mp);
        this.setModPreparare.setInt(2, idReteta);
        this.setModPreparare.execute();
    }

    public String getModPreparare(int idReteta) throws SQLException {
        String result = "";
        this.getModPreparare.setInt(1, idReteta);
        ResultSet rs = this.getModPreparare.executeQuery();
        if (rs.next()) {
            result = rs.getString(1);
        }
        rs.close();
        return result;
    }

    public boolean isProductie(int idProduct) throws SQLException {
        boolean result = false;
        this.getProductieForProduct.setInt(1, idProduct);
        ResultSet rs = this.getProductieForProduct.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1) == 1;
        }
        rs.close();
        return result;
    }

    public void setProductieForReteta(boolean productie, int idReteta) throws SQLException {
        this.setProductieForReteta.setInt(1, productie ? 1 : 0);
        this.setProductieForReteta.setInt(2, idReteta);
        this.setProductieForReteta.execute();
    }

    public int getIdRetetaForProduct(int idProduct) throws SQLException {
        int result = -1;
        this.getIdRetetaForProduct.setInt(1, idProduct);
        ResultSet rs = this.getIdRetetaForProduct.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void stergeRetetaContent(int idReteta) throws SQLException {
    }

    public void deleteAllRecipes() throws SQLException {
        this.deleteAllProductie.execute();
        this.deleteAllRecipes.execute();
        Vector<Integer> allProduseReteta = new Vector<Integer>();
        ResultSet rs = this.getProduseReteta.executeQuery();
        while (rs.next()) {
            allProduseReteta.add(rs.getInt(1));
        }
        rs.close();
        this.deleteAllProduseReteta.execute();
        for (int i = 0; i < allProduseReteta.size(); ++i) {
            Integer o = (Integer)allProduseReteta.elementAt(i);
            this.updateTipContClientForProductId.setNull(1, 4);
            this.updateTipContClientForProductId.setInt(2, o);
            this.updateTipContClientForProductId.execute();
            this.deleteProductById.setInt(1, o);
            this.deleteProductById.execute();
        }
    }

    public Vector getRecipeEntries(int idSectie, int idCategorie, int idProdus) throws SQLException {
        Vector<RecipeEntry> result = new Vector<RecipeEntry>();
        this.selectRecipesForCategory.setInt(1, idSectie);
        this.selectRecipesForCategory.setInt(2, idSectie);
        this.selectRecipesForCategory.setInt(3, idCategorie);
        this.selectRecipesForCategory.setInt(4, idCategorie);
        this.selectRecipesForCategory.setInt(5, idProdus);
        this.selectRecipesForCategory.setInt(6, idProdus);
        ResultSet rs = this.selectRecipesForCategory.executeQuery();
        while (rs.next()) {
            RecipeEntry re = new RecipeEntry(rs.getString("subcategory"), rs.getString("produs"), rs.getDouble("pret"), rs.getInt("id_reteta"), rs.getInt("id_produs"), rs.getInt("cod"), rs.getString("cod_bare"), rs.getInt("uz_intern") == 1);
            result.add(re);
        }
        rs.close();
        return result;
    }

    public Vector getRetetarViewEntries(int idProdusReteta, int idLang) throws SQLException {
        Vector<NewRecipeEntry> result = new Vector<NewRecipeEntry>();
        this.selectIngredientsForProduct.setInt(1, idProdusReteta);
        this.selectIngredientsForProduct.setInt(2, idLang);
        ResultSet rs = this.selectIngredientsForProduct.executeQuery();
        while (rs.next()) {
            NewRecipeEntry ne = new NewRecipeEntry();
            int stockId = rs.getInt("id_stock");
            int productId = rs.getInt("id_product");
            if (stockId > 0) {
                ne.setIdStock(stockId);
                ne.setName(rs.getString("stock_label"));
                ne.setUm(rs.getString("um_label"));
            } else {
                ne.setName(rs.getString("produs_label"));
                ne.setUm(rs.getString("um_label"));
                ne.setIdProduct(productId);
            }
            ne.setQuantity(rs.getDouble("quantity"));
            ne.setId(rs.getInt("id"));
            result.add(ne);
        }
        rs.close();
        return result;
    }

    public Vector getProductsThatUseIngredient(int idStock) throws SQLException {
        Vector<String> result = new Vector<String>();
        this.selectProductsByUsedStock.setInt(1, idStock);
        ResultSet rs = this.selectProductsByUsedStock.executeQuery();
        while (rs.next()) {
            result.add(rs.getString("produs"));
        }
        rs.close();
        return result;
    }

    public void addProdusReteta(int idProduct, double sellPrice, String modPreparare, boolean productie) throws SQLException {
        this.addProduseReteta.setInt(1, idProduct);
        this.addProduseReteta.setDouble(2, sellPrice);
        this.addProduseReteta.setString(3, modPreparare);
        this.addProduseReteta.setInt(4, productie ? 1 : 0);
        this.addProduseReteta.execute();
    }

    public void addRecipeItem(int idParent, int idStock, int idProduct, double quantity) throws SQLException {
        this.addRecipeItem.setInt(1, idParent);
        this.addRecipeItem.setInt(2, idStock);
        this.addRecipeItem.setInt(3, idProduct);
        this.addRecipeItem.setDouble(4, quantity);
        this.addRecipeItem.execute();
    }

    public Vector getRecipeItemsForProdusRetetaId(int idProdusReteta) throws SQLException {
        Vector<RecipeItem> result = new Vector<RecipeItem>();
        this.selectRecipesByProdusRetetaId.setInt(1, idProdusReteta);
        ResultSet rs = this.selectRecipesByProdusRetetaId.executeQuery();
        while (rs.next()) {
            int stockId = rs.getInt("id_stock");
            int productId = rs.getInt("id_product");
            int id = rs.getInt("id");
            int idParent = rs.getInt("id_parent");
            RecipeItem item = new RecipeItem();
            if (stockId > 0) {
                item.setIdStock(stockId);
            } else if (productId > 0) {
                item.setIdProduct(productId);
            } else {
                Logger.logWarning(this, "PROBLEME1 : id : " + id + " stockId : " + stockId + " productId : " + productId + " idParent : " + idParent);
                continue;
            }
            item.setQuantity(rs.getDouble("quantity"));
            item.setId(id);
            item.setIdParent(idParent);
            result.add(item);
        }
        rs.close();
        return result;
    }

    public void deleteRecipeItem(int toDelete) throws SQLException {
        this.deleteRecipeItem.setInt(1, toDelete);
        this.deleteRecipeItem.execute();
    }

    public double getPriceForRetetaProduct(int idReteta) throws SQLException {
        double result = -1.0;
        this.getPriceForRetetaProduct.setInt(1, idReteta);
        ResultSet rs = this.getPriceForRetetaProduct.executeQuery();
        if (rs.next()) {
            result = rs.getDouble(1);
        }
        rs.close();
        return result;
    }

    public void setPriceForRetetaProduct(int idReteta, double newPrice) throws SQLException {
        this.setPriceForRetetaProduct.setDouble(1, newPrice);
        this.setPriceForRetetaProduct.setInt(2, idReteta);
        this.setPriceForRetetaProduct.execute();
    }
}

