/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.store.cl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.restaurant.base.OrdineServire;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.reports.VanzareNedescarcata;
import ro.atreides.utils.db.DaoInterface;

public class SalesImpl
implements DaoInterface {
    private PreparedStatement insertIntoSales;
    private PreparedStatement updateSale;
    private PreparedStatement deleteSale;
    private PreparedStatement addOrdineServire;
    private PreparedStatement deleteOrdineServire;
    private PreparedStatement selectOrdineServire;
    private PreparedStatement deleteAllSales;
    private PreparedStatement deleteAllSalesNF;
    private PreparedStatement getVanzariNeprocesate;
    private PreparedStatement selectOrdineServireByLabel;
    private PreparedStatement setSalePrinted;
    private PreparedStatement setClientIndexToSale;
    private PreparedStatement setServireToSale;
    private PreparedStatement setSaleFacturata;
    private PreparedStatement setFreeParams;
    private PreparedStatement insertIntoSalesPictures;
    private PreparedStatement getImgSrcFromSalesPictures;
    private Connection connection;

    public SalesImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.setFreeParams = this.connection.prepareStatement("update sales set freeS1 = ? , freeS2 = ?, freeD1 = ?, freeD2 = ? , freeI1 = ? where id = ?");
        this.setServireToSale = this.connection.prepareStatement("update sales set id_servire = ? where id = ?");
        this.setSalePrinted = this.connection.prepareStatement("update sales set printed = 1 where id = ?");
        this.setSaleFacturata = this.connection.prepareStatement("update sales set facturata = ? where id = ?");
        this.insertIntoSales = this.connection.prepareStatement("insert into sales (id_order, id_product, quantity_float, ppu, ppu_original, id_promotion, saledate, mod_preparare, id_platou, discount, id_servire, id_user2, client_index, freeS1, freeS2, freeD1, freeD2, freeI1, ignore_promo, id_lot) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.updateSale = this.connection.prepareStatement("update sales set quantity_float = ?, id_promotion = ?, discount = ?, ppu = ? where id = ?");
        this.deleteSale = this.connection.prepareStatement("delete from sales where id = ?");
        this.addOrdineServire = this.connection.prepareStatement("insert into servire (servire, status ) values ( ? , 1 )");
        this.deleteOrdineServire = this.connection.prepareStatement("update servire set status = 2 where id = ?");
        this.selectOrdineServire = this.connection.prepareStatement("select * from servire where status = 1 and (id = ? or ? = -1 ) order by id");
        this.selectOrdineServireByLabel = this.connection.prepareStatement("select * from servire where servire = ?");
        this.deleteAllSales = this.connection.prepareStatement("delete from sales");
        this.getVanzariNeprocesate = this.connection.prepareStatement("select sum(quantity_float) as cantitate, sales.id_product, categories.label as categorie, products.label as produs, categories.id as id_sectie from sales inner join products on sales.id_product = products.id inner join subcategories on products.id_subcategory = subcategories.id inner join categories on subcategories.id_category = categories.id  where 1 =1 and descarcata = 0 and sales.saledate >= ? and sales.saledate < ? group by sales.id_product, categories.label, products.label, categories.id order by categories.label, products.label");
        this.deleteAllSalesNF = this.connection.prepareStatement("delete from sales where id_order in ( select id from orders where (fiscal is null or fiscal = 'false') and (orders.status = 3 or orders.status = 4) ) ");
        this.setClientIndexToSale = this.connection.prepareStatement("update sales set client_index = ? where id = ?");
        this.insertIntoSalesPictures = this.connection.prepareStatement("insert into sales_pictures (id_sale, picture_name) values (?, ?)");
        this.getImgSrcFromSalesPictures = this.connection.prepareStatement("select picture_name from sales_pictures where id_sale = ?");
    }

    public void setServireToSale(int idSale, int idServire) throws SQLException {
        if (idServire > 0) {
            this.setServireToSale.setInt(1, idServire);
        } else {
            this.setServireToSale.setNull(1, 4);
        }
        this.setServireToSale.setInt(2, idSale);
        this.setServireToSale.execute();
    }

    public void setClientIndexToSale(int idSale, int clientIndex) throws SQLException {
        this.setClientIndexToSale.setInt(1, clientIndex);
        this.setClientIndexToSale.setInt(2, idSale);
        this.setClientIndexToSale.execute();
    }

    public void setSalePrinted(int id) throws SQLException {
        this.setSalePrinted.setInt(1, id);
        this.setSalePrinted.execute();
    }

    public void setSaleFacturata(int id, boolean facturata) throws SQLException {
        this.setSaleFacturata.setInt(1, facturata ? 1 : 0);
        this.setSaleFacturata.setInt(2, id);
        this.setSaleFacturata.execute();
    }

    public Vector getVanzariNeprocesate(Timestamp start, Timestamp stop) throws SQLException {
        Vector<VanzareNedescarcata> result = new Vector<VanzareNedescarcata>();
        this.getVanzariNeprocesate.setTimestamp(1, start);
        this.getVanzariNeprocesate.setTimestamp(2, stop);
        ResultSet rs = this.getVanzariNeprocesate.executeQuery();
        while (rs.next()) {
            VanzareNedescarcata v = new VanzareNedescarcata();
            v.setCantitate(rs.getDouble("cantitate"));
            v.setIdProduct(rs.getInt("id_product"));
            v.setProdus(rs.getString("produs"));
            v.setSectie(rs.getString("categorie"));
            v.setIdSectie(rs.getInt("id_sectie"));
            result.add(v);
        }
        return result;
    }

    public void deleteFromSales() throws SQLException {
        this.deleteAllSales.execute();
    }

    public void deleteFromSalesNF() throws SQLException {
        this.deleteAllSalesNF.execute();
    }

    public void addSale(Sale toAdd, int idRevenueGenerator) throws SQLException {
        this.insertIntoSales.setInt(1, toAdd.getIdOrder());
        this.insertIntoSales.setInt(2, toAdd.getIdProduct());
        this.insertIntoSales.setDouble(3, toAdd.getCantitateNoua());
        this.insertIntoSales.setDouble(4, toAdd.getPrice());
        this.insertIntoSales.setDouble(5, toAdd.getPpuOriginal());
        this.insertIntoSales.setInt(6, toAdd.getIdPromotie());
        this.insertIntoSales.setTimestamp(7, new Timestamp(toAdd.getSaledate()));
        this.insertIntoSales.setString(8, toAdd.getModPreparare());
        this.insertIntoSales.setInt(9, toAdd.getIdPlatou());
        this.insertIntoSales.setDouble(10, toAdd.getDiscount());
        if (toAdd.getIdServire() <= 0) {
            this.insertIntoSales.setNull(11, 4);
        } else {
            this.insertIntoSales.setInt(11, toAdd.getIdServire());
        }
        this.insertIntoSales.setInt(12, idRevenueGenerator);
        this.insertIntoSales.setInt(13, toAdd.getClientIndex());
        this.insertIntoSales.setString(14, toAdd.getFreeS1());
        this.insertIntoSales.setString(15, toAdd.getFreeS2());
        this.insertIntoSales.setDouble(16, toAdd.getFreeD1());
        this.insertIntoSales.setDouble(17, toAdd.getFreeD2());
        this.insertIntoSales.setInt(18, toAdd.getFreeI1());
        this.insertIntoSales.setInt(19, toAdd.ignorePromotion() ? 1 : 0);
        int idLot = toAdd.getIdLot();
        if (idLot > 0) {
            this.insertIntoSales.setInt(20, idLot);
        } else {
            this.insertIntoSales.setNull(20, 4);
        }
        this.insertIntoSales.execute();
    }

    public void deleteSale(int idSale) throws SQLException {
        this.deleteSale.setInt(1, idSale);
        this.deleteSale.execute();
    }

    public void updateSale(int idSale, double cant, int idPromo, double discount, double price) throws SQLException {
        this.updateSale.setDouble(1, cant);
        this.updateSale.setInt(2, idPromo);
        this.updateSale.setDouble(3, discount);
        this.updateSale.setDouble(4, price);
        this.updateSale.setInt(5, idSale);
        this.updateSale.execute();
    }

    public void addOrdineServire(String servire) throws SQLException {
        this.addOrdineServire.setString(1, servire);
        this.addOrdineServire.execute();
    }

    public void deleteOrdineServire(int id) throws SQLException {
        this.deleteOrdineServire.setInt(1, id);
        this.deleteOrdineServire.execute();
    }

    public Vector<OrdineServire> getOrdineServire(int idOrdineServire) throws SQLException {
        Vector<OrdineServire> result = new Vector<OrdineServire>();
        this.selectOrdineServire.setInt(1, idOrdineServire);
        this.selectOrdineServire.setInt(2, idOrdineServire);
        ResultSet rs = this.selectOrdineServire.executeQuery();
        while (rs.next()) {
            OrdineServire mp = new OrdineServire(rs.getInt("id"), rs.getString("servire"));
            result.add(mp);
        }
        rs.close();
        return result;
    }

    public OrdineServire getOrdineServireByLabel(String label) throws SQLException {
        OrdineServire result = null;
        this.selectOrdineServireByLabel.setString(1, label);
        ResultSet rs = this.selectOrdineServireByLabel.executeQuery();
        if (rs.next()) {
            result = new OrdineServire(rs.getInt("id"), rs.getString("servire"));
        }
        rs.close();
        return result;
    }

    public void setFreeFieldsToSale(int idSale, Sale data) throws SQLException {
        this.setFreeParams.setString(1, data.getFreeS1());
        this.setFreeParams.setString(2, data.getFreeS1());
        this.setFreeParams.setDouble(3, data.getFreeD1());
        this.setFreeParams.setDouble(4, data.getFreeD2());
        this.setFreeParams.setInt(5, data.getFreeI1());
        this.setFreeParams.setInt(6, idSale);
    }

    public void insertIntoSalesPictures(int idSale, String pictureName) throws SQLException {
        this.insertIntoSalesPictures.setInt(1, idSale);
        this.insertIntoSalesPictures.setString(2, pictureName);
        this.insertIntoSalesPictures.execute();
    }

    public String getImgSrcFromSalesPictures(int idSale) throws SQLException {
        String result = null;
        this.getImgSrcFromSalesPictures.setInt(1, idSale);
        ResultSet rs = this.getImgSrcFromSalesPictures.executeQuery();
        if (rs.next()) {
            result = rs.getString("picture_name");
        }
        return result;
    }
}

