/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.restaurant.store.cl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.store.cl.TableCodsBean;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.gui.Validators;

public class TablesImpl
implements DaoInterface {
    private PreparedStatement selectAllTables;
    private PreparedStatement selectTableById;
    private PreparedStatement deleteTable;
    private PreparedStatement addTable;
    private PreparedStatement selectTablesByLocation;
    private PreparedStatement selectTablesByLocationAndName;
    private PreparedStatement deleteAll;
    private PreparedStatement getFirstFreeTable;
    private PreparedStatement updateTable;
    private PreparedStatement setCodAutentificare;
    private PreparedStatement getByCodAutentificare;
    private PreparedStatement getAllCodAutentificareForTables;
    private PreparedStatement setDefectaStatusForTable;
    private PreparedStatement setMurdaraStatusForTable;
    private Connection connection;

    public TablesImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.setDefectaStatusForTable = this.connection.prepareStatement("update tables set defecta = ? where id = ?");
        this.setMurdaraStatusForTable = this.connection.prepareStatement("update tables set murdara = ? where id = ?");
        this.updateTable = this.connection.prepareStatement("update tables set label = ?, scaune = ?, virtuala = ?, full_details = ? where id = ?");
        this.deleteAll = this.connection.prepareStatement("delete from tables");
        this.selectAllTables = this.connection.prepareStatement("select * from tables where status = 1 and id_locatie in (select id from locations where tip = ? or ? = -1 )");
        this.selectTableById = this.connection.prepareStatement("select * from tables where id =?");
        this.deleteTable = this.connection.prepareStatement("update tables set status = 2 where id = ?");
        this.addTable = this.connection.prepareStatement("insert into tables (label, id_locatie, scaune, virtuala, full_details, status) values ( ?, ?, ?, ?, ?, 1 )");
        this.selectTablesByLocation = this.connection.prepareStatement("select * from tables where id_locatie = ? and status = 1");
        this.selectTablesByLocationAndName = this.connection.prepareStatement("select * from tables where id_locatie = ? and status = 1 and label = ?");
        this.getFirstFreeTable = this.connection.prepareStatement("select * from tables where status = 1 and (id_locatie = ? or ? = -1) and id not in ( select id_table from orders where closedate IS NULL )");
        this.setCodAutentificare = this.connection.prepareStatement("update tables set cod_autentificare = ? where id = ?");
        this.getByCodAutentificare = this.connection.prepareStatement("select * from tables where cod_autentificare = ? and status = 1");
        this.getAllCodAutentificareForTables = this.connection.prepareStatement("select tables.label as nume_masa, locations.name as nume_locatie, cod_autentificare from tables inner join locations on tables.id_locatie = locations.id where locations.status = 1 and tables.status = 1 order by locations.name, tables.label");
    }

    public Vector getAllCodAutentificareForTables() throws SQLException {
        ResultSet rs = this.getAllCodAutentificareForTables.executeQuery();
        Vector<TableCodsBean> result = new Vector<TableCodsBean>();
        while (rs.next()) {
            String cod = rs.getString("cod_autentificare");
            if (!Validators.correctString(cod)) continue;
            String tableName = rs.getString("nume_masa");
            String locatieName = rs.getString("nume_locatie");
            TableCodsBean tcb = new TableCodsBean();
            tcb.setCod(cod);
            tcb.setLocatieName(locatieName);
            tcb.setTableName(tableName);
            result.add(tcb);
        }
        rs.close();
        return result;
    }

    public void setCodAutentificare(String cod, int id) throws SQLException {
        this.setCodAutentificare.setString(1, cod);
        this.setCodAutentificare.setInt(2, id);
        this.setCodAutentificare.execute();
    }

    public Table getByCodAutentificare(String cod) throws SQLException {
        this.getByCodAutentificare.setString(1, cod);
        ResultSet rs = this.getByCodAutentificare.executeQuery();
        Table t = null;
        if (rs.next()) {
            t = this.getTableFromResultSet(rs);
        }
        rs.close();
        return t;
    }

    public Table getFirstFreeTable(int idLocatie) throws SQLException {
        this.getFirstFreeTable.setInt(1, idLocatie);
        this.getFirstFreeTable.setInt(2, idLocatie);
        ResultSet rs = this.getFirstFreeTable.executeQuery();
        Table t = null;
        if (rs.next()) {
            t = this.getTableFromResultSet(rs);
        }
        rs.close();
        return t;
    }

    public Vector<Table> getTables(int tipLocatie) throws SQLException {
        Vector<Table> result = new Vector<Table>();
        this.selectAllTables.setInt(1, tipLocatie);
        this.selectAllTables.setInt(2, tipLocatie);
        ResultSet rs = this.selectAllTables.executeQuery();
        while (rs.next()) {
            result.add(this.getTableFromResultSet(rs));
        }
        rs.close();
        return result;
    }

    private Table getTableFromResultSet(ResultSet rs) throws SQLException {
        Table t = new Table(new Integer(rs.getInt("id")), rs.getString("label"), rs.getInt("id_locatie"), rs.getInt("scaune"), rs.getInt("virtuala") == 1, rs.getString("full_details"));
        boolean defecta = rs.getInt("defecta") == 1;
        boolean murdara = rs.getInt("murdara") == 1;
        t.setDefecta(defecta);
        t.setMurdara(murdara);
        return t;
    }

    public Table getTableById(int id) throws SQLException {
        Table result = null;
        this.selectTableById.setInt(1, id);
        ResultSet rs = this.selectTableById.executeQuery();
        if (rs.next()) {
            result = this.getTableFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public void updateTable(String newName, int scaune, boolean virtuala, String fullDetails, int id) throws SQLException {
        this.updateTable.setString(1, newName);
        this.updateTable.setInt(2, scaune);
        this.updateTable.setInt(3, virtuala ? 1 : 0);
        this.updateTable.setString(4, fullDetails);
        this.updateTable.setInt(5, id);
        this.updateTable.execute();
    }

    public void addTable(Table table) throws SQLException {
        this.addTable.setString(1, table.getLabel());
        this.addTable.setInt(2, table.getIdLocatie());
        this.addTable.setInt(3, table.getLocuri());
        this.addTable.setInt(4, table.isVirtuala() ? 1 : 0);
        this.addTable.setString(5, table.getFullDetails());
        this.addTable.execute();
    }

    public void deleteTable(Table toDelete) throws SQLException {
        this.deleteTable.setInt(1, toDelete.getId());
        this.deleteTable.execute();
    }

    public Vector<Table> selectTablesByIdLocation(int idLocation) throws SQLException {
        Vector<Table> result = new Vector<Table>();
        this.selectTablesByLocation.setInt(1, idLocation);
        ResultSet rs = this.selectTablesByLocation.executeQuery();
        while (rs.next()) {
            result.add(this.getTableFromResultSet(rs));
        }
        rs.close();
        return result;
    }

    public Table selectTableByLocatieAndName(int idLocatie, String name) throws SQLException {
        Table result = null;
        this.selectTablesByLocationAndName.setInt(1, idLocatie);
        this.selectTablesByLocationAndName.setString(2, name);
        ResultSet rs = this.selectTablesByLocationAndName.executeQuery();
        if (rs.next()) {
            result = this.getTableFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public void cleanupTables() throws SQLException {
        this.deleteAll.execute();
    }

    public void setDefecta(int idCamera, boolean defecta) throws SQLException {
        this.setDefectaStatusForTable.setInt(1, defecta ? 1 : 0);
        this.setDefectaStatusForTable.setInt(2, idCamera);
        this.setDefectaStatusForTable.execute();
    }

    public void setMurdara(int idCamera, boolean murdara) throws SQLException {
        this.setMurdaraStatusForTable.setInt(1, murdara ? 1 : 0);
        this.setMurdaraStatusForTable.setInt(2, idCamera);
        this.setMurdaraStatusForTable.execute();
    }
}

