/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.simplestocks;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.simplestocks.CheckStockInDepositInterface;
import ro.atreides.simplestocks.SimpleStockEntry;
import ro.atreides.simplestocks.db.SimpleStocksDao;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;

public class SimpleStockLogic
implements CheckStockInDepositInterface {
    private static SimpleStockLogic instance;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private SimpleStockLogic() {
    }

    public static synchronized SimpleStockLogic getInstance() {
        if (instance == null) {
            instance = new SimpleStockLogic();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getStocks(int idMagazie, int what) {
        Vector result = new Vector();
        if (idMagazie != -1) {
            try {
                result = this.getDao().getStocksForMagazie(idMagazie, -1, 1, what);
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
        } else {
            Vector allStocks = StockLogic.getInstance().getPowerSearchStocks();
            Vector<Magazie> allMagazii = StockLogic.getInstance().getMagazii();
            for (int i = 0; i < allStocks.size(); ++i) {
                Stock s = (Stock)allStocks.elementAt(i);
                for (int j = 0; j < allMagazii.size(); ++j) {
                    Magazie m = allMagazii.elementAt(j);
                    try {
                        SimpleStockEntry se = null;
                        Vector fise = this.getDao().getStocksForMagazie(m.getId(), s.getId(), 1, what);
                        if (fise.size() > 0) {
                            se = (SimpleStockEntry)fise.elementAt(0);
                        } else {
                            se = new SimpleStockEntry();
                            se.setIdMagazie(m.getId());
                            se.setMagazie(m.getLabel());
                            se.setIdStock(s.getId());
                            se.setNume(s.getLabel());
                            se.compute();
                        }
                        result.add(se);
                        continue;
                    }
                    catch (SQLException e) {
                        Logger.logException(this, (Exception)e);
                        continue;
                    }
                    finally {
                        try {
                            this.pool.commit();
                        }
                        catch (SQLException e) {
                            Logger.logException(this, (Exception)e);
                        }
                        this.pool.releaseConnection();
                    }
                }
            }
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                String c1 = ((SimpleStockEntry)o1).getNume();
                String c2 = ((SimpleStockEntry)o2).getNume();
                return c1.compareToIgnoreCase(c2);
            }
        });
        return result;
    }

    private synchronized SimpleStocksDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        SimpleStocksDao dao = null;
        while (dao == null) {
            dao = (SimpleStocksDao)this.pool.getDao(SimpleStocksDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(SimpleStocksDao.class.getName(), connection);
        }
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntrare(int idStock, int idMagazie, double value) {
        try {
            this.getDao().setIntrare(idStock, idMagazie, value);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntrarePartiala(int idStock, int idMagazie, double value) {
        try {
            this.getDao().setIntrarePartiala(idStock, idMagazie, value);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void addIntrarePartialaNoCommit(int idStock, int idMagazie, double value) throws SQLException {
        this.getDao().addIntrarePartiala(idStock, idMagazie, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFaptic(int idStock, int idMagazie, double value) {
        try {
            this.getDao().setFaptic(idStock, idMagazie, value);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsum(int idStock, int idMagazie, double value) {
        try {
            this.getDao().addConsum(idStock, idMagazie, value);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsum2(int idStock, int idMagazie, double value) {
        try {
            this.getDao().addConsum2(idStock, idMagazie, value);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDay() {
        try {
            this.getDao().closeDay();
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proceseazaIntrariPartiale(int idMagazie) {
        try {
            this.getDao().proceseazaIntrariPartiale(idMagazie);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void golesteInitial(int idMagazie) {
        try {
            this.getDao().golesteInitial(idMagazie);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void golesteConsum(int idMagazie) {
        try {
            this.getDao().golesteConsum(idMagazie);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void golesteIntrari(int idMagazie) {
        try {
            this.getDao().golesteIntrari(idMagazie);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void golesteFaptic(int idMagazie) {
        try {
            this.getDao().golesteFaptic(idMagazie);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void exportStockToXml(Hashtable criteria, Vector sales, String destinationFile) {
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<document>\n");
        bigFile.append("<filters ");
        for (Object o : criteria.keySet()) {
            Object v = criteria.get(o);
            bigFile.append("\t" + TextUtils.escapeForXML(o.toString()) + "=\"" + TextUtils.escapeForXML(v.toString()) + "\"\n");
        }
        bigFile.append("/>\n");
        for (int i = 0; i < sales.size(); ++i) {
            bigFile.append("<stock ");
            SimpleStockEntry s = (SimpleStockEntry)sales.elementAt(i);
            bigFile.append("\tprodus=\"" + TextUtils.escapeForXML(s.getNume()) + "\"\n");
            bigFile.append("\tid=\"" + s.getIdStock() + "\"\n");
            bigFile.append("\tmagazie=\"" + s.getMagazie() + "\"\n");
            bigFile.append("\tidMagazie=\"" + s.getIdMagazie() + "\"\n");
            bigFile.append("\tinitial=\"" + Utils.getString3Decimals(s.getInitial()) + "\"\n");
            bigFile.append("\tintrare=\"" + Utils.getString3Decimals(s.getIntrare()) + "\"\n");
            bigFile.append("\tintrarePartiala=\"" + Utils.getString3Decimals(s.getIntrarePartiala()) + "\"\n");
            bigFile.append("\tconsum=\"" + Utils.getString3Decimals(s.getIesire()) + "\"\n");
            bigFile.append("\tscriptic=\"" + Utils.getString3Decimals(s.getScriptic()) + "\"\n");
            bigFile.append("\tfaptic=\"" + Utils.getString3Decimals(s.getFaptic()) + "\"\n");
            bigFile.append("\tdiferenta=\"" + Utils.getString3Decimals(s.getDiferenta()) + "\"\n");
            bigFile.append("/>\n");
        }
        bigFile.append("</document>");
        try {
            FileUtils.writeTextToFile(destinationFile, bigFile.toString());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public boolean incarcaInitialFromXML(String inputFile, final int requestedIdMagazie, final String selection) {
        try {
            Utils.importXml(new DefaultHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("stock")) {
                        int idMagazie = Integer.parseInt(attributes.getValue("idMagazie"));
                        if (requestedIdMagazie == -1 || idMagazie == requestedIdMagazie) {
                            try {
                                int idStoc = Integer.parseInt(attributes.getValue("id"));
                                double value = Utils.parseDouble(attributes.getValue(selection));
                                SimpleStockLogic.this.getDao().setInitial(idStoc, idMagazie, value);
                                SimpleStockLogic.this.pool.commit();
                            }
                            catch (SQLException e) {
                                Logger.logException(this, (Exception)e);
                                try {
                                    SimpleStockLogic.this.pool.rollBack();
                                }
                                catch (SQLException e1) {
                                    Logger.logException(this, (Exception)e1);
                                }
                            }
                            finally {
                                SimpleStockLogic.this.pool.releaseConnection();
                            }
                        }
                    }
                }
            }, inputFile);
            return true;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStockInDeposit(int idStock, int idMagazie) {
        try {
            Vector v = this.getDao().getStocksForMagazie(idMagazie, idStock, 1, -1);
            if (v.size() > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return false;
    }
}

