/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.simplestocks.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.simplestocks.SimpleStockEntry;
import ro.atreides.utils.db.DaoInterface;

public class SimpleStocksDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement addConsum1ForStock;
    private PreparedStatement addConsum2ForStock;
    private PreparedStatement updateIntrareForStock;
    private PreparedStatement updateIntrarePartialaForStock;
    private PreparedStatement updateFapticForStock;
    private PreparedStatement selectFisaStoc;
    private PreparedStatement addFisaStoc;
    private PreparedStatement resetAll;
    private PreparedStatement resetInitialFapticSet;
    private PreparedStatement resetInitialFapticNotSet;
    private PreparedStatement proceseazaIntrariPartiale;
    private PreparedStatement addIntrarePartialaForStock;
    private PreparedStatement golesteInitial;
    private PreparedStatement golesteConsum;
    private PreparedStatement golesteFaptic;
    private PreparedStatement golesteIntrari;
    private PreparedStatement updateInitialForStock;

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.addConsum1ForStock = this.connection.prepareStatement("update fisa_stoc set consum = consum + ?  where id_stock = ? and id_magazie = ?");
        this.addConsum2ForStock = this.connection.prepareStatement("update fisa_stoc set consum2 = consum2 + ?  where id_stock = ? and id_magazie = ?");
        this.updateIntrareForStock = this.connection.prepareStatement("update fisa_stoc set intrare = ?  where id_stock = ? and id_magazie = ?");
        this.updateIntrarePartialaForStock = this.connection.prepareStatement("update fisa_stoc set intrare_partiala = ?  where id_stock = ? and id_magazie = ?");
        this.addIntrarePartialaForStock = this.connection.prepareStatement("update fisa_stoc set intrare_partiala = intrare_partiala + ?  where id_stock = ? and id_magazie = ?");
        this.updateFapticForStock = this.connection.prepareStatement("update fisa_stoc set faptic = ? , faptic_set = 1 where id_stock = ? and id_magazie = ?");
        this.selectFisaStoc = this.connection.prepareStatement("select fisa_stoc.*, stocks.label as nume, magazii.label as magazie from stocks inner join fisa_stoc on stocks.id = fisa_stoc.id_stock inner join magazii on fisa_stoc.id_magazie = magazii.id where id_magazie = ? and ( id_stock = ? or ? = -1 ) and (stocks.status = ? OR ? = -1 ) order by stocks.label, magazie");
        this.addFisaStoc = this.connection.prepareStatement("insert into fisa_stoc ( id_stock, id_magazie, initial, intrare, consum, consum2, faptic ) values ( ?, ?, 0, 0, 0, 0, 0 ) ");
        this.resetAll = this.connection.prepareStatement("update fisa_stoc set faptic = 0, intrare = 0, intrare_partiala = 0, consum = 0, consum2 = 0, faptic_set = 0");
        this.resetInitialFapticNotSet = this.connection.prepareStatement("update fisa_stoc set initial = initial + intrare - consum - consum2 where faptic_set = 0 ");
        this.resetInitialFapticSet = this.connection.prepareStatement("update fisa_stoc set initial = faptic where faptic_set = 1 ");
        this.proceseazaIntrariPartiale = this.connection.prepareStatement("update fisa_stoc set intrare = intrare + intrare_partiala, intrare_partiala = 0 where (id_magazie = ? or ? = -1 )");
        this.golesteInitial = this.connection.prepareStatement("update fisa_stoc set initial = 0 where ( id_magazie = ? or ? = -1 )");
        this.golesteConsum = this.connection.prepareStatement("update fisa_stoc set consum = 0, consum2 = 0 where ( id_magazie = ? or ? = -1 )");
        this.golesteIntrari = this.connection.prepareStatement("update fisa_stoc set intrare = 0, intrare_partiala = 0 where ( id_magazie = ? or ? = -1 )");
        this.golesteFaptic = this.connection.prepareStatement("update fisa_stoc set faptic = 0, faptic_set = 0 where ( id_magazie = ? or ? = -1 )");
        this.updateInitialForStock = this.connection.prepareStatement("update fisa_stoc set initial = ? where id_stock = ? and id_magazie = ?");
    }

    public SimpleStocksDao(Connection conn) throws SQLException {
        this.connection = conn;
    }

    public void closeDay() throws SQLException {
        this.resetInitialFapticSet.execute();
        this.resetInitialFapticNotSet.execute();
        this.resetAll.execute();
    }

    private void addFisaStoc(int idStock, int idMagazie) throws SQLException {
        this.addFisaStoc.setInt(1, idStock);
        this.addFisaStoc.setInt(2, idMagazie);
        this.addFisaStoc.execute();
    }

    public void setIntrare(int idStock, int idMagazie, double value) throws SQLException {
        int modifiedRows = 0;
        while (modifiedRows == 0) {
            this.updateIntrareForStock.setDouble(1, value);
            this.updateIntrareForStock.setInt(2, idStock);
            this.updateIntrareForStock.setInt(3, idMagazie);
            modifiedRows = this.updateIntrareForStock.executeUpdate();
            if (modifiedRows != 0) continue;
            this.addFisaStoc(idStock, idMagazie);
        }
    }

    public void setInitial(int idStock, int idMagazie, double value) throws SQLException {
        int modifiedRows = 0;
        while (modifiedRows == 0) {
            this.updateInitialForStock.setDouble(1, value);
            this.updateInitialForStock.setInt(2, idStock);
            this.updateInitialForStock.setInt(3, idMagazie);
            modifiedRows = this.updateInitialForStock.executeUpdate();
            if (modifiedRows != 0) continue;
            this.addFisaStoc(idStock, idMagazie);
        }
    }

    public void setIntrarePartiala(int idStock, int idMagazie, double value) throws SQLException {
        int modifiedRows = 0;
        while (modifiedRows == 0) {
            this.updateIntrarePartialaForStock.setDouble(1, value);
            this.updateIntrarePartialaForStock.setInt(2, idStock);
            this.updateIntrarePartialaForStock.setInt(3, idMagazie);
            modifiedRows = this.updateIntrarePartialaForStock.executeUpdate();
            if (modifiedRows != 0) continue;
            this.addFisaStoc(idStock, idMagazie);
        }
    }

    public void addIntrarePartiala(int idStock, int idMagazie, double value) throws SQLException {
        int modifiedRows = 0;
        while (modifiedRows == 0) {
            this.addIntrarePartialaForStock.setDouble(1, value);
            this.addIntrarePartialaForStock.setInt(2, idStock);
            this.addIntrarePartialaForStock.setInt(3, idMagazie);
            modifiedRows = this.addIntrarePartialaForStock.executeUpdate();
            if (modifiedRows != 0) continue;
            this.addFisaStoc(idStock, idMagazie);
        }
    }

    public void setFaptic(int idStock, int idMagazie, double value) throws SQLException {
        int modifiedRows = 0;
        while (modifiedRows == 0) {
            this.updateFapticForStock.setDouble(1, value);
            this.updateFapticForStock.setInt(2, idStock);
            this.updateFapticForStock.setInt(3, idMagazie);
            modifiedRows = this.updateFapticForStock.executeUpdate();
            if (modifiedRows != 0) continue;
            this.addFisaStoc(idStock, idMagazie);
        }
    }

    public void addConsum(int idStock, int idMagazie, double value) throws SQLException {
        int modifiedRows = 0;
        while (modifiedRows == 0) {
            this.addConsum1ForStock.setDouble(1, value);
            this.addConsum1ForStock.setInt(2, idStock);
            this.addConsum1ForStock.setInt(3, idMagazie);
            modifiedRows = this.addConsum1ForStock.executeUpdate();
            if (modifiedRows != 0) continue;
            this.addFisaStoc(idStock, idMagazie);
        }
    }

    public void addConsum2(int idStock, int idMagazie, double value) throws SQLException {
        int modifiedRows = 0;
        while (modifiedRows == 0) {
            this.addConsum2ForStock.setDouble(1, value);
            this.addConsum2ForStock.setInt(2, idStock);
            this.addConsum2ForStock.setInt(3, idMagazie);
            modifiedRows = this.addConsum2ForStock.executeUpdate();
            if (modifiedRows != 0) continue;
            this.addFisaStoc(idStock, idMagazie);
        }
    }

    public Vector getStocksForMagazie(int idMagazie, int idStoc, int statusStock, int what) throws SQLException {
        Vector<SimpleStockEntry> result = new Vector<SimpleStockEntry>();
        this.selectFisaStoc.setInt(1, idMagazie);
        this.selectFisaStoc.setInt(2, idStoc);
        this.selectFisaStoc.setInt(3, idStoc);
        this.selectFisaStoc.setInt(4, statusStock);
        this.selectFisaStoc.setInt(5, statusStock);
        ResultSet rs = this.selectFisaStoc.executeQuery();
        while (rs.next()) {
            SimpleStockEntry se = this.getStockEntryFromResultSet(rs, what);
            result.add(se);
        }
        rs.close();
        return result;
    }

    private SimpleStockEntry getStockEntryFromResultSet(ResultSet rs, int what) throws SQLException {
        SimpleStockEntry se = new SimpleStockEntry();
        int idM = rs.getInt("id_magazie");
        se.setNume(rs.getString("nume"));
        se.setIdStock(rs.getInt("id_stock"));
        se.setInitial(rs.getDouble("initial"));
        se.setIntrare(rs.getDouble("intrare"));
        se.setIntrarePartiala(rs.getDouble("intrare_partiala"));
        switch (what) {
            case 2: {
                se.setIesire(rs.getDouble("consum"));
                break;
            }
            case 3: {
                se.setIesire(rs.getDouble("consum2"));
                break;
            }
            case 1: {
                se.setIesire(rs.getDouble("consum2") + rs.getDouble("consum"));
            }
        }
        se.setFaptic(rs.getDouble("faptic"));
        se.setId(rs.getInt("id"));
        se.setIdMagazie(idM);
        se.setMagazie(rs.getString("magazie"));
        se.compute();
        return se;
    }

    public void proceseazaIntrariPartiale(int idMagazie) throws SQLException {
        this.proceseazaIntrariPartiale.setInt(1, idMagazie);
        this.proceseazaIntrariPartiale.setInt(2, idMagazie);
        this.proceseazaIntrariPartiale.execute();
    }

    public void golesteInitial(int idMagazie) throws SQLException {
        this.golesteInitial.setInt(1, idMagazie);
        this.golesteInitial.setInt(2, idMagazie);
        this.golesteInitial.execute();
    }

    public void golesteConsum(int idMagazie) throws SQLException {
        this.golesteConsum.setInt(1, idMagazie);
        this.golesteConsum.setInt(2, idMagazie);
        this.golesteConsum.execute();
    }

    public void golesteIntrari(int idMagazie) throws SQLException {
        this.golesteIntrari.setInt(1, idMagazie);
        this.golesteIntrari.setInt(2, idMagazie);
        this.golesteIntrari.execute();
    }

    public void golesteFaptic(int idMagazie) throws SQLException {
        this.golesteFaptic.setInt(1, idMagazie);
        this.golesteFaptic.setInt(2, idMagazie);
        this.golesteFaptic.execute();
    }
}

