/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks;

import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.stocks.gui.StockViewEntry;
import ro.atreides.utils.Logger;
import ro.atreides.utils.excel.ExcelProcessor;

public class StockExcelProcessor
implements ExcelProcessor {
    private String[] columns;
    private String sheetName;

    public StockExcelProcessor(String sheetName, String[] columns) {
        this.columns = columns;
        this.sheetName = sheetName;
    }

    @Override
    public void processLine(Object o, WritableSheet sheet, int row) {
        StockViewEntry entry = (StockViewEntry)o;
        try {
            Label label = new Label(0, row, entry.getNume() + " (" + entry.getUmName() + ")");
            sheet.addCell((WritableCell)label);
            label = new Label(1, row, entry.getMagazie());
            sheet.addCell((WritableCell)label);
            label = new Label(2, row, entry.getCodBare());
            sheet.addCell((WritableCell)label);
            sheet.addCell((WritableCell)new Number(3, row, entry.getStocActual()));
            sheet.addCell((WritableCell)new Number(4, row, entry.getValoarePa() / entry.getStocActual()));
            sheet.addCell((WritableCell)new Number(5, row, entry.getPretPv()));
            sheet.addCell((WritableCell)new Number(6, row, entry.getValoarePa()));
            sheet.addCell((WritableCell)new Number(7, row, entry.getValoarePv()));
            sheet.addCell((WritableCell)new Number(8, row, entry.getProfit()));
            sheet.addCell((WritableCell)new Number(9, row, entry.getAdaosProcent()));
        }
        catch (RowsExceededException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }

    @Override
    public String[] getColumns() {
        return this.columns;
    }

    @Override
    public String getSheetName() {
        return this.sheetName;
    }

    @Override
    public int buildHeader(WritableSheet sheet, int startRow) {
        return 0;
    }

    @Override
    public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
    }
}

