/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.facturi.IesireProdusFacturiEmise;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.print.PrintLogic;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.ProductieCuInventarBean;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.restaurant.modules.transfer.StockTransferWebBean;
import ro.atreides.stocks.BalantaXmlHandler;
import ro.atreides.stocks.BonConsum;
import ro.atreides.stocks.BonConsumItem;
import ro.atreides.stocks.CerereAprovizionareEntry;
import ro.atreides.stocks.ConsumTransferInterface;
import ro.atreides.stocks.Corectie;
import ro.atreides.stocks.DeleteStockImpediments;
import ro.atreides.stocks.FisaIntrareActiva;
import ro.atreides.stocks.FisaIntrareSimple;
import ro.atreides.stocks.FisaMagazieEntry;
import ro.atreides.stocks.Lot;
import ro.atreides.stocks.MIscariStockBean;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.ModificarePret;
import ro.atreides.stocks.PierdereConsumInterface;
import ro.atreides.stocks.PowerSearchStock;
import ro.atreides.stocks.QuickSmallStocksBean;
import ro.atreides.stocks.RaportGestiuneEntry;
import ro.atreides.stocks.RaportGestiuneValoricaEntry;
import ro.atreides.stocks.ReceptieFromStockInterface;
import ro.atreides.stocks.SaleDescarcareBean;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockBean;
import ro.atreides.stocks.StockCMP;
import ro.atreides.stocks.StockComparativEntry;
import ro.atreides.stocks.StockConsum;
import ro.atreides.stocks.StockEntry;
import ro.atreides.stocks.StockInterface;
import ro.atreides.stocks.StockTransfer;
import ro.atreides.stocks.StockTransferItem;
import ro.atreides.stocks.StocksPrint;
import ro.atreides.stocks.TipArticol;
import ro.atreides.stocks.db.StocksDao;
import ro.atreides.stocks.export.ExportBCPlatforma;
import ro.atreides.stocks.gui.AddBonConsumPanel;
import ro.atreides.stocks.gui.AddTransferPanel;
import ro.atreides.stocks.gui.LoturiReportEntry;
import ro.atreides.stocks.gui.StockViewEntry;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.AtrFloat;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.InformatieMagazieProdus;
import ro.atreides.utils.LanguageProvider;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Shift;
import ro.atreides.utils.Unit;
import ro.atreides.utils.UpdateWarCritLevelObj;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.documente.Document;
import ro.atreides.utils.documente.DocumentInterface;
import ro.atreides.utils.documente.TipDocument;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.facturi.FacturaItemView;
import ro.atreides.utils.facturi.FacturiEmiseInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.registre.RegistreLogic;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.tags.TagsLogic;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.atreides.utils.units.UnitsLogic;

public class StockLogic
extends EventGenerator {
    public static final String TIP_GESTIUNE_CMP = "cmp";
    private Config config;
    private static StockLogic instance;
    private LanguageProvider languageProvider;
    private StockInterface stockInterface;
    private DeleteStockImpediments deleteImpediments;
    private FacturiEmiseInterface facturiEmiseInterface;
    private AddBonConsumPanel addConsumPanel;
    private AddTransferPanel addTransferPanel;
    private DocumentInterface documentInterface;
    private ConnectionPool pool;
    private Vector allStocks = new Vector();
    private Hashtable allStocksHash = new Hashtable();
    private boolean mustRebuildPowerStocks = true;
    private Hashtable powerStocks = new Hashtable();
    private final int perioadaAprovizionareDefault = 2;

    public static APROVIZIONARE_STATUS getAprovizionareStatusById(Integer idTip) {
        if (APROVIZIONARE_STATUS.NOUA.getCod() == idTip.intValue()) {
            return APROVIZIONARE_STATUS.NOUA;
        }
        if (APROVIZIONARE_STATUS.APROBATA.getCod() == idTip.intValue()) {
            return APROVIZIONARE_STATUS.APROBATA;
        }
        if (APROVIZIONARE_STATUS.COMANDATA.getCod() == idTip.intValue()) {
            return APROVIZIONARE_STATUS.COMANDATA;
        }
        if (APROVIZIONARE_STATUS.RECEPTIONATA.getCod() == idTip.intValue()) {
            return APROVIZIONARE_STATUS.RECEPTIONATA;
        }
        if (APROVIZIONARE_STATUS.RECEPTIONATA_PARTIAL.getCod() == idTip.intValue()) {
            return APROVIZIONARE_STATUS.RECEPTIONATA_PARTIAL;
        }
        if (APROVIZIONARE_STATUS.FACTURATA.getCod() == idTip.intValue()) {
            return APROVIZIONARE_STATUS.FACTURATA;
        }
        if (APROVIZIONARE_STATUS.ANULATA.getCod() == idTip.intValue()) {
            return APROVIZIONARE_STATUS.ANULATA;
        }
        if (APROVIZIONARE_STATUS.ALES_FURNIZOR.getCod() == idTip.intValue()) {
            return APROVIZIONARE_STATUS.ALES_FURNIZOR;
        }
        return null;
    }

    public COMANDA_TYPE getComandaTypeById(Integer idTip) {
        if (idTip != null) {
            if (COMANDA_TYPE.COMANDA_FERMA.getIdTip() == idTip.intValue()) {
                return COMANDA_TYPE.COMANDA_FERMA;
            }
            if (COMANDA_TYPE.TEMPORARA.getIdTip() == idTip.intValue()) {
                return COMANDA_TYPE.TEMPORARA;
            }
        }
        return COMANDA_TYPE.EFECTUAT;
    }

    public static Collection<COMANDA_TYPE> getComandaTypeCollection() {
        Vector<COMANDA_TYPE> result = new Vector<COMANDA_TYPE>();
        for (COMANDA_TYPE comanda_type : COMANDA_TYPE.values()) {
            result.add(comanda_type);
        }
        return result;
    }

    public DocumentInterface getDocumentInterface() {
        return this.documentInterface;
    }

    public void setDocumentInterface(DocumentInterface documentInterface) {
        this.documentInterface = documentInterface;
    }

    public static synchronized StockLogic getInstance() {
        if (instance == null) {
            try {
                instance = new StockLogic();
            }
            catch (InstantiationException e) {
                Logger.logException("StockLogic exiting", (Exception)e);
                Utils.systemExit();
            }
        }
        return instance;
    }

    private StockLogic() throws InstantiationException {
        this.pool = ConnectionPool.getInstance();
        this.config = Config.getInstance();
        this.buildStocks();
    }

    private synchronized StocksDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        StocksDao dao = null;
        while (dao == null) {
            dao = (StocksDao)this.pool.getDao(StocksDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(StocksDao.class.getName(), connection);
        }
        return dao;
    }

    public FacturiEmiseInterface getFacturiEmiseInterface() {
        return this.facturiEmiseInterface;
    }

    public void setFacturiEmiseInterface(FacturiEmiseInterface facturiEmiseInterface) {
        this.facturiEmiseInterface = facturiEmiseInterface;
    }

    public AddBonConsumPanel getAddConsumPanel() {
        return this.addConsumPanel;
    }

    public void setAddConsumPanel(AddBonConsumPanel addConsumPanel) {
        this.addConsumPanel = addConsumPanel;
    }

    public AddTransferPanel getAddTransferPanel() {
        return this.addTransferPanel;
    }

    public void setAddTransferPanel(AddTransferPanel addTransferPanel) {
        this.addTransferPanel = addTransferPanel;
    }

    public double decrementStock(int idMagazie, int stockItem, double totalQuantity, int idSale, Timestamp saleTime, String document, boolean fiscal, boolean protocol, COMANDA_TYPE comandaType, int idLot) throws SQLException {
        return this.decrementStock(stockItem, totalQuantity, idMagazie, idSale, saleTime, document, protocol ? 13 : 3, fiscal, comandaType, idLot);
    }

    public int addTransferNoCommit(int idSource, int idDest, Timestamp timeTransfer, Vector items, double totalPv, double totalPa, int tipTransfer, boolean pretAczFix, int nrDoc, User user) throws SQLException {
        Timestamp newTime = this.documentInterface.getTimeDocument(7, timeTransfer);
        this.getDao().addTransfer(idSource, idDest, newTime, totalPv, totalPa, tipTransfer, pretAczFix, nrDoc, user != null ? user.getId() : -1);
        int idTransfer = this.pool.requestConnection().getIndentityLocal();
        for (int i = 0; i < items.size(); ++i) {
            StockTransferItem o = (StockTransferItem)items.elementAt(i);
            this.getDao().addTransferItem(idTransfer, o.getIdStock(), o.getQuantity(), o.getSellPrice(), o.getPretAcz(), o.getImg(), o.getIdLot());
            o.setIdTransfer(idTransfer);
            int idTransferItem = this.pool.requestConnection().getIndentityLocal();
            o.setId(idTransferItem);
        }
        this.getDao().updateValPaForTransfer(idTransfer, totalPa);
        return this.documentInterface.transferAdded(idTransfer, newTime, "Transfer " + nrDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTransfer(int idSource, int idDest, Timestamp timeTransfer, Vector items, double totalPv, double totalPa, int tipTransfer, boolean pretAczFix, int nrDoc, User user) {
        int result = -1;
        try {
            result = this.addTransferNoCommit(idSource, idDest, timeTransfer, items, totalPv, totalPa, tipTransfer, pretAczFix, nrDoc, user);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateTransfer(Timestamp originalTime, int idTransfer, int idSursa, int idDestinatie, Timestamp timeTransfer, Vector items, double totalPv, double totalPa, int tipTransfer, boolean pretAczFix, Component parent) {
        try {
            StockTransferItem o;
            int i;
            if (!this.documentInterface.canModifyDocument(7, idTransfer)) {
                DialogUtils.errorDialog(parent, "Nu puteti modifica acest transfer", LangRoAll.nuPotContinua);
                this.pool.requestConnection().rollback();
                this.pool.releaseConnection();
                boolean bl = false;
                return bl;
            }
            Vector<StockTransferItem> oldItems = this.getDao().getTransferItemsForTransfer(idTransfer);
            for (i = 0; i < oldItems.size(); ++i) {
                o = oldItems.elementAt(i);
                this.deleteTransferItem(o.getId());
            }
            this.documentInterface.documentDeleted(originalTime);
            this.documentInterface.documentDeleted(timeTransfer);
            for (i = 0; i < items.size(); ++i) {
                o = (StockTransferItem)items.elementAt(i);
                this.getDao().addTransferItem(idTransfer, o.getIdStock(), o.getQuantity(), o.getSellPrice(), o.getPretAcz(), o.getImg(), o.getIdLot());
                o.setIdTransfer(idTransfer);
                int idTransferItem = this.pool.requestConnection().getIndentityLocal();
                o.setId(idTransferItem);
            }
            Timestamp newData = originalTime;
            if (!DateUtils.sameMinute(originalTime, timeTransfer)) {
                newData = this.documentInterface.getTimeDocument(7, timeTransfer);
            }
            this.getDao().updateTransfer(idTransfer, idSursa, idDestinatie, newData, totalPv, totalPa, tipTransfer, pretAczFix);
            this.documentInterface.transferUpdated(idTransfer, newData, "Transfer " + idTransfer);
            this.pool.commit();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void processTransferItems(Vector items, int idSource, int idDest, Timestamp timeTransfer, AtrFloat valPa, String document, boolean fiscal, boolean pretAczFix, COMANDA_TYPE comandaType) throws SQLException {
        for (int i = 0; i < items.size(); ++i) {
            StockTransferItem o = (StockTransferItem)items.elementAt(i);
            double quantity = o.getQuantity();
            int idStock = o.getIdStock();
            this.processTransferNoCommit(o, idSource, idDest, timeTransfer, document, o.getSellPrice(), valPa, fiscal, pretAczFix, comandaType);
        }
    }

    private double processTransferNoCommit(final StockTransferItem item, int idSource, final int idDest, final Timestamp time, String document, final double pretM2Dest, final AtrFloat totalValPa, boolean fiscal, boolean pretAczFix, final COMANDA_TYPE comandaType) throws SQLException {
        return this.operateOnStock(item.getIdStock(), item.getQuantity(), idSource, time, document, idDest, item.getId(), new PierdereConsumInterface(){

            @Override
            public void addPierdereOrConsum(FisaIntrareActiva entry, double quantity, int idMagazie, String document, Timestamp date, int idDestinatie1, int idTransferItem1, boolean fiscal, boolean pretAczFix) throws SQLException {
                int idFisaM1Src = entry.getIdFisa();
                double buyPrice = 0.0;
                buyPrice = pretAczFix ? item.getPretAcz() : entry.getBuyPrice();
                double sellPrice = StockLogic.this.getPretVzLaData(entry.getIdStock(), time);
                StockLogic.this.addIesireDinMagazie(entry.getIdStock(), idMagazie, 7, document, date, quantity, buyPrice, sellPrice, entry.getDenumireLaFurnizor(), entry.getCodBare(), fiscal, -1, comandaType, item.getIdLot());
                double intrareValuePa = quantity * buyPrice;
                double intrareValuePv = quantity * pretM2Dest;
                StockLogic.this.addFisaMagazieIntrareNoCommit(entry.getIdStock(), idDest, 7, document, date, buyPrice, pretM2Dest, quantity, intrareValuePa, intrareValuePv, entry.getDenumireLaFurnizor(), entry.getCodBare(), fiscal, comandaType, item.getIdLot());
                if (!pretAczFix) {
                    StockLogic.this.getDao().updateBuyPriceForTransferItem(item.getId(), entry.getBuyPrice());
                }
                StockLogic.this.addConsumEntry(entry.getIdFisa(), quantity, date);
                totalValPa.setValue(totalValPa.getValue() + intrareValuePa);
            }
        }, fiscal, pretAczFix, item.getIdLot());
    }

    public double getCatalogPriceForStockNoCommit(int idStock) throws SQLException {
        return this.getDao().getCatalogPriceForStock(idStock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCatalogPriceForStock(int idStock) {
        try {
            double result;
            double d = result = this.getCatalogPriceForStockNoCommit(idStock);
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double d = -1.0;
            return d;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void forceUpdatePowerStock(int idStock) {
        this.powerStocks.remove(idStock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePowerSearchStocks(int idStock, Vector<String> coduriBare) {
        boolean isProdusFinit = false;
        try {
            Object s = this.powerStocks.get(idStock);
            Stock stock = StockLogic.getInstance().getStockByIdNoCommit(idStock);
            if (stock != null && stock.getStatus() == 1) {
                Product produsFinit = this.getProductForStockNoCommit(stock.getId());
                if (produsFinit != null) {
                    isProdusFinit = true;
                    PowerSearchStock pss = new PowerSearchStock(stock, coduriBare);
                    this.powerStocks.put(idStock, pss);
                } else {
                    this.powerStocks.put(stock.getId(), stock);
                }
            } else {
                int idProdusFinit;
                if (stock != null && (idProdusFinit = this.getIdProductForStock(stock.getId())) != -1) {
                    NomeclaturaLogic.getInstance().productDeleted(idProdusFinit);
                }
                this.powerStocks.remove(idStock);
                isProdusFinit = true;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        this.mustRebuildPowerStocks = false;
        this.notifyListeners(26);
        if (isProdusFinit) {
            NomeclaturaLogic.getInstance().notifyListeners(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getPowerSearchStocks() {
        if (this.mustRebuildPowerStocks) {
            try {
                Hashtable<Integer, Vector<String>> produseSiCoduri = NomeclaturaLogic.getInstance().getAllProductsBarCodesHash();
                for (int i = 0; i < this.allStocks.size(); ++i) {
                    Stock stock = (Stock)this.allStocks.elementAt(i);
                    Object s = this.powerStocks.get(stock.getId());
                    if (s != null) continue;
                    Product produsFinit = this.getProductForStockNoCommit(stock.getId());
                    if (produsFinit != null) {
                        Vector<String> codBare = produseSiCoduri.get(produsFinit.getId());
                        PowerSearchStock pss = new PowerSearchStock(stock, codBare);
                        this.powerStocks.put(stock.getId(), pss);
                        continue;
                    }
                    this.powerStocks.put(stock.getId(), stock);
                }
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            finally {
                try {
                    this.pool.commit();
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
                this.pool.releaseConnection();
            }
            this.mustRebuildPowerStocks = false;
        }
        return new Vector(this.powerStocks.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildStocks() {
        this.allStocks.clear();
        this.allStocksHash.clear();
        try {
            Vector result = this.getDao().getAllStocks(false);
            for (int i = 0; i < result.size(); ++i) {
                Stock s = (Stock)result.elementAt(i);
                this.allStocks.add(s);
                this.allStocksHash.put(s.getId(), s);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void updateStockShortNoCommit(Stock s) throws SQLException {
        this.updateStockNoCommit(s.getId(), s.getLabel(), s.getIdUnit(), s.getWarningLevel(), s.getCriticalLevel(), s.isDescarcaStoc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTipArticol(int idStock, int idTipArticol) {
        try {
            this.setTipArticolNoCommit(idStock, idTipArticol);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TipArticol getTipArticolById(int id) {
        try {
            TipArticol tipArticol = this.getTipArticolByIdNoCommit(id);
            return tipArticol;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            TipArticol tipArticol = null;
            return tipArticol;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public TipArticol getTipArticolByIdNoCommit(int id) throws SQLException {
        return this.getDao().getTipArticolById(id);
    }

    public void setTipArticolNoCommit(int idStock, int idTipArticol) throws SQLException {
        this.getDao().setTipArticolForStock(idTipArticol, idStock);
    }

    public void updateStockNoCommit(int idStock, String label, int idUnit, double warning, double critical, boolean descarcaStoc) throws SQLException {
        this.getDao().updateStockWithUnit(idStock, label, idUnit, warning, critical, descarcaStoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStock(int idStock, String label, int idUnit, double warning, double critical, boolean descarcaStoc) {
        try {
            this.updateStockNoCommit(idStock, label, idUnit, warning, critical, descarcaStoc);
            this.pool.commit();
            this.stockChanged(idStock, label, idUnit, warning, critical);
            this.notifyListeners(26);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void stockChanged(int idStock, String label, int idUnit, double warning, double critical) {
        Stock s = (Stock)this.allStocksHash.get(idStock);
        if (s == null) {
            s = this.getStockById(idStock);
            this.allStocksHash.put(idStock, s);
            this.allStocks.add(s);
        }
        s.setLabel(label);
        s.setIdUnit(idUnit);
        s.setWarningLevel(warning);
        s.setCriticalLevel(critical);
        this.mustRebuildPowerStocks = true;
        this.forceUpdatePowerStock(idStock);
    }

    public void stockAdded(int idStock) {
        Stock s = this.getStockById(idStock);
        this.allStocksHash.put(idStock, s);
        this.allStocks.add(s);
        this.mustRebuildPowerStocks = true;
    }

    private void stockDeleted(int idStock) {
        Stock s = (Stock)this.allStocksHash.get(idStock);
        this.allStocks.remove(s);
        this.allStocksHash.remove(idStock);
        this.mustRebuildPowerStocks = true;
        this.forceUpdatePowerStock(idStock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product getProductForStock(int idStock) {
        Product p = null;
        try {
            p = this.getProductForStockNoCommit(idStock);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return p;
    }

    public Product getProductForStockNoCommit(int idStock) throws SQLException {
        int idProduct = this.getProductForStockFromDBNoCommit(idStock);
        Product p = NomeclaturaLogic.getInstance().getProductByIdNoCommit(idProduct);
        return p;
    }

    public int getProductForStockFromDBNoCommit(int idStock) throws SQLException {
        return this.getDao().getProductByStockId(idStock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProductForStockFromDB(int idStock) {
        try {
            int n = this.getProductForStockFromDBNoCommit(idStock);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public int getIdStockForProductIdNoCommit(int idProduct) throws SQLException {
        return this.getDao().getIdStockByProductId(idProduct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdStockForProductId(int idProduct) {
        try {
            int n = this.getIdStockForProductIdNoCommit(idProduct);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public int addStockShortNoCommit(Stock s, double pretVz, String uniqueCode) throws SQLException {
        int idStock = this.addStockNoCommit(s.getLabel(), s.getIdUnit(), s.getWarningLevel(), s.getCriticalLevel(), pretVz, s.isDescarcaStoc());
        this.getDao().updateUniqueCodeForStock(idStock, uniqueCode);
        return idStock;
    }

    public int addStockNoCommit(String name, int unitId, double warningLevel, double criticalLevel, double pret, boolean descarcaStoc) throws SQLException {
        this.getDao().addStock(name, unitId, warningLevel, criticalLevel, pret, descarcaStoc, 2);
        int idStock = this.pool.getIdentityLocal();
        this.getDao().updateUniqueCodeForStock(idStock, "UNIQ" + idStock);
        return this.pool.requestConnection().getIndentityLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addStock(String name, int unitId, double warningLevel, double criticalLevel, double pret, boolean descarcaStoc) {
        int result = -1;
        try {
            result = this.addStockNoCommit(name, unitId, warningLevel, criticalLevel, pret, descarcaStoc);
            this.pool.commit();
            this.stockAdded(result);
            this.notifyListeners(26);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toProdusFinit(int idStock, String name) {
        try {
            Categorie sc = (Categorie)NomeclaturaLogic.getInstance().getCategorii().get(0);
            String codSync = NomeclaturaLogic.getInstance().getNextProductCode() + "";
            this.addProdusFinitNoCommit(name, idStock, sc.getId(), NomeclaturaLogic.getInstance().getNextProductCode(), false, true, null, codSync, new Vector<String>());
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void pasteExistingProductToStock(int idStock, int existingProduct) throws SQLException {
        this.getDao().addProdusFinit(existingProduct, idStock);
    }

    public int addProdusFinitNoCommit(String name, int idStock, int idSubcategory, int cod, boolean exportCantar, boolean notifyListeners, String pictureFile, String codSync, Vector<String> barcodes) throws SQLException {
        int idProdus = NomeclaturaLogic.getInstance().addProductNoCommit(name, name, name, "", "", cod, idSubcategory, false, exportCantar, pictureFile, codSync, barcodes);
        this.getDao().addProdusFinit(idProdus, idStock);
        if (notifyListeners) {
            double price = this.getCatalogPriceForStockNoCommit(idStock);
            NomeclaturaLogic.getInstance().productAddedNoCommit(idProdus, price);
        }
        return idProdus;
    }

    public int addProdusFinit(String name, int unitId, int idSubcategory, int cod, double warningLevel, double criticalLevel, double pret, boolean exportCantar, String pictureFile, boolean descarcaStoc, Vector<String> barcodes) {
        return this.addProdusFinitWithTip(name, unitId, idSubcategory, cod, warningLevel, criticalLevel, pret, exportCantar, pictureFile, descarcaStoc, 1, barcodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addProdusFinitWithTip(String name, int unitId, int idSubcategory, int cod, double warningLevel, double criticalLevel, double pret, boolean exportCantar, String pictureFile, boolean descarcaStoc, int tipArticol, Vector<String> barcodes) {
        int result = -1;
        try {
            result = this.addProdusFinitWithTipNoCommit(name, unitId, idSubcategory, cod, warningLevel, criticalLevel, pret, exportCantar, pictureFile, descarcaStoc, tipArticol, barcodes);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    public Hashtable<Integer, Integer> addProdusFinitWithTipNoCommitBatchMode(String name, int unitId, int idSubcategory, int cod, double warningLevel, double criticalLevel, double pret, boolean exportCantar, String pictureFile, boolean descarcaStoc, int tipArticol, Integer eta, Vector<String> barcodes, boolean forceInsertOnly) throws SQLException {
        Product product = null;
        if (!forceInsertOnly) {
            product = NomeclaturaLogic.getInstance().getProductForNameAndPriceNoCommit(name, pret);
        }
        Hashtable<Integer, Integer> result = null;
        if (product == null) {
            this.getDao().addStock(name, unitId, warningLevel, criticalLevel, pret, descarcaStoc, eta);
            int idStock = this.pool.requestConnection().getIndentityLocal();
            String codSync = "UNIQ" + idStock;
            this.getDao().updateUniqueCodeForStock(idStock, codSync);
            int idProdus = this.addProdusFinitNoCommit(name, idStock, idSubcategory, cod, exportCantar, true, pictureFile, codSync, barcodes);
            this.setTipArticolNoCommit(idStock, tipArticol);
            NomeclaturaLogic.getInstance().deleteAllBarcodesFromProduct(idProdus);
            for (String barcode : barcodes) {
                NomeclaturaLogic.getInstance().addBarcodeToProductNoCommit(idProdus, barcode);
            }
            this.getDao().syncProdusFinit(idProdus, idStock, true);
            result = new Hashtable<Integer, Integer>();
            result.put(idStock, idProdus);
        } else {
            int idStockForProductId = this.getIdStockForProductIdNoCommit(product.getId());
            this.updateStockWithUnitAndEtaNoCommit(idStockForProductId, eta, name, unitId, warningLevel, criticalLevel, descarcaStoc);
            this.modificaPretToateMagaziile(idStockForProductId, pret, false, new Timestamp(new Date().getTime()));
            Product p = this.getProductForStockNoCommit(idStockForProductId);
            p.setName(name);
            p.setNumeCasa(name);
            p.setNumeSectie(name);
            p.setCod(cod);
            p.setIdCategorie(idSubcategory);
            p.setExportCantar(exportCantar);
            p.setPictureFile(pictureFile);
            NomeclaturaLogic.getInstance().updateProductNoCommit(p);
            this.setTipArticolNoCommit(idStockForProductId, tipArticol);
            int idProdus = p.getId();
            NomeclaturaLogic.getInstance().deleteAllBarcodesFromProduct(idProdus);
            for (String barcode : barcodes) {
                NomeclaturaLogic.getInstance().addBarcodeToProductNoCommit(idProdus, barcode);
            }
            this.getDao().syncProdusFinit(p.getId(), idStockForProductId, true);
            this.pool.commit();
        }
        return result;
    }

    private int addProdusFinitWithTipNoCommit(String name, int unitId, int idSubcategory, int cod, double warningLevel, double criticalLevel, double pret, boolean exportCantar, String pictureFile, boolean descarcaStoc, int tipArticol, Vector<String> barcodes) throws SQLException {
        Hashtable<Integer, Integer> addedIds = this.addProdusFinitWithTipNoCommitBatchMode(name, unitId, idSubcategory, cod, warningLevel, criticalLevel, pret, exportCantar, pictureFile, descarcaStoc, tipArticol, 2, barcodes, false);
        Iterator<Integer> i$ = addedIds.keySet().iterator();
        if (i$.hasNext()) {
            Integer idStock = i$.next();
            int idProdus = addedIds.get(idStock);
            this.pool.commit();
            this.stockAdded(idStock);
            this.updatePowerSearchStocks(idStock, barcodes);
            Product o = NomeclaturaLogic.getInstance().getProductByIdNoCommit(idProdus);
            this.notifyObjectListeners(101, o);
            return idStock;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Product quickAddProduct(String codBare, Categorie cat) {
        try {
            Product p;
            Vector<String> barcodes = new Vector<String>();
            barcodes.add(codBare);
            Unit unitate = UnitsLogic.getInstance().getUnitByNameNoCommit("buc");
            int code = NomeclaturaLogic.getInstance().getNextProductCodeNoCommit();
            int idStock = StockLogic.getInstance().addProdusFinitWithTipNoCommit("generic_" + Formatters.DATE_TIME_SECONDS_MILLIS_FORMAT.format(new Date()), unitate.getId(), cat.getId(), code, 0.0, 0.0, 1.0, false, null, true, 1, barcodes);
            Product product = p = this.getProductForStockNoCommit(idStock);
            return product;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Product product = null;
            return product;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modificaPretPtMagazia(int idStock, double newPrice, Timestamp data) {
        try {
            this.getDao().updatePriceForStock(idStock, newPrice);
            this.addPriceModificationNewNoCommit(idStock, newPrice, data);
            Product p = this.getProductForStockNoCommit(idStock);
            Product o = NomeclaturaLogic.getInstance().getProductByIdNoCommit(p.getId());
            NomeclaturaLogic.getInstance().updateToPrintNoCommit(true, o.getId());
            this.getDao().syncProdusFinit(p.getId(), idStock, true);
            this.pool.commit();
            this.notifyObjectListeners(100, o);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProdusFinit(int idStock, String name, int unitId, int idSubcategory, int cod, double warningLevel, double criticalLevel, double pret, boolean modifyExistingStuff, boolean exportCantar, String pictureFile, boolean descarcaStoc, Timestamp dataPret, Vector<String> barcodes) {
        try {
            this.getDao().updateStockWithUnit(idStock, name, unitId, warningLevel, criticalLevel, descarcaStoc);
            this.modificaPretToateMagaziile(idStock, pret, modifyExistingStuff, dataPret);
            Product p = this.getProductForStockNoCommit(idStock);
            p.setName(name);
            p.setNumeCasa(name);
            p.setNumeSectie(name);
            p.setCod(cod);
            p.setIdCategorie(idSubcategory);
            p.setExportCantar(exportCantar);
            p.setPictureFile(pictureFile);
            NomeclaturaLogic.getInstance().updateProductNoCommit(p);
            int idProdus = p.getId();
            NomeclaturaLogic.getInstance().deleteAllBarcodesFromProduct(idProdus);
            for (String barcode : barcodes) {
                NomeclaturaLogic.getInstance().addBarcodeToProductNoCommit(idProdus, barcode);
            }
            this.getDao().syncProdusFinit(p.getId(), idStock, true);
            this.pool.commit();
            this.stockChanged(idStock, name, unitId, warningLevel, criticalLevel);
            this.updatePowerSearchStocks(idStock, barcodes);
            NomeclaturaLogic.getInstance().updatePowerSearchProducts(idProdus, barcodes);
            this.notifyObjectListeners(100, p);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncCommit(int idProduct, int idStock) {
        try {
            this.getDao().syncProdusFinit(idProduct, idStock, true);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void syncDone(int idProduct, int idStock) throws SQLException {
        this.getDao().syncProdusFinit(idProduct, idStock, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modificaPret(int idStock, double pret, boolean modifyOld, Timestamp dataPret) {
        try {
            this.modificaPretToateMagaziile(idStock, pret, modifyOld, dataPret);
            Product p = this.getProductForStockNoCommit(idStock);
            NomeclaturaLogic.getInstance().updateToPrintNoCommit(true, p.getId());
            this.getDao().syncProdusFinit(p.getId(), idStock, true);
            this.pool.commit();
            this.notifyObjectListeners(100, p);
        }
        catch (Exception e) {
            Logger.logException(this, e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void modificaPretToateMagaziile(int idStock, double pret, boolean modificaExistingStuff, Timestamp data) throws SQLException {
        this.getDao().updatePriceForStock(idStock, pret);
        if (modificaExistingStuff) {
            this.addPriceModificationNewNoCommit(idStock, pret, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ModificarePret> getAllPriceModificationById(Hashtable criteria) {
        Vector<ModificarePret> result = new Vector();
        try {
            result = this.getAllModificariPret(criteria);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<ModificarePret> getAllModificariPret(Hashtable criteria) throws SQLException {
        return this.getDao().getAllModificarePretByStockId(criteria);
    }

    public void updatePriceForStockNoCommit(int idStock, double pret) throws SQLException {
        this.getDao().updatePriceForStock(idStock, pret);
    }

    private void addPriceModificationNewNoCommit(int idStock, double newPrice, Timestamp data) throws SQLException {
        Timestamp newData;
        data = newData = this.documentInterface.getTimeDocument(6, data);
        this.getDao().addModificarePret(idStock, data, newPrice);
        int idModificare = this.pool.getIdentityLocal();
        this.documentInterface.modificarePretAdded(idModificare, data, "Modificare pret " + idModificare, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPriceModificationNew(int idStock, double newPrice, Timestamp data) {
        try {
            this.addPriceModificationNewNoCommit(idStock, newPrice, data);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePriceModification(ModificarePret obj, Timestamp oldData) {
        try {
            Timestamp newData = StockLogic.getInstance().getDocumentInterface().getTimeDocument(6, new Timestamp(obj.getData().getTime()));
            obj.setData(newData);
            this.getDao().updateModificarePret(obj);
            int idModificarePret = obj.getIdModificarePret();
            this.documentInterface.documentDeleted(oldData);
            this.documentInterface.modificarePretUpdated(idModificarePret, newData, "Modificare pret " + idModificarePret, true);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePriceModification(ModificarePret obj) {
        try {
            this.getDao().deleteModificarePret(obj);
            this.documentInterface.documentDeleted(obj.getData());
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public ModificarePret getModificarePretByDate(Timestamp date) throws SQLException {
        return this.getDao().getModificarePretByDate(date);
    }

    public void processModificarePret(int idModificarePret, COMANDA_TYPE comandaType) throws SQLException {
        ModificarePret mp = this.getDao().getModificarePretById(idModificarePret);
        int idStock = mp.getIdStock();
        Timestamp data = mp.getData();
        double newPrice = mp.getPretNou();
        double oldPrice = mp.getPretVechi();
        double[] prices = this.getDao().getPretVzLaData(data, idStock);
        if (prices[0] >= 0.0) {
            oldPrice = prices[0];
        }
        if (oldPrice < 0.0) {
            return;
        }
        for (Magazie magazie : this.getMagazii()) {
            int idMagazie = magazie.getId();
            Vector<FisaIntrareActiva> fiseActive = this.getDao().getFiseIntrareActive(data, idStock, magazie.getId(), 0.0, -1);
            double cant = 0.0;
            for (FisaIntrareActiva fisaIntrareActiva : fiseActive) {
                cant += fisaIntrareActiva.getDisponibil();
            }
            double diffValoare = cant * (newPrice - oldPrice);
            if (diffValoare == 0.0) continue;
            this.getDao().addFisaMagazie(idStock, idMagazie, 6, "Modificare pret " + mp.getIdModificarePret(), data, 0.0, 0.0, 0.0, 0.0, diffValoare, 0.0, 0.0, "", "", 1, -1, comandaType, mp.getIdLot());
        }
    }

    public Vector<StockViewEntry> getStocksViewsForMagazieNoCommit(int idMagazie, int idStock, int idCategorie, int idFurnizor, boolean includeDeleted, int tipStock, int what, String comandaTypes) throws SQLException {
        String idStocks = null;
        if (idFurnizor > 0) {
            idStocks = this.stockInterface.getStockIdsForFurnizorId(idFurnizor);
        }
        double cotaTva = this.config.getDouble("tvaProcent");
        Connection c = this.pool.requestConnection().getConnection();
        Vector<StockViewEntry> result = this.getDao().getStocksViewsForMagazie(idMagazie, idStock, idCategorie, includeDeleted, what, idStocks, tipStock, c, cotaTva, comandaTypes);
        return result;
    }

    public Vector<StockViewEntry> getStocksViewsForMagazie(int idMagazie, int idStock, int idCategorie, int idFurnizor, boolean includeDeleted, int tipStock, int what) {
        return this.getStocksViewsForMagazie(idMagazie, idStock, idCategorie, idFurnizor, includeDeleted, tipStock, what, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<StockViewEntry> getStocksViewsForMagazie(int idMagazie, int idStock, int idCategorie, int idFurnizor, boolean includeDeleted, int tipStock, int what, String comandaTypes) {
        Vector<StockViewEntry> result = new Vector();
        try {
            result = this.getStocksViewsForMagazieNoCommit(idMagazie, idStock, idCategorie, idFurnizor, includeDeleted, tipStock, what, comandaTypes);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<StockViewEntry> getStockQuantitiesForIds(int idMagazie, String idsSqlSequence, double cotaTva) {
        try {
            Vector<StockViewEntry> q = this.getDao().getStockQuantitiesForIds(idMagazie, idsSqlSequence, new Hashtable(), -1, this.pool.requestConnection().getConnection(), cotaTva);
            Vector<StockViewEntry> vector = new Vector<StockViewEntry>(q);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<StockViewEntry> vector = new Vector<StockViewEntry>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void computeStockViewEntry(StockViewEntry sve) {
        if (sve.getAlertLevel() > sve.getStocActual()) {
            if (sve.getCriticalLevel() > sve.getStocActual()) {
                sve.setCritical(true);
            } else {
                sve.setWarning(true);
            }
        }
    }

    public int addMagazieNoCommit(String label, String contMateriiPrime, String contMarfa, String contTvaNeexigibil, String contAdaosComercial, boolean isMagazieMarfa) throws SQLException {
        this.getDao().addMagazie(label, contMateriiPrime, contMarfa, contTvaNeexigibil, contAdaosComercial, isMagazieMarfa);
        return this.pool.requestConnection().getIndentityLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addMagazie(String label, String contMateriiPrime, String contMarfa, String contTvaNeexigibil, String contAdaosComercial, boolean isMagazieMarfa) {
        int result = -1;
        try {
            result = this.addMagazieNoCommit(label, contMateriiPrime, contMarfa, contTvaNeexigibil, contAdaosComercial, isMagazieMarfa);
            this.pool.commit();
            this.notifyListeners(27);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    public void deleteMagazie(int idMagazie) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMagazie(int idMagazie, String newName, String contMateriiPrime, String contMarfa, String contTvaNeexigibil, String contAdaosComercial, boolean isMagazieMarfa) {
        try {
            this.getDao().updateMagazie(newName, contMateriiPrime, contMarfa, contTvaNeexigibil, contAdaosComercial, isMagazieMarfa, idMagazie);
            this.pool.commit();
            this.notifyListeners(27);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Magazie> getMagazii() {
        try {
            Vector<Magazie> result;
            Vector<Magazie> vector = result = this.getAllMagaziiNoCommit();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Magazie> vector = new Vector<Magazie>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<Magazie> getAllMagaziiNoCommit() throws SQLException {
        return this.getDao().getAllMagazii();
    }

    public Magazie getMagazieByNameNoCommit(String name) throws SQLException {
        return this.getDao().getMagazieByName(name);
    }

    public Magazie getMagazieByIdNoCommit(int idMagazie) throws SQLException {
        Magazie result = this.getDao().getMagazieById(idMagazie);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Magazie getMagazieById(int idMagazie) {
        try {
            Magazie result;
            Magazie magazie = result = this.getMagazieByIdNoCommit(idMagazie);
            return magazie;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Magazie magazie = null;
            return magazie;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void printStoc(int idLang, Shift lastShift) throws SQLException {
        for (Magazie element : this.getMagazii()) {
            this.printStoc(element, idLang, lastShift);
        }
    }

    public void printStoc(Magazie cat, int idLang, Shift lastShift) throws SQLException {
        Hashtable<String, Integer> criteria = new Hashtable<String, Integer>();
        criteria.put("magazieId", cat.getId());
        criteria.put("langId", idLang);
        Connection c = this.pool.requestConnection().getConnection();
        Vector stocks = this.getDao().getStocksReport(criteria, c);
        this.printZStocuri(stocks, cat, lastShift);
    }

    private void printZStocuri(Collection stocuri, Magazie m, Shift lastShift) {
        String s = "";
        for (StockEntry element : stocuri) {
            double q = element.getQuantity();
            String name = element.getStock();
            s = s + name + " " + Utils.getString6Decimals(q) + " " + element.getUm() + "\n";
        }
        String reportTitle = "Stocuri " + m.getLabel() + ", Z nr: " + lastShift.getNr() + " deschidere la: " + Formatters.DATE_AND_TIME_FORMAT.format(lastShift.getStart() + "tiparit la: " + Utils.getCurrentDateAndTimeForPrinter());
        PrintLogic.getInstance().printRaportInchidere(reportTitle, s, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stock getStockById(int id) {
        try {
            Stock stock = this.getStockByIdNoCommit(id);
            return stock;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Stock stock = null;
            return stock;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Stock getStockByIdNoCommit(int id) throws SQLException {
        Stock result = this.getDao().getStock(id);
        return result;
    }

    public Stock getStockByNameNoCommit(String stock) throws SQLException {
        Stock result = this.getDao().getStockByName(stock);
        return result;
    }

    public Stock getStockByCodUnicNoCommit(String codUnic) throws SQLException {
        Stock result = this.getDao().getStockByCodUnic(codUnic);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stock getStockByCodUnicCommit(String codUnic) {
        try {
            Stock stock = this.getStockByCodUnicNoCommit(codUnic);
            return stock;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            Stock stock = null;
            return stock;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stock getStockByName(String stock) {
        try {
            Stock result;
            Stock stock2 = result = this.getStockByNameNoCommit(stock);
            return stock2;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Stock stock3 = null;
            return stock3;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<SaleDescarcareBean> getValDescarcataForSaleNoCommit(Timestamp start, Timestamp stop, int idMagazie) throws SQLException {
        return this.getDao().getValIesireByIdSale(start, stop, idMagazie);
    }

    private double decrementStock(int idStock, double quantity, int idMagazie, int idSale, Timestamp saleTime, String document, final int tipDocument, boolean fiscal, final COMANDA_TYPE comandaType, final int idLot) throws SQLException {
        return this.operateOnStock(idStock, quantity, idMagazie, saleTime, document, idSale, -1, new PierdereConsumInterface(){

            @Override
            public void addPierdereOrConsum(FisaIntrareActiva entry, double quantity, int idMagazie, String document, Timestamp saleTime, int idSale, int idLiber2, boolean fiscal, boolean pretAczFix) throws SQLException {
                int idFisaM1Src = entry.getIdFisa();
                double sellPrice = StockLogic.this.getPretVzLaData(entry.getIdStock(), saleTime);
                StockLogic.this.addIesireDinMagazie(entry.getIdStock(), idMagazie, tipDocument, document, saleTime, quantity, entry.getBuyPrice(), sellPrice, entry.getDenumireLaFurnizor(), entry.getCodBare(), fiscal, idSale, comandaType, idLot);
                StockLogic.this.getDao().addConsum(entry.getIdFisa(), quantity, saleTime);
            }
        }, fiscal, false, idLot);
    }

    private void correctStockConsumEntries(int idStock, double quantity, int idMagazie, Timestamp data) throws SQLException {
        double cantitateCursor;
        double cantitateLotCurent;
        Vector fiseSimple = this.getDao().getFiseIntrareSortateInversPanaLaData(idStock, idMagazie, data);
        Timestamp firstFreeLot = data;
        Iterator iter = fiseSimple.iterator();
        for (cantitateCursor = quantity; iter.hasNext() && cantitateCursor > 0.0; cantitateCursor -= cantitateLotCurent) {
            FisaIntrareSimple element = (FisaIntrareSimple)iter.next();
            int idFisaIntrare = element.getId();
            Vector consumuriForFisa = this.getDao().getStockConsumByFisaIntrare(idFisaIntrare);
            for (StockConsum consum : consumuriForFisa) {
                this.getDao().deleteConsum(consum.getIdConsum());
            }
            cantitateLotCurent = element.getStoc();
            if (cantitateLotCurent < cantitateCursor) {
                continue;
            }
            double scadereLotCurent = cantitateCursor;
            double cantitateRamasaLotCurent = cantitateLotCurent - scadereLotCurent;
            if (cantitateRamasaLotCurent > 0.0) {
                this.getDao().addConsum(idFisaIntrare, cantitateRamasaLotCurent, data);
            }
            firstFreeLot = element.getData();
            break;
        }
        if (cantitateCursor > 0.0) {
            // empty if block
        }
        Vector<FisaIntrareActiva> sqs2 = this.getDao().getFiseIntrareActive(firstFreeLot, idStock, idMagazie, 0.0, -1);
        for (FisaIntrareActiva fisaIntrareActiva : sqs2) {
            this.getDao().addConsum(fisaIntrareActiva.getIdFisa(), fisaIntrareActiva.getDisponibil(), data);
        }
    }

    private double computeValueBackwards(int idStock, double quantity, int idMagazie, Timestamp data) throws SQLException {
        if (quantity == 0.0) {
            return 0.0;
        }
        double value = 0.0;
        double lastPrice = 0.0;
        Vector sqs = this.getDao().getFiseIntrareSortateInversPanaLaData(idStock, idMagazie, data);
        double toDecrement = quantity;
        for (FisaIntrareSimple element : sqs) {
            double curQ = element.getStoc();
            double decrement = 0.0;
            decrement = curQ >= toDecrement ? toDecrement : curQ;
            value += decrement * element.getPretAcz();
            lastPrice = element.getPretAcz();
            if (!((toDecrement -= decrement) <= 0.0)) continue;
            break;
        }
        if (toDecrement > 0.0) {
            value += toDecrement * lastPrice;
        }
        return value;
    }

    public double getPretAchizitieLotCurentNoCommit(Timestamp saleTime, int idStock, int idMagazie, double quantity) throws SQLException {
        double result;
        block0: {
            result = -1.0;
            Vector<FisaIntrareActiva> sqs = this.getDao().getFiseIntrareActive(saleTime, idStock, idMagazie, 0.0, -1);
            Iterator<FisaIntrareActiva> iter = sqs.iterator();
            if (!iter.hasNext()) break block0;
            FisaIntrareActiva element = iter.next();
            result = element.getBuyPrice();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPretAchizitieLotCurent(Timestamp saleTime, int idStock, int idMagazie, double quantity) {
        double result = 0.0;
        try {
            result = this.getPretAchizitieLotCurentNoCommit(saleTime, idStock, idMagazie, quantity);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public double getBackupBuyPriceNoCommit(int idStock) throws SQLException {
        FisaIntrareActiva fme = this.getDao().getLatestFisaMagazieAchizitieForStock(idStock);
        if (fme != null) {
            return fme.getBuyPrice();
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBackupBuyPrice(int idStock) {
        try {
            double d = this.getBackupBuyPriceNoCommit(idStock);
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double d = -1.0;
            return d;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public double operateOnStock(int idStock, double quantity, int idMagazie, Timestamp saleTime, String document, int idLiber1, int idLiber2, PierdereConsumInterface operation, boolean fiscal, boolean pretAczFix, int idLot) throws SQLException {
        FisaIntrareActiva element;
        double buyPrice;
        if (quantity > 0.0) {
            if (this.isGestiuneCMP()) {
                buyPrice = this.getPriceByCMP(idStock, saleTime);
                element = new FisaIntrareActiva();
                element.setBuyPrice(buyPrice);
                element.setIdStock(idStock);
                element.setCodBare("");
                element.setDenumireLaFurnizor("");
                element.setIdFisa(-1);
                operation.addPierdereOrConsum(element, quantity, idMagazie, document, saleTime, idLiber1, idLiber2, fiscal, pretAczFix);
            } else {
                Vector<FisaIntrareActiva> sqs = this.getDao().getFiseIntrareActive(saleTime, idStock, idMagazie, 0.0, idLot);
                double toDecrement = quantity;
                FisaIntrareActiva element22 = null;
                for (FisaIntrareActiva element22 : sqs) {
                    double curQ = element22.getDisponibil();
                    double decrement = 0.0;
                    decrement = curQ >= toDecrement ? toDecrement : curQ;
                    operation.addPierdereOrConsum(element22, decrement, idMagazie, document, saleTime, idLiber1, idLiber2, fiscal, pretAczFix);
                    if (!((toDecrement -= decrement) <= 0.0)) continue;
                    break;
                }
                if (toDecrement > 0.0) {
                    FisaIntrareActiva fe;
                    if (element22 == null && (fe = this.getDao().getLatestFisaMagazieAchizitieForStock(idStock)) != null) {
                        element22 = fe;
                    }
                    if (element22 == null) {
                        element22 = new FisaIntrareActiva();
                        element22.setBuyPrice(0.0);
                        element22.setIdStock(idStock);
                        element22.setCodBare("");
                        element22.setDenumireLaFurnizor("");
                        element22.setIdFisa(-1);
                    }
                    operation.addPierdereOrConsum(element22, toDecrement, idMagazie, document, saleTime, idLiber1, idLiber2, fiscal, pretAczFix);
                }
                return toDecrement;
            }
        }
        if (quantity < 0.0) {
            if (this.isGestiuneCMP()) {
                buyPrice = this.getPriceByCMP(idStock, saleTime);
                element = new FisaIntrareActiva();
                element.setBuyPrice(buyPrice);
                element.setIdStock(idStock);
                element.setCodBare("");
                element.setDenumireLaFurnizor("");
                element.setIdFisa(-1);
                operation.addPierdereOrConsum(element, quantity, idMagazie, document, saleTime, idLiber1, idLiber2, fiscal, pretAczFix);
            } else {
                Vector<FisaIntrareActiva> sqs = this.getDao().getFiseIntrareActive(saleTime, idStock, idMagazie, 0.0, idLot);
                if (sqs.size() > 0) {
                    Iterator<FisaIntrareActiva> iter = sqs.iterator();
                    if (iter.hasNext()) {
                        element = iter.next();
                        operation.addPierdereOrConsum(element, quantity, idMagazie, document, saleTime, idLiber1, idLiber2, fiscal, pretAczFix);
                    }
                } else {
                    FisaIntrareActiva element3 = null;
                    FisaIntrareActiva fe = this.getDao().getLatestFisaMagazieAchizitieForStock(idStock);
                    if (fe != null) {
                        element3 = fe;
                    }
                    if (element3 == null) {
                        element3 = new FisaIntrareActiva();
                        element3.setBuyPrice(0.0);
                        element3.setIdStock(idStock);
                        element3.setCodBare("");
                        element3.setDenumireLaFurnizor("");
                        element3.setIdFisa(-1);
                    }
                    operation.addPierdereOrConsum(element3, quantity, idMagazie, document, saleTime, idLiber1, idLiber2, fiscal, pretAczFix);
                }
            }
        }
        return 0.0;
    }

    private double getPretVzLaData(int idStock, Timestamp date) throws SQLException {
        double result = -1.0;
        double[] prices = this.getDao().getPretVzLaData(date, idStock);
        if (prices[0] < 0.0) {
            prices = this.getDao().getNextPretVzDupaData(date, idStock);
            if (prices[1] >= 0.0) {
                result = prices[1];
            }
        } else {
            result = prices[0];
        }
        if (result == -1.0) {
            result = this.getDao().getCatalogPriceForStock(idStock);
        }
        return result;
    }

    public double getPriceByCMP(int idStock, Timestamp date) throws SQLException {
        Vector<StockCMP> prices = this.getDao().getLatestStockCMPAtTimestamp(idStock, date);
        if (prices.size() > 0) {
            StockCMP latest = prices.get(0);
            return latest.getValoare() / latest.getCantitate();
        }
        return 0.0;
    }

    public void addIesireDinMagazie(int idStock, int idMagazie, int tipDocument, String document, Timestamp timeDocument, double decrement, double buyPrice, double sellPrice, String denumireLaFurnizor, String codBare, boolean fiscal, int idSale, COMANDA_TYPE comandaType, int idLot) throws SQLException {
        double iesireValuePa = decrement * buyPrice;
        double iesireValuePv = decrement * sellPrice;
        this.addFisaMagazieNoCommit(idStock, idMagazie, tipDocument, document, timeDocument, buyPrice, sellPrice, 0.0, decrement, 0.0, 0.0, iesireValuePa, iesireValuePv, denumireLaFurnizor, codBare, fiscal, idSale, comandaType, idLot);
    }

    private double addConsumNoCommit(final BonConsumItem bonConsumItem, int idMagazie, final int tipDocument, String document, Timestamp date, boolean forteazaDescarcare, boolean fiscal, final AtrFloat totalValPa, final COMANDA_TYPE comandaType) throws SQLException {
        PierdereConsumInterface inter = new PierdereConsumInterface(){

            @Override
            public void addPierdereOrConsum(FisaIntrareActiva entry, double quantity, int idMagazie, String document, Timestamp date, int idBonConsumItem, int idLiber2, boolean fiscal, boolean pretAczFix) throws SQLException {
                int idFisaM1Src = entry.getIdFisa();
                double sellPrice = StockLogic.this.getPretVzLaData(entry.getIdStock(), date);
                double buyPrice = entry.getBuyPrice();
                StockLogic.this.addIesireDinMagazie(bonConsumItem.getIdStock(), idMagazie, tipDocument, document, date, quantity, buyPrice, sellPrice, entry.getDenumireLaFurnizor(), entry.getCodBare(), fiscal, -1, comandaType, bonConsumItem.getIdLot());
                StockLogic.this.getDao().addConsum(entry.getIdFisa(), quantity, date);
                double valueAcz = quantity * buyPrice;
                totalValPa.setValue(totalValPa.getValue() + valueAcz);
                StockLogic.this.getDao().addBuyValueForConsumItem(idBonConsumItem, valueAcz);
            }
        };
        this.getDao().resetBuyValueForConsumItem(bonConsumItem.getId());
        double result = this.operateOnStock(bonConsumItem.getIdStock(), bonConsumItem.getCantitate(), idMagazie, date, document, bonConsumItem.getId(), -1, inter, fiscal, false, bonConsumItem.getIdLot());
        return result;
    }

    public void addConsumEntry(int idFisaCuStockPozitiv, double quantity, Timestamp salestamp) throws SQLException {
        this.getDao().addConsum(idFisaCuStockPozitiv, quantity, salestamp);
    }

    public LanguageProvider getLanguageProvider() {
        return this.languageProvider;
    }

    public void setLanguageProvider(LanguageProvider languageProvider) {
        this.languageProvider = languageProvider;
    }

    public void cleanupStocks() throws SQLException {
        this.getDao().cleanupStocks();
    }

    public void toIngredientNoCommit(int idStock) throws SQLException {
        this.getDao().toIngredient(idStock);
    }

    public void toIngredient(int idStock) {
        try {
            this.toIngredientNoCommit(idStock);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getDeleteImpediments(int idStock) {
        try {
            Vector impediments;
            Vector vector = impediments = this.deleteImpediments.deleteImpedimentsNoCommit(idStock);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void deleteStockShortNoCommit(int idStock) throws SQLException {
        Product produsFinit = this.getProductForStockNoCommit(idStock);
        this.toIngredientNoCommit(idStock);
        this.getDao().deleteStock(idStock);
        if (produsFinit != null) {
            this.getDao().syncProdusFinit(produsFinit.getId(), idStock, true);
        }
        this.stockDeleted(idStock);
    }

    public boolean deleteStockNoCommit(int idStock, Component parent, Vector<Product> toNotify) throws SQLException {
        Vector impediments = this.deleteImpediments.deleteImpedimentsNoCommit(idStock);
        if (impediments.size() > 0) {
            String text = this.getDeleteImpedimentsString(impediments);
            if (parent != null) {
                DialogUtils.errorDialog(parent, text, LangRoAll.nuPotContinua);
            }
            return false;
        }
        this.toIngredientNoCommit(idStock);
        this.getDao().deleteStock(idStock);
        Product produsFinit = this.getProductForStockNoCommit(idStock);
        if (produsFinit != null) {
            toNotify.add(produsFinit);
            this.getDao().syncProdusFinit(produsFinit.getId(), idStock, true);
        }
        this.stockDeleted(idStock);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteStock(int idStock, Component parent) {
        boolean result = false;
        try {
            Vector<Product> toNotify = new Vector<Product>();
            result = this.deleteStockNoCommit(idStock, parent, toNotify);
            this.pool.requestConnection().commitTransaction();
            if (toNotify.size() > 0) {
                Product produsFinit = toNotify.get(0);
                this.notifyObjectListeners(106, produsFinit);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    public String getDeleteImpedimentsString(Vector impediments) {
        String s1 = "Stocul este folosit in retetele :";
        String s2 = "Stocul nu este folosit in nici o reteta";
        return Utils.getStringForJDialogList(s1, s2, impediments);
    }

    public void deleteAllFiseMagazie() throws SQLException {
        this.getDao().deleteAllFiseMagazie(DateUtils.getStartOfDays(), DateUtils.getEndOfDays());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllFutureFiseMagazie(Timestamp start) {
        try {
            Timestamp start1 = new Timestamp(start.getTime() + 1L);
            this.getDao().deleteAllFiseMagazie(start1, DateUtils.getEndOfDays());
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void deleteAllFiseMagazie(Timestamp start, Timestamp stop) throws SQLException {
        this.getDao().deleteAllFiseMagazie(start, stop);
    }

    public void addFisaMagazieIntrareNoCommit(int idStock, int idMagazie, int tipDocument, String document, Timestamp timeDocument, double buyPrice, double sellPrice, double intrata, double intrareValuePa, double intrareValuePv, String denumireLaFurnizor, String codBare, boolean fiscal, COMANDA_TYPE comandaType, int idLot) throws SQLException {
        this.addFisaMagazieNoCommit(idStock, idMagazie, tipDocument, document, timeDocument, buyPrice, sellPrice, intrata, 0.0, intrareValuePa, intrareValuePv, 0.0, 0.0, denumireLaFurnizor, codBare, fiscal, -1, comandaType, idLot);
    }

    private boolean isGestiuneCMP() throws SQLException {
        return this.config.getStringNoCommit("gestiuneTip").equalsIgnoreCase(TIP_GESTIUNE_CMP);
    }

    public void processStockCmpForStock(Timestamp timeDocument, int idStock, double cantitate, double valIntrarePa) throws SQLException {
        StockCMP latest = new StockCMP();
        Vector<StockCMP> cmps = this.getDao().getLatestStockCMPAtTimestamp(idStock, timeDocument);
        if (cmps.size() > 0) {
            latest = cmps.get(0);
        }
        latest.setCantitate(latest.getCantitate() + cantitate);
        latest.setValoare(latest.getValoare() + valIntrarePa);
        if (!timeDocument.equals(latest.getTimeDocument())) {
            this.getDao().addStockCMP(idStock, timeDocument, latest.getValoare(), latest.getCantitate());
        } else {
            this.getDao().updateStockCmp(latest);
        }
    }

    public void deleteStockCMPsForStockAfterData(int idStock, Timestamp data) throws SQLException {
        this.getDao().deleteAllCMPForStockAfterData(idStock, data);
    }

    public int addFisaMagazieNoCommit(int idStock, int idMagazie, int tipDocument, String document, Timestamp timeDocument, double buyPrice, double sellPrice, double intrata, double iesita, double intrareValuePa, double intrareValuePv, double iesireValuePa, double iesireValuePv, String denumireLaFurnizor, String codBare, boolean fiscal, int idSale, COMANDA_TYPE comandaType) throws SQLException {
        return this.addFisaMagazieNoCommit(idStock, idMagazie, tipDocument, document, timeDocument, buyPrice, sellPrice, intrata, iesita, intrareValuePa, intrareValuePv, iesireValuePa, iesireValuePv, denumireLaFurnizor, codBare, fiscal, idSale, comandaType, -1);
    }

    public int addFisaMagazieNoCommit(int idStock, int idMagazie, int tipDocument, String document, Timestamp timeDocument, double buyPrice, double sellPrice, double intrata, double iesita, double intrareValuePa, double intrareValuePv, double iesireValuePa, double iesireValuePv, String denumireLaFurnizor, String codBare, boolean fiscal, int idSale, COMANDA_TYPE comandaType, int idLot) throws SQLException {
        this.getDao().addFisaMagazie(idStock, idMagazie, tipDocument, document, timeDocument, buyPrice, intrata, iesita, intrareValuePa, intrareValuePv, iesireValuePa, iesireValuePv, denumireLaFurnizor, codBare, fiscal ? 1 : 0, idSale, comandaType, idLot);
        int idFisaMagazie = this.pool.requestConnection().getIndentityLocal();
        return idFisaMagazie;
    }

    public void deleteFisaMagazieNoCommit(int idFisaMagazie) throws SQLException {
        this.getDao().deleteFisaMagazie(idFisaMagazie);
    }

    public Vector getFisaMagazie(Hashtable criteria, int what) {
        try {
            Integer idMagazie = (Integer)criteria.get("id_magazie");
            Integer idStock = (Integer)criteria.get("id_stock_key");
            Date start = (Date)criteria.get(Constants.START_KEY);
            Date stop = (Date)criteria.get(Constants.STOP_KEY);
            COMANDA_TYPE ct = (COMANDA_TYPE)((Object)criteria.get("Comanda Type"));
            return this.getFisaMagazie(idStock, idMagazie, new Timestamp(start.getTime()), new Timestamp(stop.getTime()), what, ct);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    public Vector getFisaMagazie(int idStock, int idMagazie, Timestamp start, Timestamp stop, int what, COMANDA_TYPE comandaType) throws SQLException {
        Connection c = this.pool.requestConnection().getConnection();
        Vector fise = this.getDao().getFisaMagazie(idStock, idMagazie, start, stop, what, c, comandaType);
        return fise;
    }

    public Vector<FisaMagazieEntry> getFisaMagazieByTimeDocument(Timestamp timestamp) throws SQLException {
        return this.getDao().getFisaMagazieByTimeDocument(timestamp);
    }

    public void cleanupSectiiMagazii() throws SQLException {
        this.getDao().deleteMagaziiSectii();
    }

    public void cleanupCantitati() throws SQLException {
        this.getDao().cleanupCantitati();
    }

    public void setStockInterface(StockInterface stockInterface) {
        this.stockInterface = stockInterface;
    }

    public StockInterface getStockInterface() {
        return this.stockInterface;
    }

    public boolean isProdusFinitNoCommit(int idStock) throws SQLException {
        boolean result = this.getProductForStockFromDBNoCommit(idStock) != -1;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProdusFinit(int idStock) {
        boolean result = false;
        try {
            result = this.isProdusFinitNoCommit(idStock);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public void setDeleteImpediments(DeleteStockImpediments deleteImpediments) {
        this.deleteImpediments = deleteImpediments;
    }

    public String printBalantaXML(String destinationFile, Date endDate, Vector items, int idMagazie) {
        try {
            String balantaTemplate = "conf" + File.separator + "exportBalanta.xml";
            String stockTemplate = "conf" + File.separator + "exportStock.xml";
            String bigFile = "<magazii data=\"" + Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(endDate) + "\">";
            String balanta = FileUtils.readFileToString(balantaTemplate);
            balanta = balanta.replaceAll("%%idMagazie%%", idMagazie + "");
            String stocksString = "";
            for (int i = 0; i < items.size(); ++i) {
                RaportGestiuneEntry o = (RaportGestiuneEntry)items.elementAt(i);
                String stock = FileUtils.readFileToString(stockTemplate);
                stock = stock.replaceAll("%%idStock%%", o.getIdStoc() + "");
                stock = stock.replaceAll("%%stoc%%", o.getCantFinala() + "");
                stock = stock.replaceAll("%%valoareAchizitie%%", o.getValFinalaAcz() + "");
                stock = stock.replaceAll("%%valoareVanzare%%", o.getValFinalaVz() + "");
                stocksString = stocksString + stock + "\n";
            }
            balanta = balanta.replaceAll("%%stocks%%", stocksString);
            bigFile = bigFile + balanta + "\n";
            bigFile = bigFile + "\n</magazii>";
            FileUtils.writeTextToFile(destinationFile, bigFile);
            return destinationFile;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    public Vector getStockForValidation(int idMagazie, Timestamp t1, int what) throws SQLException {
        Connection c = this.pool.requestConnection().getConnection();
        String sqlIn = this.getStockSqlInSequenceForBalanta(-1, false, c, null);
        if (sqlIn.length() <= 2) {
            return new Vector();
        }
        Hashtable<Integer, StockBean> stocInitial = this.getDao().getStocLaData(sqlIn, idMagazie, t1, what, c);
        return new Vector<StockBean>(stocInitial.values());
    }

    public StockBean getStockInitialForStockId(int idStock, int idMagazie, Timestamp t1, int what) throws SQLException {
        Vector<Integer> ids = new Vector<Integer>();
        ids.add(idStock);
        String s = Utils.getSqlInSequence(ids);
        Hashtable<Integer, StockBean> stocInitial = this.getDao().getStocLaData(s, idMagazie, t1, what, this.pool.requestConnection().getConnection());
        return stocInitial.get(idStock);
    }

    public Vector<RaportGestiuneEntry> generateRaportGestiuneNoCommit(Hashtable criteria, boolean consumOnly, int what) throws SQLException {
        Integer magazieId = (Integer)criteria.get("id_magazie");
        Integer tipProdus = (Integer)criteria.get("finit_ingredient");
        Date startTime = (Date)criteria.get(Constants.START_KEY);
        Date stopTime = (Date)criteria.get(Constants.STOP_KEY);
        String dbIn = (String)criteria.get("tip_document");
        Tag tag = (Tag)criteria.get("");
        boolean produseFaraTranzactii = criteria.get("Include produse fara tranzactii") != null;
        boolean produseSterse = criteria.get("Include produse sterse") != null;
        Timestamp t1 = new Timestamp(startTime.getTime());
        Timestamp t2 = new Timestamp(stopTime.getTime());
        Connection c = this.pool.requestConnection().getConnection();
        String sqlIn = this.getStockSqlInSequenceForBalanta(tipProdus, produseSterse, c, tag);
        if (sqlIn.length() <= 2) {
            return new Vector<RaportGestiuneEntry>();
        }
        Hashtable<Integer, RaportGestiuneEntry> hash = this.getDao().getStockNamesForBalanta(sqlIn, 1, c);
        Hashtable<Integer, StockBean> stocInitial = this.getDao().getStocLaData(sqlIn, magazieId, t1, what, c);
        Hashtable<Integer, MIscariStockBean> miscari = this.getDao().getMiscariIntreDateForBalanta(sqlIn, magazieId, t1, t2, dbIn, what, c);
        Hashtable<Integer, Integer> idsDeAfisat = new Hashtable<Integer, Integer>();
        for (Integer idStock : hash.keySet()) {
            StockBean sb = stocInitial.get(idStock);
            RaportGestiuneEntry rge = hash.get(idStock);
            if (sb != null && rge != null) {
                rge.setCantInitiala(sb.getCantitate());
                rge.setValInitialaVz(sb.getVanzare());
                rge.setValInitialaAcz(sb.getAchizitie());
                idsDeAfisat.put(idStock, idStock);
            } else if (rge == null) {
                System.out.println("RGE is null desi nu ar trb");
            }
            MIscariStockBean msb = miscari.get(idStock);
            if (msb != null) {
                rge.setCantIntrata(msb.getIntrare());
                rge.setCantIesita(msb.getIesire());
                rge.setValIntrataAcz(msb.getValIntrareAcz());
                rge.setValIesitaAcz(msb.getValIesireAcz());
                rge.setValIntrataVz(msb.getValIntrareVz());
                rge.setValIesitaVz(msb.getValIesireVz());
                rge.setIdStoc(idStock);
                idsDeAfisat.put(idStock, idStock);
            }
            if (consumOnly) {
                if (produseFaraTranzactii || rge.getCantIesita() != 0.0) {
                    idsDeAfisat.put(idStock, idStock);
                }
            } else if (produseFaraTranzactii || rge.getCantIesita() != 0.0 || rge.getCantIntrata() != 0.0 || rge.getCantInitiala() != 0.0) {
                idsDeAfisat.put(idStock, idStock);
            }
            rge.computeFinal();
        }
        Vector<RaportGestiuneEntry> result = new Vector<RaportGestiuneEntry>();
        for (Integer idStock : idsDeAfisat.keySet()) {
            RaportGestiuneEntry e = hash.get(idStock);
            if (e.getIdStoc() <= 0) {
                System.out.println("id stoc is zero");
            }
            result.add(e);
        }
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                RaportGestiuneEntry r1 = (RaportGestiuneEntry)o1;
                RaportGestiuneEntry r2 = (RaportGestiuneEntry)o2;
                return r1.getProdus().compareToIgnoreCase(r2.getProdus());
            }
        });
        return result;
    }

    public String getStockSqlInSequenceForBalanta(Integer tipProdus, boolean produseSterse, Connection c, Tag tag) throws SQLException {
        Hashtable<Integer, Integer> ids = this.getStockSqlInSequenceForBalantaAsHash(tipProdus, produseSterse, c, tag);
        String inSql = Utils.getSqlInSequence(new Vector<Integer>(ids.keySet()));
        return inSql;
    }

    public Hashtable<Integer, Integer> getStockSqlInSequenceForBalantaAsHash(Integer tipProdus, boolean produseSterse, Connection c, Tag tag) throws SQLException {
        return this.getDao().getStocksSqlInSequenceForBalanta(produseSterse, tipProdus, c, tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<RaportGestiuneEntry> generateRaportGestiune(Hashtable criteria, boolean consumOnly, int what) {
        try {
            Vector<RaportGestiuneEntry> vector = this.generateRaportGestiuneNoCommit(criteria, consumOnly, what);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<RaportGestiuneEntry> vector = new Vector<RaportGestiuneEntry>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector generateRaportGestiuneValorica(Hashtable criteria, int what) {
        try {
            Integer magazieId = (Integer)criteria.get("id_magazie");
            Integer tipProdus = (Integer)criteria.get("finit_ingredient");
            Date startTime = (Date)criteria.get(Constants.START_KEY);
            Date stopTime = (Date)criteria.get(Constants.STOP_KEY);
            String dbIn = (String)criteria.get("tip_document");
            Tag tag = (Tag)criteria.get("");
            boolean produseSterse = criteria.get("Include produse sterse") != null;
            Timestamp t1 = new Timestamp(startTime.getTime());
            Timestamp t2 = new Timestamp(stopTime.getTime());
            Connection c = this.pool.requestConnection().getConnection();
            String sqlIn = this.getStockSqlInSequenceForBalanta(tipProdus, produseSterse, c, tag);
            Vector<RaportGestiuneValoricaEntry> result = new Vector<RaportGestiuneValoricaEntry>();
            if (sqlIn.length() <= 2) {
                Vector vector = new Vector();
                return vector;
            }
            double[] stocValoricInitial = this.getDao().getStocValoricLaData(sqlIn, magazieId, t1, what, c);
            RaportGestiuneValoricaEntry rge = new RaportGestiuneValoricaEntry("Sold initial", stocValoricInitial[0], 0.0, stocValoricInitial[1], 0.0, new Date(t1.getTime()));
            rge.computeSold(0.0, 0.0);
            result.add(rge);
            double soldPa = rge.getSoldPa();
            double soldPv = rge.getSoldPv();
            Vector miscari = this.getDao().getMiscariValoriceIntreDateForRaportGestiuneValorica(sqlIn, magazieId, t1, t2, dbIn, what, c);
            for (int i = 0; i < miscari.size(); ++i) {
                RaportGestiuneValoricaEntry raportGestiuneValoricaEntry = (RaportGestiuneValoricaEntry)miscari.elementAt(i);
                raportGestiuneValoricaEntry.computeSold(soldPa, soldPv);
                soldPa = raportGestiuneValoricaEntry.getSoldPa();
                soldPv = raportGestiuneValoricaEntry.getSoldPv();
            }
            result.addAll(miscari);
            Vector<RaportGestiuneValoricaEntry> vector = result;
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<RaportGestiuneEntry> generateRaportConsumuri(Hashtable criteria, int what) {
        return this.generateRaportGestiune(criteria, true, what);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[][] getMiscariIntreDate(int idStock, int idMagazie, Timestamp dateStart, Timestamp dateStop) {
        try {
            double[][] result;
            double[][] dArray = result = this.getMiscariIntreDateNoCommit(idStock, idMagazie, dateStart, dateStop);
            return dArray;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            double[][] dArray = new double[2][3];
            return dArray;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public double[][] getMiscariIntreDateNoCommit(int idStock, int idMagazie, Timestamp dateStart, Timestamp dateStop) throws SQLException {
        double[][] result = this.getDao().getMiscariIntreDate(idStock, idMagazie, dateStart, dateStop);
        return result;
    }

    public String printRaportGestiune(Hashtable printCriteria, Vector items, String numeMagazie, double valInitiala, double valIntrata, double valIesita, double valFinala, int tipP) {
        try {
            StocksPrint.tipP = tipP;
            String foFile = StocksPrint.makeRaportGestiuneFoFile(items, printCriteria, numeMagazie, this.config, valInitiala, valIntrata, valIesita, valFinala);
            return foFile;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    public void importBalantaFromXml(String xmlFile, ReceptieFromStockInterface receptieInterface, StockLogic logic, Component parent) {
        try {
            SAXParser r = new SAXParser();
            BalantaXmlHandler handler = new BalantaXmlHandler(receptieInterface, logic, parent);
            r.setContentHandler(handler);
            r.setErrorHandler(handler);
            r.parse(xmlFile);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void deleteFiseMagazieNoCommit(Vector ids) throws SQLException {
        for (int i = 0; i < ids.size(); ++i) {
            Integer o = (Integer)ids.elementAt(i);
            this.getDao().deleteFisaMagazie(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<StockTransferItem> getTransferItems(int idTransfer) {
        try {
            Vector<StockTransferItem> result;
            Vector<StockTransferItem> vector = result = this.getTransferItemsNoCommit(idTransfer);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<StockTransferItem> vector = new Vector<StockTransferItem>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<StockTransferItem> getTransferItemsNoCommit(int idTransfer) throws SQLException {
        return this.getDao().getTransferItemsForTransfer(idTransfer);
    }

    private StockTransferItem getTransferItemByIdNoCommit(int idTransferItem) throws SQLException {
        return this.getDao().getTransferItemById(idTransferItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<StockTransfer> getTransferuri(Hashtable criteria) {
        try {
            Vector<StockTransfer> result;
            int idSource = (Integer)criteria.get("id_magazie");
            int idDest = (Integer)criteria.get("id_magazie_destinatie");
            Date start = (Date)criteria.get(Constants.START_KEY);
            Date stop = (Date)criteria.get(Constants.STOP_KEY);
            int tipTransfer = (Integer)criteria.get("Tip transfer");
            Vector<StockTransfer> vector = result = this.getDao().getTransferuri(idSource, idDest, new Timestamp(start.getTime()), new Timestamp(stop.getTime()), tipTransfer);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<StockTransfer> vector = new Vector<StockTransfer>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getBonuriConsum(Hashtable criteria) {
        try {
            Vector result;
            int idMagazie = (Integer)criteria.get("id_magazie");
            Date start = (Date)criteria.get(Constants.START_KEY);
            Date stop = (Date)criteria.get(Constants.STOP_KEY);
            Vector vector = result = this.getDao().getBonuriConsum(idMagazie, new Timestamp(start.getTime()), new Timestamp(stop.getTime()));
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public BonConsum getBonConsumByIdNoCommit(int id) throws SQLException {
        BonConsum result = this.getDao().getBonConsum(id);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BonConsum getBonConsumById(int id) {
        try {
            BonConsum bonConsum = this.getBonConsumByIdNoCommit(id);
            return bonConsum;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            BonConsum bonConsum = null;
            return bonConsum;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<BonConsumItem> getBonConsumItemsNoCommit(int idBc) throws SQLException {
        Vector result = this.getDao().getBonConsumItems(idBc);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getBonConsumItems(int idBc) {
        try {
            Vector<BonConsumItem> vector = this.getBonConsumItemsNoCommit(idBc);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector vector = new Vector();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Corectie getCorectieById(int id) {
        try {
            Corectie result;
            Corectie corectie = result = this.getCorectieByIdNoCommit(id);
            return corectie;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Corectie corectie = null;
            return corectie;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Corectie getCorectieByIdNoCommit(int id) throws SQLException {
        return this.getDao().getCorectie(id);
    }

    public Vector<Corectie> getRaportCorectii(int idMagazie, Timestamp start, Timestamp stop) throws SQLException {
        return this.getDao().getCorectiiForMagazie(idMagazie, start, stop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCorectieItems(int idCorectie) {
        Vector<Object> result = new Vector();
        try {
            result = this.getCorectieItemsNoCommit(idCorectie);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector<BonConsumItem> getCorectieItemsNoCommit(int idCorectie) throws SQLException {
        Vector<BonConsumItem> result = this.getDao().getCorectieItems(idCorectie, -1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reproceseazaTransfer(int idTransfer, String document, Timestamp time, boolean fiscal, COMANDA_TYPE comandaType) {
        try {
            boolean result = this.reproceseazaTransferNoCommit(idTransfer, document, time, fiscal, comandaType);
            this.pool.commit();
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public boolean reproceseazaTransferNoCommit(int idTransfer, String document, Timestamp time, boolean fiscal, COMANDA_TYPE comandaType) throws SQLException {
        StockTransfer st = this.getDao().getTransferById(idTransfer);
        if (st == null) {
            return false;
        }
        Vector<StockTransferItem> items = this.getTransferItemsNoCommit(idTransfer);
        AtrFloat valPa = new AtrFloat();
        this.processTransferItems(items, st.getIdSource(), st.getIdDestinatie(), time, valPa, document, fiscal, st.isPretAczFix(), comandaType);
        this.getDao().updateValPaForTransfer(idTransfer, valPa.getValue());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reproceseazaConsum(int idBonConsum, String document, Timestamp time, boolean fiscal, COMANDA_TYPE comandaType) {
        try {
            boolean result = this.reproceseazaConsumNoCommit(idBonConsum, document, time, fiscal, comandaType);
            this.pool.commit();
            boolean bl = result;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public boolean reproceseazaConsumNoCommit(int idBonConsum, String document, Timestamp time, boolean fiscal, COMANDA_TYPE comandaType) throws SQLException {
        BonConsum bc = this.getBonConsumByIdNoCommit(idBonConsum);
        if (bc == null) {
            return false;
        }
        Vector<BonConsumItem> items = this.getBonConsumItemsNoCommit(idBonConsum);
        AtrFloat valPa = new AtrFloat();
        this.processBonConsumItemsNoCommit(items, bc.getIdMagazie(), time, document, true, fiscal, valPa, comandaType);
        this.getDao().updateValPaForConsum(idBonConsum, valPa.getValue());
        return true;
    }

    public void replaceFapticForStockAndMagazieNoCommit(int idStoc, int idMagazie, double cantitate) throws SQLException {
        this.deleteFapticForStockAndMagazie(idStoc, idMagazie);
        this.addStockFapticNoCommit(idStoc, idMagazie, cantitate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceFapticForStockAndMagazie(int idStoc, int idMagazie, double cantitate) {
        try {
            this.replaceFapticForStockAndMagazieNoCommit(idStoc, idMagazie, cantitate);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void deleteFapticForStockAndMagazie(int idStoc, int idMagazie) throws SQLException {
        this.getDao().deleteFapticForStockAndMagazie(idStoc, idMagazie);
        Stock s = this.getStockById(idStoc);
        Magazie m = this.getMagazieById(idMagazie);
        UsersLogic.getInstance().addBOUserLogNoCommit("Sters faptic " + s.getLabel() + "-" + m.getLabel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStockFaptic(int idStock, int idMagazie, double cantitate) {
        try {
            this.addStockFapticNoCommit(idStock, idMagazie, cantitate);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void addStockFapticNoCommit(int idStock, int idMagazie, double cantitate) throws SQLException {
        this.getDao().addStockFaptic(idStock, idMagazie, cantitate);
        Stock s = this.getStockById(idStock);
        Magazie m = this.getMagazieById(idMagazie);
        UsersLogic.getInstance().addBOUserLogNoCommit("Adaugat faptic " + s.getLabel() + "-" + m.getLabel() + ": " + Utils.getString3Decimals(cantitate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<StockComparativEntry> getStockComparativ(int idMagazie, Timestamp stockDate, Corectie inventar, int idCategorie, int what) {
        Vector<StockComparativEntry> result = new Vector<StockComparativEntry>();
        try {
            Vector<StockViewEntry> stocks = this.getStocksViewsForMagazie(idMagazie, -1, idCategorie, -1, false, -1, -1);
            for (int i = 0; i < stocks.size(); ++i) {
                StockViewEntry s = stocks.elementAt(i);
                StockComparativEntry se = new StockComparativEntry();
                se.setIdStock(s.getIdStock());
                se.setIdMagazie(idMagazie);
                if (inventar == null) {
                    se.setFaptic(this.getDao().getSumFromFaptic(s.getIdStock(), idMagazie));
                    se.setFapticSet(this.getDao().getCountQuantitiesFromFaptic(s.getIdStock(), idMagazie) > 0);
                } else {
                    Vector<BonConsumItem> items = this.getDao().getCorectieItems(inventar.getId(), se.getIdStock());
                    if (items.size() > 0) {
                        BonConsumItem bci = items.get(0);
                        se.setFaptic(bci.getCantitate());
                        if (bci.getCantitate() != 0.0) {
                            se.setFapticSet(true);
                        }
                    }
                }
                double cantitate = this.getDao().getCantitateInMagazie(idMagazie, s.getIdStock(), stockDate, what)[0];
                se.setScriptic(cantitate);
                se.setStock(s.getNume());
                se.compute();
                result.add(se);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            result = new Vector();
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Vector getFapticForPda(int idStock, int idMagazie, int itemsCount, int startAt) {
        try {
            Vector result = this.getDao().selectFapticForMagazie(idStock, idMagazie, itemsCount, startAt);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return result;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    public void deleteStockFaptic(int nrCrt) {
        try {
            this.getDao().deleteStockFaptic(nrCrt);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void deleteAllFaptic(int idMagazie) {
        try {
            this.getDao().deleteAllFaptic(idMagazie);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void corecteazaCuFaptic(int idStock, int idMagazie, double cantitateNoua, Timestamp dataCorectie, double cantitateVeche, boolean fiscal, int whatToPrint) {
        Vector<StockComparativEntry> items = new Vector<StockComparativEntry>();
        StockComparativEntry s = new StockComparativEntry();
        s.setFaptic(cantitateNoua);
        s.setIdMagazie(idMagazie);
        s.setIdStock(idStock);
        s.setScriptic(cantitateVeche);
        s.compute();
        items.add(s);
        this.corecteazaCuFaptic(idMagazie, items, dataCorectie, fiscal, whatToPrint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modificaInventar(int idInventar, Component panel, Timestamp dataVeche, Timestamp dataNoua, Vector items, boolean fiscal, int whatToPrint) {
        try {
            if (!this.documentInterface.canModifyDocument(9, idInventar)) {
                DialogUtils.errorDialog(panel, "Documentele validate nu se pot modifica", LangRoAll.nuPotContinua);
                return;
            }
            Timestamp data = dataVeche;
            if (!DateUtils.sameMinute(dataVeche, dataNoua)) {
                data = this.documentInterface.getTimeDocument(2, dataNoua);
            }
            if (!this.documentInterface.canAddDocument(data)) {
                DialogUtils.errorDialog(panel, "Data nu poate fi mai mica decat ultima validare", LangRoAll.nuPotContinua);
                return;
            }
            this.deleteFiseMagazieLaData(dataVeche);
            this.getDao().updateCorectie(idInventar, data);
            if (items.size() > 0) {
                this.getDao().deleteCorectiiItemsByIdCorectie(idInventar);
                for (int i = 0; i < items.size(); ++i) {
                    StockComparativEntry o = (StockComparativEntry)items.elementAt(i);
                    this.getDao().addCorectieItem(idInventar, o.getIdStock(), o.getFaptic(), whatToPrint);
                }
            }
            this.documentInterface.corectieUpdated(idInventar, data, "Corectie " + idInventar, fiscal);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stergeInventar(int idInventar, Component panel, Timestamp dataCorectie) {
        try {
            if (!this.documentInterface.canModifyDocument(9, idInventar)) {
                DialogUtils.errorDialog(panel, "Documentele validate nu se pot sterge", LangRoAll.nuPotContinua);
                return;
            }
            this.deleteFiseMagazieLaData(dataCorectie);
            this.getDao().deleteCorectieById(idInventar);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void corecteazaCuFaptic(int idMagazie, Vector items, Timestamp dataCorectie, boolean fiscal, int whatToPrint) {
        try {
            this.adaugaCorectieNoCommit(idMagazie, dataCorectie, items, fiscal, whatToPrint);
            this.getDao().deleteAllFaptic(idMagazie);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public void transferLaFacturare(StockTransfer st, boolean retur) {
        Vector<StockTransferItem> transferItems = this.getTransferItems(st.getId());
    }

    public double getPriceForStockNoCommit(int idStock, Timestamp saleTime) throws SQLException {
        double firstPrice = -1.0;
        if (saleTime != null) {
            firstPrice = this.getPretVzLaData(idStock, saleTime);
            return firstPrice;
        }
        firstPrice = this.getDao().getCatalogPriceForStock(idStock);
        return firstPrice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPriceForStock(int idStock, Timestamp saleTime) {
        double firstPrice = -1.0;
        try {
            double d = this.getPriceForStockNoCommit(idStock, saleTime);
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return firstPrice;
    }

    public String processBonConsumItemsNoCommit(Vector items, int idMagazie, Timestamp timeTransfer, String document, boolean forteazaDescarcare, boolean fiscal, AtrFloat totalAcz, COMANDA_TYPE comandaType) throws SQLException {
        String result = "";
        int lastI = 0;
        int i = 0;
        while (i < items.size()) {
            BonConsumItem o = (BonConsumItem)items.elementAt(i);
            double quantity = o.getCantitate();
            if (o.getIdStock() == 398) {
                System.out.println("found");
            }
            this.addConsumNoCommit(o, idMagazie, 4, document, timeTransfer, forteazaDescarcare, fiscal, totalAcz, comandaType);
            lastI = i++;
        }
        return result;
    }

    public void adaugaCorectieNoCommit(int idMagazie, Timestamp dataCorectie, Vector items, boolean fiscal, int whatToPrint) throws SQLException {
        Timestamp newData = this.documentInterface.getTimeDocument(9, dataCorectie);
        this.getDao().addCorectie(idMagazie, newData);
        int idCorectie = this.pool.requestConnection().getIndentityLocal();
        for (int i = 0; i < items.size(); ++i) {
            StockComparativEntry o = (StockComparativEntry)items.elementAt(i);
            this.getDao().addCorectieItem(idCorectie, o.getIdStock(), o.getFaptic(), whatToPrint);
        }
        this.documentInterface.corectieAdded(idCorectie, newData, "Corectie " + idCorectie, fiscal);
    }

    public void processCorectieItems(Vector items, int idMagazie, Timestamp dataCorectie, String document, boolean fiscal, COMANDA_TYPE comandaType) throws SQLException {
        for (int i = 0; i < items.size(); ++i) {
            BonConsumItem o = (BonConsumItem)items.elementAt(i);
            int what = -1;
            what = fiscal ? 2 : -1;
            switch (o.getfMode()) {
                case 2: {
                    what = 2;
                    break;
                }
                case 3: {
                    what = 3;
                    break;
                }
                case 1: {
                    what = -1;
                }
            }
            int idStock = o.getIdStock();
            double[] stocTemp = this.getDao().getCantitateInMagazie(idMagazie, idStock, dataCorectie, what);
            double existent = stocTemp[0];
            double faptic = o.getCantitate();
            double diferentaCantitativa = faptic - existent;
            FisaIntrareActiva fe = this.getDao().getLatestFisaMagazieAchizitieForStock(idStock);
            String denumireLaFurnizor = "";
            String codBare = "";
            if (fe != null) {
                denumireLaFurnizor = fe.getDenumireLaFurnizor();
                codBare = fe.getCodBare();
            }
            if (diferentaCantitativa != 0.0) {
                double valIntrarePa = 0.0;
                double valIntrarePv = 0.0;
                double pa = 0.0;
                double pv = 0.0;
                if (fe != null) {
                    pa = fe.getBuyPrice();
                    pv = this.getPretVzLaData(idStock, dataCorectie);
                }
                valIntrarePa = diferentaCantitativa * pa;
                valIntrarePv = diferentaCantitativa * pv;
                this.addFisaMagazieNoCommit(idStock, idMagazie, 9, document, dataCorectie, pa, pv, 0.0, -diferentaCantitativa, 0.0, 0.0, -valIntrarePa, -valIntrarePv, denumireLaFurnizor, codBare, fiscal, -1, comandaType);
            }
            if (!this.config.getBooleanNoCommit("stockCorrectionInhibitValueModification")) {
                stocTemp = this.getDao().getCantitateInMagazie(idMagazie, o.getIdStock(), dataCorectie, what);
                double valoareCfStoc = stocTemp[1];
                double valoareCfLoturi = this.computeValueBackwards(o.getIdStock(), faptic, idMagazie, dataCorectie);
                double diferentaValorica = valoareCfLoturi - valoareCfStoc;
                if (!Utils.isValueZero(diferentaValorica)) {
                    this.addFisaMagazieNoCommit(idStock, idMagazie, 9, document, dataCorectie, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -diferentaValorica, 0.0, denumireLaFurnizor, codBare, fiscal, -1, comandaType);
                }
                double valoareVanzareCfStoc = stocTemp[2];
                double pretVanzare = this.getPretVzLaData(idStock, dataCorectie);
                double valoareVzTeoretica = faptic * pretVanzare;
                double diffValoricaPretVz = valoareVzTeoretica - valoareVanzareCfStoc;
                if (!Utils.isValueZero(diffValoricaPretVz)) {
                    this.addFisaMagazieNoCommit(idStock, idMagazie, 9, document, dataCorectie, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -diffValoricaPretVz, denumireLaFurnizor, codBare, fiscal, -1, comandaType);
                }
            }
            this.correctStockConsumEntries(idStock, faptic, idMagazie, dataCorectie);
        }
    }

    public int adaugaBonConsumNoCommit(int idMagazie, Timestamp dataConsum, Vector items, String document, boolean fiscal, double total, int nrBonConsum, String obs) throws SQLException {
        Timestamp newData = this.documentInterface.getTimeDocument(4, dataConsum);
        this.getDao().addBonConsum(idMagazie, newData, total, nrBonConsum, obs);
        int idBonConsum = this.pool.requestConnection().getIndentityLocal();
        for (int i = 0; i < items.size(); ++i) {
            BonConsumItem o = (BonConsumItem)items.elementAt(i);
            this.getDao().addBonConsumItem(idBonConsum, o.getIdStock(), o.getCantitate(), o.getIdLot());
            int idBonConsumItem = this.pool.requestConnection().getIndentityLocal();
            o.setId(idBonConsumItem);
        }
        int idDoc = this.documentInterface.consumAdded(idBonConsum, newData, "Bon consum " + nrBonConsum, fiscal);
        return idDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int adaugaBonConsum(int idMagazie, Timestamp dataConsum, Vector items, String document, boolean fiscal, double total, int nrBonConsum, String obs) {
        try {
            int idDocument = this.adaugaBonConsumNoCommit(idMagazie, dataConsum, items, document, fiscal, total, nrBonConsum, obs);
            this.pool.commit();
            int n = idDocument;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public String printBonConsum(Vector<ConsumTransferInterface> items, String magazieIn, String magazieOut, String societate, Date dateConsum, String nrBon, int tipPret) {
        try {
            String d = Formatters.DATE_AND_TIME_FORMAT.format(dateConsum);
            for (ConsumTransferInterface stock : items) {
                String denumire = stock.getDenumire();
                int idProductForStock = this.getIdProductForStock(stock.getIdStock());
                if (idProductForStock > 0) {
                    Vector<String> allBarcodes = NomeclaturaLogic.getInstance().getAllBarCodesByIdProd(idProductForStock);
                    String codesS = Utils.getSqlInSequence(allBarcodes, true);
                    denumire = denumire + " " + codesS;
                }
                stock.setDenumire(denumire);
            }
            String foFile = StocksPrint.makeBonFoFile(items, magazieIn, magazieOut, societate, d, nrBon, tipPret);
            PrintLogic.getInstance().printPdf(foFile, 1);
            return foFile;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    public String generateConsumuriFoFile(Vector items, String magazieOut, String dates, int tipP) {
        try {
            Vector<ConsumTransferInterface> bcEntries = new Vector<ConsumTransferInterface>();
            for (int i = 0; i < items.size(); ++i) {
                RaportGestiuneEntry rge = (RaportGestiuneEntry)items.elementAt(i);
                BonConsumItem bci = new BonConsumItem();
                bci.setCantitate(rge.getCantIesita());
                bci.setDenumire(rge.getProdus());
                bci.setUm(rge.getUm());
                bci.setValAcz(rge.getValIesitaAcz());
                bci.setValoare(rge.getValIesitaVz());
                bcEntries.add(bci);
            }
            String foFile = StocksPrint.makeBonFoFile(bcEntries, "Consum", magazieOut, Config.getInstance().getString("societate"), dates, "", tipP);
            return foFile;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBonConsum(Timestamp originalTime, int idBonConsum, int idMagazie, Timestamp newTime, Vector items, Component parent, boolean fiscal, int nrBonConsum, double totalValueAcz, String observatii) {
        try {
            if (!this.documentInterface.canModifyDocument(4, idBonConsum)) {
                DialogUtils.errorDialog(parent, "Nu puteti modifica acest bon consum", LangRoAll.nuPotContinua);
                this.pool.requestConnection().rollback();
                this.pool.releaseConnection();
                boolean bl = false;
                return bl;
            }
            this.deleteBonConsumItems(idBonConsum);
            this.documentInterface.documentDeleted(originalTime);
            this.documentInterface.documentDeleted(newTime);
            for (int i = 0; i < items.size(); ++i) {
                BonConsumItem o = (BonConsumItem)items.elementAt(i);
                this.getDao().addBonConsumItem(idBonConsum, o.getIdStock(), o.getCantitate(), o.getIdLot());
                int idBonConsumItem = this.pool.requestConnection().getIndentityLocal();
                o.setId(idBonConsumItem);
            }
            Timestamp newData = originalTime;
            if (!DateUtils.sameMinute(originalTime, newTime)) {
                newData = this.documentInterface.getTimeDocument(4, newTime);
            }
            this.getDao().updateBonConsum(idMagazie, newData, totalValueAcz, idBonConsum, nrBonConsum, observatii);
            this.documentInterface.consumUpdated(idBonConsum, newData, "Bon consum " + nrBonConsum, fiscal);
            this.pool.commit();
            boolean o = true;
            return o;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void deleteBonConsumItem(int idBonConsumItem) throws SQLException {
        this.getDao().deleteBonConsumItem(idBonConsumItem);
    }

    public void deleteBonConsumItems(int idBonConsum) throws SQLException {
        Vector items = this.getDao().getBonConsumItems(idBonConsum);
        for (int i = 0; i < items.size(); ++i) {
            BonConsumItem item = (BonConsumItem)items.elementAt(i);
            this.deleteBonConsumItem(item.getId());
        }
    }

    public boolean deleteBonConsum(int idBonConsum, Component parent, Timestamp dateadd) {
        try {
            if (!this.documentInterface.canModifyDocument(4, idBonConsum)) {
                DialogUtils.errorDialog(parent, "Nu puteti sterge acest bon consum", LangRoAll.nuPotContinua);
                this.pool.requestConnection().rollback();
                this.pool.releaseConnection();
                return false;
            }
            this.deleteBonConsumItems(idBonConsum);
            this.getDao().deleteBonConsum(idBonConsum);
            this.documentInterface.documentDeleted(dateadd);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return true;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    public boolean deleteTransfer(int idTransfer, Component parent, Timestamp dateadd) {
        try {
            if (!this.documentInterface.canModifyDocument(7, idTransfer)) {
                DialogUtils.errorDialog(parent, "Nu puteti sterge acest transfer", LangRoAll.nuPotContinua);
                this.pool.requestConnection().rollback();
                this.pool.releaseConnection();
                return false;
            }
            Vector<StockTransferItem> items = this.getDao().getTransferItemsForTransfer(idTransfer);
            for (int i = 0; i < items.size(); ++i) {
                StockTransferItem o = items.elementAt(i);
                this.deleteTransferItem(o.getId());
            }
            this.getDao().deleteTransfer(idTransfer);
            this.documentInterface.documentDeleted(dateadd);
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
            return true;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
    }

    private void deleteTransferItem(int idTransferItem) throws SQLException {
        this.getDao().deleteTransferItem(idTransferItem);
    }

    public int getTransferTip(String transferString) {
        int tipT = 2;
        if (transferString.equalsIgnoreCase("Materii prime")) {
            tipT = 4;
        } else if (transferString.equalsIgnoreCase("Combinat")) {
            tipT = 1;
        } else if (transferString.equalsIgnoreCase("Produse finite")) {
            tipT = 3;
        } else if (transferString.equalsIgnoreCase("All")) {
            tipT = -1;
        }
        return tipT;
    }

    public void fillTipTransferCombo(JComboBox tipTransfer, boolean includeAll) {
        if (includeAll) {
            tipTransfer.addItem("All");
        }
        tipTransfer.addItem("Marfa");
        tipTransfer.addItem("Materii prime");
        tipTransfer.addItem("Produse finite");
        tipTransfer.addItem("Combinat");
    }

    public String getStringTip(int tip) {
        String tipString = "";
        switch (tip) {
            case 2: {
                tipString = "Marfa";
                break;
            }
            case 4: {
                tipString = "Materii prime";
                break;
            }
            case 1: {
                tipString = "Combinat";
                break;
            }
            case 3: {
                tipString = "Produse finite";
                break;
            }
        }
        return tipString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Integer, Double> getConsumuri(String sqlInSeq, int idMagazie, Timestamp start, Timestamp stop) {
        try {
            Connection c = this.pool.requestConnection().getConnection();
            Hashtable<Integer, Double> hashtable = this.getDao().getConsumuri(sqlInSeq, idMagazie, start, stop, c);
            return hashtable;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Hashtable<Integer, Double> hashtable = new Hashtable<Integer, Double>();
            return hashtable;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector getConsum(Hashtable criteria, int idLanguage) {
        Date startDate = (Date)criteria.get(Constants.START_KEY);
        Date stopDate = (Date)criteria.get(Constants.STOP_KEY);
        int idMagazie = (Integer)criteria.get("id_magazie");
        return this.getConsum(startDate, stopDate, idMagazie, idLanguage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getConsum(Date startDate, Date stopDate, int idMagazie, int idLanguage) {
        Vector result = new Vector();
        try {
            Connection c = this.pool.requestConnection().getConnection();
            result = this.getDao().getConsum(startDate, stopDate, idLanguage, -1, idMagazie, c);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.requestConnection().commitTransaction();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Magazie getMagazieByLabel(String magazie) {
        Magazie result = null;
        Vector<Magazie> m = this.getMagazii();
        for (int i = 0; i < m.size(); ++i) {
            Magazie o = m.elementAt(i);
            if (!o.getLabel().equals(magazie)) continue;
            result = o;
            break;
        }
        return result;
    }

    public void deleteStockConsumLaData(Timestamp start) throws SQLException {
        this.getDao().deleteConsumLaData(start);
    }

    public void deleteStockConsumDupaData(Timestamp start) throws SQLException {
        this.getDao().deleteConsumDupaData(start);
    }

    public void deleteFiseMagazieLaData(Timestamp start) throws SQLException {
        this.getDao().deleteFiseMagazieLaData(start);
    }

    public void deleteProdusFinitByProductId(int idProduct) throws SQLException {
        this.getDao().deleteProdusFinitByProductId(idProduct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getCorectiiForMagazie(int idMagazie) {
        Vector<Object> result = new Vector();
        try {
            result = this.getDao().getCorectiiForMagazie(idMagazie, DateUtils.getStartOfDays(), DateUtils.getEndOfDays());
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public String getTipDocumentSqlInStatement(int toRemove) {
        String tipDocument = "";
        Vector<TipDocument> v = this.documentInterface.getAllTipDocument();
        for (int i = 0; i < v.size(); ++i) {
            TipDocument document = v.elementAt(i);
            if (document.getTip() == toRemove) continue;
            tipDocument = tipDocument + document.getTip() + ",";
        }
        if (tipDocument.endsWith(",")) {
            tipDocument = tipDocument.substring(0, tipDocument.length() - 1);
        }
        return tipDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getExportConsumPlatforma(Date start, Date stop) {
        Vector<ExportBCPlatforma> result = new Vector<ExportBCPlatforma>();
        Vector<Magazie> magazii = this.getMagazii();
        Connection conn = this.pool.requestConnection().getConnection();
        String tipDocument = this.getTipDocumentSqlInStatement(7);
        boolean gata = false;
        Date currentDay = start;
        try {
            int j = 0;
            while (!gata) {
                Date nextDay = DateUtils.advanceOneDay(currentDay);
                for (int i = 0; i < magazii.size(); ++i) {
                    Magazie magazie = magazii.elementAt(i);
                    double[][] totaluri = this.getDao().getMiscariIntreDateForExportConta(magazie.getId(), new Timestamp(currentDay.getTime()), new Timestamp(nextDay.getTime()), tipDocument, conn);
                    ExportBCPlatforma exp = new ExportBCPlatforma();
                    exp.setData(DateUtils.getEndOfDay(currentDay));
                    exp.setMagazie(magazie.getLabel());
                    double valAcz = totaluri[1][1];
                    double valVz = totaluri[1][2];
                    exp.setValAcz(valAcz);
                    if (valAcz > 0.0 && valVz > 0.0 || valAcz < 0.0 && valVz < 0.0) {
                        exp.setValAcz(totaluri[1][1]);
                    }
                    int nr = j * magazii.size() + i + 1;
                    exp.setNrBC(nr);
                    exp.setNrIntern(nr);
                    result.add(exp);
                }
                currentDay = nextDay;
                ++j;
                if (currentDay.getTime() < stop.getTime()) continue;
                gata = true;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public void comaseazaProduse(Vector idStocuri, int idStocTarget) {
        this.stockInterface.comaseazaProduse(idStocuri, idStocTarget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incarcaFapticDinXml(String xmlFile, final int idMagazie) {
        try {
            Utils.importXml(new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("stock")) {
                        int idStoc = Integer.parseInt(attributes.getValue("id"));
                        double q = Utils.parseDouble(attributes.getValue("stoc"));
                        StockLogic.this.replaceFapticForStockAndMagazie(idStoc, idMagazie, q);
                    }
                }
            }, xmlFile);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public Double getStocActualNoCommit(int idStock, int idMagazie) throws SQLException {
        return this.getDao().getStocActual(idStock, idMagazie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getStocActual(int idStock, int idMagazie) {
        try {
            Double d = this.getStocActualNoCommit(idStock, idMagazie);
            return d;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Double d = 0.0;
            return d;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<QuickSmallStocksBean> getAllStocksInMagazieNowNoCommit(int idMagazie) throws SQLException {
        return this.getDao().getAllStocksInMagazieNowNoCommit(idMagazie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<QuickSmallStocksBean> getAllStocksInMagazieNow(int idMagazie) {
        try {
            Vector<QuickSmallStocksBean> vector = this.getAllStocksInMagazieNowNoCommit(idMagazie);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<QuickSmallStocksBean> vector = new Vector<QuickSmallStocksBean>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void printAvizPeBazaTransfer(Vector items, String magazieIn, String magazieOut, String societate, Date dateConsum, int nrBon) {
        String cumparator = societate + " " + magazieIn;
        String j = this.config.getString("j");
        String cui = this.config.getString("cui");
        String sediu = this.config.getString("sediu");
        String judet = magazieIn;
        String iban = this.config.getString("iban");
        String banca = this.config.getString("banca");
        String numarIntern = nrBon + "";
        String data = Formatters.DATE_FORMAT_RO.format(dateConsum);
        String delegat = "";
        String numeEmitent = "";
        String cnpEmitent = "";
        String seria = "AVIZ";
        String seriaBuletin = "";
        String nrBuletin = "";
        String eliberatDe = "";
        String auto = "";
        String ora = "";
        double totalFaraTvaF = 0.0;
        Vector<FacturaItemView> items2 = new Vector<FacturaItemView>();
        for (int i = 0; i < items.size(); ++i) {
            ConsumTransferInterface e = (ConsumTransferInterface)items.elementAt(i);
            FacturaItemView item = new FacturaItemView();
            item.setCantitate(e.getCantitate());
            item.setProdus(e.getDenumire());
            if (Validators.correctString(e.getUm())) {
                item.setUm(e.getUm());
            } else {
                item.setUm("");
            }
            item.setPpuFaraTva(e.getPretAcz());
            item.setValoare(e.getValoareAchizitie());
            item.setValoareTva(0.0);
            items2.add(item);
            totalFaraTvaF += e.getValoareAchizitie();
        }
        PrintLogic.getInstance().tiparesteFacturaOdtNew("Aviz de insotire a marfii", cumparator, j, cui, sediu, judet, iban, banca, numarIntern, data, items2, Utils.getString2Decimals(totalFaraTvaF), "0", Utils.getString2Decimals(totalFaraTvaF), "", "", "", delegat, numeEmitent, cnpEmitent, seria, seriaBuletin, nrBuletin, eliberatDe, auto, ora, false, "template_aviz_openoffice.odt", "0", null, -1, null, "", "", "", "", "", new Hashtable());
    }

    public int getNextNrBonConsumNoCommit() throws SQLException {
        int result = this.getDao().getLastNrBonConsum() + 1;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextNrBonConsum() {
        try {
            int n = this.getNextNrBonConsumNoCommit();
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
            int n = 0;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void refreshStocks() {
        this.mustRebuildPowerStocks = true;
        this.buildStocks();
        this.getPowerSearchStocks();
        this.notifyListeners(26);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePriceForStock(int idStock, double pret) {
        try {
            StockLogic.getInstance().updatePriceForStockNoCommit(idStock, pret);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<TipArticol> getTipuriArticole() {
        try {
            Vector<TipArticol> vector = this.getDao().getAllTipArticol();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<TipArticol> vector = new Vector<TipArticol>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector getDetaliiProdusForTable(Product product) {
        Vector<Double> result = new Vector<Double>();
        if (product == null) {
            return new Vector();
        }
        Hashtable<String, Comparable<Integer>> criteria = new Hashtable<String, Comparable<Integer>>();
        int idStock = StockLogic.getInstance().getIdStockForProductId(product.getId());
        criteria.put("id_magazie", Integer.valueOf(-1));
        criteria.put("id_stock_key", Integer.valueOf(idStock));
        criteria.put(Constants.STOP_KEY, DateUtils.getEndOfDays());
        criteria.put(Constants.START_KEY, DateUtils.getStartOfDays());
        Vector fisaMagazie = StockLogic.getInstance().getFisaMagazie(criteria, -1);
        double futureConfirmat = 0.0;
        double futureNeconfirmat = 0.0;
        double comandatFurnizori = 0.0;
        double inMagazie = 0.0;
        double total = 0.0;
        for (FisaMagazieEntry fe : fisaMagazie) {
            switch (fe.getComandaType()) {
                case EFECTUAT: {
                    inMagazie += fe.getIntrata() - fe.getIesita();
                    total += fe.getIntrata() - fe.getIesita();
                    break;
                }
                case COMANDA_FERMA: {
                    futureConfirmat += fe.getIntrata() - fe.getIesita();
                    comandatFurnizori += fe.getIntrata();
                    total += fe.getIntrata() - fe.getIesita();
                    break;
                }
            }
        }
        result.add(futureConfirmat);
        result.add(futureNeconfirmat);
        result.add(comandatFurnizori);
        result.add(inMagazie);
        result.add(total);
        return result;
    }

    public InformatieMagazieProdus getDetaliiProdusForTableNew(int idProduct, Order o) {
        InformatieMagazieProdus result = new InformatieMagazieProdus();
        if (idProduct == -1) {
            return new InformatieMagazieProdus();
        }
        int idStock = StockLogic.getInstance().getIdStockForProductId(idProduct);
        result = this.getInfoMagazieForStock(idStock);
        Double rezervat = null;
        if (o != null) {
            Hashtable<Integer, Double> cantitateRezervata = this.getCantitateRezervataPeOrder(o);
            rezervat = cantitateRezervata.get(idProduct);
            if (rezervat == null) {
                rezervat = 0.0;
            }
        } else {
            rezervat = 0.0;
        }
        result.calculateDisponibilDeFacturat(rezervat);
        return result;
    }

    public Vector<FisaMagazieEntry> getFisaMagazieProdusForTable(Product product) {
        Vector result = new Vector();
        if (product == null) {
            return new Vector<FisaMagazieEntry>();
        }
        Hashtable<String, Comparable<Integer>> criteria = new Hashtable<String, Comparable<Integer>>();
        int idStock = StockLogic.getInstance().getIdStockForProductId(product.getId());
        criteria.put("id_magazie", Integer.valueOf(-1));
        criteria.put("id_stock_key", Integer.valueOf(idStock));
        criteria.put(Constants.STOP_KEY, DateUtils.getEndOfDays());
        criteria.put(Constants.START_KEY, DateUtils.getStartOfDays());
        result = StockLogic.getInstance().getFisaMagazie(criteria, -1);
        return result;
    }

    public Vector<FisaMagazieEntry> getFisaMagazieProdusForTableDesc(Product product) {
        Vector<FisaMagazieEntry> fisaMagazieForProduct = this.getFisaMagazieProdusForTable(product);
        Collections.sort(fisaMagazieForProduct, new Comparator<FisaMagazieEntry>(){

            @Override
            public int compare(FisaMagazieEntry o1, FisaMagazieEntry o2) {
                return o2.getData().compareToIgnoreCase(o1.getData());
            }
        });
        return fisaMagazieForProduct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFisaMagazieByProductIdAndDate(Vector<Integer> idProducts, Timestamp date) {
        try {
            for (Integer idProduct : idProducts) {
                int idStock = this.getDao().getIdStockByProductId(idProduct);
                this.getDao().deleteFisaMagazieForStockAndDate(idStock, date);
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    private void updateStockWithUnitAndEtaNoCommit(int id, int eta, String label, int idUnit, double warning, double critical, boolean descarcaStoc) throws SQLException {
        this.getDao().updateStockWithUnit(id, label, idUnit, warning, critical, descarcaStoc);
        this.getDao().updateStockWithEta(id, eta);
    }

    public void exportFisaWarningCriticExcel(File file, Vector data) {
        try {
            ExcelUtils.writeExcel(file, data, new ExcelProcessor(){
                String magazie = "";

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    StockViewEntry sve = (StockViewEntry)o;
                    this.magazie = sve.getMagazie();
                    Product product = StockLogic.getInstance().getProductForStock(sve.getIdStock());
                    Vector<String> barcodes = NomeclaturaLogic.getInstance().getAllBarCodesByIdProd(product.getId());
                    String codIntern = "";
                    String[] coduriFurnizor = new String[]{"", "", ""};
                    int i = 0;
                    for (String barcode : barcodes) {
                        if (barcode.startsWith("Int")) {
                            codIntern = barcode;
                            continue;
                        }
                        if (i >= 3) continue;
                        coduriFurnizor[i] = barcode;
                        ++i;
                    }
                    try {
                        Label label = new Label(0, row, codIntern);
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, "0");
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, "0");
                        sheet.addCell((WritableCell)label);
                        label = new Label(3, row, coduriFurnizor[0]);
                        sheet.addCell((WritableCell)label);
                        label = new Label(4, row, coduriFurnizor[1]);
                        sheet.addCell((WritableCell)label);
                        label = new Label(5, row, coduriFurnizor[2]);
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return new String[]{"Cod Intern", "Nivel alerta", "Nivel critic", "Cod Funrnizor 1", "Cod Funrnizor 2", "Cod Funrnizor 3"};
                }

                @Override
                public String getSheetName() {
                    return "Fisa nivel alerta/critic " + this.magazie;
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, new Hashtable());
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
    }

    public boolean importFisaWarningCriticForStocks(String excelFile) {
        try {
            ExcelUtils.readExcel(new File(excelFile), new ExcelImportInterface(){
                int line = 1;
                double warningLevel = 0.0;
                double criticalLevel = 0.0;
                String codInternProdus = "";
                UpdateWarCritLevelObj toAdd = new UpdateWarCritLevelObj();
                Vector<UpdateWarCritLevelObj> fisaCompleta = new Vector();

                @Override
                public void valueRead(int row, int column, String value) {
                    switch (column) {
                        case 0: {
                            this.codInternProdus = value;
                            break;
                        }
                        case 1: {
                            if (Validators.correctDouble(value)) {
                                this.warningLevel = Utils.parseDouble(value);
                                break;
                            }
                            Logger.logWarning(this, "Incorrect value at line : " + this.line);
                            break;
                        }
                        case 2: {
                            if (Validators.correctDouble(value)) {
                                this.criticalLevel = Utils.parseDouble(value);
                                break;
                            }
                            Logger.logWarning(this, "Incorrect value at line : " + this.line);
                            break;
                        }
                    }
                }

                @Override
                public void lineEnd() {
                    if (this.codInternProdus == "") {
                        Logger.logWarning(this, "Incorrect value at line : " + this.line);
                    } else {
                        this.toAdd.setCodIntern(this.codInternProdus);
                        this.toAdd.setWarningLevel(this.warningLevel);
                        this.toAdd.setCriticalLevel(this.criticalLevel);
                        this.fisaCompleta.add(this.toAdd);
                    }
                    this.codInternProdus = "";
                    ++this.line;
                }

                @Override
                public void lineStart() {
                    this.toAdd = new UpdateWarCritLevelObj();
                }

                @Override
                public void sheetStart(String sheetName) {
                }

                @Override
                public void sheetEnd(String sheetName) {
                    StockLogic.this.updateStocksWarningCriticLevelBatch(this.fisaCompleta);
                    this.fisaCompleta.clear();
                }
            });
            return true;
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
            return false;
        }
        catch (BiffException e) {
            Logger.logException(this, (Exception)((Object)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStocksWarningCriticLevelBatch(Vector<UpdateWarCritLevelObj> toUpdate) {
        int batchSize = 1000;
        try {
            int positionInBatch = 1;
            for (UpdateWarCritLevelObj todo : toUpdate) {
                StringBuffer codIntern = new StringBuffer(todo.getCodIntern());
                String substring = codIntern.substring(3, codIntern.length());
                Integer cod = -1;
                if (Validators.correctInteger(substring)) {
                    cod = Integer.valueOf(substring);
                }
                if (cod != -1) {
                    this.getDao().updateStockWithWarningAndCriticalLevel(cod, todo.getWarningLevel(), todo.getCriticalLevel());
                    ++positionInBatch;
                }
                if (batchSize > positionInBatch) continue;
                positionInBatch = 1;
                this.pool.commit();
            }
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Double getDisponibilMagazieForStock(int idStock, COMANDA_TYPE comandaType) throws SQLException {
        return this.getDao().getDisponibilMagazieForStock(idStock, comandaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<IesireProdusFacturiEmise> getIesiriProduseFacturiEmiseByCriteria(Hashtable criteria) {
        Date start = (Date)criteria.get(Constants.START_KEY);
        Date stop = (Date)criteria.get(Constants.STOP_KEY);
        int idComandaType = -1;
        if (criteria.get("Comanda Type") instanceof COMANDA_TYPE) {
            COMANDA_TYPE comandaType = (COMANDA_TYPE)((Object)criteria.get("Comanda Type"));
            idComandaType = comandaType.getIdTip();
        }
        int idProdus = (Integer)criteria.get("Product");
        int idClient = (Integer)criteria.get(Constants.CLIENT_KEY);
        try {
            Vector<IesireProdusFacturiEmise> vector = this.getDao().getIesiriProduseFacturiEmise(idProdus, idClient, new Timestamp(start.getTime()), new Timestamp(stop.getTime()), idComandaType);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<IesireProdusFacturiEmise> vector = null;
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public boolean addAndPrintTransfer(Component parent, Date date, Magazie sursa, Magazie dest, Vector<ConsumTransferInterface> items, double total, int tipPret, User user) {
        if (sursa.getId() == dest.getId()) {
            DialogUtils.errorDialog(parent, "Magaziile trebuie sa fie distincte", LangRoAll.nuPotContinua);
            return false;
        }
        int tipT = this.getTransferTip("Marfa");
        boolean pretAczFix = false;
        int nrDoc = RegistreLogic.getInstance().getNewNumberForRegistru(RestLogic.RegistreInterne.BON_CONSUM_TRANSFER_INTERN.key, RestLogic.RegistreInterne.BON_CONSUM_TRANSFER_INTERN.nume, true);
        int idDocument = this.addTransfer(sursa.getId(), dest.getId(), new Timestamp(date.getTime()), items, total, 0.0, tipT, pretAczFix, nrDoc, user);
        Vector<ConsumTransferInterface> correctItems = items;
        if (tipPret == 2 || tipPret == 3) {
            Document d = this.waitDocumentToBeProcessed(idDocument);
            int idBC = d.getIdTransfer();
            Vector<StockTransferItem> itemsBc = this.getTransferItems(idBC);
            correctItems = new Vector();
            correctItems.addAll(itemsBc);
        }
        this.printBonConsum(correctItems, dest.getLabel(), sursa.getLabel(), Config.getInstance().getString("societate"), date, nrDoc + "", tipPret);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document waitDocumentToBeProcessed(int idDocument) {
        Document d = null;
        try {
            for (long maxWait = 30000L; maxWait > 0L; maxWait -= 500L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                d = this.documentInterface.getDocumentById(idDocument);
                if (d == null) {
                } else if (d.getStatus() == 1) {
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return d;
    }

    public boolean addAndPrintConsum(Date date, Magazie sursa, Vector<ConsumTransferInterface> items, double total, int tipPret) {
        Document d;
        int nrBonConsum = RegistreLogic.getInstance().getNewNumberForRegistru(RestLogic.RegistreInterne.BON_CONSUM_TRANSFER_INTERN.key, RestLogic.RegistreInterne.BON_CONSUM_TRANSFER_INTERN.nume, true);
        int idDocument = this.adaugaBonConsum(sursa.getId(), new Timestamp(date.getTime()), items, "Bon consum", true, total, nrBonConsum, "For print");
        Vector<ConsumTransferInterface> correctItems = items;
        if ((tipPret == 2 || tipPret == 3) && (d = this.waitDocumentToBeProcessed(idDocument)) != null) {
            int idBC = d.getIdConsum();
            Vector itemsBc = this.getBonConsumItems(idBC);
            correctItems = new Vector();
            correctItems.addAll(itemsBc);
        }
        this.printBonConsum(correctItems, "CONSUM", sursa.getLabel(), Config.getInstance().getString("societate"), date, "" + nrBonConsum, tipPret);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdProductForStock(int idStock) {
        try {
            int n = this.getDao().getIdProductForStock(idStock);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            int n = -1;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Integer, Double> getCantitateRezervataPeOrder(Order o) {
        try {
            Hashtable<Integer, Double> hashtable = this.getDao().getCantitateIesiriProduseFacturiEmise(o);
            return hashtable;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InformatieMagazieProdus getInfoMagazieForStock(int idStock) {
        try {
            InformatieMagazieProdus informatieMagazieProdus = this.getDao().getInfoMagazieForProdus(idStock);
            return informatieMagazieProdus;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            InformatieMagazieProdus informatieMagazieProdus = null;
            return informatieMagazieProdus;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValutaForStock(int idStock, int idValuta) {
        try {
            this.getDao().setValutaForStock(idStock, idValuta);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Integer getIdValutaForStockNoCommit(int idStock) throws SQLException {
        return this.getDao().getIdValutaForStock(idStock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getIdValutaForStock(int idStock) {
        try {
            Integer n = this.getIdValutaForStockNoCommit(idStock);
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Integer n = null;
            return n;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getCantitateDeAprovizionare(StockViewEntry stock) {
        int idStock = stock.getIdStock();
        try {
            InformatieMagazieProdus info = this.getDao().getInfoMagazieForProdus(idStock);
            Double suma = info.getInMagazie() - (info.getComandat() + info.getComenziFerme());
            if (suma > 0.0) {
                if (stock.getCriticalLevel() > suma) {
                    Double d = stock.getAlertLevel() - suma;
                    return d;
                }
            } else {
                if (suma < 0.0) {
                    double comenziFermeDeOnorat = Math.abs(suma);
                    if (stock.getAlertLevel() > comenziFermeDeOnorat) {
                        Double d = stock.getAlertLevel();
                        return d;
                    }
                    Double d = comenziFermeDeOnorat;
                    return d;
                }
                Double comenziFermeDeOnorat = stock.getAlertLevel();
                return comenziFermeDeOnorat;
            }
            Double comenziFermeDeOnorat = 0.0;
            return comenziFermeDeOnorat;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Double d = 0.0;
            return d;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public void doCerereAprovizionare(Vector<CerereAprovizionareEntry> cereriAprovizionare, Client furnizor) {
        Vector<NirEntryFull> niruri = new Vector<NirEntryFull>();
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("Furnizor", furnizor);
        for (CerereAprovizionareEntry entry : cereriAprovizionare) {
            Stock stock = StockLogic.getInstance().getStockById(entry.getIdStock());
            Unit um = UnitsLogic.getInstance().getUnitById(stock.getIdUnit());
            Magazie m = this.getMagazieById(entry.getIdMagazie());
            NirEntryFull nir = new NirEntryFull();
            nir.setIngredientId(stock.getId());
            nir.setDenumireProdus(stock.getLabel());
            nir.setUm(um.getLabel());
            nir.setIdUnit(stock.getIdUnit());
            nir.setIdMagazie(entry.getIdMagazie());
            nir.setMagazie(m.getLabel());
            nir.setCant(entry.getCantitateCeruta());
            nir.setPpuc(entry.getPretNegociat());
            niruri.add(nir);
        }
        result.put("NoteView", niruri);
        GenericListenersLogic.getInstance().notifyObjectListeners(Constants.ADD_NOTE_KEY, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAprovizionare(Vector<StockViewEntry> stocuri, Client c) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("Furnizor", c);
        try {
            Vector<NirEntryFull> niruri = new Vector<NirEntryFull>();
            for (StockViewEntry stock : stocuri) {
                Double cantitateDeAprovizionare = 0.0;
                int idStock = stock.getIdStock();
                InformatieMagazieProdus info = this.getDao().getInfoMagazieForProdus(idStock);
                Double suma = info.getInMagazie() + (info.getComandat() - info.getComenziFerme());
                if (suma > 0.0) {
                    if (stock.getCriticalLevel() > suma) {
                        cantitateDeAprovizionare = stock.getAlertLevel() - suma;
                    }
                } else if (suma < 0.0) {
                    double comenziFermeDeOnorat = Math.abs(suma);
                    cantitateDeAprovizionare = stock.getAlertLevel() > comenziFermeDeOnorat ? Double.valueOf(stock.getAlertLevel()) : Double.valueOf(comenziFermeDeOnorat);
                } else {
                    cantitateDeAprovizionare = stock.getAlertLevel();
                }
                if (!(cantitateDeAprovizionare > 0.0)) continue;
                NirEntryFull nir = new NirEntryFull();
                nir.setIngredientId(stock.getIdStock());
                nir.setDenumireProdus(stock.getNume());
                nir.setUm(stock.getUmName());
                nir.setIdUnit(stock.getIdUnit());
                nir.setIdMagazie(stock.getIdMagazie());
                nir.setMagazie(stock.getMagazie());
                nir.setCant(cantitateDeAprovizionare);
                double price = this.getBackupBuyPriceNoCommit(stock.getIdStock());
                nir.setPpuc(price);
                niruri.add(nir);
            }
            result.put("NoteView", niruri);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
            GenericListenersLogic.getInstance().notifyObjectListeners(Constants.ADD_NOTE_KEY, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCerereAprovizionare(CerereAprovizionareEntry cae) {
        try {
            this.getDao().addCerereAprovizionare(cae);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCerereAprovizionare(CerereAprovizionareEntry cae) {
        try {
            this.getDao().updateCerereAprovizionare(cae);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<CerereAprovizionareEntry> getReportCerereAprovizionare(Hashtable criteria) {
        try {
            Vector<CerereAprovizionareEntry> vector = this.getDao().getReportCerereAprovizionare(criteria);
            return vector;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            Vector<CerereAprovizionareEntry> vector = new Vector<CerereAprovizionareEntry>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getDistinctStocksInTransfer() {
        try {
            Vector<String> vector = this.getDao().getDistinctStocksInTransfer();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<String> vector = new Vector<String>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<StockTransferWebBean> getAllStockTransfersInPeriod(String product, Timestamp start, Timestamp finish) {
        try {
            Vector<StockTransferWebBean> vector = this.getDao().getAllStockTransferInPeriod(product, start, finish);
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<StockTransferWebBean> vector = new Vector<StockTransferWebBean>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<NirEntryFull> calculeazaProductieCuInventarIntermitent(Date start, Date dataProductie, Hashtable<Integer, StockComparativEntry> stocFaptic, Vector<Tag> produseFiniteTags, Vector<Tag> materiiPrimeTags, Magazie magazie) {
        Vector<NirEntryFull> result = new Vector<NirEntryFull>();
        Vector<Integer> materiiPrimeIds = new Vector<Integer>();
        Vector<Integer> produseFiniteIds = new Vector<Integer>();
        for (Integer idStoc : stocFaptic.keySet()) {
            Vector<Tag> tagsForStoc = TagsLogic.getInstance().getAllStocksTags(idStoc);
            if (tagsForStoc.size() <= 0) continue;
            for (Tag tag : tagsForStoc) {
                if (produseFiniteTags.contains(tag)) {
                    produseFiniteIds.add(idStoc);
                }
                if (!materiiPrimeTags.contains(tag)) continue;
                materiiPrimeIds.add(idStoc);
            }
        }
        try {
            Hashtable<Integer, ProductieCuInventarBean> matPrimeBeans = new Hashtable<Integer, ProductieCuInventarBean>();
            for (Integer idStoc : materiiPrimeIds) {
                this.completeProductieBeanForIdStock(idStoc, matPrimeBeans, magazie, start, dataProductie, stocFaptic);
            }
            for (Integer idStock : matPrimeBeans.keySet()) {
                Stock s = this.getStockByIdNoCommit(idStock);
                if (s.getId() == 153) {
                    System.out.println("prins");
                }
                Unit u = UnitsLogic.getInstance().getUnitByIdNoCommit(s.getIdUnit());
                ProductieCuInventarBean bean = matPrimeBeans.get(idStock);
                double cantitateConsumataInProductie = bean.getIesireCant() + bean.getStocCant() - bean.getInitialCant() - bean.getIntrareCant();
                if (Utils.isValueZero(cantitateConsumataInProductie)) continue;
                double valConsumataInProductie = bean.getIesireCantAcz() + bean.getStocValAcz() - bean.getInitialValAcz() - bean.getIntrareValAcz();
                double ppuc = valConsumataInProductie / cantitateConsumataInProductie;
                double ppuv = this.getPriceForStock(idStock, new Timestamp(dataProductie.getTime()));
                double tvaNoiCota = TvaLogic.getInstance().getCotaTva();
                int idTva = TvaLogic.getInstance().getTvasNoCommit().get(1).getId();
                if (this.isProdusFinit(idStock)) {
                    Product product = this.getProductForStockNoCommit(idStock);
                    Categorie categorie1 = NomeclaturaLogic.getInstance().getCategoryByIdNoCommit(product.getIdCategorie());
                    idTva = categorie1.getIdTva();
                    Tva tva1 = TvaLogic.getInstance().getTvaByIdNoCommit(idTva);
                    tvaNoiCota = tva1.getCota();
                }
                double totalTvaFurnizor = valConsumataInProductie * tvaNoiCota;
                NirEntryFull toAdd = new NirEntryFull(-1, -1, idStock, s.getLabel(), u.getLabel(), cantitateConsumataInProductie, ppuc, -1.0, -1.0, ppuv, totalTvaFurnizor, u.getId(), tvaNoiCota, magazie.getId(), magazie.getLabel(), idTva);
                result.add(toAdd);
            }
            Hashtable<Integer, ProductieCuInventarBean> prodFiniteBeans = new Hashtable<Integer, ProductieCuInventarBean>();
            for (Integer idStock : produseFiniteIds) {
                this.completeProductieBeanForIdStock(idStock, prodFiniteBeans, magazie, start, dataProductie, stocFaptic);
            }
            for (Integer idStock : prodFiniteBeans.keySet()) {
                Stock s = this.getStockByIdNoCommit(idStock);
                if (s.getId() == 153) {
                    System.out.println("prins");
                }
                Unit u = UnitsLogic.getInstance().getUnitByIdNoCommit(s.getIdUnit());
                ProductieCuInventarBean bean = prodFiniteBeans.get(idStock);
                double cantProdusa = bean.getIesireCant() + bean.getStocCant() - bean.getIntrareCant() - bean.getInitialCant();
                if (Utils.isValueZero(cantProdusa)) continue;
                double valAcz = bean.getIesireCantAcz() + bean.getStocValAcz() - bean.getIntrareValAcz() - bean.getInitialValAcz();
                double tvaNoiCota = TvaLogic.getInstance().getCotaTva();
                double ppuc = valAcz / cantProdusa;
                int idTva = TvaLogic.getInstance().getTvasNoCommit().get(1).getId();
                double ppuv = this.getPriceForStock(idStock, new Timestamp(dataProductie.getTime()));
                if (this.isProdusFinit(idStock)) {
                    Product product = this.getProductForStockNoCommit(idStock);
                    Categorie categorie1 = NomeclaturaLogic.getInstance().getCategoryByIdNoCommit(product.getIdCategorie());
                    idTva = categorie1.getIdTva();
                    Tva tva1 = TvaLogic.getInstance().getTvaByIdNoCommit(idTva);
                    tvaNoiCota = tva1.getCota();
                }
                double totalTvaFurnizor = valAcz * tvaNoiCota;
                NirEntryFull toAdd = new NirEntryFull(-1, -1, idStock, s.getLabel(), u.getLabel(), cantProdusa, ppuc, -1.0, -1.0, ppuv, totalTvaFurnizor, u.getId(), tvaNoiCota, magazie.getId(), magazie.getLabel(), idTva);
                result.add(toAdd);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    private void completeProductieBeanForIdStock(int materiiPrimeId, Hashtable<Integer, ProductieCuInventarBean> matPrimeBeans, Magazie magazie, Date start, Date stop, Hashtable<Integer, StockComparativEntry> stocFaptic) throws SQLException {
        ProductieCuInventarBean bean = new ProductieCuInventarBean();
        StockBean sb = this.getStockInitialForStockId(materiiPrimeId, magazie.getId(), new Timestamp(start.getTime()), -1);
        if (sb == null) {
            sb = new StockBean();
            sb.setAchizitie(0.0);
            sb.setVanzare(0.0);
            sb.setCantitate(0.0);
        }
        bean.setInitialCant(sb.getCantitate());
        bean.setInitialValAcz(sb.getAchizitie());
        bean.setInitialValVz(sb.getVanzare());
        Timestamp stopt = new Timestamp(stop.getTime());
        double[][] miscari = this.getMiscariIntreDateNoCommit(materiiPrimeId, magazie.getId(), new Timestamp(start.getTime()), stopt);
        bean.setIntrareCant(miscari[0][0]);
        bean.setIntrareValAcz(miscari[0][1]);
        bean.setIntrareValVz(miscari[0][2]);
        bean.setIesireCant(miscari[1][0]);
        bean.setIesireCantAcz(miscari[1][1]);
        bean.setIesireCantVz(miscari[1][2]);
        Double stocCant = 0.0;
        StockComparativEntry stockComparativEntry = stocFaptic.get(materiiPrimeId);
        if (stockComparativEntry != null) {
            stocCant = stockComparativEntry.getFaptic();
        }
        bean.setStocCant(stocCant);
        double stocValAcz = this.computeValueBackwards(materiiPrimeId, stocCant, magazie.getId(), stopt);
        double stovValVz = this.getPretVzLaData(materiiPrimeId, stopt) * stocCant;
        bean.setStocValAcz(stocValAcz);
        bean.setStocValVz(stovValVz);
        matPrimeBeans.put(materiiPrimeId, bean);
    }

    public int addLotNoCommit(int idFurnizor, String nrLot, Date expirare, Date lotReceptie, int idStock) throws SQLException {
        int result = -1;
        if (LicenseManager.getInstance().isFunctionLicensed("ALLOW_LOT_CHOOSING_BY_USER")) {
            String barcodeLot = this.getNewBarcodeLotNoCommit();
            this.getDao().addLot(idFurnizor, nrLot, new Timestamp(expirare.getTime()), barcodeLot, new Timestamp(lotReceptie.getTime()), idStock);
            result = this.pool.getIdentityLocal();
        }
        return result;
    }

    public void updateLotNoCommit(Lot lot) throws SQLException {
        this.getDao().updateLot(lot);
    }

    public Lot getLotByIdNoCommit(int id) throws SQLException {
        return this.getDao().getLotById(id);
    }

    public Lot getLotByCodbareNoCommit(String codbare) throws SQLException {
        return this.getDao().getLotByCodbare(codbare);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lot getLotByIdCodbareCommit(String codbare) {
        try {
            Lot lot = this.getLotByCodbareNoCommit(codbare);
            return lot;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Lot lot = null;
            return lot;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lot getLotByIdCommit(int id) {
        try {
            Lot lot = this.getLotByIdNoCommit(id);
            return lot;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Lot lot = null;
            return lot;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public String getNewBarcodeLotNoCommit() throws SQLException {
        String barcodePrefixConfigName = "lotBarcodePrefix";
        String barcodeIndexConfigName = "lotBarcodeIndex";
        String result = RestLogic.getInstance().getNewBarcodeGenericNoCommit(barcodePrefixConfigName, barcodeIndexConfigName);
        return result;
    }

    public boolean deleteLotsForFactura(int idFactura) throws SQLException {
        Vector<Integer> idLots = this.getDao().getIdLotForFactura(idFactura);
        return this.deleteLotsByIds(idLots);
    }

    public boolean deleteLotsByIds(Vector<Integer> idLots) throws SQLException {
        boolean result = true;
        for (Integer idLot : idLots) {
            try {
                this.getDao().deleteLotById(idLot);
            }
            catch (SQLException e) {
                e.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<LoturiReportEntry> loturiReport(Hashtable criteria) {
        try {
            Vector<LoturiReportEntry> vector = this.getDao().loturiReport(criteria);
            return vector;
        }
        catch (Exception e) {
            Logger.logException(this, e);
            Vector<LoturiReportEntry> vector = new Vector<LoturiReportEntry>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public static EXPIRARE_STATUS getExpirareStatus(Date dataExpirare) {
        Date dataWarning = DateUtils.addDaysToDate(dataExpirare, -VpConfig.getInstance().lotExpirareZileWarning);
        Date dataCritical = DateUtils.addDaysToDate(dataExpirare, -VpConfig.getInstance().lotExpirareZileCritical);
        Date currentDate = new Date();
        if (currentDate.after(dataWarning)) {
            if (currentDate.after(dataCritical)) {
                return EXPIRARE_STATUS.CRITICAL;
            }
            return EXPIRARE_STATUS.WARNING;
        }
        return EXPIRARE_STATUS.NO_WARNINGS;
    }

    public static enum EXPIRARE_STATUS {
        NO_WARNINGS(Color.WHITE),
        WARNING(Color.YELLOW),
        CRITICAL(Color.RED);

        Color color;

        private EXPIRARE_STATUS(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }

    public static enum APROVIZIONARE_STATUS {
        NOUA(1),
        ALES_FURNIZOR(2),
        APROBATA(3),
        COMANDATA(4),
        RECEPTIONATA(5),
        RECEPTIONATA_PARTIAL(6),
        FACTURATA(7),
        ANULATA(99);

        private int cod;

        private APROVIZIONARE_STATUS(int cod) {
            this.cod = cod;
        }

        public int getCod() {
            return this.cod;
        }
    }

    public static enum COMANDA_TYPE {
        EFECTUAT(1),
        COMANDA_FERMA(2),
        TEMPORARA(3);

        private int idTip;

        private COMANDA_TYPE(int comanda) {
            this.idTip = comanda;
        }

        public int getIdTip() {
            return this.idTip;
        }
    }
}

