/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.db.StocksDao;
import ro.atreides.utils.db.DaoInterface;

public class PosImpl
implements DaoInterface {
    private PreparedStatement deleteSectiiMagazii;
    private PreparedStatement addMagazieSectie;
    private PreparedStatement selectMagaziiForSectie;
    private PreparedStatement getMagazieByProductId;
    private Connection connection;

    public PosImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.deleteSectiiMagazii = this.connection.prepareStatement("delete from magazii_sectii");
        this.addMagazieSectie = this.connection.prepareStatement("insert into magazii_sectii( id_magazie, id_category, id_locatie ) values ( ?, ?, ?) ");
        this.selectMagaziiForSectie = this.connection.prepareStatement("select magazii.* from magazii_sectii inner join magazii on (magazii_sectii.id_magazie = magazii.id and magazii.status = 1)  where id_category = ? and id_locatie = ?");
        this.getMagazieByProductId = this.connection.prepareStatement("select * from magazii inner join magazii_sectii on magazii.id = magazii_sectii.id_magazie inner join categories on magazii_sectii.id_category = categories.id inner join subcategories on categories.id = subcategories.id_category inner join products on subcategories.id = products.id_subcategory where products.id = ? and (id_locatie = ? or ? = -1)");
    }

    public void deleteAll() throws SQLException {
        this.deleteSectiiMagazii.execute();
    }

    public void addMagazieSectie(int idSectie, int idMagazie, int idLocatie) throws SQLException {
        this.addMagazieSectie.setInt(1, idMagazie);
        this.addMagazieSectie.setInt(2, idSectie);
        this.addMagazieSectie.setInt(3, idLocatie);
        this.addMagazieSectie.execute();
    }

    public Vector<Magazie> getMagaziiSectii(int idSectie, int idLocation) throws SQLException {
        this.selectMagaziiForSectie.setInt(1, idSectie);
        this.selectMagaziiForSectie.setInt(2, idLocation);
        ResultSet rs = this.selectMagaziiForSectie.executeQuery();
        Vector<Magazie> result = new Vector<Magazie>();
        while (rs.next()) {
            Magazie m = StocksDao.getMagazieFromRs(rs);
            result.add(m);
        }
        rs.close();
        return result;
    }

    public List<Integer> getIdMagazieByProductIdAndLocatieId(int idProduct, int idLocatie) throws SQLException {
        this.getMagazieByProductId.setInt(1, idProduct);
        this.getMagazieByProductId.setInt(2, idLocatie);
        this.getMagazieByProductId.setInt(3, idLocatie);
        ResultSet rs = this.getMagazieByProductId.executeQuery();
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (rs.next()) {
            result.add(rs.getInt("id"));
        }
        rs.close();
        return result;
    }
}

