/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.facturi.IesireProdusFacturiEmise;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.modules.transfer.StockTransferWebBean;
import ro.atreides.stocks.BonConsum;
import ro.atreides.stocks.BonConsumItem;
import ro.atreides.stocks.CerereAprovizionareEntry;
import ro.atreides.stocks.ConsumEntry;
import ro.atreides.stocks.Corectie;
import ro.atreides.stocks.FisaIntrareActiva;
import ro.atreides.stocks.FisaIntrareSimple;
import ro.atreides.stocks.FisaMagazieEntry;
import ro.atreides.stocks.Lot;
import ro.atreides.stocks.MIscariStockBean;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.ModificarePret;
import ro.atreides.stocks.QuickSmallStocksBean;
import ro.atreides.stocks.RaportGestiuneEntry;
import ro.atreides.stocks.RaportGestiuneValoricaEntry;
import ro.atreides.stocks.SaleDescarcareBean;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockBean;
import ro.atreides.stocks.StockCMP;
import ro.atreides.stocks.StockConsum;
import ro.atreides.stocks.StockEntry;
import ro.atreides.stocks.StockFapticView;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.StockTransfer;
import ro.atreides.stocks.StockTransferItem;
import ro.atreides.stocks.TipArticol;
import ro.atreides.stocks.gui.LoturiReportEntry;
import ro.atreides.stocks.gui.StockViewEntry;
import ro.atreides.users.User;
import ro.atreides.utils.Client;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.InformatieMagazieProdus;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.sql.SqlUtils;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.valute.Valuta;

public class StocksDao
implements DaoInterface {
    private PreparedStatement selectStockById;
    private PreparedStatement selectStockByName;
    private PreparedStatement selectStockByCodUnic;
    private PreparedStatement selectAllStocks;
    private PreparedStatement addStock;
    private PreparedStatement updateUniqueCodeForStock;
    private PreparedStatement getStockNameById;
    private PreparedStatement deleteStockById;
    private PreparedStatement updateStock;
    private PreparedStatement addMagazie;
    private PreparedStatement updateMagazie;
    private PreparedStatement addMagazieSectie;
    private PreparedStatement getMagazieById;
    private PreparedStatement getMagazieByName;
    private PreparedStatement renameMagazie;
    private PreparedStatement deleteMagazieSectii;
    private PreparedStatement selectAllMagazii;
    private PreparedStatement addProdusFinit;
    private PreparedStatement addTransfer;
    private PreparedStatement deleteAllTransferuri;
    private PreparedStatement getTransferById;
    private PreparedStatement updateStockWithEta;
    private PreparedStatement updateStockWithWarningAndCriticalLevel;
    private PreparedStatement setValutaForStock;
    private PreparedStatement addConsum;
    private PreparedStatement deleteConsumLaData;
    private PreparedStatement deleteConsumDupaData;
    private PreparedStatement deleteConsum;
    private PreparedStatement updateConsum;
    private PreparedStatement deleteAllConsum;
    private PreparedStatement getStockConsumByIdFisaIntrare;
    private PreparedStatement getIdStockByProductId;
    private PreparedStatement getProductByStockId;
    private PreparedStatement deleteAllStocks;
    private PreparedStatement deleteAllProduseFinite;
    private PreparedStatement deleteAllProductsForProduseFinite;
    private PreparedStatement deleteAllMagaziiSectii;
    private PreparedStatement getFisaMagazie;
    private PreparedStatement addFisaMagazieEntry;
    private PreparedStatement deleteFisaMagazieEntry;
    private PreparedStatement getLastFisaMagazieAchizitieForStock;
    private PreparedStatement deleteAllFiseMagazie;
    private PreparedStatement deleteFiseMagazieForStockAndMagazie;
    private PreparedStatement deleteFisaMagazieForStockAndDate;
    private PreparedStatement getDisponibilMagazieForStock;
    private PreparedStatement getIesiriProduseFacturiEmise;
    private PreparedStatement deleteProduct;
    private PreparedStatement deleteProductsForProduseFinite;
    private PreparedStatement deleteProdusFinitByProductId;
    private PreparedStatement getAllProductsForStock;
    private PreparedStatement getCatalogPriceForStock;
    private PreparedStatement getDisponibilInMagazie;
    private PreparedStatement getCantitateSiValoareInMagazie;
    private PreparedStatement getMiscariIntreDate;
    private PreparedStatement addFaptic;
    private PreparedStatement deleteFapticByNrCrt;
    private PreparedStatement selectFapticForMagazie;
    private PreparedStatement deleteAllFaptic;
    private PreparedStatement selectMaxCrtFromFaptic;
    private PreparedStatement selectSumFromFaptic;
    private PreparedStatement selectCountQuantitiesFromFaptic;
    private PreparedStatement deleteFapticForStockAndMagazie;
    private PreparedStatement selectProductsForProduseFinite;
    private PreparedStatement updatePriceForStock;
    private PreparedStatement addTransferItem;
    private PreparedStatement updateBuyPriceForTransferItem;
    private PreparedStatement updateValPaForTransfer;
    private PreparedStatement getTransfItemsForTransfer;
    private PreparedStatement getTransfItemById;
    private PreparedStatement getTransferuri;
    private PreparedStatement addBonConsum;
    private PreparedStatement addBonConsumItem;
    private PreparedStatement getBonuriConsum;
    private PreparedStatement getBonConsumById;
    private PreparedStatement getBonConsumItems;
    private PreparedStatement deleteBonConsumItem;
    private PreparedStatement deleteBonConsum;
    private PreparedStatement updateBonConsum;
    private PreparedStatement updateBuyValueForConsumItem;
    private PreparedStatement resetBuyValueForConsumItem;
    private PreparedStatement updateValPaForBonConsum;
    private PreparedStatement getLastNrBonConsum;
    private PreparedStatement addCorectie;
    private PreparedStatement addCorectieItem;
    private PreparedStatement getCorectieById;
    private PreparedStatement getCorectieItemsByIdCorectie;
    private PreparedStatement getCorectiiForMagazie;
    private PreparedStatement deleteCorectieById;
    private PreparedStatement deleteCorectiiItemsByIdCorectie;
    private PreparedStatement updateCorectie;
    private PreparedStatement getFiseIntrareActive;
    private PreparedStatement deleteTransferItem;
    private PreparedStatement deleteTransfer;
    private PreparedStatement updateTransfer;
    private PreparedStatement getFiseIntrareSortateInversPanaLaData;
    private PreparedStatement getFiseIntrareSortateInversDupaData;
    private PreparedStatement deleteFiseMagazieLaData;
    private PreparedStatement deleteBonConsumItemsIntreDate;
    private PreparedStatement deleteBonConsumIntreDate;
    private PreparedStatement deleteTransferItemsIntreDate;
    private PreparedStatement deleteTransferIntreDate;
    private PreparedStatement getFisaMagazieById;
    private PreparedStatement getFisaMagazieByTimeDocument;
    private PreparedStatement updateCantitateFisaMagazie;
    private PreparedStatement getTimestampForFisa;
    private PreparedStatement getCantitateIntrataForFisa;
    private PreparedStatement addAlterarePret;
    private PreparedStatement getAlterarePretById;
    private PreparedStatement syncProdusFinit;
    private PreparedStatement addStockCMP;
    private PreparedStatement getLatestStockCMP;
    private PreparedStatement deleteAllStockCMPAfterData;
    private PreparedStatement isCMPAddedForStockAndTimestamp;
    private PreparedStatement updateStockCMP;
    private PreparedStatement getPretVanzareLaData;
    private PreparedStatement addModifPret;
    private PreparedStatement getModifPretById;
    private PreparedStatement getModifPretByDate;
    private PreparedStatement getNextPretVzDupaData;
    private PreparedStatement getValIesireFromFisaByIdSale;
    private PreparedStatement updateModifPret;
    private PreparedStatement deleteModifPret;
    private PreparedStatement getAllModifPretByStockId;
    private PreparedStatement getIdClientiFromFisaMagazie;
    private PreparedStatement getTipuriArticol;
    private PreparedStatement setTipArticolForStock;
    private PreparedStatement getTipArticolById;
    private PreparedStatement selectInMagazie;
    private PreparedStatement selectComenziFerme;
    private PreparedStatement selectComandat;
    private PreparedStatement addCerereAprovizionare;
    private PreparedStatement updateCerereAprovizionare;
    private PreparedStatement getDistinctStocksInTransfer;
    private PreparedStatement getAllStockTransferInPeriod;
    private PreparedStatement addLot;
    private PreparedStatement getLotByCodBare;
    private PreparedStatement getLotById;
    private PreparedStatement updateLot;
    private PreparedStatement deleteLotById;
    private PreparedStatement getLotsForFactura;
    private Connection connection;

    private void buildLotStatements() throws SQLException {
        this.addLot = this.connection.prepareStatement("insert into loturi(lot_codbare,lot_nr,lot_expirare,id_furnizor,lot_receptie,id_stock) values ( ?, ?, ?, ?, ?, ?)");
        this.getLotById = this.connection.prepareStatement("select * from loturi where id = ?");
        this.getLotByCodBare = this.connection.prepareStatement("select * from loturi where lot_codbare = ?");
        this.updateLot = this.connection.prepareStatement("update loturi set lot_nr = ?, lot_expirare = ?, id_furnizor = ?, lot_receptie = ?, id_stock = ? where id = ?");
        this.deleteLotById = this.connection.prepareStatement("delete from loturi where id = ?");
        this.getLotsForFactura = this.connection.prepareStatement("select id_lot from factura_entries where id_factura = ?");
    }

    public Vector<LoturiReportEntry> loturiReport(Hashtable criteria) throws SQLException {
        Date start = (Date)criteria.get(Constants.START_KEY);
        Date stop = (Date)criteria.get(Constants.STOP_KEY);
        Integer idFurnizor = (Integer)criteria.get("Furnizor");
        Integer idStock = (Integer)criteria.get("id_stock_key");
        Integer idMagazie = (Integer)criteria.get("id_magazie");
        String grupare = (String)criteria.get(Constants.GRUPARE_KEY);
        boolean grupareDupaMagazieAndLotFurnizor = grupare.equalsIgnoreCase("Dupa lot furnizor si magazie");
        boolean grupareDupaLotIntern = grupare.equalsIgnoreCase("Dupa lot intern");
        if (grupareDupaLotIntern) {
            grupareDupaMagazieAndLotFurnizor = true;
        }
        String sql = "select lot_expirare, lot_nr, " + (grupareDupaLotIntern ? "lot_codbare, loturi.id as id_lot_, " : "") + "stocks.label as nume_stock, stocks.id as id_stock_," + (grupareDupaLotIntern ? " facturi.dateadd, facturi.serie_Factura, niruri.nr_nir, facturi.id_furnizor, coalesce(persoane_juridice.nume, '') as nume_pj, coalesce(persoane_fizice.nume, '') as nume_pf," : "") + " sum(coalesce(fisa_magazie.intrata,0) - coalesce(fisa_magazie.iesita,0)) as existent, " + " sum(factura_entries.cantitate_2) as cantitate_totala" + (grupareDupaMagazieAndLotFurnizor ? " ,magazii.label as nume_magazie, magazii.id as magazie_id " : "") + " from loturi" + " inner join factura_entries on loturi.id = factura_entries.id_lot" + " inner join facturi on factura_entries.id_Factura = facturi.id" + " inner join niruri on facturi.id = niruri.id_Factura" + " inner join clienti on facturi.id_furnizor = clienti.id" + " left outer join persoane_fizice on clienti.idpersfizica = persoane_fizice.id" + " left outer join persoane_juridice on clienti.idpersjuridica = persoane_juridice.id" + " inner join stocks on loturi.id_stock = stocks.id" + " left outer join fisa_magazie on loturi.id = fisa_magazie.id_lot " + " left outer join magazii on fisa_magazie.id_magazie = magazii.id" + " where 1 = 1 ";
        sql = sql + " and facturi.dateadd <= '" + new Timestamp(stop.getTime()) + "' and facturi.dateadd >= '" + new Timestamp(start.getTime()) + "'";
        sql = sql + (idFurnizor != null && idFurnizor > 0 ? " and clienti.id = " + idFurnizor : "");
        sql = sql + (idMagazie != null && idMagazie > 0 ? " and fisa_magazie.id_magazie = " + idMagazie : "");
        sql = sql + (idStock != null && idStock > 0 ? " and loturi.id_stock = " + idStock : "");
        sql = sql + " group by " + (grupareDupaMagazieAndLotFurnizor ? " magazii.label, magazie_id, " : "") + (grupareDupaLotIntern ? " loturi.id, lot_codbare, facturi.serie_factura, nr_nir, facturi.dateadd, facturi.id_furnizor, nume_pj, nume_pf, " : "") + "lot_expirare, lot_nr, stocks.label, stocks.id ";
        Vector<LoturiReportEntry> result = new Vector<LoturiReportEntry>();
        ResultSet rs = SqlUtils.executeQuery(sql, this.connection);
        while (rs.next()) {
            LoturiReportEntry toadd = new LoturiReportEntry();
            if (grupareDupaLotIntern) {
                toadd.setCodbareLot(rs.getString("lot_codbare"));
                toadd.setIdLot(rs.getInt("id_lot_"));
            }
            Timestamp lot_expirare = rs.getTimestamp("lot_expirare");
            toadd.setDataExpirare(lot_expirare);
            toadd.setNrLotFurnizor(rs.getString("lot_nr"));
            toadd.setIdStock(rs.getInt("id_stock_"));
            toadd.setDenumireProdus(rs.getString("nume_stock"));
            if (grupareDupaLotIntern) {
                toadd.setDataReceptie(rs.getTimestamp("dateadd"));
                toadd.setDetaliiReceptie(rs.getString("serie_factura") + " / " + rs.getString("nr_nir"));
            }
            if (grupareDupaLotIntern) {
                toadd.setIdFurnizor(rs.getInt("id_furnizor"));
                toadd.setNumeFurnizor(rs.getString("nume_pj") + rs.getString("nume_pf"));
            }
            if (grupareDupaMagazieAndLotFurnizor) {
                toadd.setIdMagazie(rs.getInt("magazie_id"));
                toadd.setMagazie(rs.getString("nume_magazie"));
            } else {
                toadd.setMagazie("-");
            }
            toadd.setStocExistent(rs.getDouble("existent"));
            toadd.setCantitateTotala(rs.getDouble("cantitate_totala"));
            StockLogic.getInstance();
            toadd.setExpirare_status(StockLogic.getExpirareStatus(lot_expirare));
            result.add(toadd);
        }
        rs.close();
        return result;
    }

    public void deleteLotById(int idLot) throws SQLException {
        this.deleteLotById.setInt(1, idLot);
        this.deleteLotById.execute();
    }

    public Vector<Integer> getIdLotForFactura(int idFacturaEntry) throws SQLException {
        this.getLotsForFactura.setInt(1, idFacturaEntry);
        Vector<Integer> result = new Vector<Integer>();
        ResultSet rs = this.getLotsForFactura.executeQuery();
        while (rs.next()) {
            result.add(rs.getInt(1));
        }
        rs.close();
        return result;
    }

    public Lot getLotById(int id) throws SQLException {
        Lot result = null;
        this.getLotById.setInt(1, id);
        ResultSet rs = this.getLotById.executeQuery();
        if (rs.next()) {
            result = this.getLotFromRs(rs);
        }
        rs.close();
        return result;
    }

    public Lot getLotByCodbare(String codBare) throws SQLException {
        Lot result = null;
        this.getLotByCodBare.setString(1, codBare);
        ResultSet rs = this.getLotByCodBare.executeQuery();
        if (rs.next()) {
            result = this.getLotFromRs(rs);
        }
        rs.close();
        return result;
    }

    private Lot getLotFromRs(ResultSet rs) throws SQLException {
        Lot result = new Lot();
        result.setId(rs.getInt("id"));
        result.setIdStock(rs.getInt("id_stock"));
        result.setIdFurnizor(rs.getInt("id_furnizor"));
        result.setExpirare(rs.getTimestamp("lot_expirare"));
        result.setReceptie(rs.getTimestamp("lot_receptie"));
        result.setCodbare(rs.getString("lot_codbare"));
        result.setNr(rs.getString("lot_nr"));
        return result;
    }

    public void addLot(int idFurnizor, String nrLot, Timestamp expirare, String lotCodbare, Timestamp lotReceptie, int idStock) throws SQLException {
        this.addLot.setString(1, lotCodbare);
        this.addLot.setString(2, nrLot);
        this.addLot.setTimestamp(3, expirare);
        this.addLot.setInt(4, idFurnizor);
        this.addLot.setTimestamp(5, lotReceptie);
        this.addLot.setInt(6, idStock);
        this.addLot.execute();
    }

    public void updateLot(Lot lot) throws SQLException {
        this.updateLot.setString(1, lot.getNr());
        this.updateLot.setTimestamp(2, new Timestamp(lot.getExpirare().getTime()));
        this.updateLot.setInt(3, lot.getIdFurnizor());
        this.updateLot.setTimestamp(4, new Timestamp(lot.getReceptie().getTime()));
        this.updateLot.setInt(5, lot.getIdStock());
        this.updateLot.setInt(6, lot.getId());
        this.updateLot.execute();
    }

    private void buildConsumStatements() throws SQLException {
        this.getTipArticolById = this.connection.prepareStatement("select * from tip_articol where id = ?");
        this.setTipArticolForStock = this.connection.prepareStatement("update stocks set id_tip_articol = ? where id = ?");
        this.getTipuriArticol = this.connection.prepareStatement("select * from tip_articol");
        this.getLastNrBonConsum = this.connection.prepareStatement("select max(nr_bon_consum) from bonuri_consum");
        this.updateValPaForBonConsum = this.connection.prepareStatement("update bonuri_consum set total = ? where id = ?");
        this.updateBuyValueForConsumItem = this.connection.prepareStatement("update bonuri_consum_items set val_pa = val_pa + ? where id = ?");
        this.resetBuyValueForConsumItem = this.connection.prepareStatement("update bonuri_consum_items set val_pa = 0 where id = ? ");
        this.getFiseIntrareSortateInversPanaLaData = this.connection.prepareStatement("select intrata, buy_price, id, time_document from fisa_magazie where id_stock = ? and id_magazie = ? and intrata > 0 and time_document <= ? order by time_document desc");
        this.getFiseIntrareSortateInversDupaData = this.connection.prepareStatement("select intrata, buy_price, id, time_document from fisa_magazie where id_stock = ? and type_document = 2 and id_magazie = ? and intrata > 0 and time_document >= ? order by time_document desc");
        this.getBonConsumItems = this.connection.prepareStatement("select bonuri_consum_items.*, stocks.label as produs, messages.label as um  from bonuri_consum_items inner join stocks on bonuri_consum_items.id_stock = stocks.id inner join units on stocks.id_unit = units.id inner join keys on units.id_key = keys.id inner join messages on keys.id = messages.id_key where id_bon = ?");
        this.getBonConsumById = this.connection.prepareStatement("select bonuri_consum.*, magazii.label as magazie from bonuri_consum inner join magazii on bonuri_consum.id_magazie = magazii.id where bonuri_consum.id = ?");
        this.getBonuriConsum = this.connection.prepareStatement("select bonuri_consum.*, magazii.label as magazie from bonuri_consum inner join magazii on bonuri_consum.id_magazie = magazii.id where (id_magazie = ? or ? = -1) and (dateadd >= ? and dateadd < ?) order by dateadd");
        this.addBonConsum = this.connection.prepareStatement("insert into bonuri_consum ( id_magazie, dateadd, descarcata, total, nr_bon_consum, observatii ) values ( ?, ?, 1, ?, ?, ? )");
        this.addBonConsumItem = this.connection.prepareStatement("insert into bonuri_consum_items ( id_bon, id_stock, quantity, id_lot ) values (?,?,?,?)");
        this.deleteBonConsumItem = this.connection.prepareStatement("delete from bonuri_consum_items where id = ?");
        this.deleteBonConsum = this.connection.prepareStatement("delete from bonuri_consum where id = ?");
        this.updateBonConsum = this.connection.prepareStatement("update bonuri_consum set  id_magazie = ?, dateadd = ?, total = ?, nr_bon_consum = ?, observatii = ? where id = ?");
        this.addConsum = this.connection.prepareStatement("insert into stock_consum ( id_fisa_sursa, quantity, time_consum) values ( ?, ?, ?) ");
        this.deleteConsum = this.connection.prepareStatement("delete from stock_consum where id = ?");
        this.deleteAllConsum = this.connection.prepareStatement("delete from stock_consum");
        this.deleteConsumLaData = this.connection.prepareStatement("delete from stock_consum where time_consum = ?");
        this.deleteConsumDupaData = this.connection.prepareStatement("delete from stock_consum where time_consum > ?");
        this.updateConsum = this.connection.prepareStatement("update stock_consum set quantity = ? where id = ? ");
        this.getStockConsumByIdFisaIntrare = this.connection.prepareStatement("select * from stock_consum where id_fisa_sursa = ? order by time_consum desc");
    }

    public void setTipArticolForStock(int idTipArticol, int idStock) throws SQLException {
        this.setTipArticolForStock.setInt(1, idTipArticol);
        this.setTipArticolForStock.setInt(2, idStock);
        this.setTipArticolForStock.execute();
    }

    public Vector<TipArticol> getAllTipArticol() throws SQLException {
        Vector<TipArticol> result = new Vector<TipArticol>();
        ResultSet rs = this.getTipuriArticol.executeQuery();
        while (rs.next()) {
            TipArticol toAdd = this.getTipArticolFromRs(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    private TipArticol getTipArticolFromRs(ResultSet rs) throws SQLException {
        TipArticol toAdd = new TipArticol();
        toAdd.setCod(rs.getString("cod"));
        toAdd.setCont(rs.getString("cont"));
        toAdd.setNume(rs.getString("nume"));
        toAdd.setId(rs.getInt("id"));
        return toAdd;
    }

    public TipArticol getTipArticolById(int id) throws SQLException {
        this.getTipArticolById.setInt(1, id);
        TipArticol result = null;
        ResultSet rs = this.getTipArticolById.executeQuery();
        if (rs.next()) {
            result = this.getTipArticolFromRs(rs);
        }
        rs.close();
        return result;
    }

    public void addStockCMP(int idStock, Timestamp timestamp, double valoare, double cantitate) throws SQLException {
        this.addStockCMP.setInt(1, idStock);
        this.addStockCMP.setTimestamp(2, timestamp);
        this.addStockCMP.setDouble(3, valoare);
        this.addStockCMP.setDouble(4, cantitate);
        this.addStockCMP.execute();
    }

    private StockCMP getStockCMPFromResultSet(ResultSet rs) throws SQLException {
        StockCMP result = new StockCMP();
        result.setCantitate(rs.getDouble("cantitate"));
        result.setValoare(rs.getDouble("valoare"));
        result.setIdStock(rs.getInt("id_stock"));
        result.setId(rs.getInt("id"));
        return result;
    }

    public Vector<StockCMP> getLatestStockCMPAtTimestamp(int idStock, Timestamp timestamp) throws SQLException {
        Vector<StockCMP> result = new Vector<StockCMP>();
        this.getLatestStockCMP.setInt(1, idStock);
        this.getLatestStockCMP.setTimestamp(2, timestamp);
        ResultSet rs = this.getLatestStockCMP.executeQuery();
        while (rs.next()) {
            StockCMP toadd = this.getStockCMPFromResultSet(rs);
            result.add(toadd);
        }
        rs.close();
        return result;
    }

    public StockCMP getCMPForStockAndExactTimestamp(int idStock, Timestamp data) throws SQLException {
        StockCMP result = null;
        this.isCMPAddedForStockAndTimestamp.setInt(1, idStock);
        this.isCMPAddedForStockAndTimestamp.setTimestamp(2, data);
        ResultSet rs = this.isCMPAddedForStockAndTimestamp.executeQuery();
        if (rs.next()) {
            result = this.getStockCMPFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public void deleteAllCMPForStockAfterData(int idStock, Timestamp data) throws SQLException {
        this.deleteAllStockCMPAfterData.setInt(1, idStock);
        this.deleteAllStockCMPAfterData.setTimestamp(2, data);
        this.deleteAllStockCMPAfterData.execute();
    }

    public void updateStockCmp(StockCMP toUpdate) throws SQLException {
        this.updateStockCMP.setDouble(1, toUpdate.getCantitate());
        this.updateStockCMP.setDouble(2, toUpdate.getValoare());
        this.updateStockCMP.setInt(3, toUpdate.getIdStock());
        this.updateStock.executeUpdate();
    }

    public ModificarePret getModificarePretById(int id) throws SQLException {
        ModificarePret result = null;
        this.getModifPretById.setInt(1, id);
        ResultSet rs = this.getModifPretById.executeQuery();
        if (rs.next()) {
            result = this.getModificarePretFromRS(rs, false);
        }
        rs.close();
        return result;
    }

    public ModificarePret getModificarePretByDate(Timestamp date) throws SQLException {
        ModificarePret result = null;
        this.getModifPretByDate.setTimestamp(1, date);
        ResultSet rs = this.getModifPretByDate.executeQuery();
        if (rs.next()) {
            result = this.getModificarePretFromRS(rs, false);
        }
        rs.close();
        return result;
    }

    public ModificarePret getModificarePretFromRS(ResultSet rs, boolean wantLabel) throws SQLException {
        ModificarePret result = new ModificarePret();
        result.setIdModificarePret(rs.getInt("id"));
        result.setData(rs.getTimestamp("dateadd"));
        result.setIdStock(rs.getInt("id_stock"));
        result.setPretNou(rs.getDouble("pret_vz"));
        result.setPretVechi(rs.getDouble("old_price"));
        if (wantLabel) {
            result.setNumeProdus(rs.getString("label"));
        }
        return result;
    }

    public Vector<ModificarePret> getAllModificarePretByStockId(Hashtable criteria) throws SQLException {
        Integer id_stock = (Integer)criteria.get("id_stock_key");
        Date dateStart = (Date)criteria.get(Constants.START_KEY);
        Date dateStop = (Date)criteria.get(Constants.STOP_KEY);
        this.getAllModifPretByStockId.setInt(1, id_stock);
        this.getAllModifPretByStockId.setInt(2, id_stock);
        this.getAllModifPretByStockId.setTimestamp(3, new Timestamp(dateStart.getTime()));
        this.getAllModifPretByStockId.setTimestamp(4, new Timestamp(dateStop.getTime()));
        ResultSet rs = this.getAllModifPretByStockId.executeQuery();
        Vector<ModificarePret> result = new Vector<ModificarePret>();
        while (rs.next()) {
            ModificarePret modificarePretFromRS = this.getModificarePretFromRS(rs, true);
            result.add(modificarePretFromRS);
        }
        rs.close();
        return result;
    }

    public void addModificarePret(int idStock, Timestamp data, double pret) throws SQLException {
        this.addModifPret.setInt(1, idStock);
        this.addModifPret.setDouble(2, pret);
        this.addModifPret.setTimestamp(3, data);
        this.addModifPret.execute();
    }

    public double[] getPretVzLaData(Timestamp data, int idStock) throws SQLException {
        double[] result = new double[]{-1.0, -1.0};
        this.getPretVanzareLaData.setInt(1, idStock);
        this.getPretVanzareLaData.setTimestamp(2, data);
        ResultSet rs = this.getPretVanzareLaData.executeQuery();
        if (rs.next()) {
            result[0] = rs.getDouble(1);
            result[1] = rs.getDouble(2);
        }
        rs.close();
        return result;
    }

    public double[] getNextPretVzDupaData(Timestamp data, int idStock) throws SQLException {
        double[] result = new double[]{-1.0, -1.0};
        this.getNextPretVzDupaData.setInt(1, idStock);
        this.getNextPretVzDupaData.setTimestamp(2, data);
        ResultSet rs = this.getNextPretVzDupaData.executeQuery();
        if (rs.next()) {
            result[0] = rs.getDouble(1);
            result[1] = rs.getDouble(2);
        }
        rs.close();
        return result;
    }

    public void updateModificarePret(ModificarePret obj) throws SQLException {
        this.updateModifPret.setDouble(1, obj.getPretNou());
        this.updateModifPret.setTimestamp(2, obj.getData());
        this.updateModifPret.setInt(3, obj.getIdModificarePret());
        this.updateModifPret.execute();
    }

    public void deleteModificarePret(ModificarePret obj) throws SQLException {
        this.deleteModifPret.setInt(1, obj.getIdModificarePret());
        this.deleteModifPret.execute();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.getDistinctStocksInTransfer = this.connection.prepareStatement("select distinct(stocks.id), upper(stocks.label) as produs from transfer_items inner join stocks on stocks.id = transfer_items.id_stock order by upper(stocks.label)");
        this.getAllStockTransferInPeriod = this.connection.prepareStatement("select transfer_items.id_stock, stocks.label, transfer_items.img_src, stock_transfer.time_transfer, transfer_items.quantity as cantitate, (select label from magazii where id = stock_transfer.id_sursa) as sursa, (select label from magazii where id = stock_transfer.id_dest) as destinatie, users.login as user from stock_transfer inner join transfer_items on transfer_items.id_transfer = stock_transfer.id inner join stocks on stocks.id = transfer_items.id_stock left outer join users on users.id = stock_transfer.id_user where stock_transfer.time_transfer >= ? and stock_transfer.time_transfer < ? and (upper(stocks.label) like ? or ? = 'All') order by stock_transfer.time_transfer desc ");
        this.addCerereAprovizionare = this.connection.prepareStatement("insert into cereri_aprovizionare ( id_stock, id_operator, id_supervizor, id_magazie, id_furnizor, status, cantitate_ceruta, pret_negociat, nr_zile_comanda, cantitate_recomandata_minim, cantitate_recomandata_maxim, cantitate_iesita_referinta, cantitate_intrata_medie_per_comanda_referinta,  cantitate_existenta_magazie, cantitate_existenta_total, cantitate_deja_comandata, referinta_start, referinta_stop, data_cerere ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP)");
        this.updateCerereAprovizionare = this.connection.prepareStatement("update cereri_aprovizionare set id_stock = ?, id_operator= ?, id_supervizor= ?, id_magazie= ?, id_furnizor= ?, status= ?, cantitate_ceruta = ?,pret_negociat = ?,nr_zile_comanda = ?,cantitate_recomandata_minim = ?,cantitate_recomandata_maxim= ?, cantitate_iesita_referinta = ?,cantitate_intrata_medie_per_comanda_referinta = ?, cantitate_existenta_magazie = ?,cantitate_existenta_total = ?,cantitate_deja_comandata= ?, referinta_start = ?,referinta_stop = ? where id = ?");
        this.getPretVanzareLaData = this.connection.prepareStatement("select pret_vz, old_price from modificari_pret where id_stock = ? and dateadd < ? order by dateadd desc");
        this.getNextPretVzDupaData = this.connection.prepareStatement("select pret_vz, old_price from modificari_pret where id_stock = ? and dateadd > ? order by dateadd");
        this.addModifPret = this.connection.prepareStatement("insert into modificari_pret (id_stock,pret_vz,dateadd) values (?,?,?)");
        this.getModifPretById = this.connection.prepareStatement("select * from modificari_pret where id = ?");
        this.getModifPretByDate = this.connection.prepareStatement("select * from modificari_pret where dateadd = ?");
        this.updateModifPret = this.connection.prepareStatement("update modificari_pret set pret_vz = ?, dateadd = ? where id = ?");
        this.deleteModifPret = this.connection.prepareStatement("delete from modificari_pret where id = ?");
        this.getAllModifPretByStockId = this.connection.prepareStatement("select modificari_pret.*, stocks.label from modificari_pret inner join stocks on stocks.id = modificari_pret.id_stock where (id_stock = ? or ? = -1) and dateadd >= ? and dateadd < ? order by label, dateadd");
        this.addStockCMP = this.connection.prepareStatement("insert into stock_cmp(id_stock, time_document, valoare, cantitate) values ( ?, ?, ?, ?)");
        this.getLatestStockCMP = this.connection.prepareStatement("select * from stock_cmp where id_stock = ? and time_document < ? order by time_document desc");
        this.isCMPAddedForStockAndTimestamp = this.connection.prepareStatement("select * from stock_cmp where id_stock = ? and time_document = ?");
        this.deleteAllStockCMPAfterData = this.connection.prepareStatement("delete from stock_cmp where id_stock = ? and time_document >= ? ");
        this.updateStockCMP = this.connection.prepareStatement("update stock_cmp set cantitate = ?, valoare = ? where id = ?");
        this.getMagazieByName = this.connection.prepareStatement("select *  from magazii where label = ?");
        this.getAlterarePretById = this.connection.prepareStatement("select * from alterare_pret where id = ?");
        this.addAlterarePret = this.connection.prepareStatement("insert into alterare_pret (id_magazie, id_stock, dateadd, quantity, newSellPrice, oldSellPrice) values (?, ?, ?, ?, ?, ?)");
        this.getTimestampForFisa = this.connection.prepareStatement("select time_document from fisa_magazie where id = ?");
        this.getFisaMagazieById = this.connection.prepareStatement("select * from fisa_magazie where id = ?");
        this.getFisaMagazieByTimeDocument = this.connection.prepareStatement("select fisa_magazie.*, stocks.label as produs from fisa_magazie inner join stocks on fisa_magazie.id_stock = stocks.id where time_document = ?");
        this.getCantitateIntrataForFisa = this.connection.prepareStatement("select intrata from fisa_magazie where id = ?");
        this.getCantitateSiValoareInMagazie = this.connection.prepareStatement("select sum(intrata - iesita) as stock, sum(val_intrata_pa - val_iesita_pa) as valoare, sum(val_intrata_pv - val_iesita_pv) as valoare_vz from fisa_magazie where id_magazie = ? and id_stock = ? and (fiscal = ? or ? = -1) and time_document <= ?");
        this.deleteFiseMagazieLaData = this.connection.prepareStatement("delete from fisa_magazie where time_document = ?");
        this.getMagazieById = this.connection.prepareStatement("select * from magazii where id = ?");
        this.updatePriceForStock = this.connection.prepareStatement("update stocks set sell_price = ? where id = ?");
        this.updateStockWithEta = this.connection.prepareStatement("update stocks set eta = ? where id = ?");
        this.updateStockWithWarningAndCriticalLevel = this.connection.prepareStatement("update stocks  set warning_level = ?, critical_level = ?  where stocks.id =  (select stocks.id from stocks  inner join produse_finite on stocks.id = produse_finite.id_stock  inner join products on produse_finite.id_product = products.id  where products.cod = ?)");
        this.setValutaForStock = this.connection.prepareStatement("update stocks set id_valuta = ? where id = ?");
        this.selectProductsForProduseFinite = this.connection.prepareStatement("select id from products where id in ( select id_product from produse_finite)");
        this.deleteProductsForProduseFinite = this.connection.prepareStatement("update produse_finite set status = 2 where id_stock = ?");
        this.getAllProductsForStock = this.connection.prepareStatement("select id_product from produse_finite where id_stock = ?");
        this.addProdusFinit = this.connection.prepareStatement("insert into produse_finite ( id_stock, id_product,status) values ( ?, ?, 1)");
        this.deleteProduct = this.connection.prepareStatement("update products set status = 2 where id = ? ");
        this.deleteAllProduseFinite = this.connection.prepareStatement("delete from produse_finite");
        this.deleteAllProductsForProduseFinite = this.connection.prepareStatement("delete from products where id = ?");
        this.getProductByStockId = this.connection.prepareStatement("select id_product from produse_finite where id_stock = ? and produse_finite.status = 1");
        this.getIdStockByProductId = this.connection.prepareStatement("select id_stock from produse_finite  where id_product = ? and produse_finite.status = 1");
        this.addMagazie = this.connection.prepareStatement("insert into magazii(label, cont_materii_prime, cont_marfuri, cont_tva_deductibil, cont_tva_neexigibil, cont_adaos_comercial, is_marfa, status) values (?, ?, ?, ?, ?, ?, ?, 1)");
        this.updateMagazie = this.connection.prepareStatement("update magazii set label = ? , cont_materii_prime = ?, cont_marfuri = ?, cont_tva_deductibil = ?, cont_tva_neexigibil = ?, cont_adaos_comercial = ?, is_marfa = ? where id = ?");
        this.addMagazieSectie = this.connection.prepareStatement("insert into magazii_sectii ( id_magazie, id_category ) values ( ?, ? )");
        this.renameMagazie = this.connection.prepareStatement("update magazii set label = ? where id = ?");
        this.deleteMagazieSectii = this.connection.prepareStatement("delete from magazii_sectii");
        this.selectAllMagazii = this.connection.prepareStatement("select * from magazii where status = 1");
        this.deleteAllMagaziiSectii = this.connection.prepareStatement("delete from magazii_sectii");
        this.selectStockById = this.connection.prepareStatement("select * from stocks where id = ?");
        this.selectStockByName = this.connection.prepareStatement("select * from stocks where label = ? and status = 1");
        this.selectStockByCodUnic = this.connection.prepareStatement("select * from stocks where unique_code = ? and status = 1");
        this.selectAllStocks = this.connection.prepareStatement("select * from stocks where status = 1 or ? = -1 order by label");
        this.addStock = this.connection.prepareStatement("insert into stocks ( label, id_unit, warning_level, critical_level, sell_price, status, descarca_stoc, eta) values ( ? , ?, ?, ?, ?, 1, ?, ?)");
        this.updateUniqueCodeForStock = this.connection.prepareStatement("update stocks set unique_code = ? where id = ?");
        this.getStockNameById = this.connection.prepareStatement("select label from stocks where id = ?");
        this.deleteStockById = this.connection.prepareStatement("update stocks set status = 2 where id = ?");
        this.updateStock = this.connection.prepareStatement("update stocks set label = ?, id_unit = ?,  warning_level = ? , critical_level = ?, descarca_stoc = ? where id = ?");
        this.deleteAllStocks = this.connection.prepareStatement("delete from stocks");
        this.getCatalogPriceForStock = this.connection.prepareStatement("select sell_price from stocks where id = ?");
        this.addCorectie = this.connection.prepareStatement("insert into corectii ( id_magazie, dateadd ) values ( ?, ? )");
        this.addCorectieItem = this.connection.prepareStatement("insert into corectii_items ( id_corectie, id_stock, quantity, f_mode ) values (?,?,?,?)");
        this.getCorectieById = this.connection.prepareStatement("select * from corectii where id = ?");
        this.getCorectiiForMagazie = this.connection.prepareStatement("select * from corectii where (id_magazie = ? or ? = -1 ) and dateadd >= ? and dateadd <= ?");
        this.getCorectieItemsByIdCorectie = this.connection.prepareStatement("select * from corectii_items where id_corectie = ? and (id_stock = ? or ? = -1 )");
        this.deleteCorectieById = this.connection.prepareStatement("delete from corectii where id = ?");
        this.deleteCorectiiItemsByIdCorectie = this.connection.prepareStatement("delete from corectii_items where id_corectie = ?");
        this.updateCorectie = this.connection.prepareStatement("update corectii set dateadd = ? where id = ?");
        this.deleteFiseMagazieForStockAndMagazie = this.connection.prepareStatement("delete from fisa_magazie where id_stock = ? and id_magazie = ?");
        this.deleteFisaMagazieEntry = this.connection.prepareStatement("delete from fisa_magazie where id = ?");
        this.deleteAllFiseMagazie = this.connection.prepareStatement("delete from fisa_magazie where time_document >= ? and time_document <= ?");
        this.getFisaMagazie = this.connection.prepareStatement("select fisa_magazie.*, stocks.label as produs from fisa_magazie inner join stocks on fisa_magazie.id_stock = stocks.id where (fisa_magazie.id_stock = ? OR ? = -1) and (fisa_magazie.id_magazie = ? OR ? = -1) and time_document >= ? and time_document < ? and (fiscal=? or ?=-1) and (fisa_magazie.comanda_type = ? OR ? = -1) order by produs, time_document, fisa_magazie.id");
        this.addFisaMagazieEntry = this.connection.prepareStatement("insert into fisa_magazie ( id_stock, id_magazie, type_document, document, time_document, buy_price, intrata, iesita, val_intrata_pa, val_intrata_pv, val_iesita_pa, val_iesita_pv, denumire_la_furnizor, cod_bare, fiscal, comanda_type, id_sale, id_lot ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        this.getLastFisaMagazieAchizitieForStock = this.connection.prepareStatement("select * from fise_active where id_stock = ? and fise_active.type_document = 2 order by add_time desc");
        this.getMiscariIntreDate = this.connection.prepareStatement("select sum(intrata) as intrare, sum(iesita) as iesire, sum(val_intrata_pa) as val_intrare_pa, sum(val_intrata_pv) as val_intrare_pv, sum(val_iesita_pa) as val_iesire_pa, sum(val_iesita_pv) as val_iesire_pv from fisa_magazie where id_magazie = ? and time_document >= ? and time_document < ? and (id_stock = ? or ? = -1)");
        this.deleteFisaMagazieForStockAndDate = this.connection.prepareStatement("delete from fisa_magazie where id_stock = ? and time_document = ?");
        this.getDisponibilMagazieForStock = this.connection.prepareStatement("select sum(intrata)-sum(iesita) as disponibil from fisa_magazie where id_stock = ? and comanda_type >= ?");
        this.getIesiriProduseFacturiEmise = this.connection.prepareStatement("select facturi_emise.id as idfactura, facturi_emise.serie_factura,  facturi_emise.numar, products.label as produs, facturi_emise_items.quantity as quantity, facturi_emise_items.sell_price,  clienti.id as idclient, persoane_fizice.nume as numepf, persoane_juridice.nume as numepj, facturi_emise.dateadd, documente.comanda_type from facturi_emise inner join facturi_emise_items on facturi_emise_items.id_factura = facturi_emise.id inner join products on products.id = facturi_emise_items.id_product inner join documente on documente.id_factura_emisa = facturi_emise.id inner join clienti on facturi_emise.id_client = clienti.id left join persoane_fizice on persoane_fizice.id = clienti.idpersfizica left join persoane_juridice on persoane_juridice.id = clienti.idpersjuridica where (products.id = ? or ? = -1) and (clienti.id = ? or ? = -1) and (time_document between ? and ?) and (comanda_type = ? or ? = -1) order by dateadd desc");
        this.getIdClientiFromFisaMagazie = this.connection.prepareStatement("select facturi_emise.id_client, facturi.id_furnizor from fisa_magazie inner join documente on documente.time_document = fisa_magazie.time_document left join facturi_emise on facturi_emise.id = documente.id_factura_emisa left join facturi on facturi.id = documente.id_factura where fisa_magazie.id = ?");
        this.selectInMagazie = this.connection.prepareStatement("select sum(intrata - iesita) as magazie from fisa_magazie where id_stock = ? and comanda_type = " + StockLogic.COMANDA_TYPE.EFECTUAT.getIdTip());
        this.selectComenziFerme = this.connection.prepareStatement("select sum(iesita) as comenziferme from fisa_magazie where id_stock = ? and comanda_type = " + StockLogic.COMANDA_TYPE.COMANDA_FERMA.getIdTip());
        this.selectComandat = this.connection.prepareStatement("select sum(intrata) as comandat from fisa_magazie where id_stock = ? and comanda_type = " + StockLogic.COMANDA_TYPE.COMANDA_FERMA.getIdTip());
        this.addFaptic = this.connection.prepareStatement("insert into faptic (id_stock, quantity, id_magazie, nr_crt) values ( ?, ?, ?, ? )");
        this.deleteFapticByNrCrt = this.connection.prepareStatement("delete from faptic where nr_crt = ?");
        this.selectFapticForMagazie = this.connection.prepareStatement("select faptic.*, stocks.label, magazii.label as magazie from faptic inner join stocks on faptic.id_stock = stocks.id inner join magazii on faptic.id_magazie = magazii.id where (id_stock = ? or (? = -1)) and (id_magazie = ? or (? = -1)) order by nr_crt desc");
        this.deleteAllFaptic = this.connection.prepareStatement("delete from faptic where id_magazie = ? or ? = -1");
        this.selectMaxCrtFromFaptic = this.connection.prepareStatement("select max(nr_crt) from faptic");
        this.selectSumFromFaptic = this.connection.prepareStatement("select sum(quantity) from faptic where id_stock = ? and id_magazie = ?");
        this.selectCountQuantitiesFromFaptic = this.connection.prepareStatement("select count(quantity) from faptic where id_stock = ? and id_magazie = ?");
        this.deleteFapticForStockAndMagazie = this.connection.prepareStatement("delete from faptic where id_stock = ? and id_magazie = ?");
        this.getFiseIntrareActive = this.connection.prepareStatement("select * from fise_active where id_stock = ? and (id_magazie = ? or ? = -1) and add_time < ? and disponibil > ? and (id_lot = ? or ? = -1 ) order by add_time, id_fisa");
        this.getDisponibilInMagazie = this.connection.prepareStatement("select sum(disponibil) from fise_Active where id_stock = ? and disponibil > 0 and (id_magazie = ? or ? = -1) and add_time < ?");
        this.updateCantitateFisaMagazie = this.connection.prepareStatement("update fisa_magazie set intrata = ?, val_intrata_pa = ?, val_intrata_pv = ? where id = ?");
        this.syncProdusFinit = this.connection.prepareStatement("update produse_finite set sync = ? where id_product = ? and id_stock = ?");
        this.getValIesireFromFisaByIdSale = this.connection.prepareStatement("select sum(iesita) as quantity, sum(val_iesita_pa) as val_mat_prima, sales.id_product from  fisa_magazie inner join sales on sales.id = fisa_magazie.id_sale  inner join produse_reteta on sales.id_product = produse_reteta.id_product where id_order in (select id from orders where tip_order = " + Order.TIP_ORDER.VANZARE.getTip() + " and (orders.status = " + 3 + " or orders.status = " + 4 + ") and closedate >= ? and closedate <= ? )" + " and fisa_magazie.id_magazie = ?" + " group by sales.id_product");
        this.buildTransferStatements();
        this.buildConsumStatements();
        this.buildLotStatements();
    }

    public void addCerereAprovizionare(CerereAprovizionareEntry cae) throws SQLException {
        this.addCerereAprovizionare.setInt(1, cae.getIdStock());
        this.addCerereAprovizionare.setInt(2, cae.getOperator());
        if (cae.getSupervizor() > 0) {
            this.addCerereAprovizionare.setInt(3, cae.getSupervizor());
        } else {
            this.addCerereAprovizionare.setNull(3, 4);
        }
        if (cae.getIdMagazie() > 0) {
            this.addCerereAprovizionare.setInt(4, cae.getIdMagazie());
        } else {
            this.addCerereAprovizionare.setNull(4, 4);
        }
        if (cae.getIdFurnizor() > 0) {
            this.addCerereAprovizionare.setInt(5, cae.getIdFurnizor());
        } else {
            this.addCerereAprovizionare.setNull(5, 4);
        }
        this.addCerereAprovizionare.setInt(6, cae.getStatus().getCod());
        this.addCerereAprovizionare.setDouble(7, cae.getCantitateCeruta());
        if (cae.getPretNegociat() != null) {
            this.addCerereAprovizionare.setDouble(8, cae.getPretNegociat());
        } else {
            this.addCerereAprovizionare.setNull(8, 8);
        }
        Double d = cae.getNrZileComanda();
        if (d != null) {
            this.addCerereAprovizionare.setDouble(9, d);
        } else {
            this.addCerereAprovizionare.setNull(9, 8);
        }
        d = cae.getCantitateRecomandataMinim();
        if (d != null) {
            this.addCerereAprovizionare.setDouble(10, d);
        } else {
            this.addCerereAprovizionare.setNull(10, 8);
        }
        d = cae.getCantitateRecomandataMaxim();
        if (d != null) {
            this.addCerereAprovizionare.setDouble(11, d);
        } else {
            this.addCerereAprovizionare.setNull(11, 8);
        }
        d = cae.getCantitateIesitaReferinta();
        if (d != null) {
            this.addCerereAprovizionare.setDouble(12, d);
        } else {
            this.addCerereAprovizionare.setNull(12, 8);
        }
        d = cae.getCantitateIntrataMediePerComandaReferinta();
        if (d != null) {
            this.addCerereAprovizionare.setDouble(13, d);
        } else {
            this.addCerereAprovizionare.setNull(13, 8);
        }
        this.addCerereAprovizionare.setDouble(14, cae.getCantitateExistentaMagazie());
        this.addCerereAprovizionare.setDouble(15, cae.getCantitateExistentaTotal());
        d = cae.getCantitateDejaComandata();
        if (d != null) {
            this.addCerereAprovizionare.setDouble(16, d);
        } else {
            this.addCerereAprovizionare.setNull(16, 8);
        }
        this.addCerereAprovizionare.setTimestamp(17, cae.getReferintaStart());
        this.addCerereAprovizionare.setTimestamp(18, cae.getReferintaStop());
        this.addCerereAprovizionare.execute();
    }

    public void updateCerereAprovizionare(CerereAprovizionareEntry cae) throws SQLException {
        this.updateCerereAprovizionare.setInt(1, cae.getIdStock());
        this.updateCerereAprovizionare.setInt(2, cae.getOperator());
        if (cae.getSupervizor() > 0) {
            this.updateCerereAprovizionare.setInt(3, cae.getSupervizor());
        } else {
            this.updateCerereAprovizionare.setNull(3, 4);
        }
        if (cae.getIdMagazie() > 0) {
            this.updateCerereAprovizionare.setInt(4, cae.getIdMagazie());
        } else {
            this.updateCerereAprovizionare.setNull(4, 4);
        }
        if (cae.getIdFurnizor() > 0) {
            this.updateCerereAprovizionare.setInt(5, cae.getIdFurnizor());
        } else {
            this.updateCerereAprovizionare.setInt(5, 4);
        }
        this.updateCerereAprovizionare.setInt(6, cae.getStatus().getCod());
        this.updateCerereAprovizionare.setDouble(7, cae.getCantitateCeruta());
        if (cae.getPretNegociat() != null) {
            this.updateCerereAprovizionare.setDouble(8, cae.getPretNegociat());
        } else {
            this.updateCerereAprovizionare.setNull(8, 8);
        }
        this.updateCerereAprovizionare.setDouble(9, cae.getNrZileComanda());
        this.updateCerereAprovizionare.setDouble(10, cae.getCantitateRecomandataMinim());
        this.updateCerereAprovizionare.setDouble(11, cae.getCantitateRecomandataMaxim());
        this.updateCerereAprovizionare.setDouble(12, cae.getCantitateIesitaReferinta());
        this.updateCerereAprovizionare.setDouble(13, cae.getCantitateIntrataMediePerComandaReferinta());
        this.updateCerereAprovizionare.setDouble(14, cae.getCantitateExistentaMagazie());
        this.updateCerereAprovizionare.setDouble(15, cae.getCantitateExistentaTotal());
        this.updateCerereAprovizionare.setDouble(16, cae.getCantitateDejaComandata());
        this.updateCerereAprovizionare.setTimestamp(17, cae.getReferintaStart());
        this.updateCerereAprovizionare.setTimestamp(18, cae.getReferintaStop());
        this.updateCerereAprovizionare.setInt(19, cae.getId());
        this.updateCerereAprovizionare.execute();
    }

    public Vector<CerereAprovizionareEntry> getReportCerereAprovizionare(Hashtable criteria) throws SQLException {
        StockLogic.APROVIZIONARE_STATUS status;
        Client furnizor;
        User supervizor;
        Vector<CerereAprovizionareEntry> result = new Vector<CerereAprovizionareEntry>();
        String s = "select * from cereri_aprovizionare where 1= 1 ";
        Date start = (Date)criteria.get(Constants.START_KEY);
        Date stop = (Date)criteria.get(Constants.STOP_KEY);
        s = s + " and data_cerere >=  '" + new Timestamp(start.getTime()) + "' and data_cerere <= '" + new Timestamp(stop.getTime()) + "'";
        User operator = (User)criteria.get("user");
        if (operator != null) {
            s = s + " and id_operator = " + operator.getId();
        }
        if ((supervizor = (User)criteria.get("user_bo")) != null) {
            s = s + " and id_supervizor = " + supervizor.getId();
        }
        if ((furnizor = (Client)criteria.get("Furnizor")) != null) {
            s = s + " and id_furnizor = " + furnizor.getId();
        }
        if ((status = (StockLogic.APROVIZIONARE_STATUS)((Object)criteria.get(Constants.STATUS))) != null) {
            s = s + " and status = " + status.getCod();
        }
        s = s + " order by data_cerere";
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        while (rs.next()) {
            CerereAprovizionareEntry add = new CerereAprovizionareEntry();
            add.setId(rs.getInt("id"));
            add.setIdStock(rs.getInt("id_stock"));
            add.setOperator(rs.getInt("id_operator"));
            add.setSupervizor(rs.getInt("id_supervizor"));
            add.setIdMagazie(rs.getInt("id_magazie"));
            add.setIdFurnizor(rs.getInt("id_furnizor"));
            int status2 = rs.getInt("status");
            StockLogic.APROVIZIONARE_STATUS status1 = StockLogic.getAprovizionareStatusById(status2);
            add.setStatus(status1);
            add.setCantitateCeruta(rs.getDouble("cantitate_ceruta"));
            add.setPretNegociat(rs.getDouble("pret_negociat"));
            add.setNrZileComanda(rs.getDouble("nr_zile_comanda"));
            add.setCantitateRecomandataMinim(rs.getDouble("cantitate_recomandata_minim"));
            add.setCantitateRecomandataMaxim(rs.getDouble("cantitate_recomandata_maxim"));
            add.setCantitateIesitaReferinta(rs.getDouble("cantitate_iesita_referinta"));
            add.setCantitateIntrataMediePerComandaReferinta(rs.getDouble("cantitate_intrata_medie_per_comanda_referinta"));
            add.setCantitateDejaComandata(rs.getDouble("cantitate_deja_comandata"));
            add.setCantitateExistentaMagazie(rs.getDouble("cantitate_existenta_magazie"));
            add.setCantitateExistentaTotal(rs.getDouble("cantitate_existenta_total"));
            add.setReferintaStart(rs.getTimestamp("referinta_start"));
            add.setReferintaStop(rs.getTimestamp("referinta_stop"));
            add.setDataCerere(rs.getTimestamp("data_cerere"));
            result.add(add);
        }
        rs.close();
        return result;
    }

    public Vector<SaleDescarcareBean> getValIesireByIdSale(Timestamp start, Timestamp stop, int idMagazie) throws SQLException {
        Vector<SaleDescarcareBean> result = new Vector<SaleDescarcareBean>();
        this.getValIesireFromFisaByIdSale.setTimestamp(1, start);
        this.getValIesireFromFisaByIdSale.setTimestamp(2, stop);
        this.getValIesireFromFisaByIdSale.setInt(3, idMagazie);
        ResultSet rs = this.getValIesireFromFisaByIdSale.executeQuery();
        while (rs.next()) {
            SaleDescarcareBean sb = new SaleDescarcareBean();
            sb.setValDescarcarePa(rs.getDouble("val_mat_prima"));
            sb.setIdProduct(rs.getInt("id_product"));
            sb.setQuantity(rs.getDouble("quantity"));
            result.add(sb);
        }
        rs.close();
        return result;
    }

    public double getIntrareForFisaMagazie(int idFisa) throws SQLException {
        double result = -1.0;
        this.getCantitateIntrataForFisa.setInt(1, idFisa);
        ResultSet rs = this.getCantitateIntrataForFisa.executeQuery();
        if (rs.next()) {
            result = rs.getDouble("intrata");
        }
        rs.close();
        return result;
    }

    public Timestamp getTimestampForFisa(int idFisa) throws SQLException {
        Timestamp result = null;
        this.getTimestampForFisa.setInt(1, idFisa);
        ResultSet rs = this.getTimestampForFisa.executeQuery();
        if (rs.next()) {
            result = rs.getTimestamp("time_document");
        }
        rs.close();
        return result;
    }

    public Vector<FisaMagazieEntry> getFisaMagazieByTimeDocument(Timestamp time) throws SQLException {
        Vector<FisaMagazieEntry> result = new Vector<FisaMagazieEntry>();
        this.getFisaMagazieByTimeDocument.setTimestamp(1, time);
        ResultSet rs = this.getFisaMagazieByTimeDocument.executeQuery();
        while (rs.next()) {
            FisaMagazieEntry toadd = this.getFisaMagazieFromResultSet(rs);
            result.add(toadd);
        }
        rs.close();
        return result;
    }

    public void updateCantitateForFisaMagazie(int idFisa, double cantitate, double valoareAcz, double valoareVz) throws SQLException {
        this.updateCantitateFisaMagazie.setDouble(1, cantitate);
        this.updateCantitateFisaMagazie.setDouble(2, valoareAcz);
        this.updateCantitateFisaMagazie.setDouble(3, valoareVz);
        this.updateCantitateFisaMagazie.setInt(4, idFisa);
        this.updateCantitateFisaMagazie.execute();
    }

    public void deleteCorectiiItemsByIdCorectie(int idCorectie) throws SQLException {
        this.deleteCorectiiItemsByIdCorectie.setInt(1, idCorectie);
        this.deleteCorectiiItemsByIdCorectie.execute();
    }

    public void deleteCorectieById(int idCorectie) throws SQLException {
        this.deleteCorectieById.setInt(1, idCorectie);
        this.deleteCorectieById.execute();
    }

    public void deleteTransfer(int id) throws SQLException {
        this.deleteTransfer.setInt(1, id);
        this.deleteTransfer.execute();
    }

    public void deleteTransferItem(int id) throws SQLException {
        this.deleteTransferItem.setInt(1, id);
        this.deleteTransferItem.execute();
    }

    public Vector getBonConsumItems(int idBonConsum) throws SQLException {
        Vector<BonConsumItem> result = new Vector<BonConsumItem>();
        this.getBonConsumItems.setInt(1, idBonConsum);
        ResultSet rs = this.getBonConsumItems.executeQuery();
        while (rs.next()) {
            BonConsumItem bci = new BonConsumItem();
            bci.setCantitate(rs.getDouble("quantity"));
            bci.setIdStock(rs.getInt("id_stock"));
            bci.setId(rs.getInt("id"));
            bci.setDenumire(rs.getString("produs"));
            bci.setValAcz(rs.getDouble("val_pa"));
            bci.setPretAcz(bci.getValoareAchizitie() / bci.getCantitate());
            bci.setUm(rs.getString("um"));
            bci.setIdLot(rs.getInt("id_lot"));
            result.add(bci);
        }
        rs.close();
        return result;
    }

    public void updateTransfer(int idTransfer, int idSursa, int idDestinatie, Timestamp timeTransfer, double totalPv, double totalPa, int tipTransfer, boolean pretAczFix) throws SQLException {
        this.updateTransfer.setInt(1, idSursa);
        this.updateTransfer.setInt(2, idDestinatie);
        this.updateTransfer.setTimestamp(3, timeTransfer);
        this.updateTransfer.setDouble(4, totalPv);
        this.updateTransfer.setDouble(5, totalPa);
        this.updateTransfer.setInt(6, tipTransfer);
        this.updateTransfer.setInt(7, pretAczFix ? 1 : 0);
        this.updateTransfer.setInt(8, idTransfer);
        this.updateTransfer.execute();
    }

    public void updateBonConsum(int idMagazie, Timestamp dateadd, double total, int idBonConsum, int nrBonConsum, String observatii) throws SQLException {
        this.updateBonConsum.setInt(1, idMagazie);
        this.updateBonConsum.setTimestamp(2, dateadd);
        this.updateBonConsum.setDouble(3, total);
        this.updateBonConsum.setInt(4, nrBonConsum);
        this.updateBonConsum.setString(5, observatii);
        this.updateBonConsum.setInt(6, idBonConsum);
        this.updateBonConsum.execute();
    }

    public void deleteConsumLaData(Timestamp start) throws SQLException {
        this.deleteConsumLaData.setTimestamp(1, start);
        this.deleteConsumLaData.execute();
    }

    public void deleteConsumDupaData(Timestamp start) throws SQLException {
        this.deleteConsumDupaData.setTimestamp(1, start);
        this.deleteConsumDupaData.execute();
    }

    public void deleteFiseMagazieLaData(Timestamp start) throws SQLException {
        this.deleteFiseMagazieLaData.setTimestamp(1, start);
        this.deleteFiseMagazieLaData.execute();
    }

    public void deleteProdusFinitByProductId(int idProduct) throws SQLException {
        this.deleteProdusFinitByProductId.setInt(1, idProduct);
        this.deleteProdusFinitByProductId.execute();
    }

    private void buildTransferStatements() throws SQLException {
        this.deleteProdusFinitByProductId = this.connection.prepareStatement("delete from produse_finite where id_product = ?");
        this.updateTransfer = this.connection.prepareStatement("update stock_transfer set id_sursa = ?, id_dest = ?, time_transfer = ?, total_pv = ?, val_pa = ?, tip = ?, pret_acz_fix = ? where id = ?");
        this.updateBuyPriceForTransferItem = this.connection.prepareStatement("update transfer_items set buy_price = ? where id = ?");
        this.deleteTransferItem = this.connection.prepareStatement("delete from transfer_items where id = ?");
        this.deleteTransfer = this.connection.prepareStatement("delete from stock_transfer where id = ?");
        this.addTransfer = this.connection.prepareStatement("insert into stock_transfer ( id_sursa, id_dest, time_transfer, total_pv, val_pa, tip, pret_acz_fix, nr_bon, id_user ) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.updateValPaForTransfer = this.connection.prepareStatement("update stock_transfer set val_pa = ? where id = ?");
        this.addTransferItem = this.connection.prepareStatement("insert into transfer_items ( id_transfer, id_stock, quantity, sell_price, buy_price, img_src, id_lot ) values ( ?, ?, ?, ?, ?, ?, ?)");
        this.deleteAllTransferuri = this.connection.prepareStatement("delete from stock_transfer");
        String s1 = "select stock_transfer.*, (select label from magazii where stock_transfer.id_sursa = magazii.id) as sursa, (select id from magazii where stock_transfer.id_sursa = magazii.id) as id_sursa, (select label from magazii where stock_transfer.id_dest = magazii.id) as destinatie, (select id from magazii where stock_transfer.id_dest = magazii.id) as id_destinatie from stock_transfer";
        this.getTransferById = this.connection.prepareStatement(s1 + " where id = ?");
        this.getTransferuri = this.connection.prepareStatement(s1 + " where (id_sursa = ? or ? = " + -1 + ") " + " and (id_dest = ?  or ? = " + -1 + ") " + " and (time_transfer >= ? and time_transfer < ?)" + " and (tip = ? or ? = " + -1 + ")" + " order by time_transfer, stock_transfer.id");
        String s = "select transfer_items.*, stocks.label as nume_stock, messages.label as unitate_masura from transfer_items inner join stocks on transfer_items.id_stock = stocks.id inner join units on stocks.id_unit = units.id inner join keys on units.id_key = keys.id inner join messages on keys.id = messages.id_key";
        this.getTransfItemsForTransfer = this.connection.prepareStatement(s + " where transfer_items.id_transfer = ?");
        this.getTransfItemById = this.connection.prepareStatement(s + " where transfer_items.id = ?");
    }

    public Double getStocActual(int idStock, int idMagazie) throws SQLException {
        Double result = 0.0;
        String s = "select sum(intrata - iesita) as stoc_actual  from fisa_magazie where id_stock = " + idStock;
        if (idMagazie > 0) {
            s = s + " and id_magazie = " + idMagazie;
        }
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        while (rs.next()) {
            result = rs.getDouble("stoc_actual");
        }
        rs.close();
        return result;
    }

    public Vector<QuickSmallStocksBean> getAllStocksInMagazieNowNoCommit(int idMagazie) throws SQLException {
        String s = "select stocks.label as denumire, stocks.id, sum(intrata - iesita) as stoc_actual, warning_level, critical_level from fisa_magazie inner join stocks on fisa_magazie.id_Stock = stocks.id where stocks.status = 1";
        if (idMagazie > 0) {
            s = s + " and id_magazie = " + idMagazie;
        }
        s = s + " group by stocks.label, stocks.id, warning_level, critical_level order by lower(stocks.label)";
        Vector<QuickSmallStocksBean> result = new Vector<QuickSmallStocksBean>();
        ResultSet rs = SqlUtils.executeQuery(s, this.connection);
        while (rs.next()) {
            double actual = rs.getDouble("stoc_actual");
            double max = rs.getDouble("warning_level");
            double min = rs.getDouble("critical_level");
            String den = rs.getString("denumire");
            QuickSmallStocksBean toAdd = new QuickSmallStocksBean();
            toAdd.setDenumire(den);
            toAdd.setMin(min);
            toAdd.setMax(max);
            toAdd.setIdStock(rs.getInt("id"));
            toAdd.setExistent(actual);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public StocksDao(Connection conn) throws SQLException {
        this.connection = conn;
    }

    public void syncProdusFinit(int idProdus, int idStock, boolean toSync) throws SQLException {
        this.syncProdusFinit.setInt(1, toSync ? 1 : 0);
        this.syncProdusFinit.setInt(2, idProdus);
        this.syncProdusFinit.setInt(3, idStock);
        this.syncProdusFinit.execute();
    }

    public void updateCorectie(int idCorectie, Timestamp dateadd) throws SQLException {
        this.updateCorectie.setTimestamp(1, dateadd);
        this.updateCorectie.setInt(2, idCorectie);
        this.updateCorectie.execute();
    }

    public void addCorectie(int idMagazie, Timestamp dateadd) throws SQLException {
        this.addCorectie.setInt(1, idMagazie);
        this.addCorectie.setTimestamp(2, dateadd);
        this.addCorectie.execute();
    }

    public void addCorectieItem(int idCorectie, int idStock, double quantity, int whatToPrint) throws SQLException {
        this.addCorectieItem.setInt(1, idCorectie);
        this.addCorectieItem.setInt(2, idStock);
        this.addCorectieItem.setDouble(3, quantity);
        this.addCorectieItem.setInt(4, whatToPrint);
        this.addCorectieItem.execute();
    }

    public void addBonConsum(int idMagazie, Timestamp dateadd, double total, int nrBonConsum, String obs) throws SQLException {
        this.addBonConsum.setInt(1, idMagazie);
        this.addBonConsum.setTimestamp(2, dateadd);
        this.addBonConsum.setDouble(3, total);
        this.addBonConsum.setInt(4, nrBonConsum);
        this.addBonConsum.setString(5, obs);
        this.addBonConsum.execute();
    }

    public void addBonConsumItem(int idBon, int idStock, double quantity, int idLot) throws SQLException {
        this.addBonConsumItem.setInt(1, idBon);
        this.addBonConsumItem.setInt(2, idStock);
        this.addBonConsumItem.setDouble(3, quantity);
        this.addBonConsumItem.setInt(4, idLot);
        this.addBonConsumItem.execute();
    }

    public void deleteBonConsumItem(int idBonConsumItem) throws SQLException {
        this.deleteBonConsumItem.setInt(1, idBonConsumItem);
        this.deleteBonConsumItem.execute();
    }

    public void deleteBonConsum(int idBonConsum) throws SQLException {
        this.deleteBonConsum.setInt(1, idBonConsum);
        this.deleteBonConsum.execute();
    }

    public void deleteFapticForStockAndMagazie(int idStock, int idMagazie) throws SQLException {
        this.deleteFapticForStockAndMagazie.setInt(1, idStock);
        this.deleteFapticForStockAndMagazie.setInt(2, idMagazie);
        this.deleteFapticForStockAndMagazie.execute();
    }

    public double getSumFromFaptic(int idStock, int idMagazie) throws SQLException {
        double result = 0.0;
        this.selectSumFromFaptic.setInt(1, idStock);
        this.selectSumFromFaptic.setInt(2, idMagazie);
        ResultSet rs = this.selectSumFromFaptic.executeQuery();
        if (rs.next()) {
            result = rs.getDouble(1);
        }
        rs.close();
        return result;
    }

    public int getCountQuantitiesFromFaptic(int idStock, int idMagazie) throws SQLException {
        int result = 0;
        this.selectCountQuantitiesFromFaptic.setInt(1, idStock);
        this.selectCountQuantitiesFromFaptic.setInt(2, idMagazie);
        ResultSet rs = this.selectCountQuantitiesFromFaptic.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public int getMaxCrtFromFaptic() throws SQLException {
        int result = 0;
        ResultSet rs = this.selectMaxCrtFromFaptic.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void addStockFaptic(int idStock, int idMagazie, double cantitate) throws SQLException {
        int oldCrt = this.getMaxCrtFromFaptic();
        this.addFaptic.setInt(1, idStock);
        this.addFaptic.setDouble(2, cantitate);
        this.addFaptic.setInt(3, idMagazie);
        this.addFaptic.setInt(4, oldCrt + 1);
        this.addFaptic.execute();
    }

    public void deleteStockFaptic(int nrCrt) throws SQLException {
        this.deleteFapticByNrCrt.setInt(1, nrCrt);
        this.deleteFapticByNrCrt.execute();
    }

    public void deleteAllFaptic(int idMagazie) throws SQLException {
        this.deleteAllFaptic.setInt(1, idMagazie);
        this.deleteAllFaptic.setInt(2, idMagazie);
        this.deleteAllFaptic.execute();
    }

    private StockFapticView getFapticFromResultSet(ResultSet rs) throws SQLException {
        StockFapticView toAdd = new StockFapticView();
        toAdd.setCantitate(rs.getDouble("quantity"));
        toAdd.setIdMagazie(rs.getInt("id_magazie"));
        toAdd.setIdStock(rs.getInt("id_stock"));
        toAdd.setNrCrt(rs.getInt("nr_crt"));
        toAdd.setStock(rs.getString("label"));
        toAdd.setMagazie(rs.getString("magazie"));
        return toAdd;
    }

    public Vector selectFapticForMagazie(int idStock, int idMagazie, int itemsCount, int startAt) throws SQLException {
        Vector<StockFapticView> result = new Vector<StockFapticView>();
        this.selectFapticForMagazie.setInt(1, idStock);
        this.selectFapticForMagazie.setInt(2, idStock);
        this.selectFapticForMagazie.setInt(3, idMagazie);
        this.selectFapticForMagazie.setInt(4, idMagazie);
        ResultSet rs = this.selectFapticForMagazie.executeQuery();
        int i = 0;
        while (rs.next()) {
            if (i >= startAt && i < startAt + itemsCount) {
                result.add(this.getFapticFromResultSet(rs));
            } else if (i > startAt + itemsCount) break;
            ++i;
        }
        rs.close();
        return result;
    }

    public void toIngredient(int idStock) throws SQLException {
        this.getAllProductsForStock.setInt(1, idStock);
        ResultSet rs = this.getAllProductsForStock.executeQuery();
        Vector<Integer> ids = new Vector<Integer>();
        while (rs.next()) {
            int id = rs.getInt(1);
            ids.add(id);
        }
        rs.close();
        this.deleteProductsForProduseFinite.setInt(1, idStock);
        this.deleteProductsForProduseFinite.execute();
        for (Integer element : ids) {
            this.deleteProduct.setInt(1, element);
            this.deleteProduct.execute();
        }
    }

    public int getIdProductForStock(int idStock) throws SQLException {
        int result = -1;
        this.getAllProductsForStock.setInt(1, idStock);
        ResultSet rs = this.getAllProductsForStock.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id_product");
        }
        return result;
    }

    public void deleteFiseMagazie(int idStock, int idMagazie) throws SQLException {
        this.deleteFiseMagazieForStockAndMagazie.setInt(1, idStock);
        this.deleteFiseMagazieForStockAndMagazie.setInt(2, idMagazie);
        this.deleteFiseMagazieForStockAndMagazie.execute();
    }

    public void deleteAllFiseMagazie(Timestamp start, Timestamp stop) throws SQLException {
        this.deleteAllFiseMagazie.setTimestamp(1, start);
        this.deleteAllFiseMagazie.setTimestamp(2, stop);
        this.deleteAllFiseMagazie.execute();
    }

    public FisaIntrareActiva getLatestFisaMagazieAchizitieForStock(int idStock) throws SQLException {
        FisaIntrareActiva result = null;
        this.getLastFisaMagazieAchizitieForStock.setInt(1, idStock);
        ResultSet rs = this.getLastFisaMagazieAchizitieForStock.executeQuery();
        if (rs.next()) {
            result = this.getFisaIntrareActivaFromRs(rs);
        }
        rs.close();
        return result;
    }

    public Vector getFisaMagazie(int idStock, int idMagazie, Timestamp start, Timestamp stop, int what, Connection conn, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        FisaMagazieEntry fe;
        Vector<FisaMagazieEntry> result = new Vector<FisaMagazieEntry>();
        double totalStoc = 0.0;
        double totalValPa = 0.0;
        double totalValPv = 0.0;
        Hashtable<Integer, StockBean> stocLaData = this.getStocLaData("(" + idStock + ")", idMagazie, start, what, conn);
        Vector<StockBean> stocInitial = new Vector<StockBean>(stocLaData.values());
        for (int i = 0; i < stocInitial.size(); ++i) {
            StockBean o = stocInitial.elementAt(i);
            fe = new FisaMagazieEntry();
            fe.setData(Formatters.DATE_AND_TIME_FORMAT.format(start));
            fe.setProdus(o.getProdus());
            fe.setDocument("Anterior");
            fe.setIntrata(0.0);
            fe.setIesita(0.0);
            fe.setStoc(o.getCantitate());
            fe.setIdStoc(o.getIdStock());
            fe.setValIntrataPa(0.0);
            fe.setValIntrataPv(0.0);
            fe.setValIesitaPa(0.0);
            fe.setValIesitaPv(0.0);
            fe.setValStocPa(o.getAchizitie());
            fe.setValStocPv(o.getVanzare());
            fe.setPretAchizitie(o.getAchizitie() / o.getCantitate());
            fe.setComandaType(StockLogic.COMANDA_TYPE.EFECTUAT);
            totalStoc += fe.getStoc();
            totalValPa += fe.getValStocPa();
            totalValPv += fe.getValStocPv();
            result.add(fe);
        }
        this.getFisaMagazie.setInt(1, idStock);
        this.getFisaMagazie.setInt(2, idStock);
        this.getFisaMagazie.setInt(3, idMagazie);
        this.getFisaMagazie.setInt(4, idMagazie);
        this.getFisaMagazie.setTimestamp(5, start);
        this.getFisaMagazie.setTimestamp(6, stop);
        int w = -1;
        switch (what) {
            case 2: {
                w = 1;
                break;
            }
            case 3: {
                w = 0;
                break;
            }
            default: {
                w = -1;
            }
        }
        this.getFisaMagazie.setInt(7, w);
        this.getFisaMagazie.setInt(8, w);
        if (comandaType != null && VpConfig.getInstance().futureStocksEnabled) {
            this.getFisaMagazie.setInt(9, comandaType.getIdTip());
            this.getFisaMagazie.setInt(10, comandaType.getIdTip());
        } else {
            this.getFisaMagazie.setInt(9, -1);
            this.getFisaMagazie.setInt(10, -1);
        }
        ResultSet rs = this.getFisaMagazie.executeQuery();
        while (rs.next()) {
            fe = this.getFisaMagazieFromResultSet(rs);
            result.add(fe);
            fe.setStoc(totalStoc += fe.getIntrata() - fe.getIesita());
            fe.setValStocPa(totalValPa += fe.getValIntrataPa() - fe.getValIesitaPa());
            fe.setValStocPv(totalValPv += fe.getValIntrataPv() - fe.getValIesitaPv());
            Integer idClientiFromFisaMagazie = this.getIdClientiFromFisaMagazie(fe.getId());
            fe.setIdClient(idClientiFromFisaMagazie);
        }
        rs.close();
        return result;
    }

    public void addFisaMagazie(int idStock, int idMagazie, int tipDocument, String document, Timestamp timeDocument, double buyPrice, double intrata, double iesita, double valIntrataPa, double valIntrataPv, double valIesitaPa, double valIesitaPv, String denumireLaFurnizor, String codBare, int fiscal, int idSale, StockLogic.COMANDA_TYPE comandaType, int idLot) throws SQLException {
        this.addFisaMagazieEntry.setInt(1, idStock);
        this.addFisaMagazieEntry.setInt(2, idMagazie);
        this.addFisaMagazieEntry.setInt(3, tipDocument);
        this.addFisaMagazieEntry.setString(4, document);
        this.addFisaMagazieEntry.setTimestamp(5, timeDocument);
        this.addFisaMagazieEntry.setDouble(6, buyPrice);
        this.addFisaMagazieEntry.setDouble(7, intrata);
        this.addFisaMagazieEntry.setDouble(8, iesita);
        this.addFisaMagazieEntry.setDouble(9, valIntrataPa);
        this.addFisaMagazieEntry.setDouble(10, valIntrataPv);
        this.addFisaMagazieEntry.setDouble(11, valIesitaPa);
        this.addFisaMagazieEntry.setDouble(12, valIesitaPv);
        this.addFisaMagazieEntry.setString(13, denumireLaFurnizor);
        this.addFisaMagazieEntry.setString(14, codBare);
        this.addFisaMagazieEntry.setInt(15, fiscal);
        this.addFisaMagazieEntry.setInt(16, comandaType.getIdTip());
        if (idSale > 0) {
            this.addFisaMagazieEntry.setInt(17, idSale);
        } else {
            this.addFisaMagazieEntry.setNull(17, 4);
        }
        if (idLot > 0) {
            this.addFisaMagazieEntry.setInt(18, idLot);
        } else {
            this.addFisaMagazieEntry.setNull(18, 4);
        }
        this.addFisaMagazieEntry.execute();
    }

    public void deleteFisaMagazie(int id) throws SQLException {
        this.deleteFisaMagazieEntry.setInt(1, id);
        this.deleteFisaMagazieEntry.execute();
    }

    private FisaMagazieEntry getFisaMagazieFromResultSet(ResultSet rs) throws SQLException {
        FisaMagazieEntry fe = new FisaMagazieEntry();
        Timestamp data = rs.getTimestamp("time_document");
        String doc = rs.getString("document");
        String produs = rs.getString("produs");
        double intrata = rs.getDouble("intrata");
        double iesita = rs.getDouble("iesita");
        double valIntrarePa = rs.getDouble("val_intrata_pa");
        double valIntrarePv = rs.getDouble("val_intrata_pv");
        double valIesirePa = rs.getDouble("val_iesita_pa");
        double valIesirePv = rs.getDouble("val_iesita_pv");
        double pa = rs.getDouble("buy_price");
        int id = rs.getInt("id");
        String codBare = rs.getString("cod_bare");
        String denumireLaFurnizor = rs.getString("denumire_la_furnizor");
        int comandaType = rs.getInt("comanda_type");
        fe.setData(Formatters.DATE_AND_TIME_FORMAT.format(data));
        fe.setProdus(produs);
        fe.setDocument(doc);
        fe.setIntrata(intrata);
        fe.setIesita(iesita);
        fe.setIdStoc(rs.getInt("id_stock"));
        fe.setValIntrataPa(valIntrarePa);
        fe.setValIntrataPv(valIntrarePv);
        fe.setValIesitaPa(valIesirePa);
        fe.setValIesitaPv(valIesirePv);
        fe.setPretAchizitie(pa);
        fe.setId(id);
        fe.setCodBare(codBare);
        fe.setDenumireLaFurnizor(denumireLaFurnizor);
        fe.setComandaType(StockLogic.getInstance().getComandaTypeById(comandaType));
        fe.setIdMagazie(rs.getInt("id_magazie"));
        return fe;
    }

    public void cleanupSectiiMagazii() throws SQLException {
        this.deleteAllMagaziiSectii.execute();
    }

    public void cleanupStocks() throws SQLException {
        this.deleteAllTransferuri.execute();
        ResultSet rs = this.selectProductsForProduseFinite.executeQuery();
        Vector<Integer> products = new Vector<Integer>();
        while (rs.next()) {
            products.add(rs.getInt(1));
        }
        rs.close();
        this.deleteAllProduseFinite.execute();
        for (int i = 0; i < products.size(); ++i) {
            Integer o = (Integer)products.elementAt(i);
            this.deleteAllProductsForProduseFinite.setInt(1, o);
            this.deleteAllProductsForProduseFinite.execute();
        }
        this.deleteAllFiseMagazie.execute();
        this.deleteAllStocks.execute();
    }

    public void cleanupCantitati() throws SQLException {
        this.deleteAllConsum.execute();
    }

    public int getIdStockByProductId(int idProduct) throws SQLException {
        int result = -1;
        this.getIdStockByProductId.setInt(1, idProduct);
        ResultSet rs = this.getIdStockByProductId.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id_stock");
        }
        rs.close();
        return result;
    }

    public int getProductByStockId(int idStock) throws SQLException {
        int result = -1;
        this.getProductByStockId.setInt(1, idStock);
        ResultSet rs = this.getProductByStockId.executeQuery();
        if (rs.next()) {
            result = rs.getInt("id_product");
        }
        rs.close();
        return result;
    }

    public void deleteConsum(int idConsum) throws SQLException {
        this.deleteConsum.setInt(1, idConsum);
        this.deleteConsum.execute();
    }

    public void addConsum(int idFisaSursa, double quantity, Timestamp timeDocument) throws SQLException {
        if (idFisaSursa == -1) {
            this.addConsum.setNull(1, 4);
        } else {
            this.addConsum.setInt(1, idFisaSursa);
        }
        this.addConsum.setDouble(2, quantity);
        this.addConsum.setTimestamp(3, timeDocument);
        this.addConsum.execute();
    }

    public void addTransfer(int idSursa, int idDest, Timestamp time, double totalPv, double totalPa, int tipTransfer, boolean pretAczFix, int nrDoc, int idUser) throws SQLException {
        this.addTransfer.setInt(1, idSursa);
        this.addTransfer.setInt(2, idDest);
        this.addTransfer.setTimestamp(3, time);
        this.addTransfer.setDouble(4, totalPv);
        this.addTransfer.setDouble(5, totalPa);
        this.addTransfer.setInt(6, tipTransfer);
        this.addTransfer.setInt(7, pretAczFix ? 1 : 0);
        this.addTransfer.setInt(8, nrDoc);
        this.addTransfer.setInt(9, idUser);
        this.addTransfer.execute();
    }

    public void updateValPaForTransfer(int idTransfer, double newValPa) throws SQLException {
        this.updateValPaForTransfer.setDouble(1, newValPa);
        this.updateValPaForTransfer.setInt(2, idTransfer);
        this.updateValPaForTransfer.execute();
    }

    public void updateValPaForConsum(int idBonConsum, double newValPa) throws SQLException {
        this.updateValPaForBonConsum.setDouble(1, newValPa);
        this.updateValPaForBonConsum.setInt(2, idBonConsum);
        this.updateValPaForBonConsum.execute();
    }

    public void addTransferItem(int idTransfer, int idStock, double quantity, double sellPrice, double buyPrice, String img, int idLot) throws SQLException {
        this.addTransferItem.setInt(1, idTransfer);
        this.addTransferItem.setInt(2, idStock);
        this.addTransferItem.setDouble(3, quantity);
        this.addTransferItem.setDouble(4, sellPrice);
        this.addTransferItem.setDouble(5, buyPrice);
        if (img != null) {
            this.addTransferItem.setString(6, img);
        } else {
            this.addTransferItem.setNull(6, 12);
        }
        if (idLot > 0) {
            this.addTransferItem.setInt(7, idLot);
        } else {
            this.addTransferItem.setNull(7, 4);
        }
        this.addTransferItem.execute();
    }

    public void updateBuyPriceForTransferItem(int idTransferItem, double buyPrice) throws SQLException {
        this.updateBuyPriceForTransferItem.setDouble(1, buyPrice);
        this.updateBuyPriceForTransferItem.setInt(2, idTransferItem);
        this.updateBuyPriceForTransferItem.execute();
    }

    public void resetBuyValueForConsumItem(int idConsumItem) throws SQLException {
        this.resetBuyValueForConsumItem.setInt(1, idConsumItem);
        this.resetBuyValueForConsumItem.execute();
    }

    public void addBuyValueForConsumItem(int idConsumItem, double buyValue) throws SQLException {
        this.updateBuyValueForConsumItem.setDouble(1, buyValue);
        this.updateBuyValueForConsumItem.setInt(2, idConsumItem);
        this.updateBuyValueForConsumItem.execute();
    }

    public void addProdusFinit(int idProdus, int idStock) throws SQLException {
        this.addProdusFinit.setInt(1, idStock);
        this.addProdusFinit.setInt(2, idProdus);
        this.addProdusFinit.execute();
    }

    public Magazie getMagazieById(int id) throws SQLException {
        Magazie result = null;
        this.getMagazieById.setInt(1, id);
        ResultSet rs = this.getMagazieById.executeQuery();
        if (rs.next()) {
            result = StocksDao.getMagazieFromRs(rs);
        }
        rs.close();
        return result;
    }

    public Magazie getMagazieByName(String name) throws SQLException {
        Magazie result = null;
        this.getMagazieByName.setString(1, name);
        ResultSet rs = this.getMagazieByName.executeQuery();
        if (rs.next()) {
            result = StocksDao.getMagazieFromRs(rs);
        }
        rs.close();
        return result;
    }

    public Vector<Magazie> getAllMagazii() throws SQLException {
        Vector<Magazie> result = new Vector<Magazie>();
        ResultSet rs = this.selectAllMagazii.executeQuery();
        while (rs.next()) {
            Magazie m = StocksDao.getMagazieFromRs(rs);
            result.add(m);
        }
        rs.close();
        return result;
    }

    public static Magazie getMagazieFromRs(ResultSet rs) throws SQLException {
        Magazie m = new Magazie();
        m.setId(rs.getInt("id"));
        m.setLabel(rs.getString("label"));
        m.setContMateriiPrime(rs.getString("cont_materii_prime"));
        m.setContMarfuri(rs.getString("cont_marfuri"));
        m.setContTvaNeexigibil(rs.getString("cont_tva_neexigibil"));
        m.setContAdaos(rs.getString("cont_adaos_comercial"));
        m.setMagazieMarfa(rs.getInt("is_marfa") == 1);
        return m;
    }

    public void deleteMagaziiSectii() throws SQLException {
        this.deleteMagazieSectii.execute();
    }

    public void renameMagazie(String newName, int id) throws SQLException {
        this.renameMagazie.setString(1, newName);
        this.renameMagazie.setInt(2, id);
        this.renameMagazie.execute();
    }

    public void addMagazieSectie(int idMagazie, int idSectie) throws SQLException {
        this.addMagazieSectie.setInt(1, idMagazie);
        this.addMagazieSectie.setInt(2, idSectie);
        this.addMagazieSectie.execute();
    }

    public void addMagazie(String magazie, String contMateriiPrime, String contMarfa, String contTvaNeexigibil, String contAdaosComercial, boolean isMagazieMarfa) throws SQLException {
        this.addMagazie.setString(1, magazie);
        this.addMagazie.setString(2, contMateriiPrime);
        this.addMagazie.setString(3, contMarfa);
        this.addMagazie.setString(4, "");
        this.addMagazie.setString(5, contTvaNeexigibil);
        this.addMagazie.setString(6, contAdaosComercial);
        this.addMagazie.setInt(7, isMagazieMarfa ? 1 : 0);
        this.addMagazie.execute();
    }

    public void updateMagazie(String magazie, String contMateriiPrime, String contMarfa, String contTvaNeexigibil, String contAdaosComercial, boolean isMagazieMarfa, int idMagazie) throws SQLException {
        this.updateMagazie.setString(1, magazie);
        this.updateMagazie.setString(2, contMateriiPrime);
        this.updateMagazie.setString(3, contMarfa);
        this.updateMagazie.setString(4, "");
        this.updateMagazie.setString(5, contTvaNeexigibil);
        this.updateMagazie.setString(6, contAdaosComercial);
        this.updateMagazie.setInt(7, isMagazieMarfa ? 1 : 0);
        this.updateMagazie.setInt(8, idMagazie);
        this.updateMagazie.execute();
    }

    public void updateStockWithUnit(int id, String label, int idUnit, double warning, double critical, boolean descarcaStoc) throws SQLException {
        this.updateStock.setString(1, label);
        this.updateStock.setInt(2, idUnit);
        this.updateStock.setDouble(3, warning);
        this.updateStock.setDouble(4, critical);
        this.updateStock.setInt(5, descarcaStoc ? 1 : 0);
        this.updateStock.setInt(6, id);
        this.updateStock.execute();
    }

    public void updateStockWithEta(int id, int eta) throws SQLException {
        this.updateStockWithEta.setInt(1, eta);
        this.updateStockWithEta.setInt(2, id);
        this.updateStockWithEta.execute();
    }

    public void updatePriceForStock(int idStock, double pret) throws SQLException {
        this.updatePriceForStock.setDouble(1, pret);
        this.updatePriceForStock.setInt(2, idStock);
        this.updatePriceForStock.execute();
    }

    public void deleteStock(int idStock) throws SQLException {
        this.deleteStockById.setInt(1, idStock);
        this.deleteStockById.execute();
    }

    public String getStockName(int idStock) throws SQLException {
        this.getStockNameById.setInt(1, idStock);
        ResultSet rs = this.getStockNameById.executeQuery();
        String result = null;
        if (rs.next()) {
            result = rs.getString("label");
        }
        rs.close();
        return result;
    }

    public void addStock(String label, int idUnit, double warningLevel, double criticalLevel, double pret, boolean descarcaStoc, int zile) throws SQLException {
        this.addStock.setString(1, label);
        this.addStock.setInt(2, idUnit);
        this.addStock.setDouble(3, warningLevel);
        this.addStock.setDouble(4, criticalLevel);
        this.addStock.setDouble(5, pret);
        this.addStock.setInt(6, descarcaStoc ? 1 : 0);
        this.addStock.setInt(7, zile);
        this.addStock.execute();
    }

    public Vector getAllStocks(boolean includeDeleted) throws SQLException {
        Vector<Stock> result = new Vector<Stock>();
        if (includeDeleted) {
            this.selectAllStocks.setInt(1, -1);
        } else {
            this.selectAllStocks.setInt(1, 1);
        }
        ResultSet rs = this.selectAllStocks.executeQuery();
        while (rs.next()) {
            Stock toAdd = this.getStockFromResultSet(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    private Stock getStockFromResultSet(ResultSet rs) throws SQLException {
        int id = rs.getInt("id");
        String name = rs.getString("label");
        int unitId = rs.getInt("id_unit");
        double warningLevel = rs.getDouble("warning_level");
        double criticalLevel = rs.getDouble("critical_level");
        int descarcaStoc = rs.getInt("descarca_stoc");
        String uniqCode = rs.getString("unique_code");
        Stock toAdd = new Stock();
        toAdd.setCriticalLevel(criticalLevel);
        toAdd.setId(id);
        toAdd.setLabel(name);
        toAdd.setIdUnit(unitId);
        toAdd.setWarningLevel(warningLevel);
        toAdd.setUniqueCode(uniqCode);
        toAdd.setDescarcaStoc(descarcaStoc == 1);
        toAdd.setIdTipArticol(rs.getInt("id_tip_articol"));
        toAdd.setStatus(rs.getInt("status"));
        return toAdd;
    }

    public Stock getStock(int idStock) throws SQLException {
        this.selectStockById.setInt(1, idStock);
        ResultSet rs = this.selectStockById.executeQuery();
        Stock s = null;
        if (rs.next()) {
            s = this.getStockFromResultSet(rs);
        }
        rs.close();
        return s;
    }

    public Stock getStockByName(String stock) throws SQLException {
        this.selectStockByName.setString(1, stock);
        ResultSet rs = this.selectStockByName.executeQuery();
        Stock s = null;
        if (rs.next()) {
            s = this.getStockFromResultSet(rs);
        }
        rs.close();
        return s;
    }

    public Stock getStockByCodUnic(String codUnic) throws SQLException {
        this.selectStockByCodUnic.setString(1, codUnic);
        ResultSet rs = this.selectStockByCodUnic.executeQuery();
        Stock s = null;
        if (rs.next()) {
            s = this.getStockFromResultSet(rs);
        }
        rs.close();
        return s;
    }

    public double getDisponibilInMagazie(int idMagazie, int idStock, Timestamp date) throws SQLException {
        double result = 0.0;
        this.getDisponibilInMagazie.setInt(1, idStock);
        this.getDisponibilInMagazie.setInt(2, idMagazie);
        this.getDisponibilInMagazie.setInt(3, idMagazie);
        this.getDisponibilInMagazie.setTimestamp(4, date);
        ResultSet rs = this.getDisponibilInMagazie.executeQuery();
        if (rs.next()) {
            result = rs.getDouble(1);
        }
        rs.close();
        return result;
    }

    public double[] getCantitateInMagazie(int idMagazie, int idStock, Timestamp date, int what) throws SQLException {
        double[] result = new double[3];
        this.getCantitateSiValoareInMagazie.setInt(1, idMagazie);
        this.getCantitateSiValoareInMagazie.setInt(2, idStock);
        int w = -1;
        switch (what) {
            case 2: {
                w = 1;
                break;
            }
            case 3: {
                w = 0;
                break;
            }
            default: {
                w = -1;
            }
        }
        this.getCantitateSiValoareInMagazie.setInt(3, w);
        this.getCantitateSiValoareInMagazie.setInt(4, w);
        this.getCantitateSiValoareInMagazie.setTimestamp(5, date);
        ResultSet rs = this.getCantitateSiValoareInMagazie.executeQuery();
        if (rs.next()) {
            result[0] = rs.getDouble("stock");
            result[1] = rs.getDouble("valoare");
            result[2] = rs.getDouble("valoare_vz");
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, Integer> getStocksSqlInSequenceForBalanta(boolean includeDeleted, int tipProdus, Connection connection, Tag tag) throws SQLException {
        String s = "select  stocks.id as id_stock, coalesce(products.id, -1) as id_product from stocks left outer join produse_finite on (stocks.id = produse_finite.id_stock and produse_finite.status = 1 ) left outer join products on (produse_finite.id_product = products.id  and products.status = 1 )" + (tag != null ? " inner join stocks_tags on (stocks.id = stocks_tags.id_stock and stocks_tags.id_tag = " + tag.getId() + ")" : "") + " where 1 = 1" + (!includeDeleted ? " and stocks.status = 1" : "");
        ResultSet rs = SqlUtils.executeQuery(s, connection);
        Hashtable<Integer, Integer> ids = new Hashtable<Integer, Integer>();
        while (rs.next()) {
            int idStock1 = rs.getInt("id_stock");
            int idProduct = rs.getInt("id_product");
            if (idProduct <= 0 && tipProdus == 2 || idProduct > 0 && tipProdus == 1) continue;
            ids.put(idStock1, idStock1);
        }
        rs.close();
        return ids;
    }

    public Vector<StockViewEntry> getStocksViewsForMagazie(int idMagazie, int idStock, int idCategorie, boolean includeDeleted, int what, String idStocksForFurnizor, int tipStock, Connection connection, double cotaTva, String comandaTypes) throws SQLException {
        boolean innerJoin = idCategorie != -1 || tipStock == 2;
        String joinType = innerJoin ? " inner " : " left outer ";
        String s = "select  stocks.id as id_stock, products.cod_bare from stocks" + (idMagazie != -1 ? " inner join fisa_magazie on stocks.id = fisa_magazie.id_stock" : "") + joinType + " join produse_finite on (stocks.id = produse_finite.id_stock and produse_finite.status = " + 1 + " )" + joinType + " join products on (produse_finite.id_product = products.id  and products.status = " + 1 + " )" + (tipStock == 3 ? " inner join preparate on stocks.id = preparate.id_stock" : "") + " where 1 = 1 " + (idMagazie != -1 ? " and fisa_magazie.id_magazie = " + idMagazie : "") + (!includeDeleted ? " and stocks.status = 1" : "") + (idStock != -1 ? " and (stocks.id = " + idStock + ")" : "") + (idCategorie != -1 ? " and (products.id_subcategory = " + idCategorie + ")" : "") + (idStocksForFurnizor != null ? " and stocks.id in " + idStocksForFurnizor : "") + (tipStock == 1 ? " and stocks.id not in (select id_stock from preparate) and stocks.id not in (select id_stock from produse_finite)" : "");
        ResultSet rs = SqlUtils.executeQuery(s, connection);
        Hashtable<Integer, String> ids = new Hashtable<Integer, String>();
        while (rs.next()) {
            int idStock1 = rs.getInt("id_stock");
            String codBare = rs.getString("cod_bare");
            if (Validators.correctString(codBare)) {
                ids.put(idStock1, codBare);
                continue;
            }
            ids.put(idStock1, "");
        }
        rs.close();
        String inSql = Utils.getSqlInSequence(new Vector(ids.keySet()));
        Vector<Object> quantities = new Vector();
        if (inSql.length() >= 3) {
            quantities = this.getStockQuantitiesForIds(idMagazie, inSql, ids, what, connection, cotaTva, comandaTypes);
        }
        Vector<StockViewEntry> result = new Vector<StockViewEntry>(quantities);
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                StockViewEntry s1 = (StockViewEntry)o1;
                StockViewEntry s2 = (StockViewEntry)o2;
                return s1.getNume().compareToIgnoreCase(s2.getNume());
            }
        });
        return result;
    }

    public Vector<StockViewEntry> getStockQuantitiesForIds(int idMagazie, String idsSqlSequence, Hashtable codBareHash, int what, Connection connection, double cotaTva) throws SQLException {
        return this.getStockQuantitiesForIds(idMagazie, idsSqlSequence, codBareHash, what, connection, cotaTva, "");
    }

    public Vector<StockViewEntry> getStockQuantitiesForIds(int idMagazie, String idsSqlSequence, Hashtable codBareHash, int what, Connection connection, double cotaTva, String comandaTypes) throws SQLException {
        Hashtable<Integer, StockViewEntry> h1 = new Hashtable<Integer, StockViewEntry>();
        String s1 = "select stocks.id as id_stock, stocks.sell_price as pret_vz, stocks.label, stocks.critical_level, stocks.warning_level, stocks.id_unit, messages.label as unit_name from stocks inner join units on stocks.id_unit = units.id inner join keys on units.id_key = keys.id inner join messages on keys.id = messages.id_key where stocks.id in " + idsSqlSequence;
        ResultSet rs = SqlUtils.executeQuery(s1, connection);
        while (rs.next()) {
            int idStoc = rs.getInt("id_stock");
            StockViewEntry svq = new StockViewEntry();
            svq.setIdUnit(rs.getInt("id_unit"));
            svq.setUmName(rs.getString("unit_name"));
            svq.setAlertLevel(rs.getDouble("warning_level"));
            svq.setCriticalLevel(rs.getDouble("critical_level"));
            svq.setNume(rs.getString("label"));
            svq.setPretPv(rs.getDouble("pret_vz"));
            String codBare = (String)codBareHash.get(idStoc);
            svq.setCodBare(codBare);
            h1.put(idStoc, svq);
        }
        rs.close();
        String s2 = "select sum(intrata - iesita) as stock_actual, sum(val_intrata_pa - val_iesita_pa) as val_pa, sum(val_intrata_pv - val_iesita_pv) as val_pv, fisa_magazie.id_magazie, coalesce(magazii.label, '') as magazie, stocks.id as id_stock from stocks" + (idMagazie == -1 ? " left outer " : " inner ") + " join fisa_magazie on stocks.id = fisa_magazie.id_stock" + (idMagazie == -1 ? " left outer " : " inner ") + " join magazii on fisa_magazie.id_magazie = magazii.id" + " where stocks.id in " + idsSqlSequence + (idMagazie != -1 ? " and (fisa_magazie.id_magazie = " + idMagazie + ")" : "") + (comandaTypes != null && comandaTypes != "" ? " and fisa_magazie.comanda_type in " + comandaTypes : "");
        if (what == 2) {
            s2 = s2 + " and fiscal = 1";
        }
        if (what == 3) {
            s2 = s2 + " and fiscal = 0";
        }
        s2 = s2 + " group by fisa_magazie.id_magazie, magazii.label, stocks.id";
        Hashtable<String, StockViewEntry> h2 = new Hashtable<String, StockViewEntry>();
        rs = SqlUtils.executeQuery(s2, connection);
        while (rs.next()) {
            int idStoc = rs.getInt("id_stock");
            StockViewEntry svq1 = (StockViewEntry)h1.get(idStoc);
            if (svq1 == null) {
                svq1 = new StockViewEntry();
                svq1.setNume("IMPOSSIBLE!!");
            }
            StockViewEntry svq = new StockViewEntry();
            svq.setIdUnit(svq1.getIdUnit());
            svq.setUmName(svq1.getUmName());
            svq.setAlertLevel(svq1.getAlertLevel());
            svq.setCriticalLevel(svq1.getCriticalLevel());
            svq.setNume(svq1.getNume());
            svq.setPretPv(svq1.getPretPv());
            int magazieCurenta = rs.getInt("id_magazie");
            svq.setStocActual(rs.getDouble("stock_actual"));
            svq.setIdMagazie(magazieCurenta);
            svq.setIdStock(idStoc);
            svq.setValoarePa(rs.getDouble("val_pa"));
            svq.setMagazie(rs.getString("magazie"));
            String codBare = (String)codBareHash.get(idStoc);
            svq.setCodBare(codBare);
            if (Validators.correctString(codBare)) {
                double valVz = rs.getDouble("val_pv");
                svq.setValoarePv(valVz);
                svq.setValVzString(Utils.getString2Decimals(svq.getValoarePv()));
                double profit = svq.getValoarePv() / (1.0 + cotaTva) - svq.getValoarePa();
                svq.setProfit(profit);
                double adaos = profit / svq.getValoarePa() * 100.0;
                svq.setAdaosProcent(adaos);
            } else {
                svq.setValVzString("");
                svq.setValoarePv(0.0);
                svq.setPretPv(0.0);
            }
            StockLogic.getInstance().computeStockViewEntry(svq);
            h2.put(idStoc + "_" + magazieCurenta, svq);
        }
        rs.close();
        return new Vector<StockViewEntry>(h2.values());
    }

    public Vector getStocksReport(Hashtable criteria, Connection connection) throws SQLException {
        Vector<StockEntry> result = new Vector<StockEntry>();
        String s = "select stock_magazii.quantity as quantity, stocks.label as label, messages.label as u_label  from stock_magazii inner join stocks on (stock_magazii.id_stock = stocks.id and stocks.status = 1) inner join units on stocks.id_unit = units.id inner join keys on units.id_key = keys.id inner join messages on keys.id = messages.id_key";
        Integer lang = (Integer)criteria.get("langId");
        s = s + " where messages.id_lang = " + lang;
        Integer magazie = (Integer)criteria.get("magazieId");
        if (magazie != null) {
            s = s + " and stock_magazii.id_magazie = " + magazie;
        }
        s = s + " order by stocks.label";
        ResultSet rs = SqlUtils.executeQuery(s, connection);
        while (rs.next()) {
            StockEntry entry = new StockEntry();
            entry.setCategory("Magazie");
            entry.setStock(rs.getString("label"));
            double q = rs.getDouble("quantity");
            entry.setQuantity(q);
            entry.setUm(rs.getString("u_label"));
            result.add(entry);
        }
        rs.close();
        return result;
    }

    public double[] getStocValoricLaData(String sqlIn, int idMagazie, Timestamp data, int what, Connection connection) throws SQLException {
        ResultSet rs;
        double[] result = new double[2];
        String s = "select sum(val_intrata_pa - val_iesita_pa) as val_pa, sum(val_intrata_pv - val_iesita_pv) as val_pv from fisa_magazie where id_stock in " + sqlIn;
        if (what == 2) {
            s = s + " and fiscal = 1";
        }
        if (what == 3) {
            s = s + " and fiscal = 0";
        }
        if (idMagazie > 0) {
            s = s + " and id_magazie = " + idMagazie;
        }
        if ((rs = SqlUtils.executeQuery(s = s + " and time_document < '" + data + "'", connection)).next()) {
            result[0] = rs.getDouble("val_pa");
            result[1] = rs.getDouble("val_pv");
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, StockBean> getStocLaData(String sqlIn, int idMagazie, Timestamp data, int what, Connection connection) throws SQLException {
        Hashtable<Integer, StockBean> result = new Hashtable<Integer, StockBean>();
        String s = "select sum(intrata - iesita) as cantitate, sum(val_intrata_pa - val_iesita_pa) as val_pa, sum(val_intrata_pv - val_iesita_pv) as val_pv, id_stock, stocks.label as produs from fisa_magazie inner join stocks on fisa_magazie.id_stock = stocks.id where id_stock in " + sqlIn;
        if (what == 2) {
            s = s + " and fiscal = 1";
        }
        if (what == 3) {
            s = s + " and fiscal = 0";
        }
        s = s + " and comanda_type = " + StockLogic.COMANDA_TYPE.EFECTUAT.getIdTip();
        if (idMagazie > 0) {
            s = s + " and id_magazie = " + idMagazie;
        }
        s = s + " and time_document < '" + data + "'" + " group by id_stock, stocks.label";
        ResultSet rs = SqlUtils.executeQuery(s, connection);
        while (rs.next()) {
            StockBean toAdd = new StockBean();
            toAdd.setCantitate(rs.getDouble("cantitate"));
            toAdd.setAchizitie(rs.getDouble("val_pa"));
            toAdd.setVanzare(rs.getDouble("val_pv"));
            toAdd.setProdus(rs.getString("produs"));
            int id = rs.getInt("id_stock");
            toAdd.setIdStock(id);
            result.put(id, toAdd);
        }
        rs.close();
        return result;
    }

    public double[][] getMiscariIntreDate(int idStock, int idMagazie, Timestamp dateStart, Timestamp dateStop) throws SQLException {
        this.getMiscariIntreDate.setInt(1, idMagazie);
        this.getMiscariIntreDate.setTimestamp(2, dateStart);
        this.getMiscariIntreDate.setTimestamp(3, dateStop);
        this.getMiscariIntreDate.setInt(4, idStock);
        this.getMiscariIntreDate.setInt(5, idStock);
        double[][] result = new double[2][3];
        ResultSet rs = this.getMiscariIntreDate.executeQuery();
        if (rs.next()) {
            result[0][0] = rs.getDouble("intrare");
            result[1][0] = rs.getDouble("iesire");
            result[0][1] = rs.getDouble("val_intrare_pa");
            result[0][2] = rs.getDouble("val_intrare_pv");
            result[1][1] = rs.getDouble("val_iesire_pa");
            result[1][2] = rs.getDouble("val_iesire_pv");
        }
        rs.close();
        return result;
    }

    public double[][] getMiscariIntreDateForExportConta(int idMagazie, Timestamp dateStart, Timestamp dateStop, String tipDocument, Connection conn) throws SQLException {
        String s = "select sum(intrata) as intrare, sum(iesita) as iesire, sum(val_intrata_pa) as val_intrare_pa, sum(val_intrata_pv) as val_intrare_pv, sum(val_iesita_pa) as val_iesire_pa, sum(val_iesita_pv) as val_iesire_pv from fisa_magazie where id_magazie = " + idMagazie + " and time_document >= '" + dateStart + "'" + " and time_document < '" + dateStop + "'" + " and type_document in (" + tipDocument + ")";
        double[][] result = new double[2][3];
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        if (rs.next()) {
            result[0][0] = rs.getDouble("intrare");
            result[1][0] = rs.getDouble("iesire");
            result[0][1] = rs.getDouble("val_intrare_pa");
            result[0][2] = rs.getDouble("val_intrare_pv");
            result[1][1] = rs.getDouble("val_iesire_pa");
            result[1][2] = rs.getDouble("val_iesire_pv");
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, Double> getConsumuri(String sqlInSequence, int idMagazie, Timestamp dateStart, Timestamp dateStop, Connection conn) throws SQLException {
        Hashtable<Integer, Double> result = new Hashtable<Integer, Double>();
        String s = "select sum(iesita) as consum, id_stock from fisa_magazie where id_stock in " + sqlInSequence;
        if (idMagazie != -1) {
            s = s + " and id_magazie = " + idMagazie;
        }
        s = s + " and time_document >= '" + dateStart + "'" + " and time_document <= " + "'" + dateStop + "'" + " and type_document = " + 3 + " group by id_stock";
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        while (rs.next()) {
            int idStoc = rs.getInt("id_stock");
            result.put(idStoc, rs.getDouble("consum"));
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, RaportGestiuneEntry> getStockNamesForBalanta(String sqlInSequence, int idLang, Connection conn) throws SQLException {
        String s = "select stocks.label as nume_stoc, stocks.id as id_stock, messages.label as unitate_masura, string_agg(products_barcodes.barcode, ', ' order by barcode) as cod_bare from stocks inner join units on stocks.id_unit = units.id inner join keys on units.id_key = keys.id inner join messages on keys.id = messages.id_key left outer join produse_finite on stocks.id = produse_finite.id_stock left outer join products_barcodes on produse_Finite.id_product = products_barcodes.id_product where messages.id_lang = " + idLang + " group by stocks.label, stocks.id, messages.label";
        Hashtable<Integer, RaportGestiuneEntry> result = new Hashtable<Integer, RaportGestiuneEntry>();
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        while (rs.next()) {
            int idStock = rs.getInt("id_stock");
            RaportGestiuneEntry rge = new RaportGestiuneEntry();
            rge.setUm(rs.getString("unitate_masura"));
            rge.setProdus(rs.getString("nume_stoc"));
            rge.setIdStoc(idStock);
            String cod_bare = rs.getString("cod_bare");
            if (cod_bare != null) {
                rge.setProductLine2(cod_bare);
            }
            result.put(idStock, rge);
        }
        rs.close();
        return result;
    }

    public Vector getMiscariValoriceIntreDateForRaportGestiuneValorica(String sqlInSequence, int idMagazie, Timestamp dateStart, Timestamp dateStop, String tipDocument, int what, Connection conn) throws SQLException {
        Vector<RaportGestiuneValoricaEntry> result = new Vector<RaportGestiuneValoricaEntry>();
        String s = "select sum(val_intrata_pa) as val_intrare_pa, sum(val_intrata_pv) as val_intrare_pv, sum(val_iesita_pa) as val_iesire_pa, sum(val_iesita_pv) as val_iesire_pv, date(time_document) as data from fisa_magazie where id_stock in " + sqlInSequence;
        if (what == 2) {
            s = s + " and fiscal = 1";
        }
        if (what == 3) {
            s = s + " and fiscal = 0";
        }
        s = s + " and comanda_type = " + StockLogic.COMANDA_TYPE.EFECTUAT.getIdTip();
        s = s + " and id_magazie = " + idMagazie + " and time_document >= '" + dateStart + "'" + " and time_document < '" + dateStop + "'" + " and type_document in (" + tipDocument + ")" + " group by date(time_document)" + " order by date(time_document)";
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        while (rs.next()) {
            RaportGestiuneValoricaEntry rge = new RaportGestiuneValoricaEntry("Tranzactii", rs.getDouble("val_intrare_pa"), rs.getDouble("val_iesire_pa"), rs.getDouble("val_intrare_pv"), rs.getDouble("val_iesire_pv"), rs.getDate("data"));
            result.add(rge);
        }
        rs.close();
        return result;
    }

    public Hashtable<Integer, MIscariStockBean> getMiscariIntreDateForBalanta(String sqlInSequence, int idMagazie, Timestamp dateStart, Timestamp dateStop, String tipDocument, int what, Connection conn) throws SQLException {
        Hashtable<Integer, MIscariStockBean> result = new Hashtable<Integer, MIscariStockBean>();
        String s = "select sum(intrata) as intrare, sum(iesita) as iesire, sum(val_intrata_pa) as val_intrare_pa, sum(val_intrata_pv) as val_intrare_pv, sum(val_iesita_pa) as val_iesire_pa, sum(val_iesita_pv) as val_iesire_pv, id_stock from fisa_magazie where id_stock in " + sqlInSequence;
        if (what == 2) {
            s = s + " and fiscal = 1";
        }
        if (what == 3) {
            s = s + " and fiscal = 0";
        }
        s = s + " and comanda_type = " + StockLogic.COMANDA_TYPE.EFECTUAT.getIdTip();
        s = s + " and id_magazie = " + idMagazie + " and time_document >= '" + dateStart + "'" + " and time_document < '" + dateStop + "'" + " and type_document in (" + tipDocument + ")" + " group by id_stock";
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        while (rs.next()) {
            MIscariStockBean msb = new MIscariStockBean();
            msb.setIntrare(rs.getDouble("intrare"));
            msb.setIesire(rs.getDouble("iesire"));
            msb.setValIntrareAcz(rs.getDouble("val_intrare_pa"));
            msb.setValIntrareVz(rs.getDouble("val_intrare_pv"));
            msb.setValIesireAcz(rs.getDouble("val_iesire_pa"));
            msb.setValIesireVz(rs.getDouble("val_iesire_pv"));
            result.put(rs.getInt("id_stock"), msb);
        }
        rs.close();
        return result;
    }

    public double getCatalogPriceForStock(int idStock) throws SQLException {
        double result = -1.0;
        this.getCatalogPriceForStock.setInt(1, idStock);
        ResultSet rs = this.getCatalogPriceForStock.executeQuery();
        if (rs.next()) {
            result = rs.getDouble(1);
        }
        rs.close();
        return result;
    }

    public static StockTransferItem getTransferItemFromResultSet(ResultSet rs) throws SQLException {
        StockTransferItem st = new StockTransferItem();
        st.setQuantity(rs.getDouble("quantity"));
        st.setSellPrice(rs.getDouble("sell_price"));
        st.setBuyPrice(rs.getDouble("buy_price"));
        st.setDenumire(rs.getString("nume_stock"));
        st.setId(rs.getInt("id"));
        st.setIdStock(rs.getInt("id_stock"));
        st.setIdTransfer(rs.getInt("id_transfer"));
        st.setUm(rs.getString("unitate_masura"));
        st.setIdLot(rs.getInt("id_lot"));
        return st;
    }

    private StockTransfer getTransferFromResultSet(ResultSet rs) throws SQLException {
        StockTransfer st = new StockTransfer();
        st.setTimp(rs.getTimestamp("time_transfer"));
        st.setDestinatie(rs.getString("destinatie"));
        st.setSursa(rs.getString("sursa"));
        st.setId(rs.getInt("id"));
        st.setIdDestinatie(rs.getInt("id_destinatie"));
        st.setIdSource(rs.getInt("id_sursa"));
        st.setValPa(rs.getDouble("val_pa"));
        st.setValPv(rs.getDouble("total_pv"));
        st.setPretAczFix(rs.getInt("pret_acz_fix") == 1);
        int tip = rs.getInt("tip");
        st.setTipTransfer(tip);
        st.setNrBon(rs.getInt("nr_bon"));
        String tipString = StockLogic.getInstance().getStringTip(tip);
        st.setTipTransferString(tipString);
        return st;
    }

    public Vector getBonConsumItemsForBonConsum(int idBonConsum) throws SQLException {
        Vector result = new Vector();
        return result;
    }

    public Vector<StockTransferItem> getTransferItemsForTransfer(int idTransfer) throws SQLException {
        Vector<StockTransferItem> result = new Vector<StockTransferItem>();
        this.getTransfItemsForTransfer.setInt(1, idTransfer);
        ResultSet rs = this.getTransfItemsForTransfer.executeQuery();
        while (rs.next()) {
            StockTransferItem sti = StocksDao.getTransferItemFromResultSet(rs);
            result.add(sti);
        }
        rs.close();
        return result;
    }

    public StockTransferItem getTransferItemById(int idTransferItem) throws SQLException {
        StockTransferItem result = null;
        this.getTransfItemById.setInt(1, idTransferItem);
        ResultSet rs = this.getTransfItemById.executeQuery();
        if (rs.next()) {
            result = StocksDao.getTransferItemFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Corectie getCorectie(int id) throws SQLException {
        Corectie result = null;
        this.getCorectieById.setInt(1, id);
        ResultSet rs = this.getCorectieById.executeQuery();
        if (rs.next()) {
            result = new Corectie();
            result.setDateadd(rs.getTimestamp("dateadd"));
            result.setIdMagazie(rs.getInt("id_magazie"));
            result.setId(id);
        }
        rs.close();
        return result;
    }

    public Vector<BonConsumItem> getCorectieItems(int idCorectie, int idStock) throws SQLException {
        Vector<BonConsumItem> result = new Vector<BonConsumItem>();
        this.getCorectieItemsByIdCorectie.setInt(1, idCorectie);
        this.getCorectieItemsByIdCorectie.setInt(2, idStock);
        this.getCorectieItemsByIdCorectie.setInt(3, idStock);
        ResultSet rs = this.getCorectieItemsByIdCorectie.executeQuery();
        while (rs.next()) {
            BonConsumItem bci = new BonConsumItem();
            bci.setCantitate(rs.getDouble("quantity"));
            bci.setIdStock(rs.getInt("id_stock"));
            bci.setfMode(rs.getInt("f_mode"));
            result.add(bci);
        }
        rs.close();
        return result;
    }

    public BonConsum getBonConsum(int idBonConsum) throws SQLException {
        BonConsum result = null;
        this.getBonConsumById.setInt(1, idBonConsum);
        ResultSet rs = this.getBonConsumById.executeQuery();
        if (rs.next()) {
            result = this.getBCFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Vector getBonuriConsum(int idMagazie, Timestamp startTime, Timestamp stopTime) throws SQLException {
        Vector<BonConsum> result = new Vector<BonConsum>();
        this.getBonuriConsum.setInt(1, idMagazie);
        this.getBonuriConsum.setInt(2, idMagazie);
        this.getBonuriConsum.setTimestamp(3, startTime);
        this.getBonuriConsum.setTimestamp(4, stopTime);
        ResultSet rs = this.getBonuriConsum.executeQuery();
        while (rs.next()) {
            BonConsum bc = this.getBCFromResultSet(rs);
            result.add(bc);
        }
        rs.close();
        return result;
    }

    private BonConsum getBCFromResultSet(ResultSet rs) throws SQLException {
        BonConsum bc = new BonConsum();
        bc.setDateadd(rs.getTimestamp("dateadd"));
        bc.setIdMagazie(rs.getInt("id_magazie"));
        bc.setTotal(rs.getDouble("total"));
        bc.setMagazie(rs.getString("magazie"));
        bc.setNrBonConsum(rs.getInt("nr_bon_consum"));
        bc.setId(rs.getInt("id"));
        bc.setObservatii(rs.getString("observatii"));
        return bc;
    }

    public Vector<StockTransfer> getTransferuri(int idSource, int idDestinatie, Timestamp startTime, Timestamp stopTime, int tipTransfer) throws SQLException {
        Vector<StockTransfer> result = new Vector<StockTransfer>();
        this.getTransferuri.setInt(1, idSource);
        this.getTransferuri.setInt(2, idSource);
        this.getTransferuri.setInt(3, idDestinatie);
        this.getTransferuri.setInt(4, idDestinatie);
        this.getTransferuri.setTimestamp(5, startTime);
        this.getTransferuri.setTimestamp(6, stopTime);
        this.getTransferuri.setInt(7, tipTransfer);
        this.getTransferuri.setInt(8, tipTransfer);
        ResultSet rs = this.getTransferuri.executeQuery();
        while (rs.next()) {
            StockTransfer st = this.getTransferFromResultSet(rs);
            result.add(st);
        }
        rs.close();
        return result;
    }

    public StockTransfer getTransferById(int idTransfer) throws SQLException {
        StockTransfer result = null;
        this.getTransferById.setInt(1, idTransfer);
        ResultSet rs = this.getTransferById.executeQuery();
        if (rs.next()) {
            result = this.getTransferFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Vector getStockConsumByFisaIntrare(int idFisaIntrare) throws SQLException {
        this.getStockConsumByIdFisaIntrare.setInt(1, idFisaIntrare);
        Vector<StockConsum> result = new Vector<StockConsum>();
        ResultSet rs = this.getStockConsumByIdFisaIntrare.executeQuery();
        while (rs.next()) {
            StockConsum sc = new StockConsum();
            sc.setIdFisaSursa(rs.getInt("id_fisa_sursa"));
            sc.setQuantity(rs.getDouble("quantity"));
            sc.setIdConsum(rs.getInt("id"));
            sc.setDataConsum(rs.getTimestamp("time_consum"));
            result.add(sc);
        }
        rs.close();
        return result;
    }

    private FisaIntrareSimple getFisaIntrareSimpleFromRS(ResultSet rs) throws SQLException {
        FisaIntrareSimple toAdd = new FisaIntrareSimple();
        toAdd.setPretAcz(rs.getDouble("buy_price"));
        toAdd.setStoc(rs.getDouble("intrata"));
        toAdd.setData(rs.getTimestamp("time_document"));
        toAdd.setId(rs.getInt("id"));
        return toAdd;
    }

    public Vector getFiseIntrareSortateInversPanaLaData(int idStock, int idMagazie, Timestamp data) throws SQLException {
        Vector<FisaIntrareSimple> result = new Vector<FisaIntrareSimple>();
        this.getFiseIntrareSortateInversPanaLaData.setInt(1, idStock);
        this.getFiseIntrareSortateInversPanaLaData.setInt(2, idMagazie);
        this.getFiseIntrareSortateInversPanaLaData.setTimestamp(3, data);
        ResultSet rs = this.getFiseIntrareSortateInversPanaLaData.executeQuery();
        while (rs.next()) {
            FisaIntrareSimple toAdd = this.getFisaIntrareSimpleFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector getFiseIntrareSortateInversDupaData(int idStock, int idMagazie, Timestamp data) throws SQLException {
        Vector<FisaIntrareSimple> result = new Vector<FisaIntrareSimple>();
        this.getFiseIntrareSortateInversDupaData.setInt(1, idStock);
        this.getFiseIntrareSortateInversDupaData.setInt(2, idMagazie);
        this.getFiseIntrareSortateInversDupaData.setTimestamp(3, data);
        ResultSet rs = this.getFiseIntrareSortateInversDupaData.executeQuery();
        while (rs.next()) {
            FisaIntrareSimple toAdd = this.getFisaIntrareSimpleFromRS(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Vector<FisaIntrareActiva> getFiseIntrareActive(Timestamp date, int idStock, int idMagazie, double minim, int idLot) throws SQLException {
        Vector<FisaIntrareActiva> result = new Vector<FisaIntrareActiva>();
        this.getFiseIntrareActive.setInt(1, idStock);
        this.getFiseIntrareActive.setInt(2, idMagazie);
        this.getFiseIntrareActive.setInt(3, idMagazie);
        this.getFiseIntrareActive.setTimestamp(4, date);
        this.getFiseIntrareActive.setDouble(5, minim);
        this.getFiseIntrareActive.setInt(6, idLot);
        this.getFiseIntrareActive.setInt(7, idLot);
        ResultSet rs = this.getFiseIntrareActive.executeQuery();
        while (rs.next()) {
            FisaIntrareActiva fa = this.getFisaIntrareActivaFromRs(rs);
            result.add(fa);
        }
        rs.close();
        return result;
    }

    private FisaIntrareActiva getFisaIntrareActivaFromRs(ResultSet rs) throws SQLException {
        FisaIntrareActiva fa = new FisaIntrareActiva();
        fa.setBuyPrice(rs.getDouble("buy_price"));
        fa.setIdMagazie(rs.getInt("id_magazie"));
        fa.setDisponibil(rs.getDouble("disponibil"));
        fa.setIdStock(rs.getInt("id_stock"));
        fa.setIdFisa(rs.getInt("id_fisa"));
        fa.setCodBare(rs.getString("cod_bare"));
        fa.setDenumireLaFurnizor(rs.getString("denumire_la_furnizor"));
        fa.setTimestamp(rs.getTimestamp("add_time"));
        return fa;
    }

    public Vector getConsum(Date startDate, Date stopDate, int idLang, int typeDocument, int idMagazie, Connection connection) throws SQLException {
        String s = "select sum(stock_consum.quantity) as cantitate, fisa_magazie.id_stock as id_stock, fisa_magazie.buy_price as buy_price, stocks.label as denumire, messages.label as unitate_masura from stock_consum inner join fisa_magazie on stock_consum.id_fisa_sursa = fisa_magazie.id inner join stocks on fisa_magazie.id_stock = stocks.id inner join units on stocks.id_unit = units.id inner join keys on units.id_key = keys.id inner join messages on keys.id = messages.id_key where messages.id_lang = " + idLang;
        s = s + " and time_consum >= '" + new Timestamp(startDate.getTime()) + "'";
        s = s + " and time_consum < '" + new Timestamp(stopDate.getTime()) + "'";
        if (typeDocument != -1) {
            s = s + " and type_document = " + typeDocument;
        }
        if (idMagazie != -1) {
            s = s + " and fisa_magazie.id_magazie = " + idMagazie;
        }
        s = s + " group by fisa_magazie.buy_price, fisa_magazie.id_stock, stocks.label, messages.label order by stocks.label";
        Logger.logDebugVerbose(this, "executing query : " + s);
        ResultSet rs = SqlUtils.executeQuery(s, connection);
        Vector<ConsumEntry> result = new Vector<ConsumEntry>();
        while (rs.next()) {
            ConsumEntry pe = new ConsumEntry();
            pe.setCantitate(rs.getDouble("cantitate"));
            pe.setDenumire(rs.getString("denumire"));
            pe.setIdStock(rs.getInt("id_stock"));
            pe.setPretAchizitie(rs.getDouble("buy_price"));
            pe.setUnitateMasura(rs.getString("unitate_masura"));
            pe.compute();
            result.add(pe);
        }
        rs.close();
        return result;
    }

    public Vector<Corectie> getCorectiiForMagazie(int idMagazie, Timestamp start, Timestamp stop) throws SQLException {
        Vector<Corectie> result = new Vector<Corectie>();
        this.getCorectiiForMagazie.setInt(1, idMagazie);
        this.getCorectiiForMagazie.setInt(2, idMagazie);
        this.getCorectiiForMagazie.setTimestamp(3, start);
        this.getCorectiiForMagazie.setTimestamp(4, stop);
        ResultSet rs = this.getCorectiiForMagazie.executeQuery();
        while (rs.next()) {
            Corectie c = new Corectie();
            c.setDateadd(rs.getTimestamp("dateadd"));
            c.setId(rs.getInt("id"));
            c.setIdMagazie(rs.getInt("id_magazie"));
            result.add(c);
        }
        rs.close();
        return result;
    }

    public void updateUniqueCodeForStock(int idStock, String cod) throws SQLException {
        this.updateUniqueCodeForStock.setString(1, cod);
        this.updateUniqueCodeForStock.setInt(2, idStock);
        this.updateUniqueCodeForStock.execute();
    }

    public int getLastNrBonConsum() throws SQLException {
        ResultSet rs = this.getLastNrBonConsum.executeQuery();
        int result = 0;
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void deleteFisaMagazieForStockAndDate(int idStock, Timestamp date) throws SQLException {
        this.deleteFisaMagazieForStockAndDate.setInt(1, idStock);
        this.deleteFisaMagazieForStockAndDate.setTimestamp(2, date);
        this.deleteFisaMagazieForStockAndDate.execute();
    }

    public void updateStockWithWarningAndCriticalLevel(int cod, double warningLevel, double criticalLevel) throws SQLException {
        this.updateStockWithWarningAndCriticalLevel.setDouble(1, warningLevel);
        this.updateStockWithWarningAndCriticalLevel.setDouble(2, criticalLevel);
        this.updateStockWithWarningAndCriticalLevel.setInt(3, cod);
        this.updateStockWithWarningAndCriticalLevel.executeUpdate();
    }

    public double getDisponibilMagazieForStock(int idStock, StockLogic.COMANDA_TYPE comandaType) throws SQLException {
        Double result = null;
        this.getDisponibilMagazieForStock.setInt(1, idStock);
        this.getDisponibilMagazieForStock.setInt(2, comandaType.getIdTip());
        ResultSet rs = this.getDisponibilMagazieForStock.executeQuery();
        if (rs.next()) {
            result = rs.getDouble("disponibil");
        }
        return result;
    }

    public Vector<IesireProdusFacturiEmise> getIesiriProduseFacturiEmise(int idProdus, int idClient, Timestamp start, Timestamp stop, int comandaType) throws SQLException {
        Vector<IesireProdusFacturiEmise> result = new Vector<IesireProdusFacturiEmise>();
        this.getIesiriProduseFacturiEmise.setInt(1, idProdus);
        this.getIesiriProduseFacturiEmise.setInt(2, idProdus);
        this.getIesiriProduseFacturiEmise.setInt(3, idClient);
        this.getIesiriProduseFacturiEmise.setInt(4, idClient);
        this.getIesiriProduseFacturiEmise.setTimestamp(5, start);
        this.getIesiriProduseFacturiEmise.setTimestamp(6, stop);
        this.getIesiriProduseFacturiEmise.setInt(7, comandaType);
        this.getIesiriProduseFacturiEmise.setInt(8, comandaType);
        ResultSet rs = this.getIesiriProduseFacturiEmise.executeQuery();
        while (rs.next()) {
            IesireProdusFacturiEmise iesireFisa = this.getIesireProdusFacturiEmiseFromRs(rs);
            result.add(iesireFisa);
        }
        return result;
    }

    public IesireProdusFacturiEmise getIesireProdusFacturiEmiseFromRs(ResultSet rs) throws SQLException {
        IesireProdusFacturiEmise iesire = new IesireProdusFacturiEmise();
        double quantity = rs.getDouble("quantity");
        iesire.setCantitate(quantity);
        double ppu = rs.getDouble("sell_price");
        iesire.setPpu(ppu);
        iesire.setSerieFactura(rs.getString("serie_factura"));
        iesire.setNumarFactura(rs.getInt("numar"));
        iesire.setProdus(rs.getString("produs"));
        iesire.setIdClient(rs.getInt("idclient"));
        iesire.setIdFactura(rs.getInt("idfactura"));
        iesire.setNumePersFizica(rs.getString("numepf"));
        iesire.setNumePersJuridica(rs.getString("numepj"));
        iesire.setData(rs.getTimestamp("dateadd"));
        iesire.setValoare(quantity * ppu);
        int idCtype = rs.getInt("comanda_type");
        iesire.setComandaType(StockLogic.getInstance().getComandaTypeById(idCtype));
        return iesire;
    }

    public Hashtable<Integer, Double> getCantitateIesiriProduseFacturiEmise(Order o) throws SQLException {
        Hashtable<Integer, Double> result = new Hashtable<Integer, Double>();
        String query = "select facturi_emise_items.id_product, sum(facturi_emise_items.quantity) as total from documente inner join facturi_emise on facturi_emise.id = documente.id_factura_emisa inner join facturi_emise_items on facturi_emise_items.id_factura = facturi_emise.id inner join facturi_emise_orders on facturi_emise_orders.id_factura = facturi_emise.id inner join orders on orders.id = facturi_emise_orders.id_order where orders.id = " + o.getId() + " and documente.comanda_type = 2" + " and orders.status = 5" + " group by facturi_emise_items.id_product";
        ResultSet rs = SqlUtils.executeQuery(query, this.connection);
        while (rs.next()) {
            int id_product = rs.getInt("id_product");
            double total = rs.getDouble("total");
            result.put(id_product, total);
        }
        return result;
    }

    public InformatieMagazieProdus getInfoMagazieForProdus(int idStock) throws SQLException {
        this.selectInMagazie.setInt(1, idStock);
        this.selectComenziFerme.setInt(1, idStock);
        this.selectComandat.setInt(1, idStock);
        InformatieMagazieProdus info = new InformatieMagazieProdus();
        info.setIdStock(idStock);
        ResultSet rs1 = this.selectInMagazie.executeQuery();
        double magazie = 0.0;
        if (rs1.next()) {
            magazie = rs1.getDouble("magazie");
        }
        rs1.close();
        ResultSet rs2 = this.selectComenziFerme.executeQuery();
        double comenziferme = 0.0;
        if (rs2.next()) {
            comenziferme = rs2.getDouble("comenziferme");
        }
        rs2.close();
        ResultSet rs3 = this.selectComandat.executeQuery();
        double comandat = 0.0;
        if (rs3.next()) {
            comandat = rs3.getDouble("comandat");
        }
        rs3.close();
        info.setInMagazie(magazie);
        info.setComenziFerme(comenziferme);
        info.setComandat(comandat);
        return info;
    }

    public void setValutaForStock(int idStock, int idValuta) throws SQLException {
        if (idValuta == Valuta.mostenitaDinCategorie) {
            this.setValutaForStock.setNull(1, 4);
        } else {
            this.setValutaForStock.setInt(1, idValuta);
        }
        this.setValutaForStock.setInt(2, idStock);
        this.setValutaForStock.execute();
    }

    public Integer getIdValutaForStock(int idStock) throws SQLException {
        Integer result = -1;
        ResultSet rs = SqlUtils.executeQuery("select id_valuta from stocks where id = " + idStock, this.connection);
        if (rs.next()) {
            Integer id_valuta = rs.getInt("id_valuta");
            result = id_valuta != 0 ? id_valuta : Integer.valueOf(Valuta.mostenitaDinCategorie);
        }
        rs.close();
        return result;
    }

    public Integer getIdClientiFromFisaMagazie(int idFisaMagazie) throws SQLException {
        Integer result = -1;
        this.getIdClientiFromFisaMagazie.setInt(1, idFisaMagazie);
        ResultSet rs = this.getIdClientiFromFisaMagazie.executeQuery();
        if (rs.next()) {
            Integer idClient = rs.getInt("id_client");
            result = idClient != 0 ? idClient : Integer.valueOf(rs.getInt("id_furnizor"));
        }
        return result;
    }

    public Vector<String> getDistinctStocksInTransfer() throws SQLException {
        Vector<String> result = new Vector<String>();
        ResultSet rs = this.getDistinctStocksInTransfer.executeQuery();
        while (rs.next()) {
            String produs = rs.getString("produs");
            result.add(produs);
        }
        rs.close();
        return result;
    }

    public Vector<StockTransferWebBean> getAllStockTransferInPeriod(String product, Timestamp start, Timestamp finish) throws SQLException {
        Vector<StockTransferWebBean> result = new Vector<StockTransferWebBean>();
        this.getAllStockTransferInPeriod.setTimestamp(1, start);
        this.getAllStockTransferInPeriod.setTimestamp(2, finish);
        this.getAllStockTransferInPeriod.setString(3, "%" + product + "%");
        this.getAllStockTransferInPeriod.setString(4, product);
        ResultSet rs = this.getAllStockTransferInPeriod.executeQuery();
        while (rs.next()) {
            StockTransferWebBean bean = new StockTransferWebBean();
            bean.setIdStock(rs.getInt("id_stock"));
            bean.setProduct(rs.getString("label"));
            bean.setDate(rs.getTimestamp("time_transfer"));
            bean.setImgLocation(rs.getString("img_src"));
            bean.setSursa(rs.getString("sursa"));
            bean.setDestinatie(rs.getString("destinatie"));
            bean.setUser(rs.getString("user"));
            bean.setCantitate(rs.getDouble("cantitate"));
            result.add(bean);
        }
        rs.close();
        return result;
    }
}

