/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.CerereAprovizionareEntry;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.RaportGestiuneEntry;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.documente.TipDocument;
import ro.atreides.utils.gui.DateSelector;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class AddCerereAprovizionarePanel
extends JPanel {
    private Hashtable printCriteria = new Hashtable();
    private JDialog dialog;
    private int produsDeComandat;
    private Magazie magazie;
    private DateSelector dateSelector;
    private JTextField nrZileAprovizionare;
    private JTextField existentMagazie;
    private JTextField existentTotal;
    private JTextField consumReferinta;
    private JTextField dejaComandat;
    private JTextField medieComanda;
    private JTextField recomandatMinim;
    private JTextField recomandatMaxim;
    private JTextField comandaAcum;

    private Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        if (this.magazie != null) {
            result.put("id_magazie", this.magazie.getId());
            this.printCriteria.put("Magazie", this.magazie.getId());
        } else {
            result.put("id_magazie", -1);
            this.printCriteria.remove("Magazie");
        }
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        result.put("finit_ingredient", -1);
        Vector<TipDocument> selected = RestLogic.getInstance().getAllTipDocumentForConsum();
        String printString = "";
        String dbString = "";
        for (int i = 0; i < selected.size(); ++i) {
            TipDocument tipDocument = selected.elementAt(i);
            printString = printString + tipDocument;
            dbString = dbString + tipDocument.getTip();
            if (i >= selected.size() - 1) continue;
            printString = printString + ",";
            dbString = dbString + ",";
        }
        result.put("tip_document", dbString);
        this.printCriteria.put("tip_document", printString);
        return result;
    }

    public AddCerereAprovizionarePanel(int produsDeComandat, Magazie magazie) {
        this.produsDeComandat = produsDeComandat;
        this.magazie = magazie;
        this.display();
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public void display() {
        this.setLayout((LayoutManager)new MigLayout(""));
        this.add(new JLabel(Utils.getTranslation(LangRoAll.nrZileAprovizionare, new String[0])));
        this.nrZileAprovizionare = new JTextField(5);
        this.add(this.nrZileAprovizionare);
        this.add(new JLabel(Utils.getTranslation(LangRoAll.aprovizionareReferintaLabel, new String[0])));
        this.dateSelector = new DateSelector();
        Date endDate = DateUtils.getEndOfDay(DateUtils.addDaysToDate(new Date(), -1));
        Date startDate = DateUtils.addDaysToDate(DateUtils.getStartOfDay(new Date()), -7);
        this.dateSelector.selectPeriod();
        this.dateSelector.setStartDate(startDate);
        this.dateSelector.setStopDate(endDate);
        this.add((Component)this.dateSelector, "wrap");
        JButton calcul = new JButton(Utils.getTranslation(LangRoAll.calculeaza));
        calcul.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddCerereAprovizionarePanel.this.updateData();
            }
        });
        this.add((Component)calcul, "wrap");
        this.add(new JLabel(Utils.getTranslation(LangRoAll.stocActualMagazie, new String[0])));
        this.existentMagazie = new JTextField(5);
        this.existentMagazie.setEditable(false);
        this.add(this.existentMagazie);
        this.add(new JLabel(Utils.getTranslation(LangRoAll.stocActualTotal, new String[0])));
        this.existentTotal = new JTextField(5);
        this.existentTotal.setEditable(false);
        this.add((Component)this.existentTotal, "wrap");
        this.add(new JLabel(Utils.getTranslation(LangRoAll.aprovizionareConsumReferinta, new String[0])));
        this.consumReferinta = new JTextField(5);
        this.consumReferinta.setEditable(false);
        this.add(this.consumReferinta);
        this.add(new JLabel(Utils.getTranslation(LangRoAll.aprovizionareDejaComandat, new String[0])));
        this.dejaComandat = new JTextField(5);
        this.dejaComandat.setEditable(false);
        this.add((Component)this.dejaComandat, "wrap");
        this.add(new JLabel(Utils.getTranslation(LangRoAll.aprovizionareMedieComanda, new String[0])));
        this.medieComanda = new JTextField(5);
        this.medieComanda.setEditable(false);
        this.add(this.medieComanda);
        this.add(new JLabel(Utils.getTranslation(LangRoAll.aprovizionareRecomandatMinim, new String[0])));
        this.recomandatMinim = new JTextField(5);
        this.recomandatMinim.setEditable(false);
        this.add((Component)this.recomandatMinim, "wrap");
        this.add(new JLabel(Utils.getTranslation(LangRoAll.aprovizionareRecomandatMaxim, new String[0])));
        this.recomandatMaxim = new JTextField(5);
        this.recomandatMaxim.setEditable(false);
        this.add(this.recomandatMaxim);
        this.add(new JLabel(Utils.getTranslation(LangRoAll.aprovizionareComandaAcum, new String[0])));
        this.comandaAcum = new JTextField(5);
        this.add((Component)this.comandaAcum, "wrap");
        JButton adauga = new JButton(Utils.getTranslation(LangRoAll.adauga));
        adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CerereAprovizionareEntry cae = new CerereAprovizionareEntry();
                cae.setIdStock(AddCerereAprovizionarePanel.this.produsDeComandat);
                if (AddCerereAprovizionarePanel.this.magazie != null) {
                    cae.setIdMagazie(AddCerereAprovizionarePanel.this.magazie.getId());
                } else {
                    cae.setIdMagazie(-1);
                }
                double cantitateCeruta = Utils.parseDouble(AddCerereAprovizionarePanel.this.comandaAcum.getText());
                cae.setCantitateCeruta(cantitateCeruta);
                double cantitatePeStoc = Utils.parseDouble(AddCerereAprovizionarePanel.this.existentMagazie.getText());
                cae.setCantitateExistentaMagazie(cantitatePeStoc);
                double cantitateTotalaPeStoc = Utils.parseDouble(AddCerereAprovizionarePanel.this.existentTotal.getText());
                cae.setCantitateExistentaTotal(cantitateTotalaPeStoc);
                Date[] dates = AddCerereAprovizionarePanel.this.dateSelector.getDates();
                cae.setReferintaStart(new Timestamp(dates[0].getTime()));
                cae.setReferintaStop(new Timestamp(dates[1].getTime()));
                cae.setStatus(StockLogic.APROVIZIONARE_STATUS.NOUA);
                cae.setOperator(AdministrationPanel.loggedUser.getId());
                StockLogic.getInstance().addCerereAprovizionare(cae);
                AddCerereAprovizionarePanel.this.dialog.dispose();
            }
        });
        this.add(adauga);
        JButton renunta = new JButton(Utils.getTranslation(LangRoAll.renunta));
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddCerereAprovizionarePanel.this.dialog.dispose();
            }
        });
        this.add((Component)renunta, "wrap");
        calcul.doClick();
    }

    private void updateData() {
        Date[] dates = this.dateSelector.getDates();
        Hashtable criteria = this.buildCriteria(dates[0], dates[1]);
        Vector<RaportGestiuneEntry> consumuriInPerioada = StockLogic.getInstance().generateRaportConsumuri(criteria, 1);
        RaportGestiuneEntry found = null;
        for (RaportGestiuneEntry raportGestiuneEntry : consumuriInPerioada) {
            if (raportGestiuneEntry.getIdStoc() != this.produsDeComandat) continue;
            found = raportGestiuneEntry;
            break;
        }
        if (found != null) {
            double cantIesita = found.getCantIesita();
            this.consumReferinta.setText(Utils.getString2DecimalsNoTrunc(cantIesita));
        }
        int idMagazie = -1;
        if (this.magazie != null) {
            idMagazie = this.magazie.getId();
        }
        double stocActual = StockLogic.getInstance().getStocActual(this.produsDeComandat, idMagazie);
        this.existentMagazie.setText(Utils.getString2DecimalsNoTrunc(stocActual));
        idMagazie = -1;
        double stocTotal = StockLogic.getInstance().getStocActual(this.produsDeComandat, idMagazie);
        this.existentTotal.setText(Utils.getString2DecimalsNoTrunc(stocTotal));
    }
}

