/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.stocks.Lot;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.PowerSearchStock;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.stocks.StockTransfer;
import ro.atreides.stocks.StockTransferItem;
import ro.atreides.stocks.gui.AddTransferCellRenderer;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.SwitchToList;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.registre.RegistreLogic;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class AddTransferPanel
extends ReflectedJPanel {
    private JPanel parent;
    private StockLogic stockLogic;
    private JComboBox magazieSursa;
    private JComboBox magazieDestinatie;
    private JComboBox tipTransfer;
    private JCheckBox pretAchizitieFix;
    private XComboBox produse;
    private FilterableComboBoxModel xStocksComboModel;
    private JTextField codbareField;
    private JTextField time;
    private JTextField cantitate;
    private JTextField pretVanzare;
    private JTextField pretAchizitie;
    private JTextField nrDocInput;
    private JLabel detaliiLot;
    private JButton adauga;
    private JButton verificaRulaj;
    private MDateEntryField data;
    private JLabel totalTransferVanzareCuTva;
    private JLabel totalTransferAchizitie;
    private AbstractTM itemsTm;
    private double totalGeneralPretVz;
    private double totalGeneralPretAcz;
    private StockTransfer toEdit;
    private SwitchToList action;
    private FocusTraversalPolicy focus;
    private int idLot = -1;
    public static final String[] columns = new String[]{LangRoAll.produs, LangRoAll.cantitate, "Pret achizitie", "Valoare achizitie", "Pret vanzare", "Valoare vanzare"};
    private JTable table;

    public AddTransferPanel(JPanel parent) {
        this.parent = parent;
        this.stockLogic = StockLogic.getInstance();
        this.init();
    }

    @Override
    public void doStuff() {
        AddTransferCellRenderer cellRenderer = new AddTransferCellRenderer(this.itemsTm);
        GuiUtils.updateJTableColumns(this.table, cellRenderer);
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AddTransferPanel.this.xStocksComboModel.refresh(AddTransferPanel.this.stockLogic.getPowerSearchStocks());
            }

            @Override
            public String getName() {
                return "AddTransferPanel_stocks";
            }
        }, 26);
        this.codbareField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AddTransferPanel.this.handleKey(e.getKeyCode(), AddTransferPanel.this.codbareField);
            }
        });
    }

    protected void handleKey(int keyCode, JTextField codBareField) {
        switch (keyCode) {
            case 10: {
                this.detaliiLot.setText("");
                String barcode = codBareField.getText().trim();
                if (Validators.correctString(barcode)) {
                    if (Utils.isCodLot(barcode)) {
                        Lot lot = StockLogic.getInstance().getLotByIdCodbareCommit(barcode);
                        if (lot == null) {
                            DialogUtils.errorDialog(this, "Lot negasit", LangRoAll.nuPotContinua);
                        } else {
                            this.idLot = lot.getId();
                            this.detaliiLot.setText(lot.getNr() + " ; Expira la " + Formatters.DATE_FORMAT_RO.format(lot.getExpirare()));
                            int idStock = lot.getIdStock();
                            Stock stock = this.stockLogic.getStockById(idStock);
                            Product produsFinit = this.stockLogic.getProductForStock(idStock);
                            if (produsFinit != null) {
                                Vector<String> allCodesForProduct = NomeclaturaLogic.getInstance().getAllBarCodesByIdProd(produsFinit.getId());
                                PowerSearchStock pss = new PowerSearchStock(stock, allCodesForProduct);
                                this.produse.setSelectedItem(pss);
                            } else {
                                this.produse.setSelectedItem(stock);
                            }
                        }
                    } else {
                        int idStock;
                        Product produsFinit = NomeclaturaLogic.getInstance().getProductByCodBare(barcode);
                        if (produsFinit == null) {
                            String message = Utils.getTranslation(LangRoAll.produsNegasit, new String[0]) + " " + barcode;
                            DialogUtils.errorDialog(this, message, LangRoAll.atentie);
                            codBareField.setText("");
                            codBareField.requestFocus();
                        } else if (produsFinit != null && (idStock = this.stockLogic.getIdStockForProductId(produsFinit.getId())) > 0) {
                            Stock stock = this.stockLogic.getStockById(idStock);
                            if (stock != null) {
                                Vector<String> allCodesForProduct = NomeclaturaLogic.getInstance().getAllBarCodesByIdProd(produsFinit.getId());
                                PowerSearchStock pss = new PowerSearchStock(stock, allCodesForProduct);
                                this.produse.setSelectedItem(pss);
                            } else {
                                String message = Utils.getTranslation(LangRoAll.produsNegasit, new String[0]) + " " + barcode;
                                DialogUtils.errorDialog(this, message, LangRoAll.atentie);
                            }
                        }
                    }
                }
                codBareField.setText("");
                codBareField.requestFocus();
                break;
            }
        }
    }

    private void init() {
        this.xStocksComboModel = new FilterableComboBoxModel(StockLogic.getInstance().getPowerSearchStocks());
        this.produse = new XComboBox(this.xStocksComboModel);
        this.produse.setPrototypeDisplayValue("111111111111111111111111111111111");
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        this.add((Component)this.getTopPanel(), c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        JPanel total = this.getTotalFacturaPanel();
        this.add((Component)total, c);
        ++c.gridx;
        JPanel buttons = this.getButtonsPanel();
        this.add((Component)buttons, c);
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.5;
        JPanel dateFactura = this.getFacturaPanel();
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)dateFactura, c);
        c.weightx = 1.0;
        JPanel dateProdus = this.getProdusPanel();
        ++c.gridx;
        result.add((Component)dateProdus, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        JPanel nirTable = this.getNirTablePanel();
        result.add((Component)nirTable, c);
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                AddTransferPanel.this.refreshMagaziiCombo();
            }

            @Override
            public String getName() {
                return "AddTransferPanel_magazii";
            }
        }, 27);
        this.refreshMagaziiCombo();
        this.stockLogic.fillTipTransferCombo(this.tipTransfer, false);
        return result;
    }

    private JPanel getProdusPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date produse"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.codBare), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 5;
        this.codbareField = new JTextField(13);
        result.add((Component)this.codbareField, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.detalii), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 5;
        this.detaliiLot = new JLabel();
        result.add((Component)this.detaliiLot, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.produs), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 5;
        result.add((Component)this.produse, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.cantitate), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.cantitate = new JTextField(10);
        result.add((Component)this.cantitate, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Pret vanzare"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.pretVanzare = new JTextField(10);
        result.add((Component)this.pretVanzare, c);
        ++c.gridx;
        c.weightx = 0.0;
        result.add((Component)new JLabel("Pret achizitie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.pretAchizitie = new JTextField(10);
        result.add((Component)this.pretAchizitie, c);
        this.produse.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AddTransferPanel.this.produse.selectAllText();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 6;
        this.adauga = new JButton(LangRoAll.adauga);
        this.adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddTransferPanel.this.addEntry();
                AddTransferPanel.this.produse.requestFocus();
            }
        });
        result.add((Component)this.adauga, c);
        this.initFields();
        this.focus = new FocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                if (GuiUtils.isXComboBox(aComponent)) {
                    AddTransferPanel.this.setValuesForSelectedProduct();
                    return AddTransferPanel.this.cantitate;
                }
                if (aComponent.equals(AddTransferPanel.this.cantitate)) {
                    return AddTransferPanel.this.pretVanzare;
                }
                if (aComponent.equals(AddTransferPanel.this.pretVanzare)) {
                    if (AddTransferPanel.this.pretAchizitieFix.isSelected()) {
                        return AddTransferPanel.this.pretAchizitie;
                    }
                    return AddTransferPanel.this.adauga;
                }
                if (aComponent.equals(AddTransferPanel.this.pretAchizitie)) {
                    return AddTransferPanel.this.adauga;
                }
                return this.getDefaultComponent(aContainer);
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return null;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return AddTransferPanel.this.produse;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return AddTransferPanel.this.produse;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return AddTransferPanel.this.adauga;
            }
        };
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(this.focus);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setValuesForSelectedProduct() {
        Date d = DateUtils.setTimeToDate((Component)this.parent, this.data, this.time);
        if (d == null) {
            return;
        }
        Magazie sursa = (Magazie)this.magazieSursa.getSelectedItem();
        Stock product = (Stock)this.produse.getSelectedItem();
        if (product == null) {
            this.goBackToProduse();
            return;
        }
        if (this.pretAchizitieFix.isSelected()) {
            double currentPrice = this.stockLogic.getPretAchizitieLotCurent(new Timestamp(d.getTime()), product.getId(), sursa.getId(), 0.0);
            if (currentPrice > 0.0) {
                this.pretAchizitie.setText(Utils.getString2Decimals(currentPrice));
            } else {
                if (!DialogUtils.confirmDialog(this.parent, "Lot inexistent ! Doriti sa folosim ultimul pret de achizitie disponibil", "ATENTIE")) {
                    this.goBackToProduse();
                    return;
                }
                currentPrice = this.stockLogic.getBackupBuyPrice(product.getId());
                if (currentPrice <= 0.0) {
                    if (DialogUtils.confirmDialog(this.parent, "Intrare inexistenta !! Continuam cu pret zero", "ATENTIE")) {
                        this.pretAchizitie.setText("0");
                        return;
                    }
                    this.goBackToProduse();
                    return;
                }
                this.pretAchizitie.setText(Utils.getString2Decimals(currentPrice));
            }
        } else {
            this.pretAchizitie.setText("0");
        }
        double pretIesire = this.stockLogic.getPriceForStock(product.getId(), new Timestamp(d.getTime()));
        if (pretIesire < 0.0) {
            pretIesire = 0.0;
        }
        this.pretVanzare.setText(Utils.getString2Decimals(pretIesire));
    }

    public void addEntries(Vector bce) {
        this.itemsTm.getData().addAll(bce);
        this.itemsTm.fireTableDataChanged();
    }

    private void goBackToProduse() {
        this.produse.setSelectedItem(null);
        this.produse.requestFocus();
    }

    public void setTransferToEdit(StockTransfer transfer) {
        this.toEdit = transfer;
        this.magazieSursa.setSelectedItem(this.stockLogic.getMagazieById(transfer.getIdSource()));
        this.magazieDestinatie.setSelectedItem(this.stockLogic.getMagazieById(transfer.getIdDestinatie()));
        this.tipTransfer.setSelectedItem(transfer.getTipTransferString());
        this.data.setValue((Date)transfer.getTimp());
        this.time.setText(DateUtils.getTimeFromDate(transfer.getTimp()));
        Vector<StockTransferItem> items = this.stockLogic.getTransferItems(transfer.getId());
        this.itemsTm.getData().removeAllElements();
        this.itemsTm.getData().addAll(items);
        this.itemsTm.fireTableDataChanged();
        this.nrDocInput.setText(transfer.getNrBon() + "");
        this.updateTotals();
        this.pretAchizitieFix.setSelected(transfer.isPretAczFix());
    }

    public SwitchToList getAction() {
        return this.action;
    }

    public void setAction(SwitchToList action) {
        this.action = action;
    }

    private void refreshMagaziiCombo() {
        AddTransferPanel addTransferPanel = this;
        Vector<Magazie> magazii = addTransferPanel.stockLogic.getInstance().getMagazii();
        ComboUtils.replaceItemsForCombo(this.magazieSursa, magazii, false);
        ComboUtils.replaceItemsForCombo(this.magazieDestinatie, magazii, false);
    }

    private void initFields() {
        this.cantitate.setText("");
        this.pretAchizitie.setText("");
        this.pretVanzare.setText("");
        this.detaliiLot.setText("");
        this.idLot = -1;
    }

    private JPanel getFacturaPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date transfer"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Magazie sursa"), c);
        ++c.gridx;
        this.magazieSursa = new JComboBox();
        c.gridwidth = 2;
        result.add((Component)this.magazieSursa, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Magazie destinatie"), c);
        ++c.gridx;
        this.magazieDestinatie = new JComboBox();
        c.gridwidth = 2;
        result.add((Component)this.magazieDestinatie, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Tip transfer"), c);
        ++c.gridx;
        this.tipTransfer = new JComboBox();
        c.gridwidth = 2;
        result.add((Component)this.tipTransfer, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Pret Achizitie fix"), c);
        ++c.gridx;
        this.pretAchizitieFix = new JCheckBox();
        c.gridwidth = 2;
        result.add((Component)this.pretAchizitieFix, c);
        this.setPretAczCfFifoSelected();
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.data), c);
        ++c.gridx;
        this.data = new MDateEntryField();
        this.data.setValue(new Date());
        this.data.setEditable(false);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 3;
        this.data.setConstraints((MDateSelectorConstraints)c1);
        this.data.setToolTipText("Alege data");
        result.add((Component)this.data, c);
        ++c.gridx;
        this.time = new JTextField();
        this.time.setText("00:00");
        result.add((Component)this.time, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Nr. doc"), c);
        ++c.gridx;
        this.nrDocInput = new JTextField();
        c.gridwidth = 2;
        result.add((Component)this.nrDocInput, c);
        return result;
    }

    private void setPretAczCfFifoSelected() {
        boolean defaultChecked = Config.getInstance().getBoolean("stockTransferPretAczFix");
        this.pretAchizitieFix.setSelected(defaultChecked);
    }

    private JPanel getTotalFacturaPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.total));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)new JLabel("Valoare la pret achizitie"), c);
        ++c.gridx;
        this.totalTransferAchizitie = new JLabel("0");
        result.add((Component)this.totalTransferAchizitie, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Valoare la pret vanzare"), c);
        ++c.gridx;
        this.totalTransferVanzareCuTva = new JLabel("0");
        result.add((Component)this.totalTransferVanzareCuTva, c);
        return result;
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder(LangRoAll.actiuni));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        final AddTransferPanel panel = this;
        c.gridx = 0;
        c.gridy = 0;
        JButton tipareste = new JButton("Tipareste la pret Vz");
        tipareste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AddTransferPanel.this.toEdit == null || AddTransferPanel.this.toEdit.getNrBon() == null) {
                    DialogUtils.errorDialog(AddTransferPanel.this.parent, "Intai salvati, apoi tipariti", LangRoAll.nuPotContinua);
                    return;
                }
                Date d = DateUtils.setTimeToDate((Component)AddTransferPanel.this.parent, AddTransferPanel.this.data, AddTransferPanel.this.time);
                if (d == null) {
                    return;
                }
                Magazie sursa = (Magazie)AddTransferPanel.this.magazieSursa.getSelectedItem();
                Magazie destinatie = (Magazie)AddTransferPanel.this.magazieDestinatie.getSelectedItem();
                AddTransferPanel.this.stockLogic.printBonConsum(AddTransferPanel.this.itemsTm.getData(), destinatie.getLabel(), sursa.getLabel(), Config.getInstance().getString("societate"), d, AddTransferPanel.this.toEdit.getNrBon() + "", 1);
            }
        });
        result.add((Component)tipareste, c);
        ++c.gridx;
        JButton tiparesteAcz = new JButton("Tipareste la pret Acz");
        tiparesteAcz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AddTransferPanel.this.toEdit == null || AddTransferPanel.this.toEdit.getNrBon() == null) {
                    DialogUtils.errorDialog(AddTransferPanel.this.parent, "Intai salvati, apoi tipariti", LangRoAll.nuPotContinua);
                    return;
                }
                Date d = DateUtils.setTimeToDate((Component)AddTransferPanel.this.parent, AddTransferPanel.this.data, AddTransferPanel.this.time);
                if (d == null) {
                    return;
                }
                Magazie sursa = (Magazie)AddTransferPanel.this.magazieSursa.getSelectedItem();
                Magazie destinatie = (Magazie)AddTransferPanel.this.magazieDestinatie.getSelectedItem();
                AddTransferPanel.this.stockLogic.printBonConsum(AddTransferPanel.this.itemsTm.getData(), destinatie.getLabel(), sursa.getLabel(), Config.getInstance().getString("societate"), d, AddTransferPanel.this.toEdit.getNrBon() + "", 2);
            }
        });
        result.add((Component)tiparesteAcz, c);
        ++c.gridx;
        JButton tiparesteAczVz = new JButton("Tipareste la pret Acz si Vz");
        tiparesteAczVz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AddTransferPanel.this.toEdit == null || AddTransferPanel.this.toEdit.getNrBon() == null) {
                    DialogUtils.errorDialog(AddTransferPanel.this.parent, "Intai salvati, apoi tipariti", LangRoAll.nuPotContinua);
                    return;
                }
                Date d = DateUtils.setTimeToDate((Component)AddTransferPanel.this.parent, AddTransferPanel.this.data, AddTransferPanel.this.time);
                if (d == null) {
                    return;
                }
                Magazie sursa = (Magazie)AddTransferPanel.this.magazieSursa.getSelectedItem();
                Magazie destinatie = (Magazie)AddTransferPanel.this.magazieDestinatie.getSelectedItem();
                AddTransferPanel.this.stockLogic.printBonConsum(AddTransferPanel.this.itemsTm.getData(), destinatie.getLabel(), sursa.getLabel(), Config.getInstance().getString("societate"), d, AddTransferPanel.this.toEdit.getNrBon() + "", 3);
            }
        });
        result.add((Component)tiparesteAczVz, c);
        ++c.gridx;
        JButton tiparesteAvizAcz = new JButton("Tipareste Aviz la pret Acz");
        tiparesteAvizAcz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (AddTransferPanel.this.toEdit == null || AddTransferPanel.this.toEdit.getNrBon() == null) {
                    DialogUtils.errorDialog(AddTransferPanel.this.parent, "Intai salvati, apoi tipariti", LangRoAll.nuPotContinua);
                    return;
                }
                Date d = DateUtils.setTimeToDate((Component)AddTransferPanel.this.parent, AddTransferPanel.this.data, AddTransferPanel.this.time);
                if (d == null) {
                    return;
                }
                Magazie sursa = (Magazie)AddTransferPanel.this.magazieSursa.getSelectedItem();
                Magazie destinatie = (Magazie)AddTransferPanel.this.magazieDestinatie.getSelectedItem();
                AddTransferPanel.this.stockLogic.printAvizPeBazaTransfer(AddTransferPanel.this.itemsTm.getData(), destinatie.getLabel(), sursa.getLabel(), Config.getInstance().getString("societate"), d, AddTransferPanel.this.toEdit.getNrBon());
            }
        });
        result.add((Component)tiparesteAvizAcz, c);
        ++c.gridy;
        c.gridx = 0;
        this.verificaRulaj = new JButton("Verifica rulaj");
        this.verificaRulaj.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddTransferPanel.this.checkRulajInMagaziaDestinatie((Magazie)AddTransferPanel.this.magazieDestinatie.getSelectedItem());
            }
        });
        result.add((Component)this.verificaRulaj, c);
        ++c.gridx;
        c.gridwidth = 2;
        JButton salveaza = new JButton("Salveaza transfer");
        salveaza.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Date d = DateUtils.setTimeToDate((Component)AddTransferPanel.this.parent, AddTransferPanel.this.data, AddTransferPanel.this.time);
                if (d == null) {
                    return;
                }
                Magazie sursa = (Magazie)AddTransferPanel.this.magazieSursa.getSelectedItem();
                Magazie dest = (Magazie)AddTransferPanel.this.magazieDestinatie.getSelectedItem();
                if (sursa.getId() == dest.getId()) {
                    DialogUtils.errorDialog(AddTransferPanel.this.parent, "Magaziile trebuie sa fie distincte", LangRoAll.nuPotContinua);
                    return;
                }
                String tip = (String)AddTransferPanel.this.tipTransfer.getSelectedItem();
                int tipT = AddTransferPanel.this.stockLogic.getTransferTip(tip);
                boolean pretAczFix = AddTransferPanel.this.pretAchizitieFix.isSelected();
                if (AddTransferPanel.this.toEdit == null) {
                    int nrDoc = -1;
                    if (VpConfig.getInstance().bonConsumNrDocManual) {
                        String nrDocInputText = AddTransferPanel.this.nrDocInput.getText();
                        if (!Validators.correctInteger(nrDocInputText)) {
                            DialogUtils.errorDialog(GuiUtils.currentFrame, "Nu ati introldus numarul de document", LangRoAll.eroare);
                            return;
                        }
                        nrDoc = Integer.valueOf(nrDocInputText);
                    } else {
                        nrDoc = RegistreLogic.getInstance().getNewNumberForRegistru(RestLogic.RegistreInterne.BON_CONSUM_TRANSFER_INTERN.key, RestLogic.RegistreInterne.BON_CONSUM_TRANSFER_INTERN.nume, true);
                    }
                    AddTransferPanel.this.stockLogic.addTransfer(sursa.getId(), dest.getId(), new Timestamp(d.getTime()), AddTransferPanel.this.itemsTm.getData(), AddTransferPanel.this.totalGeneralPretVz, AddTransferPanel.this.totalGeneralPretAcz, tipT, pretAczFix, nrDoc, AdministrationPanel.loggedUser);
                    AddTransferPanel.this.resetFields();
                } else {
                    AddTransferPanel.this.stockLogic.updateTransfer(AddTransferPanel.this.toEdit.getTimp(), AddTransferPanel.this.toEdit.getId(), sursa.getId(), dest.getId(), new Timestamp(d.getTime()), AddTransferPanel.this.itemsTm.getData(), AddTransferPanel.this.totalGeneralPretVz, AddTransferPanel.this.totalGeneralPretAcz, tipT, pretAczFix, panel);
                    AddTransferPanel.this.resetFields();
                    AddTransferPanel.this.toEdit = null;
                    AddTransferPanel.this.action.doAction();
                }
            }
        });
        result.add((Component)salveaza, c);
        c.gridx += 2;
        c.gridwidth = 1;
        JButton renunta = new JButton(LangRoAll.renunta);
        renunta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddTransferPanel.this.resetFields();
                if (AddTransferPanel.this.toEdit != null) {
                    AddTransferPanel.this.toEdit = null;
                    AddTransferPanel.this.action.doAction();
                }
            }
        });
        result.add((Component)renunta, c);
        return result;
    }

    private void checkRulajInMagaziaDestinatie(Magazie destinatie) {
        int minQty = Config.getInstance().getInt("bonTransferCheckRulajLimit");
        if (minQty < 0) {
            return;
        }
        Hashtable<Integer, StockTransferItem> stocks = new Hashtable<Integer, StockTransferItem>();
        for (Object o : this.itemsTm.getData()) {
            StockTransferItem sti = (StockTransferItem)o;
            stocks.put(sti.getIdStock(), sti);
            sti.setRulajInPerioada(StockTransferItem.RulajEnum.CRITICAL);
            sti.setRulaj(0.0);
        }
        String inSql = Utils.getSqlInSequence(new Vector(stocks.keySet()));
        Date start = DateUtils.addDaysToDate(new Date(), -Config.getInstance().getInt("bonTransferCheckRulajPeriod"));
        Hashtable<Integer, Double> consumuri = this.stockLogic.getConsumuri(inSql, destinatie.getId(), new Timestamp(start.getTime()), DateUtils.getCurrentTimestamp());
        for (Integer idStock : consumuri.keySet()) {
            StockTransferItem sti = (StockTransferItem)stocks.get(idStock);
            Double rulaj = consumuri.get(idStock);
            sti.setRulaj(rulaj);
            if (rulaj < (double)minQty) {
                sti.setRulajInPerioada(StockTransferItem.RulajEnum.CRITICAL);
                continue;
            }
            sti.setRulajInPerioada(StockTransferItem.RulajEnum.OK);
        }
        this.itemsTm.fireTableDataChanged();
    }

    private void resetFields() {
        this.initFields();
        Vector data = this.itemsTm.getData();
        if (data != null) {
            data.removeAllElements();
        }
        this.itemsTm.fireTableDataChanged();
        this.totalGeneralPretVz = 0.0;
        this.totalGeneralPretAcz = 0.0;
        this.updateTotals();
        this.setPretAczCfFifoSelected();
    }

    private void addEntry() {
        double cant = 0.0;
        double ppuv = 0.0;
        double ppuc = 0.0;
        Stock product = (Stock)this.produse.getSelectedItem();
        String cantS = this.cantitate.getText();
        if (!Validators.correctDouble(cantS)) {
            DialogUtils.errorDialog(this.parent, "Cantitatea trebuie sa fie un numar", LangRoAll.nuPotContinua);
            this.cantitate.requestFocus();
            return;
        }
        cant = Utils.parseDouble(cantS);
        if (cant <= 0.0) {
            DialogUtils.errorDialog(this.parent, "Cantitatea trebuie sa fie > 0", LangRoAll.nuPotContinua);
            this.cantitate.requestFocus();
            return;
        }
        String pretS = this.pretVanzare.getText();
        if (!Validators.correctDouble(pretS)) {
            DialogUtils.errorDialog(this.parent, "Pretul de vanzare trebuie sa fie un numar", LangRoAll.nuPotContinua);
            this.pretVanzare.setText("");
            this.pretVanzare.requestFocus();
            return;
        }
        ppuv = Utils.parseDouble(pretS);
        pretS = this.pretAchizitie.getText();
        if (!Validators.correctDouble(pretS)) {
            DialogUtils.errorDialog(this.parent, "Pretul de achizitie trebuie sa fie un numar", LangRoAll.nuPotContinua);
            this.pretAchizitie.setText("");
            this.pretAchizitie.requestFocus();
            return;
        }
        ppuc = Utils.parseDouble(pretS);
        StockTransferItem sti = new StockTransferItem();
        sti.setQuantity(cant);
        sti.setIdStock(product.getId());
        sti.setDenumire(product.getLabel());
        sti.setSellPrice(ppuv);
        sti.setBuyPrice(ppuc);
        sti.setIdLot(this.idLot);
        Vector entries = this.itemsTm.getData();
        entries.add(sti);
        this.itemsTm.fireTableDataChanged();
        this.initFields();
        this.updateTotals();
    }

    private void updateTotals() {
        this.totalGeneralPretVz = 0.0;
        this.totalGeneralPretAcz = 0.0;
        Vector d = this.itemsTm.getData();
        for (int i = 0; i < d.size(); ++i) {
            StockTransferItem pp = (StockTransferItem)d.elementAt(i);
            this.totalGeneralPretVz += pp.getValoareVanzare();
            this.totalGeneralPretAcz += pp.getValoareAchizitie();
        }
        this.totalTransferVanzareCuTva.setText(Utils.getString2Decimals(this.totalGeneralPretVz));
        this.totalTransferAchizitie.setText(Utils.getString2Decimals(this.totalGeneralPretAcz));
    }

    private JPanel getNirTablePanel() {
        JPanel result = new JPanel();
        result.setLayout(new GridBagLayout());
        result.setBorder(new TitledBorder("Date transfer"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        this.itemsTm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                StockTransferItem e = (StockTransferItem)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getDenumire();
                    }
                    case 1: {
                        return Utils.getString3Decimals(e.getQuantity()) + (e.getRulaj() >= 0.0 ? " (" + Utils.getString3Decimals(e.getRulaj()) + ")" : "");
                    }
                    case 2: {
                        return Utils.getString2Decimals(e.getPretAcz());
                    }
                    case 3: {
                        return Utils.getString2Decimals(e.getValoareAchizitie());
                    }
                    case 4: {
                        return Utils.getString2Decimals(e.getSellPrice());
                    }
                    case 5: {
                        return Utils.getString2Decimals(e.getValoareVanzare());
                    }
                }
                return null;
            }
        });
        this.table = new JTable(this.itemsTm);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JTable source = (JTable)e.getSource();
                int selRow = source.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2 && DialogUtils.confirmDialog(AddTransferPanel.this.parent, "Doriti sa stergeti acest produs", LangRoAll.confirmare)) {
                    AddTransferPanel.this.eraseEntry(selRow);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        JScrollPane scroll = new JScrollPane(this.table);
        result.add((Component)scroll, c);
        return result;
    }

    private void eraseEntry(int selRow) {
        this.itemsTm.getData().removeElementAt(selRow);
        this.itemsTm.fireTableDataChanged();
        this.updateTotals();
    }

    public void cleanup() {
        this.magazieSursa.removeAllItems();
        this.magazieDestinatie.removeAllItems();
        this.tipTransfer.removeAllItems();
    }
}

