/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.stocks.Magazie;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class ModificaPretDialog
extends JDialog {
    private Component parent;
    private double cantitate;
    private double pret;
    private boolean salvat;
    private MDateEntryField _startDayTextField;
    private JTextField _startTimeField;
    private Vector magazii;
    private JComboBox magaziiCombo;
    private Magazie currentMagazie;

    public ModificaPretDialog(Vector magazii, Magazie currentMagazie, Component parent, double cantitate, double pret, String ingredientName) {
        super(GuiUtils.currentFrame, "Modificare pret " + ingredientName, true);
        this.parent = parent;
        this.pret = pret;
        this.cantitate = cantitate;
        this.magazii = magazii;
        this.currentMagazie = currentMagazie;
        this.display();
        this.toFront();
    }

    public boolean isSalvat() {
        return this.salvat;
    }

    public double getCantitate() {
        return this.cantitate;
    }

    public double getPret() {
        return this.pret;
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        JLabel magazieLabel = new JLabel(LangRoAll.cantitate);
        this.add((Component)magazieLabel, c);
        ++c.gridx;
        this.magaziiCombo = ComboUtils.buildCombo(this.magazii);
        if (this.currentMagazie != null) {
            this.magaziiCombo.setSelectedItem(this.currentMagazie);
        }
        this.add((Component)this.magaziiCombo, c);
        c.gridx = 0;
        ++c.gridy;
        JLabel cantitateLabel = new JLabel(LangRoAll.cantitate);
        this.add((Component)cantitateLabel, c);
        ++c.gridx;
        final JTextField cantText = new JTextField(10);
        cantText.setText(Utils.getString3Decimals(this.cantitate));
        this.add((Component)cantText, c);
        ++c.gridy;
        c.gridx = 0;
        JLabel pretLabel = new JLabel(LangRoAll.pret);
        this.add((Component)pretLabel, c);
        ++c.gridx;
        final JTextField pretText = new JTextField(10);
        pretText.setText(Utils.getString2Decimals(this.pret));
        this.add((Component)pretText, c);
        Date d = new Date();
        ++c.gridy;
        c.gridx = 0;
        JLabel _startDateLabel = new JLabel(LangRoAll.data);
        this.add((Component)_startDateLabel, c);
        ++c.gridx;
        this._startDayTextField = new MDateEntryField();
        this._startDayTextField.setValue(d);
        this._startDayTextField.setEditable(false);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 3;
        this._startDayTextField.setConstraints((MDateSelectorConstraints)c1);
        this._startDayTextField.setToolTipText("Alege data");
        this.add((Component)this._startDayTextField, c);
        ++c.gridy;
        c.gridx = 0;
        JLabel _startTimeLabel = new JLabel("Ora (hh:mm)");
        this.add((Component)_startTimeLabel, c);
        ++c.gridx;
        this._startTimeField = new JTextField(5);
        this._startTimeField.setText(Formatters.TIME_FORMAT.format(d));
        this.add((Component)this._startTimeField, c);
        ++c.gridy;
        c.gridx = 0;
        JButton gata = new JButton(LangRoAll.salveaza);
        gata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Validators.correctFloatTextField(cantText)) {
                    return;
                }
                if (!Validators.correctFloatTextField(pretText)) {
                    return;
                }
                if (ModificaPretDialog.this.magaziiCombo.getSelectedItem() == null) {
                    DialogUtils.errorDialog(ModificaPretDialog.this.parent, "Alegeti magazia", LangRoAll.nuPotContinua);
                    return;
                }
                String s1 = cantText.getText();
                String s2 = pretText.getText();
                ModificaPretDialog.this.cantitate = Utils.parseDouble(s1);
                ModificaPretDialog.this.pret = Utils.parseDouble(s2);
                ModificaPretDialog.this.salvat = true;
                ModificaPretDialog.this.dispose();
            }
        });
        this.add((Component)gata, c);
        ++c.gridx;
        JButton cancel = new JButton(LangRoAll.renunta);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModificaPretDialog.this.dispose();
            }
        });
        this.add((Component)cancel, c);
        this.pack();
        int width = this.getWidth();
        int height = this.getHeight();
        int x = 0;
        int y = 0;
        if (this.parent != null) {
            int parentWidth = this.parent.getWidth();
            int parentHeight = this.parent.getHeight();
            x = this.parent.getX() + (parentWidth - width) / 2;
            y = this.parent.getY() + (parentHeight - height) / 2;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setBounds(x, y, width, height);
        this.setVisible(true);
    }

    public Magazie getChosenMagazie() {
        Magazie m = (Magazie)this.magaziiCombo.getSelectedItem();
        return m;
    }

    public Date getChosenDate() {
        Date d = DateUtils.setTimeToDate(this.parent, this._startDayTextField, this._startTimeField);
        return d;
    }
}

