/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ro.atreides.stocks.QuickSmallStocksBean;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;

public class QuickSmallStocksInMagaziePanel
extends AbstractListPanel {
    private int idMagazie;

    public QuickSmallStocksInMagaziePanel(int idMagazie) {
        this.idMagazie = idMagazie;
    }

    @Override
    public String[] buildColumns() {
        return new String[]{"Produs", "In magazie", "Min", "Max"};
    }

    @Override
    public AbstractTM buildTableModel() {
        return new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                QuickSmallStocksBean shift = (QuickSmallStocksBean)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return shift.getDenumire();
                    }
                    case 1: {
                        return Utils.getString3Decimals(shift.getExistent());
                    }
                    case 2: {
                        return Utils.getString3Decimals(shift.getMin());
                    }
                    case 3: {
                        return Utils.getString3Decimals(shift.getMax());
                    }
                }
                return null;
            }
        });
    }

    @Override
    public JPanel getBottomPanel() {
        return null;
    }

    @Override
    public Vector buildData() {
        return StockLogic.getInstance().getAllStocksInMagazieNow(this.idMagazie);
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public void doStuff() {
        this.display();
        DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                QuickSmallStocksBean se = (QuickSmallStocksBean)QuickSmallStocksInMagaziePanel.this.tm.getData().elementAt(row);
                if (se.getExistent() < 0.0) {
                    this.setBackground(Color.ORANGE);
                    this.setForeground(Color.BLACK);
                } else if (se.getExistent() > se.getMin()) {
                    if (se.getExistent() > se.getMax()) {
                        this.setBackground(Color.CYAN);
                        this.setForeground(Color.BLACK);
                    } else {
                        this.setBackground(Color.WHITE);
                        this.setForeground(Color.BLACK);
                    }
                } else if (se.getExistent() <= se.getMin()) {
                    this.setBackground(Color.YELLOW);
                    this.setForeground(Color.BLACK);
                }
                return this;
            }
        };
        GuiUtils.updateJTableColumns(this.table, cellRenderer);
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    QuickSmallStocksInMagaziePanel.this.refreshTable();
                }
            }
        }.start();
    }
}

