/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import net.miginfocom.swing.MigLayout;
import ro.atreides.print.PrintLogic;
import ro.atreides.stocks.ModificarePret;
import ro.atreides.stocks.Stock;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.XComboBox;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class RaportModificariPretPanel
extends AbstractReportPanel
implements CleanupRequired {
    public static final String[] columns = new String[]{LangRoAll.produs, Utils.getTranslation(LangRoAll.pretVz, new String[0]), LangRoAll.data};
    private XComboBox stocks;
    private FilterableComboBoxModel xStocksComboModel;
    private Hashtable printCriteria = new Hashtable();
    private JButton adauga;
    private ReportInterface reportInterface;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Comparable<Date>> result = new Hashtable<String, Comparable<Date>>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(LangRoAll.start, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(LangRoAll.stop, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Object selectedItem = this.stocks.getSelectedItem();
        Stock s = null;
        if (selectedItem instanceof Stock) {
            s = (Stock)selectedItem;
        }
        if (s != null) {
            result.put("id_stock_key", Integer.valueOf(s.getId()));
            this.printCriteria.put(Utils.getTranslation(LangRoAll.stoc, new String[0]), s.getLabel());
        } else {
            result.put("id_stock_key", Integer.valueOf(-1));
            this.printCriteria.remove(Utils.getTranslation(LangRoAll.stoc, new String[0]));
        }
        return result;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return StockLogic.getInstance().getAllPriceModificationById(criteria);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    ModificarePret entry = (ModificarePret)o;
                    try {
                        Label label = new Label(0, row, entry.getNumeProdus());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, String.valueOf(entry.getPretNou()));
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, entry.getData().toString());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return RaportModificariPretPanel.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return Utils.getTranslation(LangRoAll.raportModificariPreturi);
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                String aValueString = aValue.toString();
                ModificarePret x = (ModificarePret)data.elementAt(rowIndex);
                Timestamp oldData = x.getData();
                switch (columnIndex) {
                    case 1: {
                        if (!Validators.correctDouble(aValueString)) break;
                        x.setPretNou(Double.valueOf(aValueString));
                        break;
                    }
                    case 2: {
                        if (!Validators.correctDate(aValueString, Formatters.DATE_AND_TIME_FORMAT)) break;
                        try {
                            Date dataNoua = Formatters.DATE_AND_TIME_FORMAT.parse(aValueString);
                            x.setData(new Timestamp(dataNoua.getTime()));
                            break;
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                }
                StockLogic.getInstance().updatePriceModification(x, oldData);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                ModificarePret sqv = (ModificarePret)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return sqv.getNumeProdus();
                    }
                    case 1: {
                        return Utils.getString2Decimals(sqv.getPretNou());
                    }
                    case 2: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(sqv.getData());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout(""));
        final RaportModificariPretPanel parent = this;
        this.adauga = new JButton(LangRoAll.adauga);
        this.adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Stock s = (Stock)RaportModificariPretPanel.this.stocks.getSelectedItem();
                if (s == null) {
                    DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.alegetiUnProdus, new String[0]), LangRoAll.nuPotContinua);
                    return;
                }
                ModificarePret forAdd = new ModificarePret();
                Stock st = (Stock)RaportModificariPretPanel.this.stocks.getSelectedItem();
                String pretNou = DialogUtils.inputDialog(parent, Utils.getString2Decimals(StockLogic.getInstance().getCatalogPriceForStock(st.getId())), "Pret nou");
                if (Validators.correctDouble(pretNou)) {
                    forAdd.setPretNou(Utils.parseDouble(pretNou));
                    String dataString = DialogUtils.inputDialog(parent, Formatters.DATE_AND_TIME_FORMAT.format(new Date()), "Data");
                    if (Validators.correctDate(dataString, Formatters.DATE_AND_TIME_FORMAT)) {
                        try {
                            Date dataNoua = Formatters.DATE_AND_TIME_FORMAT.parse(dataString);
                            forAdd.setData(new Timestamp(dataNoua.getTime()));
                        }
                        catch (ParseException e1) {
                            e1.printStackTrace();
                        }
                        StockLogic.getInstance().addPriceModificationNew(s.getId(), forAdd.getPretNou(), forAdd.getData());
                        RaportModificariPretPanel.this.raport();
                    } else {
                        DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.valoareIncorecta), LangRoAll.nuPotContinua);
                    }
                } else {
                    DialogUtils.errorDialog(parent, Utils.getTranslation(LangRoAll.valoareIncorecta), LangRoAll.nuPotContinua);
                }
            }
        });
        result.add(this.adauga);
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.fill = 2;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridx = 0;
        buttonsPanel.add((Component)new JLabel(Utils.getTranslation(LangRoAll.stoc, new String[0])), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.xStocksComboModel = new FilterableComboBoxModel(StockLogic.getInstance().getPowerSearchStocks());
        this.stocks = new XComboBox(this.xStocksComboModel);
        this.stocks.setPrototypeDisplayValue("111111111111111111111111111111111");
        buttonsPanel.add((Component)this.stocks, c);
        return buttonsPanel;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void doStuff() {
        final RaportModificariPretPanel parent = this;
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point p;
                JTable t = (JTable)e.getSource();
                int selRow = t.rowAtPoint(p = e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final ModificarePret source = (ModificarePret)RaportModificariPretPanel.this.tm.getObjectAt(selRow);
                int modifiers = e.getModifiers();
                if ((modifiers & 0x10) <= 0) {
                    final JPopupMenu popup = new JPopupMenu();
                    JMenuItem stergeStock = new JMenuItem(Utils.getTranslation(LangRoAll.sterge));
                    popup.add(stergeStock);
                    stergeStock.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (DialogUtils.confirmDialog(parent, Utils.getTranslation(LangRoAll.sterge), LangRoAll.confirmare)) {
                                popup.setVisible(false);
                                StockLogic.getInstance().deletePriceModification(source);
                                RaportModificariPretPanel.this.raport();
                            }
                        }
                    });
                    popup.setInvoker(RaportModificariPretPanel.this.table);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 4;
                    }
                    case 2: {
                        return 2;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                switch (column) {
                    default: 
                }
                return "";
            }

            @Override
            public String getReportTitle() {
                return Utils.getTranslation(LangRoAll.raportModificariPreturi);
            }

            @Override
            public Hashtable getCriteria() {
                return RaportModificariPretPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                ModificarePret modf = (ModificarePret)row;
                double pretNou = 0.0;
                Timestamp data = null;
                String produs = (String)RaportModificariPretPanel.this.printCriteria.get(Utils.getTranslation(LangRoAll.stoc, new String[0]));
                pretNou = modf.getPretNou();
                data = modf.getData();
                switch (column) {
                    case 0: {
                        return produs;
                    }
                    case 1: {
                        return Utils.getString2Decimals(pretNou);
                    }
                    case 2: {
                        return Formatters.DATE_AND_TIME_FORMAT.format(data);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

