/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.contabilitate.NirEntryFull;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.print.PrintLogic;
import ro.atreides.stocks.Corectie;
import ro.atreides.stocks.Magazie;
import ro.atreides.stocks.StockComparativEntry;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Constants;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.GenericListenersLogic;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.SimpleDateSelector;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.dialogs.FileDialog;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.tags.TagsLogic;

public class StocFapticPanel
extends AbstractReportPanel
implements CleanupRequired {
    public static final String[] columns = new String[]{LangRoAll.produs, "Scriptic", "Faptic", "Adauga cantitate", "Diferenta", "Modific"};
    private static final Class[] types = new Class[]{String.class, String.class, String.class, String.class, String.class, Boolean.class};
    private StockLogic stockLogic;
    private JComboBox magazii;
    private JComboBox inventare;
    private JComboBox categorii;
    private Hashtable printCriteria = new Hashtable();
    private Hashtable searchCriteria;
    private ReportInterface reportInterface;
    private static final String NOU_TEXT = "Nou";
    private Corectie inventar = null;
    private JButton stergeInventar;
    private JButton golireFaptic;
    private JButton scriptic;
    private JButton incarcaFacpticDinXml;

    public StocFapticPanel() {
        this.stockLogic = StockLogic.getInstance();
    }

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        this.searchCriteria = new Hashtable();
        this.searchCriteria.put(Constants.START_KEY, startDate);
        this.printCriteria.put("Data stoc", startDate);
        if (ComboUtils.anythingButAllSelected(this.magazii)) {
            Magazie m = (Magazie)this.magazii.getSelectedItem();
            this.searchCriteria.put("id_magazie", m.getId());
            this.printCriteria.put("Magazie", m.getLabel());
        } else {
            this.searchCriteria.put("id_magazie", -1);
            this.printCriteria.remove("Magazie");
        }
        if (ComboUtils.anythingButAllSelected(this.categorii)) {
            Categorie c = (Categorie)this.categorii.getSelectedItem();
            this.searchCriteria.put("Categorie", c.getId());
            this.printCriteria.put("Categorie", c.getName());
        } else {
            this.searchCriteria.put("Categorie", -1);
            this.printCriteria.remove("Categorie");
        }
        return this.searchCriteria;
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        int idMagazie = (Integer)criteria.get("id_magazie");
        int idCategorie = (Integer)criteria.get("Categorie");
        Date date = (Date)criteria.get(Constants.START_KEY);
        return this.stockLogic.getStockComparativ(idMagazie, new Timestamp(date.getTime()), this.inventar, idCategorie, this.whatToPrint);
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    StockComparativEntry sqv = (StockComparativEntry)o;
                    try {
                        Label label = new Label(0, row, sqv.getStock());
                        sheet.addCell((WritableCell)label);
                        sheet.addCell((WritableCell)new Number(1, row, sqv.getScriptic()));
                        sheet.addCell((WritableCell)new Number(2, row, sqv.getFaptic()));
                        sheet.addCell((WritableCell)new Number(3, row, sqv.getDiferenta()));
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return StocFapticPanel.this.getName();
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public String getName() {
        return "Diferente inventar";
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, types, new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                String s = (String)aValue;
                if (Validators.correctDouble(s)) {
                    double q = Utils.parseDouble(s);
                    StockComparativEntry sqv = (StockComparativEntry)data.elementAt(rowIndex);
                    if (columnIndex == 2) {
                        if (StocFapticPanel.this.inventar == null) {
                            StocFapticPanel.this.stockLogic.replaceFapticForStockAndMagazie(sqv.getIdStock(), sqv.getIdMagazie(), q);
                        }
                        sqv.setFaptic(q);
                        sqv.setFapticSet(true);
                    }
                    if (columnIndex == 3) {
                        if (StocFapticPanel.this.inventar == null) {
                            StocFapticPanel.this.stockLogic.addStockFaptic(sqv.getIdStock(), sqv.getIdMagazie(), q);
                        }
                        double initial = sqv.getFaptic();
                        sqv.setFaptic(q + initial);
                        sqv.setFapticSet(true);
                        s = "";
                    }
                    sqv.compute();
                    StocFapticPanel.this.tm.fireTableRowsUpdated(rowIndex, rowIndex);
                } else {
                    s = "";
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 2: {
                        return true;
                    }
                    case 3: {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                StockComparativEntry sqv = (StockComparativEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return sqv.getStock();
                    }
                    case 1: {
                        return Utils.getString3Decimals(sqv.getScriptic());
                    }
                    case 2: {
                        return Utils.getFloatStringOrEmpty3Decimals(sqv.getFaptic());
                    }
                    case 4: {
                        return Utils.getFloatStringOrEmpty3Decimals(sqv.getDiferenta());
                    }
                    case 5: {
                        return new Boolean(sqv.isFapticSet());
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        final StocFapticPanel panel = this;
        c.gridy = 0;
        c.gridx = 0;
        this.scriptic = new JButton("Initializeaza cu scriptic");
        this.scriptic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(panel, "Initializam stocul faptic cu cel scriptic", LangRoAll.confirmare)) {
                    Magazie m = (Magazie)StocFapticPanel.this.magazii.getSelectedItem();
                    for (int i = 0; i < StocFapticPanel.this.data.size(); ++i) {
                        StockComparativEntry o = (StockComparativEntry)StocFapticPanel.this.data.elementAt(i);
                        StocFapticPanel.this.stockLogic.replaceFapticForStockAndMagazie(o.getIdStock(), o.getIdMagazie(), o.getScriptic());
                    }
                    StocFapticPanel.this.raport();
                }
            }
        });
        result.add((Component)this.scriptic, c);
        ++c.gridx;
        JButton action = new JButton("Salveaza inventar");
        action.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(panel, "Salvam inventarul", LangRoAll.confirmare)) {
                    boolean fiscal = true;
                    if (Config.getInstance().getBoolean("piratMode")) {
                        switch (StocFapticPanel.this.whatToPrint) {
                            case 1: 
                            case 3: {
                                fiscal = false;
                            }
                        }
                    }
                    if (StocFapticPanel.this.inventar == null) {
                        boolean allOk = true;
                        for (int i = 0; i < StocFapticPanel.this.data.size(); ++i) {
                            StockComparativEntry o = (StockComparativEntry)StocFapticPanel.this.data.elementAt(i);
                            if (o.getFaptic() != 0.0 || o.getScriptic() == 0.0) continue;
                            allOk = false;
                        }
                        if (!allOk && !DialogUtils.confirmDialog(panel, "Exista stocuri pentru care nu s-a introdus fapticul. Continuam", LangRoAll.confirmare)) {
                            return;
                        }
                        Magazie m = (Magazie)StocFapticPanel.this.magazii.getSelectedItem();
                        Date s = (Date)StocFapticPanel.this.printCriteria.get("Data stoc");
                        StocFapticPanel.this.stockLogic.corecteazaCuFaptic(m.getId(), StocFapticPanel.this.data, new Timestamp(s.getTime()), fiscal, StocFapticPanel.this.whatToPrint);
                    } else {
                        Date s = StocFapticPanel.this.dateSelector.getDates()[0];
                        Timestamp t = new Timestamp(s.getTime());
                        StocFapticPanel.this.stockLogic.modificaInventar(StocFapticPanel.this.inventar.getId(), panel, StocFapticPanel.this.inventar.getDateadd(), t, StocFapticPanel.this.data, fiscal, StocFapticPanel.this.whatToPrint);
                    }
                    StocFapticPanel.this.magazii.setSelectedIndex(0);
                    StocFapticPanel.this.table.refresh(new Vector());
                }
            }
        });
        result.add((Component)action, c);
        ++c.gridx;
        this.golireFaptic = new JButton("Goleste faptic");
        this.golireFaptic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Magazie m = (Magazie)StocFapticPanel.this.magazii.getSelectedItem();
                if (m != null && DialogUtils.confirmDialog(panel, "Golim stocul faptic", LangRoAll.confirmare)) {
                    StocFapticPanel.this.stockLogic.deleteAllFaptic(m.getId());
                    StocFapticPanel.this.raport();
                }
            }
        });
        result.add((Component)this.golireFaptic, c);
        ++c.gridx;
        this.incarcaFacpticDinXml = new JButton("Incarca faptic din XML");
        this.incarcaFacpticDinXml.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (DialogUtils.confirmDialog(panel, "Incarcam faptic din XML", LangRoAll.confirmare) && DialogUtils.confirmDialog(panel, "Fapticul actual va fi sters. Continuam", LangRoAll.confirmare)) {
                    Magazie m = (Magazie)StocFapticPanel.this.magazii.getSelectedItem();
                    String inputFile = FileDialog.getLoadDialogLocation(panel, "Alegeti fisierul de import", "xml");
                    if (inputFile != null) {
                        StocFapticPanel.this.stockLogic.incarcaFapticDinXml(inputFile, m.getId());
                        StocFapticPanel.this.raport();
                        DialogUtils.okDialog(panel, "Operatie efectuata", LangRoAll.succes);
                    } else {
                        DialogUtils.errorDialog(panel, "Operatie anulata", "Cancel");
                    }
                }
            }
        });
        result.add((Component)this.incarcaFacpticDinXml, c);
        ++c.gridx;
        this.stergeInventar = new JButton("Sterge inventar");
        this.stergeInventar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (StocFapticPanel.this.inventar != null && DialogUtils.confirmDialog(panel, "Stergem acest inventar", LangRoAll.confirmare)) {
                    StocFapticPanel.this.stockLogic.stergeInventar(StocFapticPanel.this.inventar.getId(), panel, StocFapticPanel.this.inventar.getDateadd());
                    StocFapticPanel.this.magazii.setSelectedIndex(0);
                    StocFapticPanel.this.table.refresh(new Vector());
                }
            }
        });
        this.stergeInventar.setEnabled(false);
        result.add((Component)this.stergeInventar, c);
        ++c.gridx;
        JButton searchByCodBare = new JButton("Cod bare");
        searchByCodBare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String cod = DialogUtils.inputDialog(panel, "", "Introduceti codul de bare");
                Product p = NomeclaturaLogic.getInstance().getProductByCodBare(cod);
                if (p != null) {
                    int idStock = StocFapticPanel.this.stockLogic.getStockInterface().getIdStock(p.getId());
                    if (idStock > 0) {
                        int position = StocFapticPanel.this.findStock(idStock);
                        if (position > 0) {
                            StocFapticPanel.this.table.scrollRectToVisible(StocFapticPanel.this.table.getCellRect(position, 1, false));
                            ListSelectionModel selectionModel = StocFapticPanel.this.table.getSelectionModel();
                            selectionModel.setSelectionInterval(position, position);
                        } else {
                            DialogUtils.errorDialog(panel, "Produsul cautat nu se regaseste in tabel. Verificati magazia.", LangRoAll.nuPotContinua);
                        }
                    } else {
                        DialogUtils.errorDialog(panel, "Produsul cautat nu este stocabil.", LangRoAll.nuPotContinua);
                    }
                } else {
                    DialogUtils.errorDialog(panel, "Produs negasit in baza de date. Atentie: Doar produsele vandabile au cod bare !", LangRoAll.nuPotContinua);
                }
            }
        });
        result.add((Component)searchByCodBare, c);
        final StocFapticPanel parent = this;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        JButton productie = new JButton("Productie cu inventar intermitent");
        productie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String s2 = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
                    String startS = DialogUtils.inputDialog(parent, s2, "Introduceti data productiei precedente");
                    if (!Validators.correctDate(startS, Formatters.DATE_AND_TIME_FORMAT)) {
                        DialogUtils.errorDialog(parent, "Format de data incorect", LangRoAll.nuPotContinua);
                        return;
                    }
                    Date start = Formatters.DATE_AND_TIME_FORMAT.parse(startS);
                    Date dataInventar = (Date)StocFapticPanel.this.searchCriteria.get(Constants.START_KEY);
                    s2 = Formatters.DATE_AND_TIME_FORMAT.format(dataInventar);
                    String stopS = DialogUtils.inputDialog(parent, s2, "Introduceti data productiei actuale");
                    if (!Validators.correctDate(stopS, Formatters.DATE_AND_TIME_FORMAT)) {
                        DialogUtils.errorDialog(parent, "Format de data incorect", LangRoAll.nuPotContinua);
                        return;
                    }
                    Date stop = Formatters.DATE_AND_TIME_FORMAT.parse(stopS);
                    int idMagazie = (Integer)StocFapticPanel.this.searchCriteria.get("id_magazie");
                    Vector<Tag> materiiPrimeTags = new Vector<Tag>();
                    Tag pui = TagsLogic.getInstance().getTagByName("pui");
                    materiiPrimeTags.add(pui);
                    Vector<Tag> produseFiniteTags = new Vector<Tag>();
                    Tag piese = TagsLogic.getInstance().getTagByName("piese");
                    produseFiniteTags.add(piese);
                    Magazie magazie = StocFapticPanel.this.stockLogic.getMagazieById(idMagazie);
                    Hashtable<Integer, StockComparativEntry> stockComparativEntryHashtable = new Hashtable<Integer, StockComparativEntry>();
                    for (StockComparativEntry stockComparativEntry : StocFapticPanel.this.tm.getData()) {
                        stockComparativEntryHashtable.put(stockComparativEntry.getIdStock(), stockComparativEntry);
                    }
                    StocFapticPanel.this.stockLogic;
                    Vector<NirEntryFull> nirEntries = StockLogic.getInstance().calculeazaProductieCuInventarIntermitent(start, stop, stockComparativEntryHashtable, produseFiniteTags, materiiPrimeTags, magazie);
                    GenericListenersLogic.getInstance().notifyObjectListeners(Constants.ADD_NIR_ENTRY_FULL_KEY, nirEntries);
                    DialogUtils.okDialog(panel, "Inregistrarile au fost adaugate in ecranul de adaugare nir", LangRoAll.succes);
                }
                catch (ParseException e1) {
                    Logger.logException(this, (Exception)e1);
                    return;
                }
            }
        });
        result.add((Component)productie, c);
        return result;
    }

    private int findStock(int idStock) {
        for (int i = 0; i < this.data.size(); ++i) {
            StockComparativEntry stockComparativEntry = (StockComparativEntry)this.data.elementAt(i);
            if (stockComparativEntry.getIdStock() != idStock) continue;
            return i;
        }
        return -1;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 17;
        c.fill = 1;
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        buttonsPanel.add((Component)new JLabel("Magazie"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.magazii = new JComboBox();
        buttonsPanel.add((Component)this.magazii, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        buttonsPanel.add((Component)new JLabel("Inventar"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.inventare = new JComboBox();
        buttonsPanel.add((Component)this.inventare, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        buttonsPanel.add((Component)new JLabel(LangRoAll.categorie), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.categorii = new JComboBox();
        buttonsPanel.add((Component)this.categorii, c);
        return buttonsPanel;
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public DateSelectorInterface getDateSelector() {
        return new SimpleDateSelector();
    }

    @Override
    public void doStuff() {
        ComboUtils.replaceItemsForCombo(this.magazii, this.stockLogic.getMagazii(), false);
        ComboUtils.replaceItemsForCombo(this.categorii, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder());
        this.magazii.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Magazie m = (Magazie)StocFapticPanel.this.magazii.getSelectedItem();
                if (m != null) {
                    Vector corectii = StocFapticPanel.this.stockLogic.getCorectiiForMagazie(m.getId());
                    ComboUtils.replaceItemsForCombo(StocFapticPanel.this.inventare, corectii, true, StocFapticPanel.NOU_TEXT);
                    StocFapticPanel.this.inventare.setSelectedIndex(0);
                }
            }
        });
        this.inventare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Object o = StocFapticPanel.this.inventare.getSelectedItem();
                if (o instanceof Corectie) {
                    Corectie c = (Corectie)o;
                    StocFapticPanel.this.dateSelector.setStopDate(c.getDateadd());
                    StocFapticPanel.this.inventar = c;
                    StocFapticPanel.this.stergeInventar.setEnabled(true);
                    StocFapticPanel.this.golireFaptic.setEnabled(false);
                    StocFapticPanel.this.scriptic.setEnabled(false);
                } else {
                    StocFapticPanel.this.dateSelector.setStopDate(DateUtils.getCurrentTimestamp());
                    StocFapticPanel.this.inventar = null;
                    StocFapticPanel.this.stergeInventar.setEnabled(false);
                    StocFapticPanel.this.golireFaptic.setEnabled(true);
                    StocFapticPanel.this.scriptic.setEnabled(true);
                }
            }
        });
        this.stockLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(StocFapticPanel.this.magazii, StocFapticPanel.this.stockLogic.getMagazii(), false);
            }

            @Override
            public String getName() {
                return "StockViewPanel_magazii";
            }
        }, 27);
        NomeclaturaLogic.getInstance().addListener(new EventListener(){

            @Override
            public void dataChanged() {
                ComboUtils.replaceItemsForCombo(StocFapticPanel.this.categorii, NomeclaturaLogic.getInstance().getCategoriiNaturalOrder());
            }

            @Override
            public String getName() {
                return "StockViewPanel_categorii";
            }
        }, 1);
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                switch (column) {
                    case 0: {
                        return 6;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 0;
                    }
                    case 4: {
                        return 2;
                    }
                }
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return StocFapticPanel.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return StocFapticPanel.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                StockComparativEntry sqv = (StockComparativEntry)row;
                switch (column) {
                    case 0: {
                        return sqv.getStock();
                    }
                    case 1: {
                        return Utils.getString3Decimals(sqv.getScriptic());
                    }
                    case 2: {
                        return Utils.getString3Decimals(sqv.getFaptic());
                    }
                    case 3: {
                        return "";
                    }
                    case 4: {
                        return Utils.getString3Decimals(sqv.getDiferenta());
                    }
                }
                return null;
            }
        };
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }

    @Override
    public void cleanup() {
        this.magazii.removeAllItems();
    }
}

