/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.stocks.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import ro.atreides.stocks.gui.StockViewEntry;
import ro.atreides.utils.gui.table.AbstractTM;

public class StockViewCellRenderer
extends DefaultTableCellRenderer {
    private AbstractTM model;

    public StockViewCellRenderer(AbstractTM model) {
        this.model = model;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        StockViewEntry se = (StockViewEntry)this.model.getData().elementAt(row);
        switch (column) {
            case 0: {
                if (se.isSelected()) {
                    this.setBackground(Color.YELLOW);
                    this.setForeground(Color.BLACK);
                    break;
                }
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                break;
            }
            case 3: {
                if (se.isWarning()) {
                    this.setBackground(Color.YELLOW);
                    this.setForeground(Color.BLACK);
                    break;
                }
                if (se.isCritical()) {
                    this.setBackground(Color.RED);
                    this.setForeground(Color.BLACK);
                    break;
                }
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
                break;
            }
            default: {
                this.setBackground(Color.WHITE);
                this.setForeground(Color.BLACK);
            }
        }
        return this;
    }
}

