/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.update;

import java.io.File;
import java.util.List;
import ro.atreides.update.Code;
import ro.atreides.update.Version;
import ro.atreides.update.files.FileHandler;
import ro.atreides.utils.Logger;

public class VersionInstall {
    public boolean install(Version v, String applicationRoot) {
        String archive = v.getArchive();
        String versionsDirectory = applicationRoot + File.separator + "versions";
        String fullArchive = versionsDirectory + File.separator + archive;
        FileHandler.unZip(fullArchive);
        String archiveName = archive.substring(0, archive.lastIndexOf("."));
        String backupDir = versionsDirectory + File.separator + "backup" + File.separator + archiveName;
        String archiveDir = versionsDirectory + File.separator + archiveName;
        if (!new File(backupDir).exists() && !new File(backupDir).mkdirs()) {
            System.out.println("VersionInstall.install: Directory " + backupDir + " couldn't be created");
            return false;
        }
        List codeList = v.getCode();
        for (int i = 0; i < codeList.size(); ++i) {
            if (this.parseCode((Code)codeList.get(i), applicationRoot, backupDir, archiveDir)) continue;
            return false;
        }
        FileHandler.appendFile(versionsDirectory + File.separator + "db_update.txt", v.getDb());
        FileHandler.appendFile(versionsDirectory + File.separator + "changelog.txt", v.getDocs());
        return true;
    }

    private boolean parseCode(Code c, String applicationRoot, String backup, String archiveDir) {
        int lRem = c.getToRemove().length();
        int lAdd = c.getToAdd().length();
        boolean result = true;
        if (lRem > 0 && lAdd > 0) {
            if (!this.codeToRemove(c, applicationRoot, backup)) {
                System.out.println("Warning: File \"" + c.getToRemove() + "\" wasn't removed");
            }
            result = this.codeToAdd(c, applicationRoot, backup, archiveDir);
        } else if (lAdd > 0) {
            result = this.codeToAdd(c, applicationRoot, backup, archiveDir);
        } else if (lRem > 0) {
            this.codeToRemove(c, applicationRoot, backup);
        }
        return result;
    }

    private boolean codeToRemove(Code c, String applicationRoot, String backupDir) {
        try {
            String fileToRemove = c.getToRemove();
            String pathToRemove = applicationRoot + File.separator + c.getPath() + File.separator + fileToRemove;
            File f = new File(pathToRemove);
            if (f.exists()) {
                File fb = new File(backupDir + File.separator + fileToRemove);
                FileHandler.copy(f, fb);
                if (f.canWrite()) {
                    f.delete();
                } else {
                    f.deleteOnExit();
                }
            }
        }
        catch (Exception e) {
            Logger.logException(this, e);
            return false;
        }
        return true;
    }

    private boolean codeToAdd(Code c, String applicationRoot, String backupDir, String archiveDir) {
        try {
            String fileToAdd = c.getToAdd();
            String destPath = applicationRoot + File.separator + c.getPath() + File.separator + fileToAdd;
            File fSrc = new File(archiveDir + File.separator + fileToAdd);
            File fDest = new File(destPath);
            File fBackup = new File(backupDir + File.separator + fileToAdd);
            FileHandler.copy(fSrc, fBackup);
            if (!fSrc.exists()) {
                System.out.println("File \"" + archiveDir + File.separator + fileToAdd + "\" doesn't exist");
                return false;
            }
            FileHandler.copy(fSrc, fDest);
        }
        catch (Exception e) {
            Logger.logException(this, e);
            return false;
        }
        return true;
    }
}

