/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.update.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import ro.atreides.update.files.MD5;

public class FileHandler {
    public static boolean downloadURL(String source, String localDirectory) {
        try {
            int data;
            URL sourcefile = new URL(source);
            URLConnection connection = sourcefile.openConnection();
            InputStream in = connection.getInputStream();
            if (!new File(localDirectory).exists() && !new File(localDirectory).mkdirs()) {
                System.out.println("FileHandler.downloadURL: Directory " + localDirectory + " couldn't be created");
                return false;
            }
            File f = new File(localDirectory + File.separatorChar + source.substring(1 + source.lastIndexOf("/")));
            FileOutputStream fout = new FileOutputStream(f);
            while ((data = in.read()) > -1) {
                fout.write(data);
            }
            in.close();
            fout.flush();
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        out.flush();
        ((OutputStream)out).close();
    }

    public static boolean createEmptyFile(String name) {
        try {
            File f1 = new File(name);
            if (f1.exists()) {
                f1.delete();
            }
            f1.createNewFile();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean appendFile(String fileName, String string) {
        try {
            FileWriter f = new FileWriter(fileName, true);
            f.write(string + "\n");
            f.flush();
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean delDir(File dir) {
        if (!dir.isDirectory()) {
            System.out.println(dir.getName() + " is not a directory");
            return false;
        }
        try {
            File[] contents = dir.listFiles();
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i].isDirectory()) {
                    FileHandler.delDir(contents[i]);
                    continue;
                }
                contents[i].delete();
            }
            dir.delete();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean md5check(String name, String md5) {
        byte[] buf = new byte[397];
        byte[] out = new byte[16];
        int len = 0;
        MD5 md = new MD5();
        try {
            int rc;
            FileInputStream fin = new FileInputStream(name);
            while ((rc = fin.read(buf, 0, 397)) > 0) {
                md.update(buf, rc);
                len += rc;
            }
            md.md5final(out);
            System.out.println("md5(" + name + ") computed: " + MD5.dumpBytes(out) + " correct: " + md5);
            if (md5.equals(MD5.dumpBytes(out))) {
                return true;
            }
            fin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static boolean unZip(String inFilename) {
        String unzipDirectory;
        if (!".zip".equals(inFilename.substring(inFilename.lastIndexOf(".")))) {
            System.out.println("FileHandler.unZip: File " + inFilename + " doesn't end with <.zip>");
        }
        if (!new File(unzipDirectory = inFilename.substring(0, inFilename.lastIndexOf("."))).exists() && !new File(unzipDirectory).mkdir()) {
            System.out.println("FileHandler.unZip: Directory " + unzipDirectory + " couldn't be created");
            return false;
        }
        try {
            ZipFile zf = new ZipFile(inFilename);
            ZipInputStream in = new ZipInputStream(new FileInputStream(inFilename));
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int len;
                String zipEntryName = entries.nextElement().getName();
                in.getNextEntry();
                FileOutputStream out = new FileOutputStream(unzipDirectory + File.separatorChar + zipEntryName);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

