/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.users.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import ro.atreides.print.PrintLogic;
import ro.atreides.users.User;
import ro.atreides.users.UserLogEntry;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Constants;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.excel.ExcelUtils;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.ReportInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.reports.AbstractReportPanel;

public class UserLogReport
extends AbstractReportPanel {
    public static final String[] columns = new String[]{LangRoAll.utilizator, LangRoAll.data, LangRoAll.operatie};
    private ReportInterface reportInterface;
    private Hashtable printCriteria = new Hashtable();
    protected JComboBox waiters;
    protected JComboBox tipOperatie;

    @Override
    public Hashtable buildCriteria(Date startDate, Date stopDate) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put(Constants.START_KEY, startDate);
        result.put(Constants.STOP_KEY, stopDate);
        this.printCriteria.put(Constants.START_KEY, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(startDate));
        this.printCriteria.put(Constants.STOP_KEY, Formatters.DATE_AND_TIME_AND_SECONDS_HUMAN_FORMAT.format(stopDate));
        Object waiter = this.waiters.getSelectedItem();
        if (waiter instanceof User) {
            result.put(Constants.WAITER_KEY, waiter);
            this.printCriteria.put(Constants.WAITER_KEY, waiter);
        } else {
            this.printCriteria.remove(Constants.WAITER_KEY);
        }
        if (ComboUtils.anythingButAllSelected(this.tipOperatie)) {
            String tp = (String)this.tipOperatie.getSelectedItem();
            result.put(Constants.USER_LOG_TIP_OPERATIE_KEY, tp);
            this.printCriteria.put(Constants.USER_LOG_TIP_OPERATIE_KEY, tp);
        } else {
            this.printCriteria.remove(Constants.USER_LOG_TIP_OPERATIE_KEY);
        }
        return result;
    }

    @Override
    public JPanel buildCustomParamsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 17;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.operator), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.waiters = new JComboBox();
        result.add((Component)this.waiters, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        result.add((Component)new JLabel(LangRoAll.tipOperatie), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.tipOperatie = new JComboBox();
        result.add((Component)this.tipOperatie, c);
        return result;
    }

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                UserLogEntry sve = (UserLogEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return sve.getUser();
                    }
                    case 1: {
                        return sve.getDateadd();
                    }
                    case 2: {
                        return sve.getText();
                    }
                }
                return null;
            }
        });
        return this.tm;
    }

    @Override
    public JPanel buildTotalPanel() {
        final UserLogReport panel = this;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 2;
        c.gridy = 0;
        c.gridx = 0;
        if (Config.getInstance().getBoolean("showStergereButtons")) {
            JButton sterge = new JButton(LangRoAll.sterge);
            sterge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (DialogUtils.confirmDialog(panel, Utils.getTranslation(LangRoAll.stergemUserLog, new String[0]), LangRoAll.atentie)) {
                        UsersLogic.getInstance().deleteUserLog();
                        UserLogReport.this.raport();
                    }
                }
            });
            sterge.setMargin(new Insets(1, 1, 1, 1));
            result.add((Component)sterge, c);
        }
        return result;
    }

    @Override
    public String getName() {
        return LangRoAll.actiuniUtilizatori;
    }

    @Override
    public Vector getResult(Hashtable criteria) {
        return UsersLogic.getInstance().getUserActions(criteria);
    }

    @Override
    public void printPreview() {
        String pdfFile = PrintLogic.getInstance().buildReportPdfText(this.data, this.reportInterface);
        PrintLogic.getInstance().printPreview(pdfFile);
    }

    @Override
    public void printReport() {
        PrintLogic.getInstance().printReport(this, this.reportInterface, this.data);
    }

    @Override
    public void refreshTotalPanel() {
    }

    @Override
    public void writeExcel(File reportFile) {
        try {
            ExcelUtils.writeExcel(reportFile, this.data, new ExcelProcessor(){

                @Override
                public void processLine(Object o, WritableSheet sheet, int row) {
                    UserLogEntry sve = (UserLogEntry)UserLogReport.this.data.elementAt(row);
                    try {
                        Label label = new Label(0, row, sve.getUser());
                        sheet.addCell((WritableCell)label);
                        label = new Label(1, row, sve.getDateadd());
                        sheet.addCell((WritableCell)label);
                        label = new Label(2, row, sve.getText());
                        sheet.addCell((WritableCell)label);
                    }
                    catch (RowsExceededException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                    catch (WriteException e) {
                        Logger.logException(this, (Exception)((Object)e));
                    }
                }

                @Override
                public String[] getColumns() {
                    return columns;
                }

                @Override
                public String getSheetName() {
                    return UserLogReport.this.getName();
                }

                @Override
                public int buildHeader(WritableSheet sheet, int startRow) {
                    return 0;
                }

                @Override
                public void buildTotal(WritableSheet sheet, int row, int firstTableRow, int lastTableRow) {
                }
            }, this.printCriteria);
        }
        catch (WriteException e) {
            Logger.logException(this, (Exception)((Object)e));
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    @Override
    public void doStuff() {
        this.reportInterface = new ReportInterface(){

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public int getColumnSize(int column) {
                return 1;
            }

            @Override
            public String getColumnName(int column) {
                return columns[column];
            }

            @Override
            public String getTotal(int column) {
                return "";
            }

            @Override
            public String getReportTitle() {
                return UserLogReport.this.getName();
            }

            @Override
            public Hashtable getCriteria() {
                return UserLogReport.this.printCriteria;
            }

            @Override
            public boolean isLandscape() {
                return false;
            }

            @Override
            public String getCellContent(Object row, int column) {
                UserLogEntry sve = (UserLogEntry)row;
                switch (column) {
                    case 0: {
                        return sve.getUser();
                    }
                    case 1: {
                        return sve.getDateadd();
                    }
                    case 2: {
                        return sve.getText();
                    }
                }
                return null;
            }
        };
        ComboUtils.replaceItemsForCombo(this.waiters, UsersLogic.getInstance().getAllUsers());
        this.addTipOperatie();
    }

    protected void addTipOperatie() {
        this.tipOperatie.addItem("All");
        this.tipOperatie.addItem("Incasat ");
        this.tipOperatie.addItem("Bon marcaj ");
        this.tipOperatie.addItem("Nota ");
        this.tipOperatie.addItem("Intermediara ");
        this.tipOperatie.addItem("Proforma ");
        this.tipOperatie.addItem("Retiparire nota ");
        this.tipOperatie.addItem("Retur ");
        this.tipOperatie.addItem("Seara ");
        this.tipOperatie.addItem("X ");
        this.tipOperatie.addItem("Sters nota ");
        this.tipOperatie.addItem("Transfer ");
        this.tipOperatie.addItem("Sters rezervare ");
        this.tipOperatie.addItem("Sters sosire ");
        this.tipOperatie.addItem("Sters cazare ");
        this.tipOperatie.addItem("Tiparire factura ");
        this.tipOperatie.addItem("Modificare factura ");
        this.tipOperatie.addItem("Factura temporara ");
        this.tipOperatie.addItem("Anulare factura ");
    }

    @Override
    public Comparator getComparatorForColumn(int columnIndex) {
        return null;
    }
}

