/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.sql.Timestamp;
import java.util.Vector;
import ro.atreides.utils.ExportedByXml;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public abstract class Client
implements Comparable,
ExportedByXml {
    protected int id;
    protected int status;
    protected String city;
    protected String telefonFix;
    protected String fax;
    protected String telefonMobil;
    protected String email;
    protected String paginaWeb;
    protected String codSyncClient;
    private int idCountry;
    private Timestamp lastUpdated;
    protected Vector<String> adrese = new Vector();

    protected Client(int id, String city, String address, int idCountry, String telefonFix, String fax, String telefonMobil, String email, String paginaWeb, Timestamp lastUpdated) {
        this.id = id;
        this.city = city;
        this.adrese = Utils.splitString(address, '|');
        this.idCountry = idCountry;
        this.telefonFix = telefonFix;
        this.fax = fax;
        this.telefonMobil = telefonMobil;
        this.email = email;
        this.paginaWeb = paginaWeb;
        this.lastUpdated = lastUpdated;
    }

    public Client() {
    }

    public Timestamp getLastUpdated() {
        return this.lastUpdated;
    }

    public String getTelefoane(String separator) {
        StringBuffer result = new StringBuffer();
        if (Validators.correctString(this.telefonFix)) {
            result.append("F:" + this.telefonFix);
        }
        if (Validators.correctString(this.telefonMobil)) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append("M:" + this.telefonMobil);
        }
        return result.toString();
    }

    public String getTelefoaneShort(String separator) {
        StringBuffer result = new StringBuffer();
        if (Validators.correctString(this.telefonFix)) {
            result.append(this.telefonFix);
        }
        if (Validators.correctString(this.telefonMobil)) {
            if (result.length() > 0) {
                result.append(separator);
            }
            result.append(this.telefonMobil);
        }
        return result.toString();
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public int getIdCountry() {
        return this.idCountry;
    }

    public void setIdCountry(int idCountry) {
        this.idCountry = idCountry;
    }

    public String getAddress1() {
        return this.getAddressAsString();
    }

    public void setAddress1(String address) {
        if (address != null) {
            this.adrese = Utils.splitString(address, '|');
        }
    }

    public Vector<String> getAdrese() {
        return this.adrese;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Client)) {
            return false;
        }
        Client c = (Client)obj;
        return c.id == this.id;
    }

    public String getEmail() {
        return this.email;
    }

    public String getTelefonFix() {
        return this.telefonFix;
    }

    public void setTelefonFix(String telefonFix) {
        this.telefonFix = telefonFix;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getPaginaWeb() {
        return this.paginaWeb;
    }

    public void setPaginaWeb(String paginaWeb) {
        this.paginaWeb = paginaWeb;
    }

    public String getTelefonMobil() {
        return this.telefonMobil;
    }

    public void setTelefonMobil(String telefonMobil) {
        this.telefonMobil = telefonMobil;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDateContact(String lineSeparator) {
        StringBuffer result = new StringBuffer();
        if (Validators.correctString(this.telefonFix)) {
            result.append(lineSeparator);
            result.append("Fix: " + this.telefonFix);
        }
        if (Validators.correctString(this.telefonMobil)) {
            result.append(lineSeparator);
            result.append("Mobil: " + this.telefonMobil);
        }
        if (Validators.correctString(this.fax)) {
            result.append(lineSeparator);
            result.append("Fax: " + this.fax);
        }
        if (Validators.correctString(this.email)) {
            result.append(lineSeparator);
            result.append("Email: " + this.email);
        }
        if (Validators.correctString(this.paginaWeb)) {
            result.append(lineSeparator);
            result.append("Web: " + this.paginaWeb);
        }
        if (this.adrese.size() > 0) {
            result.append(lineSeparator);
            result.append("Adresa: " + this.getAddressAsString() + "," + this.city);
        }
        return result.toString();
    }

    public String getAddressAsString() {
        return this.getAddressAsString('|');
    }

    public String getAddressAsString(char separator) {
        String result = "";
        for (String s : this.adrese) {
            result = result + s + separator;
        }
        if (result.length() > 1) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public String getProblems() {
        return "";
    }

    public String getCodSyncClient() {
        return this.codSyncClient;
    }

    public void setCodSyncClient(String codSync) {
        this.codSyncClient = codSync;
    }
}

