/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;

public class HttpUtils {
    public static String smsServletAddress = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadHttpPage(String fullAddress, String saveFile) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(saveFile);
            URL url = new URL(fullAddress);
            InputStream in = url.openStream();
            BufferedInputStream bufIn = new BufferedInputStream(in);
            int SIZE = 65535;
            byte[] buffer = new byte[SIZE];
            boolean stop = false;
            while (!stop) {
                int charsRead = bufIn.read(buffer);
                if (charsRead > 0) {
                    fos.write(buffer, 0, charsRead);
                    fos.flush();
                    continue;
                }
                stop = true;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getHttpPage(String fullAddress) {
        StringBuffer result = new StringBuffer();
        try {
            URL url = new URL(fullAddress);
            InputStream in = url.openStream();
            BufferedInputStream bufIn = new BufferedInputStream(in);
            int SIZE = 65535;
            byte[] buffer = new byte[SIZE];
            boolean stop = false;
            while (!stop) {
                int charsRead = bufIn.read(buffer);
                if (charsRead > 0) {
                    String s = new String(buffer, 0, charsRead);
                    result.append(s);
                    continue;
                }
                stop = true;
            }
            return result.toString();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String postHttpPage(String bigUrl) {
        int splitIndex = bigUrl.indexOf("?");
        String address = bigUrl.substring(0, splitIndex);
        String data = bigUrl.substring(splitIndex + 1);
        try {
            URL url = new URL(address);
            URLConnection conn = url.openConnection();
            int maxBlocking = 20000;
            conn.setReadTimeout(maxBlocking);
            conn.setConnectTimeout(maxBlocking);
            int blockingMillis = conn.getReadTimeout();
            blockingMillis = conn.getConnectTimeout();
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = rd.readLine();
            wr.close();
            rd.close();
            return line;
        }
        catch (IOException e) {
            Logger.logDebug("HttpUtils", "Exception for address : " + address);
            return null;
        }
    }

    public static String filterWebRequest(String referer, String[] allowedReferers) {
        Vector tokens = Utils.splitString(referer, '/');
        try {
            String refererServer = (String)tokens.get(1);
            for (int i = 0; i < allowedReferers.length; ++i) {
                String current = allowedReferers[i];
                if (!refererServer.equalsIgnoreCase(current)) continue;
                return refererServer;
            }
        }
        catch (Exception e) {
            Logger.logWarning(Class.class.getName(), "Referrer path incorect: " + referer);
        }
        return null;
    }
}

