/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils;

import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import ro.atreides.utils.Logger;

public class MailUtils {
    public static void sendMail(Properties props, Session session, String server, String from, String[] to, String subject, String message, String[] attachFiles, String loginname, String password) throws MessagingException {
        boolean debug = true;
        if (props == null) {
            props = new Properties();
        }
        props.put("mail.smtp.host", server);
        if (session == null) {
            session = Session.getDefaultInstance((Properties)props, null);
        }
        session.setDebug(debug);
        MimeMessage msg = new MimeMessage(session);
        msg.setSubject(subject);
        msg.setFrom((Address)new InternetAddress(from));
        InternetAddress[] addressTo = new InternetAddress[to.length];
        for (int i = 0; i < to.length; ++i) {
            addressTo[i] = new InternetAddress(to[i]);
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])addressTo);
        if (attachFiles != null) {
            MimeBodyPart bodyMessage = new MimeBodyPart();
            bodyMessage.setText(message);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)bodyMessage);
            for (int i = 0; i < attachFiles.length; ++i) {
                String file = attachFiles[i];
                MimeBodyPart bodyAttachment = new MimeBodyPart();
                bodyAttachment.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
                bodyAttachment.setFileName(file);
                multipart.addBodyPart((BodyPart)bodyAttachment);
            }
            msg.setContent((Multipart)multipart);
        } else {
            msg.setContent((Object)message, "text/plain");
        }
        Transport transport = session.getTransport("smtp");
        transport.connect(server, 587, loginname, password);
        transport.sendMessage((Message)msg, msg.getAllRecipients());
        transport.close();
    }

    public static void sendMailGoogleSMTP(final String username, final String password, String from, String[] to, String subject, String message, String[] attachFiles) throws MessagingException {
        Properties props = new Properties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.host", "smtp.gmail.com");
        props.put("mail.smtp.port", "587");
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        MailUtils.sendMail(props, session, "smtp.gmail.com", from, to, subject, message, attachFiles, username, password);
    }

    public static void sendMailGoogleSMTP(String username, String password, String from, String to, String subject, String message, String[] attachFiles) throws MessagingException {
        MailUtils.sendMailGoogleSMTP(username, password, from, new String[]{to}, subject, message, attachFiles);
    }

    public static void sendSms(final String number, final String message) {
        new Thread(){

            @Override
            public void run() {
                try {
                    MailUtils.sendMailGoogleSMTP("atreides.support", "atreides1234", "sms1@fabricadesoft.ro", "sms1@fabricadesoft.ro", number, message, null);
                }
                catch (MessagingException e) {
                    Logger.logException("MailUtils.sendSms", (Exception)((Object)e));
                }
            }
        }.start();
    }
}

