/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.db;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.sql.SqlUtils;

public class CommonsDao {
    public static void writeAvarieOnServer(Connection connection) throws SQLException {
        CallableStatement cs = connection.prepareCall("CALL app.avarieon()");
        cs.execute();
        cs.close();
    }

    public static boolean isAvarieOnServer(Connection connection) throws SQLException {
        String rez;
        String s = "values app.isavarieon()";
        ResultSet rs = SqlUtils.executeQuery(s, connection);
        boolean result = false;
        if (rs.next() && (rez = rs.getString(1)).equalsIgnoreCase("1")) {
            result = true;
        }
        rs.close();
        return result;
    }

    public static void backupDatabase(String root, String leaf, Connection connection) throws SQLException {
        String bkLocation = root + File.separator + leaf;
        if (new File(bkLocation).exists()) {
            throw new RuntimeException("location must not exist already");
        }
        CallableStatement cs = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE (?, ?)");
        cs.setString(1, bkLocation);
        cs.setInt(2, 1);
        cs.execute();
        cs.close();
    }

    public static void zipBackup(String sourcePath, String destinationPath, Connection connection) throws SQLException {
        CallableStatement cs = connection.prepareCall("CALL app.zipBackup(?, ?)");
        cs.setString(1, sourcePath);
        cs.setString(2, destinationPath);
        cs.execute();
        cs.close();
    }

    public static void verifyDatabase(Connection conn) throws SQLException {
        String s = "SELECT schemaname, tablename,SYSCS_UTIL.SYSCS_CHECK_TABLE(schemaname, tablename) FROM sys.sysschemas s, sys.systables t WHERE s.schemaid = t.schemaid";
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        while (rs.next()) {
            String s1 = rs.getString(1);
            String s2 = rs.getString(2);
            System.out.println(s1 + " : " + s2);
        }
        rs.close();
    }

    public static Timestamp getServerTimestamp(Connection conn) throws SQLException {
        Timestamp t1;
        Timestamp result = DateUtils.getCurrentTimestamp();
        String s = "select current_timestamp";
        ResultSet rs = SqlUtils.executeQuery(s, conn);
        if (rs.next() && (t1 = rs.getTimestamp(1)) != null) {
            result = t1;
        }
        rs.close();
        return result;
    }

    public static void freezeDatabase(Connection connection) throws SQLException {
        CallableStatement cs = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_FREEZE_DATABASE()");
        cs.execute();
        cs.close();
    }

    public static void unfreezeDatabase(Connection connection) throws SQLException {
        CallableStatement cs = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_UNFREEZE_DATABASE()");
        cs.execute();
        cs.close();
    }

    public static void compressDatabase(Connection conn) throws SQLException {
        String sql = "select schemaname, tablename from sys.sysschemas s, sys.systables t where s.schemaid=t.schemaid and t.tabletype='T'";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        CallableStatement cs = conn.prepareCall("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?,?, ?)");
        while (rs.next()) {
            String schema = rs.getString(1).trim();
            String table = rs.getString(2).trim();
            cs.setString(1, schema);
            cs.setString(2, table);
            cs.setShort(3, (short)1);
            cs.execute();
        }
        rs.close();
    }
}

