/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.db;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.db.DatabaseManager;

public class ConnectionPool {
    private Hashtable allConnections;
    private Hashtable assignedConnections;
    private static ConnectionPool instance = null;
    public static int MAX_CONNECTIONS = 5;
    public static final int MAX_RETRIES = 10;

    private ConnectionPool() throws SQLException {
        boolean ok = this.buildAllConnections();
        if (!ok) {
            SQLException ex = new SQLException("The connection has been terminated.");
            throw ex;
        }
    }

    private boolean buildAllConnections() {
        boolean ok = true;
        this.allConnections = new Hashtable();
        this.assignedConnections = new Hashtable();
        for (int i = 0; i < MAX_CONNECTIONS && ok; ++i) {
            ConnectionWrapper cw = this.buildNewConnection();
            if (cw != null) {
                this.allConnections.put(cw, new Hashtable());
                continue;
            }
            ok = false;
        }
        return ok;
    }

    public void buildDao(String className, ConnectionWrapper cw) {
        try {
            Object[] arguments = new Object[]{cw.getConnection()};
            Class[] c1 = new Class[]{Connection.class};
            Class<?> c2 = Class.forName(className);
            Constructor<?> c3 = c2.getConstructor(c1);
            DaoInterface c = (DaoInterface)c3.newInstance(arguments);
            c.buildPreparedStatements();
            Hashtable daos = (Hashtable)this.allConnections.get(cw);
            daos.put(className, c);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (InvocationTargetException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (NoSuchMethodException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (InstantiationException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IllegalAccessException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (ClassNotFoundException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    public void buildDaos(String className) {
        for (ConnectionWrapper cw : this.allConnections.keySet()) {
            this.buildDao(className, cw);
        }
    }

    public static synchronized ConnectionPool getFirstInstance() throws SQLException {
        instance = new ConnectionPool();
        return instance;
    }

    public static synchronized ConnectionPool getInstance() {
        return instance;
    }

    public synchronized boolean reconnectAll() {
        return this.buildAllConnections();
    }

    public synchronized ConnectionWrapper requestConnection() {
        Thread currentThread = Thread.currentThread();
        ConnectionWrapper wrapper = (ConnectionWrapper)this.assignedConnections.get(currentThread);
        if (wrapper == null) {
            wrapper = this.getFreeConnection();
        }
        this.assignedConnections.put(currentThread, wrapper);
        wrapper.setLastUsed(DateUtils.getCurrentTimestamp());
        return wrapper;
    }

    public synchronized void rollBack() throws SQLException {
        this.requestConnection().rollback();
    }

    public synchronized void commit() throws SQLException {
        this.requestConnection().commitTransaction();
    }

    public synchronized void releaseConnection() {
        Thread currentThread = Thread.currentThread();
        this.assignedConnections.remove(currentThread);
    }

    public synchronized Object getDao(Class daoClass, ConnectionWrapper connection) {
        Object result = null;
        Hashtable hash = (Hashtable)this.allConnections.get(connection);
        if (hash != null) {
            result = hash.get(daoClass.getName());
        }
        return result;
    }

    private ConnectionWrapper getFreeConnection() {
        ConnectionWrapper result = null;
        while (result == null) {
            for (ConnectionWrapper con : this.allConnections.keySet()) {
                if (this.assignedConnections.contains(con)) continue;
                result = con;
                break;
            }
            if (result != null) continue;
            ConnectionWrapper cw = this.buildNewConnection();
            if (cw != null) {
                this.allConnections.put(cw, new Hashtable());
                continue;
            }
            Logger.logError((Object)this, "FATALITY: Am ramas fara conexiuni valide");
        }
        return result;
    }

    private void printAssignedConnections() {
        String out = "Assigned connections " + this.assignedConnections.size() + "\n";
        for (Thread key : this.assignedConnections.keySet()) {
            out = out + "Thread: " + key + "\n";
            ConnectionWrapper value = (ConnectionWrapper)this.assignedConnections.get(key);
            out = out + " connection: " + value + "\n";
        }
        System.out.println(out);
        Logger.logDebug(this, out);
    }

    private ConnectionWrapper buildNewConnection() {
        try {
            ConnectionWrapper sql = DatabaseManager.getInstance().getConnectionWrapper(10);
            return sql;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (InstantiationException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (IllegalAccessException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (ClassNotFoundException e) {
            Logger.logException(this, (Exception)e);
        }
        return null;
    }

    public int getIdentityLocal() throws SQLException {
        return this.requestConnection().getIndentityLocal();
    }
}

