/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.DatabaseManager;
import ro.atreides.utils.sql.SqlUtils;

public class Shell
extends Thread {
    private boolean stop = false;
    private DatabaseManager db;

    public Shell(DatabaseManager db) {
        this.db = db;
        this.setName("Shell");
    }

    public void printResultSet(ResultSet rs) throws SQLException {
        int i;
        ResultSetMetaData meta = rs.getMetaData();
        int columns = meta.getColumnCount();
        for (i = 1; i <= columns; ++i) {
            System.out.print(meta.getColumnName(i) + "\t");
        }
        System.out.println();
        while (rs.next()) {
            for (i = 1; i <= columns; ++i) {
                System.out.print(rs.getObject(i) + "\t");
            }
            System.out.println();
        }
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                Shell.sleep(100L);
                byte[] input = new byte[1024];
                System.out.print("$ ");
                int read = System.in.read(input);
                if (read <= 0) continue;
                String s = new String(input, 0, read);
                if ((s = s.trim()).startsWith("select")) {
                    ResultSet rs = SqlUtils.executeQuery(s, this.db.getFirstConnection());
                    this.printResultSet(rs);
                    rs.close();
                    continue;
                }
                Connection conn = this.db.getFirstConnection();
                boolean result = SqlUtils.executeUpdate(s, conn);
                conn.commit();
                if (!result) continue;
                Logger.logDebug(this, "ok");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws SQLException {
        new Shell(DatabaseManager.getInstance()).start();
    }
}

