/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.events.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import ro.atreides.utils.events.Event;

public class EventsDao {
    private PreparedStatement add;
    private PreparedStatement getCloseDateForTimestamp;
    private PreparedStatement getOpenDateForTimestamp;
    private PreparedStatement getLastOpenDate;
    private PreparedStatement getLastCloseDate;
    private Connection conn;

    public EventsDao(Connection conn) throws SQLException {
        this.conn = conn;
        this.prepareStatements();
    }

    private void prepareStatements() throws SQLException {
        this.add = this.conn.prepareStatement("insert into events ( tip) values ( ?)");
        this.getLastOpenDate = this.conn.prepareStatement("select max(data) from events where tip = 0");
        this.getLastCloseDate = this.conn.prepareStatement("select max(data) from events where tip = 1");
        this.getCloseDateForTimestamp = this.conn.prepareStatement("select min(data) from events where tip = 0 and data > ?");
        this.getOpenDateForTimestamp = this.conn.prepareStatement("select max(data) from events where tip = 1 and data < ?");
    }

    public void add(Event event) throws SQLException {
        this.add.setInt(1, event.getType());
        this.add.execute();
    }

    public Timestamp getCloseDateForTimestamp(Timestamp t) throws SQLException {
        this.getCloseDateForTimestamp.setTimestamp(1, t);
        ResultSet rs = this.getCloseDateForTimestamp.executeQuery();
        if (rs.next()) {
            return rs.getTimestamp(1);
        }
        rs.close();
        return null;
    }

    public Timestamp getLastCloseDate() throws SQLException {
        ResultSet rs = this.getLastCloseDate.executeQuery();
        Timestamp result = null;
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public Timestamp getLastOpenDate() throws SQLException {
        ResultSet rs = this.getLastOpenDate.executeQuery();
        Timestamp result = null;
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public Timestamp getOpenDateForTimestamp(Timestamp t) throws SQLException {
        this.getOpenDateForTimestamp.setTimestamp(1, t);
        ResultSet rs = this.getOpenDateForTimestamp.executeQuery();
        Timestamp result = null;
        if (rs.next()) {
            result = rs.getTimestamp(1);
        }
        rs.close();
        return result;
    }

    public boolean isClosed() throws SQLException {
        Timestamp open = this.getLastOpenDate();
        Timestamp close = this.getLastCloseDate();
        if (open == null) {
            return true;
        }
        if (close == null) {
            return false;
        }
        return this.compareTimestamps(open, close) < 0L;
    }

    public boolean isOpen() throws SQLException {
        Timestamp open = this.getLastOpenDate();
        Timestamp close = this.getLastCloseDate();
        if (close == null) {
            return true;
        }
        if (open == null) {
            return false;
        }
        return this.compareTimestamps(open, close) > 0L;
    }

    private long compareTimestamps(Timestamp open, Timestamp close) {
        if (open == null) {
            if (close != null) {
                return -1L;
            }
            return 0L;
        }
        if (close == null) {
            if (open != null) {
                return 1L;
            }
            return 0L;
        }
        if (open.getTime() > close.getTime()) {
            return 1L;
        }
        if (open.getTime() < close.getTime()) {
            return -1L;
        }
        return 0L;
    }
}

