/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.excel;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import ro.atreides.utils.excel.ExcelImportInterface;
import ro.atreides.utils.excel.ExcelProcessor;
import ro.atreides.utils.multilang.LangRoAll;

public class ExcelUtils {
    public static void writeExcel(File toFile, Collection data, ExcelProcessor processor, Hashtable printCriteria) throws IOException, WriteException {
        WritableFont font = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat cellFormat = new WritableCellFormat(font);
        cellFormat.setAlignment(Alignment.CENTRE);
        WritableWorkbook wb = Workbook.createWorkbook((File)toFile);
        WritableSheet sheet = wb.createSheet(processor.getSheetName(), 0);
        int row = 0;
        int headerSize = processor.buildHeader(sheet, row);
        row += headerSize;
        String[] columns = processor.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Label l = new Label(i, row, columns[i], (CellFormat)cellFormat);
            sheet.addCell((WritableCell)l);
        }
        int firstTableRow = ++row;
        for (Object now : data) {
            processor.processLine(now, sheet, row);
            ++row;
        }
        processor.buildTotal(sheet, row, firstTableRow + 1, firstTableRow + data.size());
        if (printCriteria != null) {
            WritableSheet filtre = wb.createSheet("Filtre", 1);
            Vector v = new Vector(printCriteria.keySet());
            Collections.sort(v);
            Label l = new Label(0, 0, "Filtru");
            filtre.addCell((WritableCell)l);
            l = new Label(1, 0, LangRoAll.valoare);
            filtre.addCell((WritableCell)l);
            row = 1;
            for (int i = 0; i < v.size(); ++i) {
                String key = (String)v.elementAt(i);
                Object value = printCriteria.get(key);
                l = new Label(0, row, key);
                filtre.addCell((WritableCell)l);
                l = new Label(1, row, value.toString());
                filtre.addCell((WritableCell)l);
                ++row;
            }
        }
        wb.write();
        wb.close();
    }

    public static void readExcel(File source, ExcelImportInterface processor) throws IOException, BiffException {
        ExcelUtils.readExcel(source, processor, 0);
    }

    public static void readExcel(File source, ExcelImportInterface processor, int startAtLine) throws IOException, BiffException {
        Workbook workbook = Workbook.getWorkbook((File)source);
        Sheet[] sheets = workbook.getSheets();
        for (int k = 0; k < sheets.length; ++k) {
            Sheet sheet = workbook.getSheet(k);
            processor.sheetStart(sheet.getName());
            for (int i = startAtLine; i < sheet.getRows(); ++i) {
                Cell[] cells = sheet.getRow(i);
                processor.lineStart();
                for (int j = 0; j < cells.length; ++j) {
                    String value = cells[j].getContents();
                    processor.valueRead(i, j, value);
                }
                processor.lineEnd();
            }
            processor.sheetEnd(sheet.getName());
        }
        workbook.close();
    }
}

