/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.utils.Country;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.Validators;

public class AdresaPanel
extends JPanel {
    private JTextField[] adressField;
    private JTextField orasField;
    private Collection countries;
    private JComboBox countriesCombo;

    public AdresaPanel() {
        this.display();
    }

    public void initFields() {
        this.setAdresa("");
        this.setOras("");
        this.refreshCountriesSetSelected("Romania");
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        int adressesCount = Config.getInstance().getInt("clientiNumberOfAddresses", 1);
        this.adressField = new JTextField[adressesCount];
        for (int i = 0; i < adressesCount; ++i) {
            this.adressField[i] = new JTextField();
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            this.add((Component)this.adressField[i], c);
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Oras"), c);
        ++c.gridx;
        this.orasField = new JTextField("");
        this.add((Component)this.orasField, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Tara"), c);
        ++c.gridx;
        this.countriesCombo = new JComboBox();
        this.add((Component)this.countriesCombo, c);
        this.setBorder(new TitledBorder("Adresa"));
    }

    public String getAdresa() {
        String result = "";
        for (int i = 0; i < this.adressField.length; ++i) {
            String s1 = this.adressField[i].getText();
            if (!Validators.correctString(s1)) continue;
            result = result + s1 + '|';
        }
        return result;
    }

    public void setAdresa(String adresa) {
        Vector adresses = Utils.splitString(adresa, '|');
        if (adresses.size() > 0) {
            int i = 0;
            for (String s : adresses) {
                this.adressField[i].setText(s);
                if (++i < this.adressField.length) continue;
                break;
            }
        } else {
            this.adressField[0].setText("");
        }
    }

    public int getIdTara() {
        Country selected = (Country)this.countriesCombo.getSelectedItem();
        return selected.getId();
    }

    public void setTara(Country selected) {
        this.countriesCombo.setSelectedItem(selected);
    }

    public String getOras() {
        return this.orasField.getText();
    }

    public void setOras(String oras) {
        this.orasField.setText(oras);
    }

    public Collection getCountries() {
        return this.countries;
    }

    public void setCountries(Collection countries) {
        this.countries = countries;
        this.countriesCombo.removeAllItems();
        for (Country element : countries) {
            this.countriesCombo.addItem(element);
        }
        this.refreshCountriesSetSelected("Romania");
    }

    private void refreshCountriesSetSelected(String country) {
        if (country != null) {
            for (int i = 0; i < this.countriesCombo.getItemCount(); ++i) {
                Country item = (Country)this.countriesCombo.getItemAt(i);
                if (!item.getName().equals(country)) continue;
                this.countriesCombo.setSelectedItem(item);
            }
        } else {
            this.countriesCombo.setSelectedIndex(0);
        }
    }
}

