/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;

public class DateSelector
extends JPanel
implements DateSelectorInterface {
    private JLabel _dayLabel;
    private JLabel _periodLabel;
    private JLabel _startDayLabel;
    private JLabel _stopDayLabel;
    private JLabel _startTimeLabel;
    private JLabel _stopTimeLabel;
    private JRadioButton _dayRadioButton;
    private JRadioButton _periodRadioButton = null;
    private MDateEntryField _startDayTextField;
    private MDateEntryField _stopDayTextField;
    private MDateEntryField _dayTextField;
    private JTextField _startTimeField;
    private JTextField _stopTimeField;

    public DateSelector() {
        this.display();
    }

    @Override
    public void setStopDate(Date stop) {
        this._stopDayTextField.setValue(stop);
        String time = DateUtils.getTimeFromDate(stop);
        this._stopTimeField.setText(time);
    }

    @Override
    public void setStartDate(Date start) {
        this._startDayTextField.setValue(start);
        String time = DateUtils.getTimeFromDate(start);
        this._startTimeField.setText(time);
    }

    private JPanel initStartStopPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this._startDayLabel = new JLabel("Start: ");
        panel.add((Component)this._startDayLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this._startDayTextField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this._startDayTextField.setValue(new Date());
        this._startDayTextField.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this._startDayTextField.setConstraints((MDateSelectorConstraints)c1);
        this._startDayTextField.setToolTipText("Alege data start");
        this._startDayTextField.setMinimum(DateUtils.getStartOfCentury());
        this._startDayTextField.setShowTodayButton(true);
        panel.add((Component)this._startDayTextField, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this._startTimeLabel = new JLabel("Ora: ");
        panel.add((Component)this._startTimeLabel, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this._startTimeField = new JTextField(5);
        this._startTimeField.setText("00:00");
        panel.add((Component)this._startTimeField, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this._stopDayLabel = new JLabel("Stop: ");
        panel.add((Component)this._stopDayLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this._stopDayTextField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this._stopDayTextField.setValue(new Date());
        this._stopDayTextField.setEditable(true);
        MDefaultPullDownConstraints c2 = new MDefaultPullDownConstraints();
        c2.firstDay = 2;
        c2.changerStyle = 2;
        this._stopDayTextField.setConstraints((MDateSelectorConstraints)c2);
        this._stopDayTextField.setToolTipText("Alege data stop");
        this._stopDayTextField.setMinimum(DateUtils.getStartOfCentury());
        this._stopDayTextField.setShowTodayButton(true);
        panel.add((Component)this._stopDayTextField, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this._stopTimeLabel = new JLabel("Ora: ");
        panel.add((Component)this._stopTimeLabel, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this._stopTimeField = new JTextField(5);
        this._stopTimeField.setText("23:59");
        panel.add((Component)this._stopTimeField, c);
        return panel;
    }

    private JPanel initTimePanel() {
        JPanel startStopPanel = this.initStartStopPanel();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this._dayRadioButton = new JRadioButton();
        this._dayRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateSelector.this.enableDayFields(true);
                DateSelector.this.enablePeriodFields(false);
            }
        });
        panel.add((Component)this._dayRadioButton, c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this._dayLabel = new JLabel("Zi");
        panel.add((Component)this._dayLabel, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.anchor = 13;
        c.fill = 2;
        this._dayTextField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this._dayTextField.setValue(new Date());
        this._dayTextField.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this._dayTextField.setConstraints((MDateSelectorConstraints)c1);
        this._dayTextField.setToolTipText("Alege data start");
        this._dayTextField.setMinimum(DateUtils.getStartOfCentury());
        this._dayTextField.setShowTodayButton(true);
        panel.add((Component)this._dayTextField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.anchor = 17;
        c.fill = 0;
        this._periodRadioButton = new JRadioButton();
        this._periodRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateSelector.this.enablePeriodFields(true);
                DateSelector.this.enableDayFields(false);
            }
        });
        panel.add((Component)this._periodRadioButton, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.anchor = 17;
        c.fill = 0;
        this._periodLabel = new JLabel("Perioada");
        panel.add((Component)this._periodLabel, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.anchor = 10;
        c.fill = 2;
        panel.add((Component)startStopPanel, c);
        ++c.gridy;
        c.gridx = 0;
        JLabel sizeSetter = new JLabel("___________________________________");
        panel.add((Component)sizeSetter, c);
        return panel;
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 2;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        JPanel timePanel = this.initTimePanel();
        this.add((Component)timePanel, c);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._dayRadioButton);
        bg.add(this._periodRadioButton);
        this._dayRadioButton.doClick();
    }

    private void enableDayFields(boolean enable) {
        this._dayTextField.setEnabled(enable);
    }

    private void enablePeriodFields(boolean enable) {
        this._startDayLabel.setEnabled(enable);
        this._startDayTextField.setEnabled(enable);
        this._startTimeLabel.setEnabled(enable);
        this._startTimeField.setEnabled(enable);
        this._stopDayLabel.setEnabled(enable);
        this._stopDayTextField.setEnabled(enable);
        this._stopTimeLabel.setEnabled(enable);
        this._stopTimeField.setEnabled(enable);
    }

    public boolean isDaySelected() {
        return this._dayRadioButton.isSelected();
    }

    public boolean isPeriodSelected() {
        return this._periodRadioButton.isSelected();
    }

    @Override
    public void selectPeriod() {
        this._periodRadioButton.doClick();
    }

    @Override
    public void selectDay() {
        this._dayRadioButton.doClick();
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public Date[] getDates() {
        Date[] result = new Date[2];
        try {
            Date stop;
            Date start = this.isDaySelected() ? this._dayTextField.getValue() : this._startDayTextField.getValue();
            start = DateUtils.getStartOfDay(start);
            if (!this.isDaySelected()) {
                String startTime = this._startTimeField.getText();
                int hours = 0;
                int minutes = 0;
                try {
                    StringTokenizer t = new StringTokenizer(startTime, ":");
                    hours = Integer.parseInt(t.nextToken());
                    minutes = Integer.parseInt(t.nextToken());
                }
                catch (NumberFormatException e) {
                    DialogUtils.errorDialog(this, "Timp incorect : " + startTime, "Utilizez 00:00");
                    hours = 0;
                    minutes = 0;
                }
                catch (NoSuchElementException e) {
                    DialogUtils.errorDialog(this, "Timp incorect : " + startTime, "Utilizez 00:00");
                    hours = 0;
                    minutes = 0;
                }
                int seconds = 0;
                int millis = 0;
                start = DateUtils.setTimeToDate(start, hours, minutes, seconds, millis);
            }
            if (this.isDaySelected()) {
                stop = DateUtils.getEndOfDay(start);
            } else {
                stop = this._stopDayTextField.getValue();
                stop = DateUtils.getStartOfDay(stop);
                String stopTime = this._stopTimeField.getText();
                int hours = 0;
                int minutes = 0;
                try {
                    StringTokenizer t = new StringTokenizer(stopTime, ":");
                    hours = Integer.parseInt(t.nextToken());
                    minutes = Integer.parseInt(t.nextToken());
                }
                catch (NumberFormatException e) {
                    DialogUtils.errorDialog(this, "Timp incorect : " + stopTime, "Utilizez 00:00");
                    hours = 0;
                    minutes = 0;
                }
                catch (NoSuchElementException e) {
                    DialogUtils.errorDialog(this, "Timp incorect : " + stopTime, "Utilizez 00:00");
                    hours = 0;
                    minutes = 0;
                }
                int seconds = 59;
                int millis = 999;
                stop = DateUtils.setTimeToDate(stop, hours, minutes, seconds, millis);
            }
            result[0] = start;
            result[1] = stop;
        }
        catch (ParseException e) {
            Logger.logException(this, (Exception)e);
        }
        return result;
    }
}

