/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ro.atreides.utils.gui.ItemChooser;

public class FontChooser
extends JDialog {
    String family;
    int style;
    int size;
    Font selectedFont;
    String[] fontFamilies;
    ItemChooser families;
    ItemChooser styles;
    ItemChooser sizes;
    JTextArea preview;
    JButton okay;
    JButton cancel;
    static final String[] styleNames = new String[]{"Plain", "Italic", "Bold", "BoldItalic"};
    static final Integer[] styleValues = new Integer[]{new Integer(0), new Integer(2), new Integer(1), new Integer(3)};
    static final String[] sizeNames = new String[]{"8", "10", "12", "14", "18", "20", "24", "28", "32", "40", "48", "56", "64", "72"};
    static final String defaultPreviewString = "ABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n1234567890!@#$%^&*()_-=+[]{}<,.>\nThe quick brown fox jumps over the lazy dog";

    public FontChooser(Frame owner) {
        super(owner, "Choose a Font");
        this.setModal(true);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.fontFamilies = env.getAvailableFontFamilyNames();
        this.family = this.fontFamilies[0];
        this.style = 0;
        this.size = 18;
        this.selectedFont = new Font(this.family, this.style, this.size);
        this.families = new ItemChooser("Family", this.fontFamilies, null, 0, 2);
        this.styles = new ItemChooser("Style", styleNames, styleValues, 0, 2);
        this.sizes = new ItemChooser("Size", sizeNames, null, 4, 2);
        this.families.addItemChooserListener(new ItemChooser.Listener(){

            @Override
            public void itemChosen(ItemChooser.Event e) {
                FontChooser.this.setFontFamily((String)e.getSelectedValue());
            }
        });
        this.styles.addItemChooserListener(new ItemChooser.Listener(){

            @Override
            public void itemChosen(ItemChooser.Event e) {
                FontChooser.this.setFontStyle((Integer)e.getSelectedValue());
            }
        });
        this.sizes.addItemChooserListener(new ItemChooser.Listener(){

            @Override
            public void itemChosen(ItemChooser.Event e) {
                FontChooser.this.setFontSize(Integer.parseInt((String)e.getSelectedValue()));
            }
        });
        this.preview = new JTextArea(defaultPreviewString, 5, 40);
        this.preview.setFont(this.selectedFont);
        this.okay = new JButton("Okay");
        this.cancel = new JButton("Cancel");
        this.okay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.hide();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontChooser.this.selectedFont = null;
                FontChooser.this.hide();
            }
        });
        Box choosersBox = Box.createHorizontalBox();
        choosersBox.add(Box.createHorizontalStrut(15));
        choosersBox.add(this.families);
        choosersBox.add(Box.createHorizontalStrut(15));
        choosersBox.add(this.styles);
        choosersBox.add(Box.createHorizontalStrut(15));
        choosersBox.add(this.sizes);
        choosersBox.add(Box.createHorizontalStrut(15));
        choosersBox.add(Box.createGlue());
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createGlue());
        buttonBox.add(this.okay);
        buttonBox.add(Box.createGlue());
        buttonBox.add(this.cancel);
        buttonBox.add(Box.createGlue());
        Container contentPane = this.getContentPane();
        contentPane.add((Component)new JScrollPane(this.preview), "Center");
        contentPane.add((Component)choosersBox, "North");
        contentPane.add((Component)buttonBox, "South");
        this.pack();
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public String getFontFamily() {
        return this.family;
    }

    public int getFontStyle() {
        return this.style;
    }

    public int getFontSize() {
        return this.size;
    }

    public void setFontFamily(String name) {
        this.family = name;
        this.changeFont();
    }

    public void setFontStyle(int style) {
        this.style = style;
        this.changeFont();
    }

    public void setFontSize(int size) {
        this.size = size;
        this.changeFont();
    }

    public void setSelectedFont(Font font) {
        this.selectedFont = font;
        this.family = font.getFamily();
        this.style = font.getStyle();
        this.size = font.getSize();
        this.preview.setFont(font);
    }

    protected void changeFont() {
        this.selectedFont = new Font(this.family, this.style, this.size);
        this.preview.setFont(this.selectedFont);
    }

    @Override
    public boolean isModal() {
        return true;
    }

    public static class Demo {
        public static void main(String[] args) {
            JFrame frame = new JFrame("demo");
            final JButton button = new JButton("Push Me!");
            final FontChooser chooser = new FontChooser(frame);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    chooser.show();
                    Font font = chooser.getSelectedFont();
                    if (font != null) {
                        button.setFont(font);
                    }
                }
            });
            frame.getContentPane().add(button);
            frame.setSize(200, 100);
            frame.show();
        }
    }
}

