/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ItemChooser
extends JPanel {
    String name;
    String[] labels;
    Object[] values;
    int selection;
    int presentation;
    public static final int LIST = 1;
    public static final int COMBOBOX = 2;
    public static final int RADIOBUTTONS = 3;
    JList list;
    JComboBox combobox;
    JRadioButton[] radiobuttons;
    ArrayList listeners = new ArrayList();

    public ItemChooser(String name, String[] labels, Object[] values, int defaultSelection, int presentation) {
        this.name = name;
        this.labels = labels;
        this.values = values;
        this.selection = defaultSelection;
        this.presentation = presentation;
        if (values == null) {
            this.values = labels;
        }
        switch (presentation) {
            case 1: {
                this.initList();
                break;
            }
            case 2: {
                this.initComboBox();
                break;
            }
            case 3: {
                this.initRadioButtons();
            }
        }
    }

    void initList() {
        this.list = new JList<String>(this.labels);
        this.list.setSelectedIndex(this.selection);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ItemChooser.this.select(ItemChooser.this.list.getSelectedIndex());
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.add(new JLabel(this.name));
        this.add(new JScrollPane(this.list));
    }

    void initComboBox() {
        this.combobox = new JComboBox<String>(this.labels);
        this.combobox.setSelectedIndex(this.selection);
        this.combobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ItemChooser.this.select(ItemChooser.this.combobox.getSelectedIndex());
            }
        });
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(this.name));
        this.add(this.combobox);
    }

    void initRadioButtons() {
        this.radiobuttons = new JRadioButton[this.labels.length];
        ButtonGroup radioButtonGroup = new ButtonGroup();
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JRadioButton b = (JRadioButton)e.getSource();
                if (b.isSelected()) {
                    for (int i = 0; i < ItemChooser.this.radiobuttons.length; ++i) {
                        if (ItemChooser.this.radiobuttons[i] != b) continue;
                        ItemChooser.this.select(i);
                        return;
                    }
                }
            }
        };
        this.setBorder(new TitledBorder(new EtchedBorder(), this.name));
        this.setLayout(new BoxLayout(this, 1));
        for (int i = 0; i < this.labels.length; ++i) {
            this.radiobuttons[i] = new JRadioButton(this.labels[i]);
            if (i == this.selection) {
                this.radiobuttons[i].setSelected(true);
            }
            this.radiobuttons[i].addChangeListener(listener);
            radioButtonGroup.add(this.radiobuttons[i]);
            this.add(this.radiobuttons[i]);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getPresentation() {
        return this.presentation;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public Object[] getValues() {
        return this.values;
    }

    public int getSelectedIndex() {
        return this.selection;
    }

    public Object getSelectedValue() {
        return this.values[this.selection];
    }

    public void setSelectedIndex(int selection) {
        switch (this.presentation) {
            case 1: {
                this.list.setSelectedIndex(selection);
                break;
            }
            case 2: {
                this.combobox.setSelectedIndex(selection);
                break;
            }
            case 3: {
                this.radiobuttons[selection].setSelected(true);
            }
        }
        this.selection = selection;
    }

    protected void select(int selection) {
        this.selection = selection;
        if (!this.listeners.isEmpty()) {
            Event e = new Event(this, selection, this.values[selection]);
            for (Listener l : this.listeners) {
                l.itemChosen(e);
            }
        }
    }

    public void addItemChooserListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeItemChooserListener(Listener l) {
        this.listeners.remove(l);
    }

    public static class Demo {
        public static void main(String[] args) {
            final JFrame frame = new JFrame("ItemChooser Demo");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            final JLabel msgline = new JLabel(" ");
            JPanel chooserPanel = new JPanel();
            final ItemChooser c1 = new ItemChooser("Choice #1", args, null, 0, 1);
            final ItemChooser c2 = new ItemChooser("Choice #2", args, null, 0, 2);
            final ItemChooser c3 = new ItemChooser("Choice #3", args, null, 0, 3);
            Listener l = new Listener(){

                @Override
                public void itemChosen(Event e) {
                    msgline.setText(e.getItemChooser().getName() + ": " + e.getSelectedIndex() + ": " + e.getSelectedValue());
                }
            };
            c1.addItemChooserListener(l);
            c2.addItemChooserListener(l);
            c3.addItemChooserListener(l);
            JButton report = new JButton("Report");
            report.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String msg = "<html><i>" + c1.getName() + ": " + c1.getSelectedValue() + "<br>" + c2.getName() + ": " + c2.getSelectedValue() + "<br>" + c3.getName() + ": " + c3.getSelectedValue() + "</i>";
                    JOptionPane.showMessageDialog(frame, msg);
                }
            });
            chooserPanel.add(c1);
            chooserPanel.add(c2);
            chooserPanel.add(c3);
            chooserPanel.add(report);
            Container contentPane = frame.getContentPane();
            contentPane.add((Component)chooserPanel, "Center");
            contentPane.add((Component)msgline, "South");
            frame.pack();
            frame.show();
        }
    }

    public static interface Listener
    extends EventListener {
        public void itemChosen(Event var1);
    }

    public static class Event
    extends EventObject {
        int selectedIndex;
        Object selectedValue;

        public Event(ItemChooser source, int selectedIndex, Object selectedValue) {
            super(source);
            this.selectedIndex = selectedIndex;
            this.selectedValue = selectedValue;
        }

        public ItemChooser getItemChooser() {
            return (ItemChooser)this.getSource();
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public Object getSelectedValue() {
            return this.selectedValue;
        }
    }
}

