/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import ro.atreides.restaurant.gui.GuiUtilsRest;
import ro.atreides.utils.AbstractAppInit;
import ro.atreides.utils.Backup;
import ro.atreides.utils.BoPanelProvider;
import ro.atreides.utils.CancelException;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Module;
import ro.atreides.utils.ModuleView;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.licensing.LicenseManager;
import ro.atreides.utils.multilang.LangRoAll;

public abstract class Main {
    public static void execute(String[] args, String appTitle, String clientName, AbstractAppInit app, BoPanelProvider boProvider, JFrame frame) {
        try {
            Logger.logDebug("Main", "============= application starting at : " + new Date() + " =============");
            GuiUtils.appTitle = appTitle;
            GuiUtils.clientName = clientName;
            final String section = Utils.getCmdlineValue("-section", args, "fo");
            String controller = Utils.getCmdlineValue("-controller", args, "true");
            if (section.equalsIgnoreCase("fo")) {
                JTabbedPane tabs = new JTabbedPane();
                tabs.setFocusable(false);
                Iterator<Module> iter = app.getModules().iterator();
                while (iter.hasNext()) {
                    try {
                        Module mod = iter.next();
                        Collection views = mod.getViews();
                        if (views == null) continue;
                        for (ModuleView view : views) {
                            String className = view.getFullClass();
                            boolean isLicenced = LicenseManager.getInstance().isGuiPanelLicenced(className);
                            if (!isLicenced) continue;
                            long startTime = System.currentTimeMillis();
                            ReflectedJPanel panel = (ReflectedJPanel)Class.forName(className).newInstance();
                            panel.doStuff();
                            long stopTime = System.currentTimeMillis();
                            Logger.logDebugVerbose("Main", "SPEED Class \"" + className + "\" Took " + Utils.getString2Decimals((stopTime - startTime) / 1000L) + " seconds to load");
                            tabs.addTab(view.getName(), panel);
                        }
                    }
                    catch (RuntimeException e1) {
                        Logger.logException("Main", (Exception)e1);
                    }
                }
                JPanel main = new JPanel(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                c.anchor = 10;
                c.insets = new Insets(3, 3, 3, 3);
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                c.gridy = 0;
                if (tabs.getTabCount() == 1) {
                    frame.getContentPane().add(tabs.getComponentAt(0));
                } else {
                    main.add((Component)tabs, c);
                    frame.getContentPane().add(main);
                }
                if (Config.getInstance().getBoolean("fullscreenAtStartup") && !controller.equalsIgnoreCase("false")) {
                    GuiUtilsRest.switchToFullScreen();
                } else {
                    GuiUtilsRest.switchToWindowMode();
                }
            } else if (section.equalsIgnoreCase("bo")) {
                boolean loginOk = false;
                do {
                    try {
                        JPanel panel = boProvider.getBoPanel(frame);
                        if (panel == null) continue;
                        frame.getContentPane().add(panel);
                        loginOk = true;
                    }
                    catch (CancelException e) {
                        Utils.systemExit();
                    }
                } while (!loginOk);
                GuiUtilsRest.switchToWindowMode(true);
            } else if (section.equalsIgnoreCase("db") || section.equalsIgnoreCase("nogui")) {
                // empty if block
            }
            Thread th2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(300000L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (Backup.isServerAvariat()) {
                            if (section.equalsIgnoreCase("db") || section.equalsIgnoreCase("nogui")) {
                                Logger.logWarning(this, "URGENT !! Contactati suport tehnic : Baza de date avariata!");
                            } else {
                                DialogUtils.errorDialog(GuiUtils.currentFrame, "URGENT !! Contactati suport tehnic : Baza de date avariata!", LangRoAll.atentie);
                            }
                        }
                        try {
                            Thread.sleep(300000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            });
            th2.setName("Main_notifyUserThread");
            th2.start();
        }
        catch (HeadlessException e) {
            Logger.logException(Main.class.getName(), (Exception)e);
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
    }
}

