/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.DateSelectorInterface;

public class MonthYearDateSelector
extends JPanel
implements DateSelectorInterface {
    private JLabel dayLabel;
    private MDateEntryField dayTextField;

    public MonthYearDateSelector() {
        this.display();
    }

    @Override
    public void selectDay() {
    }

    @Override
    public void selectPeriod() {
    }

    @Override
    public void setStartDate(Date start) {
        this.setStopDate(start);
    }

    @Override
    public void setStopDate(Date stop) {
        this.dayTextField.setValue(stop);
        String time = DateUtils.getTimeFromDate(stop);
    }

    private JPanel initStartStopPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this.dayLabel = new JLabel("Data: ");
        panel.add((Component)this.dayLabel, c);
        ++c.gridx;
        c.fill = 2;
        this.dayTextField = new MDateEntryField((DateFormat)Formatters.MONTH_YEAR_HUMAN_FORMAT);
        this.dayTextField.setValue(new Date());
        this.dayTextField.setEditable(false);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 4;
        this.dayTextField.setConstraints((MDateSelectorConstraints)c1);
        this.dayTextField.setToolTipText("Alege luna");
        panel.add((Component)this.dayTextField, c);
        return panel;
    }

    private void display() {
        JPanel timePanel = this.initStartStopPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 0);
        this.add((Component)timePanel, c);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public Date[] getDates() {
        Date[] result = new Date[2];
        try {
            Date date = this.dayTextField.getValue();
            date = DateUtils.advanceOneMonth(date);
            result[0] = date = DateUtils.addMillisToDate(date, -1L);
            result[1] = date;
        }
        catch (ParseException e) {
            Logger.logException(this, (Exception)e);
        }
        return result;
    }
}

