/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.LineBorder;
import ro.atreides.utils.gui.AbstractMultipleSelectionBox;

public class MultiboxList
extends AbstractMultipleSelectionBox {
    private CellRenderer renderer;

    public MultiboxList(Collection data, int nrcolumns) {
        super(data, nrcolumns);
    }

    public void setCellRenderer(CellRenderer r) {
        this.renderer = r;
    }

    @Override
    protected Component getPopupPanel() {
        JScrollPane scrool = new JScrollPane(new JCheckBoxList(this.data));
        scrool.setBorder(new LineBorder(Color.BLACK));
        return scrool;
    }

    @Override
    protected Dimension getPopupSize(Component popupComp) {
        int listSize;
        JCheckBoxList list = (JCheckBoxList)((JScrollPane)popupComp).getViewport().getView();
        Rectangle r = list.getCellBounds(0, (listSize = list.getModel().getSize()) - 1);
        if (r != null) {
            int height = Math.min(160, r.height);
            r.setSize(this.getSize().width, height);
        } else {
            r = new Rectangle(0, 0, this.getSize().width, 160);
        }
        return new Dimension(r.width, r.height);
    }

    public void selectItem(String s, boolean selected) {
        for (Object data : this.data) {
            AbstractMultipleSelectionBox.ListData d;
            Object name;
            if (!(data instanceof AbstractMultipleSelectionBox.ListData) || !(name = (d = (AbstractMultipleSelectionBox.ListData)data).getData()).toString().equalsIgnoreCase(s)) continue;
            this.setSelectedItem(name, selected);
        }
    }

    public static interface CellRenderer {
        public Color getForeground(Object var1);

        public Color getBackground(Object var1);
    }

    public class JCheckBoxList
    extends JList {
        public JCheckBoxList(ListModel dataModel) {
            super(dataModel);
            this.init();
        }

        public JCheckBoxList(Object[] listData) {
            super(listData);
            this.init();
        }

        public JCheckBoxList(Vector data) {
            super(data);
            this.init();
        }

        public JCheckBoxList() {
            this.init();
        }

        public void init() {
            this.setCellRenderer(new CustomListRenderer());
            this.setSelectionMode(0);
            this.addMouseListener(new CustomListToggleCheckbox());
            this.addKeyListener(new CustomListToggleCheckbox());
        }

        private class CustomListToggleCheckbox
        extends MouseAdapter
        implements KeyListener {
            private CustomListToggleCheckbox() {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent ke) {
                if (' ' == ke.getKeyChar()) {
                    this.toggleCheckBox(ke, false);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getX() < 20) {
                    this.toggleCheckBox(e, true);
                }
            }

            private void toggleCheckBox(AWTEvent e, boolean saveCurrent) {
                AbstractMultipleSelectionBox.ListData ld;
                JList list = (JList)e.getSource();
                int index = list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                ld.setSelected(!(ld = (AbstractMultipleSelectionBox.ListData)list.getModel().getElementAt(index)).isSelected());
                list.repaint();
            }
        }

        private class CustomListRenderer
        extends JCheckBox
        implements ListCellRenderer {
            public CustomListRenderer() {
                this.setHorizontalAlignment(2);
                this.setVerticalAlignment(0);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setText(value.toString());
                AbstractMultipleSelectionBox.ListData ld = (AbstractMultipleSelectionBox.ListData)value;
                this.setSelected(ld.isSelected());
                if (MultiboxList.this.renderer != null) {
                    Color f = MultiboxList.this.renderer.getForeground(ld.getData());
                    Color b = MultiboxList.this.renderer.getBackground(ld.getData());
                    if (f != null) {
                        this.setForeground(f);
                    }
                    if (b != null) {
                        this.setBackground(b);
                    }
                }
                return this;
            }
        }
    }
}

