/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.PersFizicaLabelProvider;

public class NamePanel
extends JPanel {
    private JTextField numeField;
    private JTextField prenumeField;
    private JTextField telFixField;
    private JTextField faxField;
    private JTextField telMobilField;
    private JTextField emailField;
    private JTextField webField;
    private JTextField loculNasterii;
    private JTextField cetatenie;
    private JTextField nationalitate;
    private JComboBox persJuridice;
    private MDateEntryField dateField;
    private MDateEntryField nameDateField;
    private PersFizicaLabelProvider labelProvider;

    public NamePanel(PersFizicaLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        this.display();
        this.initFields();
    }

    public void initFields() {
        this.setNume("");
        this.setPrenume("");
        this.setTelFix("");
        this.setFax("");
        this.setTelMobil("");
        this.setEmail("");
        this.setWeb("");
        this.setCetatenie(this.labelProvider.getCetatenieDefault());
        this.setNationalitate(this.labelProvider.getNationalitateDefault());
        this.setLoculNasterii("");
        this.setDataNasterii(new Date());
        this.setDataNumelui(new Date());
        if (this.persJuridice.getItemCount() > 0) {
            this.persJuridice.setSelectedIndex(0);
        }
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        this.add((Component)new JLabel("Nume (*)"), c);
        c.gridx = 1;
        this.numeField = new JTextField("");
        this.add((Component)this.numeField, c);
        this.prenumeField = new JTextField("");
        if (this.labelProvider.showPrenume()) {
            ++c.gridy;
            c.gridx = 0;
            this.add((Component)new JLabel("Prenume (*)"), c);
            c.gridx = 1;
            this.add((Component)this.prenumeField, c);
        }
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel(this.labelProvider.getTelFixName()), c);
        c.gridx = 1;
        this.telFixField = new JTextField("");
        this.add((Component)this.telFixField, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel(this.labelProvider.getFaxName()), c);
        c.gridx = 1;
        this.faxField = new JTextField("");
        this.add((Component)this.faxField, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel(this.labelProvider.getTelefonMobilName()), c);
        c.gridx = 1;
        this.telMobilField = new JTextField("");
        this.add((Component)this.telMobilField, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel(this.labelProvider.getEmailName()), c);
        c.gridx = 1;
        this.emailField = new JTextField("");
        this.add((Component)this.emailField, c);
        this.webField = new JTextField("");
        if (this.labelProvider.showWeb()) {
            ++c.gridy;
            c.gridx = 0;
            this.add((Component)new JLabel(this.labelProvider.getPaginaWebName()), c);
            c.gridx = 1;
            this.add((Component)this.webField, c);
        }
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel(this.labelProvider.getCompanieName()), c);
        c.gridx = 1;
        this.persJuridice = new JComboBox();
        this.add((Component)this.persJuridice, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Data nasterii (dd-MM-yyyy)"), c);
        ++c.gridx;
        this.dateField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.dateField.setValue(new Date());
        this.dateField.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this.dateField.setConstraints((MDateSelectorConstraints)c1);
        this.dateField.setToolTipText("Data nasterii");
        this.dateField.setMinimum(DateUtils.getStartOfCentury());
        this.dateField.setShowTodayButton(true);
        this.add((Component)this.dateField, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Data numelui (dd-MM-yyyy)"), c);
        ++c.gridx;
        this.nameDateField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.nameDateField.setValue(new Date());
        this.nameDateField.setEditable(true);
        MDefaultPullDownConstraints c2 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this.nameDateField.setConstraints((MDateSelectorConstraints)c1);
        this.nameDateField.setToolTipText("Data numelui");
        this.nameDateField.setMinimum(DateUtils.getStartOfCentury());
        this.nameDateField.setShowTodayButton(true);
        this.add((Component)this.nameDateField, c);
        this.loculNasterii = new JTextField();
        if (this.labelProvider.showLoculNasterii()) {
            ++c.gridy;
            c.gridx = 0;
            this.add((Component)new JLabel("Locul nasterii"), c);
            c.gridx = 1;
            this.add((Component)this.loculNasterii, c);
        }
        this.cetatenie = new JTextField();
        if (this.labelProvider.showCetatenie()) {
            ++c.gridy;
            c.gridx = 0;
            this.add((Component)new JLabel("Cetatenie"), c);
            c.gridx = 1;
            this.add((Component)this.cetatenie, c);
        }
        this.nationalitate = new JTextField();
        if (this.labelProvider.showNationalitate()) {
            ++c.gridy;
            c.gridx = 0;
            this.add((Component)new JLabel("Nationalitate"), c);
            c.gridx = 1;
            this.add((Component)this.nationalitate, c);
        }
        this.setBorder(new TitledBorder("Nume"));
    }

    public Date getDataNasterii() {
        try {
            return this.dateField.getValue();
        }
        catch (ParseException e) {
            Logger.logException(this, (Exception)e);
            return new Date();
        }
    }

    public void setDataNasterii(Date d) {
        this.dateField.setValue(d);
    }

    public Date getDataNumelui() {
        try {
            return this.nameDateField.getValue();
        }
        catch (ParseException e) {
            Logger.logException(this, (Exception)e);
            return new Date();
        }
    }

    public void setDataNumelui(Date d) {
        this.nameDateField.setValue(d);
    }

    public String getLoculNasterii() {
        return this.loculNasterii.getText();
    }

    public void setLoculNasterii(String s) {
        this.loculNasterii.setText(s);
    }

    public String getNationalitate() {
        return this.nationalitate.getText();
    }

    public void setNationalitate(String s) {
        this.nationalitate.setText(s);
    }

    public String getCetatenie() {
        return this.cetatenie.getText();
    }

    public void setCetatenie(String s) {
        this.cetatenie.setText(s);
    }

    public String getNume() {
        return this.numeField.getText();
    }

    public String getPrenume() {
        return this.prenumeField.getText();
    }

    public void setNume(String nume) {
        this.numeField.setText(nume);
    }

    public void setPrenume(String prenume) {
        this.prenumeField.setText(prenume);
    }

    public JComboBox getPersJuridiceCombo() {
        return this.persJuridice;
    }

    public String getTelFixField() {
        return this.telFixField.getText();
    }

    public void setTelFix(String toSet) {
        this.telFixField.setText(toSet);
    }

    public String getFaxField() {
        return this.faxField.getText();
    }

    public void setFax(String toSet) {
        this.faxField.setText(toSet);
    }

    public String getTelMobilField() {
        return this.telMobilField.getText();
    }

    public void setTelMobil(String toSet) {
        this.telMobilField.setText(toSet);
    }

    public String getEmailField() {
        return this.emailField.getText();
    }

    public void setEmail(String toSet) {
        this.emailField.setText(toSet);
    }

    public String getWebField() {
        return this.webField.getText();
    }

    public void setWeb(String toSet) {
        this.webField.setText(toSet);
    }
}

