/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;

public class PasaportPanel
extends JPanel {
    private JTextField seria;
    private JTextField tipAct;
    private MDateEntryField dataEliberarii;
    private MDateEntryField dataExpirarii;

    public PasaportPanel() {
        this.display();
    }

    public void initFields() {
        this.tipAct.setText("");
        this.seria.setText("");
        this.dataEliberarii.setText("");
        this.dataExpirarii.setText("");
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridy = 0;
        c.gridx = 0;
        this.add((Component)new JLabel("Tip act (*)"), c);
        ++c.gridx;
        this.tipAct = new JTextField();
        this.add((Component)this.tipAct, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Seria (*)"), c);
        ++c.gridx;
        this.seria = new JTextField();
        this.add((Component)this.seria, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Data eliberarii (dd.MM.yy) "), c);
        ++c.gridx;
        this.dataEliberarii = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.dataEliberarii.setValue(new Date());
        this.dataEliberarii.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this.dataEliberarii.setConstraints((MDateSelectorConstraints)c1);
        this.dataEliberarii.setToolTipText("Data eliberarii");
        this.dataEliberarii.setMinimum(DateUtils.getStartOfCentury());
        this.dataEliberarii.setShowTodayButton(true);
        this.add((Component)this.dataEliberarii, c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Data expirarii (dd.MM.yy)"), c);
        ++c.gridx;
        this.dataExpirarii = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this.dataExpirarii.setValue(new Date());
        this.dataExpirarii.setEditable(true);
        MDefaultPullDownConstraints c2 = new MDefaultPullDownConstraints();
        c2.firstDay = 2;
        c2.changerStyle = 2;
        this.dataExpirarii.setConstraints((MDateSelectorConstraints)c1);
        this.dataExpirarii.setToolTipText("Data expirarii");
        this.dataExpirarii.setMinimum(DateUtils.getStartOfCentury());
        this.dataExpirarii.setShowTodayButton(true);
        this.add((Component)this.dataExpirarii, c);
        this.setBorder(new TitledBorder("Alt act"));
    }

    public void setTipAct(String tipAct) {
        this.tipAct.setText(tipAct);
    }

    public String getTipAct() {
        return this.tipAct.getText();
    }

    public void setSeria(String seria) {
        this.seria.setText(seria);
    }

    public void setDataEliberarii(String dataEliberarii) {
        this.dataEliberarii.setText(dataEliberarii);
    }

    public void setDataExpirarii(String dataExpirarii) {
        this.dataExpirarii.setText(dataExpirarii);
    }

    public String getSeria() {
        return this.seria.getText();
    }

    public Date getDataEliberarii() {
        return DateUtils.getDate(this.dataEliberarii.getText(), Formatters.SHORT_DATE_FORMAT_RO);
    }

    public Date getDataExpirarii() {
        return DateUtils.getDate(this.dataExpirarii.getText(), Formatters.SHORT_DATE_FORMAT_RO);
    }
}

