/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateEntryField;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.DateSelectorInterface;
import ro.atreides.utils.gui.dialogs.DialogUtils;

public class PeriodOnlyNoTimeDateSelector
extends JPanel
implements DateSelectorInterface {
    private JLabel _startDayLabel;
    private JLabel _stopDayLabel;
    private MDateEntryField _startDayTextField;
    private MDateEntryField _stopDayTextField;

    public PeriodOnlyNoTimeDateSelector() {
        this.display();
    }

    @Override
    public void setStopDate(Date stop) {
        this._stopDayTextField.setValue(stop);
    }

    @Override
    public void setStartDate(Date start) {
        this._startDayTextField.setValue(start);
    }

    private JPanel initStartStopPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        this._startDayLabel = new JLabel("Start: ");
        panel.add((Component)this._startDayLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        c.fill = 2;
        this._startDayTextField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this._startDayTextField.setValue(new Date());
        this._startDayTextField.setEditable(true);
        MDefaultPullDownConstraints c1 = new MDefaultPullDownConstraints();
        c1.firstDay = 2;
        c1.changerStyle = 2;
        this._startDayTextField.setConstraints((MDateSelectorConstraints)c1);
        this._startDayTextField.setToolTipText("Alege data start");
        this._startDayTextField.setMinimum(DateUtils.getStartOfCentury());
        this._startDayTextField.setShowTodayButton(true);
        panel.add((Component)this._startDayTextField, c);
        c.weightx = 0.0;
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        this._stopDayLabel = new JLabel("Stop: ");
        panel.add((Component)this._stopDayLabel, c);
        c.weightx = 1.0;
        ++c.gridx;
        c.fill = 2;
        this._stopDayTextField = new MDateEntryField((DateFormat)Formatters.SHORT_DATE_FORMAT_RO);
        this._stopDayTextField.setValue(new Date());
        this._stopDayTextField.setEditable(true);
        MDefaultPullDownConstraints c2 = new MDefaultPullDownConstraints();
        c2.firstDay = 2;
        c2.changerStyle = 2;
        this._stopDayTextField.setConstraints((MDateSelectorConstraints)c2);
        this._stopDayTextField.setToolTipText("Alege data stop");
        this._stopDayTextField.setMinimum(DateUtils.getStartOfCentury());
        this._stopDayTextField.setShowTodayButton(true);
        panel.add((Component)this._stopDayTextField, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        JLabel sizeSetter = new JLabel("____________________________________");
        panel.add((Component)sizeSetter, c);
        return panel;
    }

    private JPanel initTimePanel() {
        JPanel startStopPanel = this.initStartStopPanel();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 2;
        panel.add((Component)startStopPanel, c);
        return panel;
    }

    private void display() {
        JPanel timePanel = this.initTimePanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 0);
        this.add((Component)timePanel, c);
    }

    @Override
    public void selectPeriod() {
    }

    @Override
    public void selectDay() {
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public Date[] getDates() {
        Date[] result = new Date[2];
        try {
            Date start = this._startDayTextField.getValue();
            start = DateUtils.getStartOfDay(start);
            String startTime = "00:00";
            int hours = 0;
            int minutes = 0;
            try {
                StringTokenizer t = new StringTokenizer(startTime, ":");
                hours = Integer.parseInt(t.nextToken());
                minutes = Integer.parseInt(t.nextToken());
            }
            catch (NumberFormatException e) {
                DialogUtils.errorDialog(this, "Timp incorect : " + startTime, "Utilizez 00:00");
                hours = 0;
                minutes = 0;
            }
            catch (NoSuchElementException e) {
                DialogUtils.errorDialog(this, "Timp incorect : " + startTime, "Utilizez 00:00");
                hours = 0;
                minutes = 0;
            }
            int seconds = 0;
            int millis = 0;
            start = DateUtils.setTimeToDate(start, hours, minutes, seconds, millis);
            Date stop = this._stopDayTextField.getValue();
            stop = DateUtils.getStartOfDay(stop);
            String stopTime = "23:59";
            hours = 0;
            minutes = 0;
            try {
                StringTokenizer t = new StringTokenizer(stopTime, ":");
                hours = Integer.parseInt(t.nextToken());
                minutes = Integer.parseInt(t.nextToken());
            }
            catch (NumberFormatException e) {
                DialogUtils.errorDialog(this, "Timp incorect : " + stopTime, "Utilizez 00:00");
                hours = 0;
                minutes = 0;
            }
            catch (NoSuchElementException e) {
                DialogUtils.errorDialog(this, "Timp incorect : " + stopTime, "Utilizez 00:00");
                hours = 0;
                minutes = 0;
            }
            seconds = 59;
            millis = 999;
            stop = DateUtils.setTimeToDate(stop, hours, minutes, seconds, millis);
            result[0] = start;
            result[1] = stop;
        }
        catch (ParseException e) {
            Logger.logException(this, (Exception)e);
        }
        return result;
    }
}

