/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.ItemChooserDialog;
import ro.atreides.utils.gui.keypad.VirtualKeypad2;
import ro.atreides.utils.gui.splash.SplashScreenMain;

public class DialogUtils {
    public static boolean bigConfirmDialog(JFrame parent, String text1, String text2, String title) {
        SplashScreenMain splash = SplashScreenMain.getInstance();
        if (splash != null) {
            splash.stop();
        }
        final boolean[] result = new boolean[1];
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridwidth = 2;
        c.gridy = 0;
        c.gridx = 0;
        JLabel text1A = new JLabel(text1);
        panel.add((Component)text1A, c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        JTextArea text2A = new JTextArea(text2);
        panel.add((Component)new JScrollPane(text2A), c);
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 0.0;
        panel.add((Component)new JLabel("Continuam"), c);
        c.gridwidth = 1;
        c.fill = 0;
        ++c.gridy;
        c.gridx = 0;
        JButton yes = new JButton("Yes");
        panel.add((Component)yes, c);
        ++c.gridx;
        JButton no = new JButton("No");
        panel.add((Component)no, c);
        final JDialog dia = DialogUtils.getJDialog(panel, parent, title, 1.2);
        dia.pack();
        yes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                result[0] = true;
                dia.dispose();
            }
        });
        no.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                result[0] = false;
                dia.dispose();
            }
        });
        dia.pack();
        dia.setBounds(100, 100, 500, 400);
        dia.setVisible(true);
        return result[0];
    }

    public static int confirmAndCancelDialog(Component parent, String message, String title) {
        SplashScreenMain splash = SplashScreenMain.getInstance();
        if (splash != null) {
            splash.stop();
        }
        int opt = -1;
        while (opt == -1) {
            opt = JOptionPane.showConfirmDialog(parent, message + " ?", title, 1, 3);
        }
        return opt;
    }

    public static boolean confirmDialog(Component parent, String message, String title) {
        SplashScreenMain splash = SplashScreenMain.getInstance();
        if (splash != null) {
            splash.stop();
        }
        int opt = -1;
        while (opt == -1) {
            opt = JOptionPane.showConfirmDialog(parent, message + " ?", title, 0, 3);
        }
        boolean result = opt == 0;
        return result;
    }

    public static void okDialog(Component parent, String message, String title) {
        SplashScreenMain splash = SplashScreenMain.getInstance();
        if (splash != null) {
            splash.stop();
        }
        JOptionPane.showMessageDialog(parent, message, title, 1);
    }

    public static void okFocusEaterDialog(String message, String title) {
        SplashScreenMain splash = SplashScreenMain.getInstance();
        if (splash != null) {
            splash.stop();
        }
        DialogUtils.htmlOkFocusEaterDialog(GuiUtils.currentFrame, message, title);
    }

    public static String inputDialog(Component parent, String defaultText, String title) {
        return JOptionPane.showInputDialog(parent, title, defaultText);
    }

    public static String virtualKeyboardInputDialog(JFrame frame, String title, double scale, int fontSize, boolean enforceNumbers) {
        VirtualKeypad2 kp2 = new VirtualKeypad2(fontSize, enforceNumbers);
        JDialog dialog = DialogUtils.getJDialogOKButton(kp2, frame, title, scale);
        dialog.setVisible(true);
        return kp2.getValueS();
    }

    public static void htmlOKDialog(Component parent, String message, String title) {
        SplashScreenMain splash = SplashScreenMain.getInstance();
        if (splash != null) {
            splash.stop();
        }
        JOptionPane.showMessageDialog(parent, "<html>" + message + "</html>", title, 1);
    }

    public static void errorDialog(Component parent, String message, String title) {
        SplashScreenMain splash = SplashScreenMain.getInstance();
        if (splash != null) {
            splash.stop();
        }
        if (!GuiUtils.daemon) {
            JOptionPane.showMessageDialog(parent, message, title, 0);
        } else {
            System.out.println(title + ": " + message);
        }
    }

    public static void htmlOkFocusEaterDialog(JFrame parent, String message, String title) {
        String m = "<html>" + message + "</html>";
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridy = 0;
        c.gridx = 0;
        JLabel label = new JLabel(m);
        p.add((Component)label, c);
        ++c.gridy;
        JButton ok = new JButton("OK");
        p.add((Component)ok, c);
        p.setFocusCycleRoot(true);
        final JDialog dialog = DialogUtils.getJDialog(p, parent, title, 3.5);
        dialog.pack();
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                dialog.dispose();
            }
        });
        dialog.setVisible(true);
    }

    public static JDialog getJDialog(Component panel, JFrame parent, String title, double scale) {
        return DialogUtils.getJDialog(panel, parent, title, scale, true);
    }

    public static JDialog getJDialog(Component panel, JFrame parent, String title, double scale, boolean modal) {
        JDialog dialog = new JDialog(parent, title, modal);
        dialog.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridy = 0;
        c.gridx = 0;
        dialog.add(panel, c);
        dialog.pack();
        int width = (int)((double)parent.getWidth() / scale);
        int height = (int)((double)parent.getHeight() / scale);
        int x = 0;
        int y = 0;
        if (parent != null) {
            int parentWidth = parent.getWidth();
            int parentHeight = parent.getHeight();
            x = parent.getX() + (parentWidth - width) / 2;
            y = parent.getY() + (parentHeight - height) / 2;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        dialog.setBounds(x, y, width, height);
        return dialog;
    }

    public static JDialog getJDialogOKButton(Component panel, JFrame parent, String title, double scale) {
        final JDialog dialog = new JDialog(parent, title, true);
        dialog.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.gridy = 0;
        c.gridx = 0;
        dialog.add(panel, c);
        JButton ok = new JButton("OK");
        c.weighty = 0.0;
        c.weightx = 0.0;
        ++c.gridy;
        c.insets = new Insets(8, 2, 2, 2);
        dialog.add((Component)ok, c);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                dialog.dispose();
            }
        });
        dialog.pack();
        int width = (int)((double)parent.getWidth() / scale);
        int height = (int)((double)parent.getHeight() / scale);
        int x = 0;
        int y = 0;
        if (parent != null) {
            int parentWidth = parent.getWidth();
            int parentHeight = parent.getHeight();
            x = parent.getX() + (parentWidth - width) / 2;
            y = parent.getY() + (parentHeight - height) / 2;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        dialog.setBounds(x, y, width, height);
        return dialog;
    }

    public static Object getItemChooserDialog(Vector items, int buttonsPerLine, boolean showAllButton) {
        ItemChooserDialog dia = new ItemChooserDialog(buttonsPerLine, items, showAllButton);
        if (dia.isAll()) {
            return null;
        }
        return dia.getSelected();
    }

    public static String buildBulletedText(Vector<String> lines) {
        String message = "<ol>";
        for (String line : lines) {
            message = message + "<li>" + line + "</li>";
        }
        message = message + "</ol>";
        return message;
    }

    public static void bulletedOKDialog(Component parent, Vector<String> lines, String title) {
        String message = DialogUtils.buildBulletedText(lines);
        JOptionPane.showMessageDialog(parent, "<html>" + message + "</html>", title, 1);
    }

    public static void bulletedWarningDialog(Component parent, Vector<String> lines, String title) {
        String message = DialogUtils.buildBulletedText(lines);
        JOptionPane.showMessageDialog(parent, "<html>" + message + "</html>", title, 2);
    }

    public static void bulletedErrorDialog(Component parent, Vector<String> lines, String title) {
        String message = DialogUtils.buildBulletedText(lines);
        JOptionPane.showMessageDialog(parent, "<html>" + message + "</html>", title, 0);
    }

    public static String[] changePasswordDialog(Component parent, String title) {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        JPasswordField pass0 = new JPasswordField(10);
        panel.add(new JLabel("Parola actuala:"));
        panel.add((Component)pass0, "wrap");
        JPasswordField pass1 = new JPasswordField(10);
        panel.add(new JLabel("Parola noua :"));
        panel.add((Component)pass1, "wrap");
        JPasswordField pass2 = new JPasswordField(10);
        panel.add(new JLabel("Parola din nou:"));
        panel.add((Component)pass2, "wrap");
        Object[] options = new String[]{"OK", "Cancel"};
        int option = JOptionPane.showOptionDialog(parent, panel, title, 1, -1, null, options, options[0]);
        if (option == 0) {
            String[] result = new String[]{new String(pass0.getPassword()), new String(pass1.getPassword()), new String(pass2.getPassword())};
            return result;
        }
        return null;
    }

    public static String passwordDialog(Component parent, String title) {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        JPasswordField pass0 = new JPasswordField(10);
        panel.add(new JLabel("Parola actuala:"));
        panel.add((Component)pass0, "wrap");
        Object[] options = new String[]{"OK", "Cancel"};
        int option = JOptionPane.showOptionDialog(parent, panel, title, 1, -1, null, options, options[0]);
        if (option == 0) {
            return new String(pass0.getPassword());
        }
        return null;
    }
}

