/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.multilang.LangRoAll;

public class LoginDialog
extends JDialog {
    private String userName = "";
    private String password = "********";
    private JTextField user;
    private JPasswordField pass;
    private JButton reset;
    private JButton ok;
    private String codAutentificare = "";
    public static String title = "Autentificare";
    private boolean cancel = false;

    public LoginDialog(Frame parent, boolean modal) {
        super(parent, title, modal);
        this.init();
        this.display();
        this.pack();
        int width = this.getWidth();
        int height = this.getHeight();
        int x = 0;
        int y = 0;
        if (parent != null) {
            int parentWidth = parent.getWidth();
            int parentHeight = parent.getHeight();
            x = parent.getX() + (parentWidth - width) / 2;
            y = parent.getY() + (parentHeight - height) / 2;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.setBounds(x, y, width, height);
        this.setVisible(true);
    }

    private void init() {
        this.user = new JTextField(this.userName, 10);
        this.pass = new JPasswordField(10);
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.userName = LoginDialog.this.user.getText();
                LoginDialog.this.password = new String(LoginDialog.this.pass.getPassword());
                LoginDialog.this.dispose();
            }
        });
        this.reset = new JButton("Reset");
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.cancel = true;
                LoginDialog.this.dispose();
            }
        });
        this.user.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LoginDialog.this.pass.requestFocus();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.pass.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    LoginDialog.this.ok.doClick();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public boolean isCancel() {
        return this.cancel;
    }

    private void display() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 10;
        c.weightx = 0.5;
        c.insets = new Insets(10, 10, 10, 10);
        c.gridx = 0;
        c.gridy = 0;
        this.getContentPane().add((Component)new JLabel(LangRoAll.utilizator), c);
        c.gridx = 1;
        c.gridy = 0;
        this.getContentPane().add((Component)this.user, c);
        c.gridx = 2;
        c.gridy = 0;
        this.getContentPane().add((Component)this.ok, c);
        c.gridx = 0;
        c.gridy = 1;
        this.getContentPane().add((Component)new JLabel(LangRoAll.parola), c);
        c.gridx = 1;
        c.gridy = 1;
        this.getContentPane().add((Component)this.pass, c);
        c.gridx = 2;
        c.gridy = 1;
        this.getContentPane().add((Component)this.reset, c);
        this.getContentPane().setFocusable(true);
        this.getContentPane().addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                LoginDialog.this.codAutentificare = LoginDialog.this.codAutentificare + String.valueOf(e.getKeyChar());
                if (LoginDialog.this.codAutentificare.length() == Config.getInstance().getInt("codAutentificareLength")) {
                    LoginDialog.this.dispose();
                }
            }
        });
        this.getContentPane().requestFocus();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCodAutentificare() {
        return this.codAutentificare;
    }
}

