/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.fullscreen;

import java.awt.BorderLayout;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.ImageCapabilities;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ro.atreides.utils.gui.fullscreen.GCWrapper;

public class CapabilitiesTest
extends JFrame
implements ItemListener {
    private JComboBox gcSelection = new JComboBox();
    private JCheckBox imageAccelerated = new JCheckBox("Accelerated", false);
    private JCheckBox imageTrueVolatile = new JCheckBox("Volatile", false);
    private JCheckBox flipping = new JCheckBox("Flipping", false);
    private JLabel flippingMethod = new JLabel("");
    private JCheckBox fullScreen = new JCheckBox("Full Screen Only", false);
    private JCheckBox multiBuffer = new JCheckBox("Multi-Buffering", false);
    private JCheckBox fbAccelerated = new JCheckBox("Accelerated", false);
    private JCheckBox fbTrueVolatile = new JCheckBox("Volatile", false);
    private JCheckBox bbAccelerated = new JCheckBox("Accelerated", false);
    private JCheckBox bbTrueVolatile = new JCheckBox("Volatile", false);

    public CapabilitiesTest(GraphicsDevice dev) {
        super(dev.getDefaultConfiguration());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
        this.initComponents(this.getContentPane());
        GraphicsConfiguration[] gcs = dev.getConfigurations();
        for (int i = 0; i < gcs.length; ++i) {
            this.gcSelection.addItem(new GCWrapper(gcs[i], i));
        }
        this.gcSelection.addItemListener(this);
        this.gcChanged();
    }

    private void initComponents(Container c) {
        c.setLayout(new BorderLayout());
        JPanel gcPanel = new JPanel(new FlowLayout(1));
        c.add((Component)gcPanel, "North");
        this.gcSelection.setPreferredSize(new Dimension(400, 30));
        gcPanel.add(this.gcSelection);
        JPanel capsPanel = new JPanel(new BorderLayout());
        c.add((Component)capsPanel, "Center");
        JPanel imageCapsPanel = new JPanel(new GridLayout(2, 1));
        capsPanel.add((Component)imageCapsPanel, "North");
        imageCapsPanel.setBorder(BorderFactory.createTitledBorder("Image Capabilities"));
        this.imageAccelerated.setEnabled(false);
        imageCapsPanel.add(this.imageAccelerated);
        this.imageTrueVolatile.setEnabled(false);
        imageCapsPanel.add(this.imageTrueVolatile);
        JPanel bufferCapsPanel = new JPanel(new BorderLayout());
        capsPanel.add((Component)bufferCapsPanel, "Center");
        bufferCapsPanel.setBorder(BorderFactory.createTitledBorder("Buffer Capabilities"));
        JPanel bufferAccessCapsPanel = new JPanel(new GridLayout(3, 1));
        bufferAccessCapsPanel.setPreferredSize(new Dimension(300, 88));
        bufferCapsPanel.add((Component)bufferAccessCapsPanel, "North");
        JPanel flippingPanel = new JPanel(new FlowLayout(0));
        bufferAccessCapsPanel.add(flippingPanel);
        flippingPanel.add(this.flipping);
        this.flipping.setEnabled(false);
        flippingPanel.add(this.flippingMethod);
        JPanel fsPanel = new JPanel(new FlowLayout(0));
        bufferAccessCapsPanel.add(fsPanel);
        JPanel indentPanel = new JPanel();
        indentPanel.setPreferredSize(new Dimension(30, 30));
        fsPanel.add(indentPanel);
        fsPanel.add(this.fullScreen);
        this.fullScreen.setEnabled(false);
        JPanel mbPanel = new JPanel(new FlowLayout(0));
        bufferAccessCapsPanel.add(mbPanel);
        indentPanel = new JPanel();
        indentPanel.setPreferredSize(new Dimension(30, 30));
        mbPanel.add(indentPanel);
        mbPanel.add(this.multiBuffer);
        this.multiBuffer.setEnabled(false);
        JPanel buffersPanel = new JPanel(new GridLayout(1, 2));
        bufferCapsPanel.add((Component)buffersPanel, "Center");
        JPanel fbPanel = new JPanel(new GridLayout(2, 1));
        fbPanel.setBorder(BorderFactory.createTitledBorder("Front Buffer"));
        buffersPanel.add(fbPanel);
        fbPanel.add(this.fbAccelerated);
        this.fbAccelerated.setEnabled(false);
        fbPanel.add(this.fbTrueVolatile);
        this.fbTrueVolatile.setEnabled(false);
        JPanel bbPanel = new JPanel(new GridLayout(2, 1));
        bbPanel.setPreferredSize(new Dimension(250, 80));
        bbPanel.setBorder(BorderFactory.createTitledBorder("Back and Intermediate Buffers"));
        buffersPanel.add(bbPanel);
        bbPanel.add(this.bbAccelerated);
        this.bbAccelerated.setEnabled(false);
        bbPanel.add(this.bbTrueVolatile);
        this.bbTrueVolatile.setEnabled(false);
    }

    @Override
    public void itemStateChanged(ItemEvent ev) {
        this.gcChanged();
    }

    private void gcChanged() {
        GCWrapper wrap = (GCWrapper)this.gcSelection.getSelectedItem();
        GraphicsConfiguration gc = wrap.getGC();
        ImageCapabilities imageCaps = gc.getImageCapabilities();
        this.imageAccelerated.setSelected(imageCaps.isAccelerated());
        this.imageTrueVolatile.setSelected(imageCaps.isTrueVolatile());
        BufferCapabilities bufferCaps = gc.getBufferCapabilities();
        this.flipping.setSelected(bufferCaps.isPageFlipping());
        this.flippingMethod.setText(CapabilitiesTest.getFlipText(bufferCaps.getFlipContents()));
        this.fullScreen.setSelected(bufferCaps.isFullScreenRequired());
        this.multiBuffer.setSelected(bufferCaps.isMultiBufferAvailable());
        imageCaps = bufferCaps.getFrontBufferCapabilities();
        this.fbAccelerated.setSelected(imageCaps.isAccelerated());
        this.fbTrueVolatile.setSelected(imageCaps.isTrueVolatile());
        imageCaps = bufferCaps.getFrontBufferCapabilities();
        imageCaps = bufferCaps.getBackBufferCapabilities();
        this.bbAccelerated.setSelected(imageCaps.isAccelerated());
        this.bbTrueVolatile.setSelected(imageCaps.isTrueVolatile());
    }

    private static String getFlipText(BufferCapabilities.FlipContents flip) {
        if (flip == null) {
            return "";
        }
        if (flip == BufferCapabilities.FlipContents.UNDEFINED) {
            return "Method Unspecified";
        }
        if (flip == BufferCapabilities.FlipContents.BACKGROUND) {
            return "Cleared to Background";
        }
        if (flip == BufferCapabilities.FlipContents.PRIOR) {
            return "Previous Front Buffer";
        }
        return "Copied";
    }

    public static void main(String[] args) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = ge.getScreenDevices();
        for (int i = 0; i < devices.length; ++i) {
            CapabilitiesTest tst = new CapabilitiesTest(devices[i]);
            tst.pack();
            tst.setVisible(true);
        }
    }
}

