/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.keypad;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import ro.atreides.utils.Logger;
import ro.atreides.utils.gui.keypad.KeypadListener;

public class VirtualKeypad
extends JPanel {
    private Vector listeners = new Vector();
    private int fontSize;

    public void addKeypadListener(KeypadListener listener) {
        this.listeners.add(listener);
    }

    public VirtualKeypad(int fontSize) {
        this.fontSize = fontSize;
        this.display(null);
    }

    public VirtualKeypad(String border) {
        this.display(border);
    }

    private void display(String border) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        if (border != null) {
            this.setBorder(new TitledBorder(border));
        }
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 7, 7, 7);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.buildDigitButton(7), c);
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)this.buildDigitButton(8), c);
        c.gridx = 2;
        c.gridy = 0;
        this.add((Component)this.buildDigitButton(9), c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.buildDigitButton(4), c);
        c.gridx = 1;
        c.gridy = 1;
        this.add((Component)this.buildDigitButton(5), c);
        c.gridx = 2;
        c.gridy = 1;
        this.add((Component)this.buildDigitButton(6), c);
        c.gridx = 0;
        c.gridy = 2;
        this.add((Component)this.buildDigitButton(1), c);
        c.gridx = 1;
        c.gridy = 2;
        this.add((Component)this.buildDigitButton(2), c);
        c.gridx = 2;
        c.gridy = 2;
        this.add((Component)this.buildDigitButton(3), c);
        c.insets = new Insets(0, 7, 0, 7);
        c.gridx = 0;
        c.gridy = 3;
        JButton ok = new JButton("OK");
        ok.setFont(new Font(null, 1, this.fontSize + 2));
        ok.setForeground(Color.RED);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualKeypad.this.okPressed();
            }
        });
        ok.setFocusable(false);
        this.add((Component)ok, c);
        c.gridx = 1;
        c.gridy = 3;
        this.add((Component)this.buildDigitButton(0), c);
        c.gridx = 2;
        c.gridy = 3;
        JButton backspace = new JButton("<-");
        backspace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualKeypad.this.backspace();
            }
        });
        backspace.setFocusable(false);
        this.add((Component)backspace, c);
    }

    private JButton buildDigitButton(int digit) {
        JButton btn = new JButton("" + digit);
        btn.setFont(new Font(null, 0, this.fontSize));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                try {
                    int digit = Integer.parseInt(cmd);
                    VirtualKeypad.this.digitPressed(digit);
                }
                catch (NumberFormatException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
        });
        btn.setFocusable(false);
        return btn;
    }

    private void okPressed() {
        for (KeypadListener element : this.listeners) {
            element.okPressed();
        }
    }

    private void backspace() {
        for (KeypadListener element : this.listeners) {
            element.backspace();
        }
    }

    private void digitPressed(int digit) {
        for (KeypadListener element : this.listeners) {
            element.keypadPressed(digit);
        }
    }
}

